"""
Module EAS0FModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

from EEPASModel import EEPASModel


#--------------------------------------------------------------------------------
#
# EAS-0F forecast model.
#
# This class is designed to invoke three-months EEPAS forecast model. 
# It uses 'eepas_0r.par' configuration for the run. It has model weights
# disabled.
#
class EAS0FModel (EEPASModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = EEPASModel.Type + "-EAS0F"
    
    __executable = "eepasof21srevg77" 
    __grid = "EASGRID"
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for EAS0FModel class"""
        
        EEPASModel.__init__(self, dir_path, args, "nzeas_0f.par","0")
        
    def executableFile (self):
        """ Returns the executable file of the EEPAS model."""

        return self.__executable

    def gridFile (self):
        """ Returns the grid file of the EEPAS model."""

        return self.__grid






    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type

        
