c======EEPSOF PROGRAM
c===== version 19p 
c===== EEPAS FORECASTING MODEL SOFTWARE VERSION 1.9m
c===== COPYRIGHT GNS SCIENCE (2007)
c===== WRITTEN BY DAVID A RHOADES, GNS SCIENCE, 
c===== PO BOX 30368, LOWER HUTT 5040, NEW ZEALAND.
c===== All rights reserved.
c===== Use of this program for any purpose other than what
c===== is expressly permitted by the author and GNS Science is forbidden.
c===== Licensed users are not permitted to pass on this software, 
c===== in whole or in part, to any third party.
c===== eepasof19p provides option for masking outside polygon in EEPGRID etc
c===== eepasof19o extends filename character arrays to length 256
c===== eepasof19n fixes problem EEPTM array calculation for veep=1
c===== eepasof19m changes imoto file formats to free format reads
c===== eepasof19l does calculations of rate for imoto collaboration
c===== eepasof19k corrects stpo, index no. for stmu
c===== eepasof19j requires parameter names and limits in STPO 
c===== eepasof19i added option in cstep (to fill in zeros with PPE or not)
c===== eepasof19h introduces stcom parameter and lstpe2
c===== eepasof19g makes command file a parameter
c===== eepasof19c modifies LIKELIHOOD to include PPE-ETAS
c===== Additional features in eepasof19
c===== optimisation of sup-etas model etc lljan* functions
c===== additional features in eepasof17
c===== optimisation of lleep in mixture with STEP model
c===== should apply to any other model for which likelihood components
c===== are read from a file
c===== new subroutine is called llstpe (modification of lleep) 
c
c     Beginning of mainline
      implicit none
      character*256 fil9nm,filenm,filinm(15),fil8nm,jointx
      character*72 datafn,gmtfn,joinst
      character*32,par3,param3(3),title,contfn,cptfn,modnm,title1
      character*32 ttlgen
      character*4 parst2(46),astrng(18),filetp,filitp(16),filist(16)
      character*4 astri(100),bkey,parstr(39),pars,catkey,catoth
      character*1 backsl
      character*4 parst3(3)
      integer jff10,jff14,jff22,nlist(5000),ncat,nf,filino(15)
      integer jff6,jff9,jff20,nfile,ntstp,nmstp,tstpst,mstpst
      integer lastri,icom,npar,iwgt,iread,isave,npar2,nftp
      integer y1,y2,m1,m2,d1,d2,yref,lostst,lastst,yrmn,yrmx
      integer yeartm,mnthtm,daytm,mrange,trange,polyfl,colfl,contfl
      integer year,month,day,hour,minute,i,n,n1,n2,inros,stcom
      integer ss,inout,npoly,ncount,l,j,inside,neq,pnum,nsim
      integer mp,np,ndim,iter,yr(90000),mth(90000),dy(90000)
      integer hr(90000),mnt(90000),licval,ncom,niread,npar3
      integer gyr1,gyr2,gmo1,gmo2,gdy1,gdy2,neqi,rtrfl,gmtfl
      integer nfflag,titfl,latn,lonn,eepfl,nf1,nf2,veepas,nsyn
      integer isyn,syn01(90000),order(1000),steflg,vjanus
      integer ghr1,gmn1,ghr2,gmn2,h1,h2,mn1,mn2,optst
      integer jff91,jff92,mask
      real ll0,ll1,ll2,ll3,evitmx,llas,tymn,scnd(90000),dep(90000)
      real kjbtm(10000),kjbxt(10000),kjbmx(10000),evitm1(10000)
      real evimx(10000),evixt(10000),glast,glost,m0min,m0max,m0stp
      real tyr1,tyr2,tyr,xm,tdec,mmin,mmax,mstp,tstp,rand,llstpp
      real xmag,lamn,lamx,lomn,lomx,lost,last,xlat,xlon
      real tmin,tmax,t1,t2,parmin,parmax,param2(46),grint,grint2
      real ftol,depmin,depmax,depdel,extraf,bi,sei,m0i
      real latmin,latmax,longmn,longmx,m0,eta(90000)
      real time,lat,long,mag,wsum,wsumd,llstpe,oclstp,noclst
      real second,lattd,longtd,depth,magtd,a,d,s,t0,kjmu
      real cx,cy,x,y,xpoly,ypoly,apoly,mueep,ocllst
      real am,bm,sigm,at,bt,sigt,ba,siga,sigu,b,c,p
      real mu,kappa,delay,sumgt0,timsyn(1000),latsyn(1000)
      real w,evson(90000),omor,bckgrd,magi,param,par
      real eta1,eqmag(90000),bgdkj,f0rsum,tval,pval
      real n5pd,area,minmag,maxmag,r5pd,eqmagi,areain,dctime
      real mag0,deltam,wbar,pmat(20,19),pvec(380),ptry(20)
      real lleep,yvec(20),llppe,pmin,prange,beepas,totlst
      real ocllkj,ocll,totll3,oclsup,totll0,oclogl,totll1
      real balpha,delgm2,lleep2,inflam(100,2),cdfmag(100,100)
      real lonsyn(1000),magsyn(1000),magsrt(1000),latsrt(1000)
      real timsrt(1000),lonsrt(1000),zeta,stmu,step
      real jkappa,jp,jc,jsig,jmu,jd,jq,jb,jomor,lljans
      real ll4,jocll,oclogj,totll4,noclj,gsc1,gsc2,s1,s2
      real lstpp2,lstpe2,rated,magdel,maglim,ppertd,timed,evtfmx
      logical unitok, unitop
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockg/tval(251),pval(251)
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blocki/stmu,step(90000)
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
      data param/3.95,5.75,8.05,1.0,0.0926,7.68,1.41e-6,
     1     1.4,1.0,0.32,1.5,0.4,0.23,0.35,3.3,0.0,
     1     0.03,1.2,0.0901,0.0056,0.746,0.7,50.0,1.0,0.95,0.95,
     1     0.61,0.0,0.0901,1.1,0.03,0.0056,0.3,1.5,1.5,0.95,1,2/     
      data parstr/'m0','mc','mmax','b','a','d','s',
     1 'am','bm','sigm','at','bt','sigt','ba','siga','mu',
     1 'c','p','kapp','sigu','nu','delt','dely','beep',
     1 'alph','omeg','zeta','stmu','jkap','jp','jc',
     1 'jsig','jmu','jd','jq','jalp','veep','vjan','endp'/
      data filino/10,20,21,11,14,21,25,19,24,23,16,8,22,91,92/
      data nftp,filitp/15,'cata','poly','oldw','out1','out2',
     1 'neww','arra','conv','grdm','grdl','expn','lice','norm',
     1'bkgd','cond','end'/
      data filist/'old','old','old','new','new','new','new','new',
     1'old','old','old','old','old','old','old','old'/
      data parst2/'mstp','mlo','mhi','lat','lamn','lamx',
     1 'long','lomn','lomx','tstp','mnth','day','yrmn','yrmx',
     1 'mag','last','lost','latn','lonn','year','nfile','nmstp',
     1 'ntstp','glas','glos','gyr1','gmo1','gdy1','ghr1','gmn1',
     1 'gsc1','gyr2','gmo2','gdy2','ghr2','gmn2','gsc2',
     1 'rtr','gmt','colfl','cntfl','ttlfl','nsim','stcom','optst',
     1 'mask'/
      data filinm(12)/'licence/licencekey.dat'/
      data filinm(13)/'normalintegral.dat'/
      data param2/0.1,6.0,8.0,0.,-90.,90.,0.,-180.,180.,1.,
     1     1.,1.,1996.,2016.,7.0,0.,0.,41.,41.,2006.,25,21,21.,
     1     0.1,0.1,2006,1,1,0,0,0.0,2007,1,1,0,0,0.0,1,1,1,1,1,
     1     5000,1,0,1/ 
      data jff6,jff9,jff10,jff14,jff20,jff22/6,9,10,14,20,22/
      data jff91,jff92/91,92/
      data parst3/'titl','cntfn','cptfn'/
      data param3/"","contour.dat","colours.cpt"/
c----- file number definitions
      parameter (backsl = '\\')
      parameter (lastri=41,npar=38,npar2=46,npar3=3)
c----- lastri is length of astri
      data (astri(i),i=1,lastri)/'FILE','CATA','CATP','POLY',
     1'PARA','WEIG','PERI','COMP','PPEO','EEPO',
     1 'ASOP','PPET','PPEM','PPEX','EEPT','EEPM','EEPX','GMTP',
     1 'LICE','NULL','EEPG','PARP','BOPT','NVST','LIKE','WBOP',
     1 'PERF','PPEG','EASO','EAST','EASM','EASX','EASG','EASL',
     1 'EEPS','STEO','STPO','JANO','EEPF','PPEF','STOP'/
      external dnorsc,dnorm,llppe,lleep,llas,lleep2,llstpp,
     1 llstpe,lljans,lstpe2,lstpp2
c-----read in name of command data file
c      read(5,*)fil9nm
      call getarg(1,fil9nm)
c-----initialise random number generator
      x=rand(372)
c-----assign default names to output files
      do i=4,8
         filinm(i)=jointx(fil9nm,filino(i))
         open(unit=filino(i),file=filinm(i),status='new')
         write(6,*)filinm(i),filitp(i),filino(i)
      enddo   
      open(unit=jff9,file=fil9nm,status='old')
      write(6,*)"EEPSOF (EEPAS Software) Version 1.9l"
      do i=1,90000
       ss(i)=1
      enddo
c-----read and print command file
 50   read(jff9,51,end=52)astrng
 51   format(20a4)
      write(jff6,53)astrng
 53   format(1x,20A4)
      go to 50
 52   rewind Jff9
      ncom=0
c-----assign default parameter values
      go to 5043
c-----read directive from command file
 60   read(jff9,61,end=598)bkey
 61   format(A4)
      if ((ncom.ge.1).and.(licval.eq.0)) then
      inquire(unit=8,exist=unitok,opened=unitop)
      if (unitok .and. .not. unitop)
     1  open(unit=8,file=filinm(12),status='old')
       call checky(8)
       close(8)
c-----check licence key if not already checked
       licval=1
      endif
      if ((ncom.ge.1).and.(niread.eq.0))then
      inquire(unit=8,exist=unitok,opened=unitop)
      if (unitok .and. .not. unitop)
     1 open(unit=jff22,file=filinm(13),status='old')
c----- now read in normal integral values
      do i=1,251
         read(jff22,*,err=47)tval(i),pval(i)
      enddo
      go to 48
 47   write(jff6,*)"Input file ",filinm(13)," not present ",
     1"or incomplete. Exiting."
      go to 599      
 48   close(jff22)
      niread=1
      endif
      ncom=ncom+1
      do icom=1,lastri
         if (bkey.eq.astri(icom))go to 5
c---- we know it was command 'icom'
      enddo
      write(jff6,25)bkey
 25   format(1X,'Directive name ',A4,' not recognised. Exiting')
      go to 599
 5    write(jff6,*)astri(icom)
      go to (500,501,502,503,504,505,506,507,
     1 508,509,510,511,512,513,514,515,516,517,518,519,520,521,
     1 522,523,524,525,526,527,528,529,530,531,532,533,534,535,
     1 536,537,538,539,599), icom
C========FILES
c     read in file names from input file and open
 500  read(jff9,*)filetp,filenm
      if (filetp.eq.'end')go to 5003
      do i=1,nftp
         if (filetp.eq.filitp(i))go to 5001
      enddo
      write(jff6,*)'Unknown filetype',filetp,'. Exiting'
      go to 599
 5001 filinm(i)=filenm
      inquire(unit=filino(i),exist=unitok,opened=unitop)
      if (unitok .and. unitop) close(filino(i))
      open(unit=filino(i),file=filinm(i),status=filist(i))
      write(6,*)filitp(i),filinm(i),filino(i)
      go to 500
 5003 continue
      go to 60
C========CATAlog
C     read in and select earthquake catalog data
 501  if (polyfl.eq.0) then
         write(6,*)'Error: POLYGON or NULLPOLY ',
     1   'directive must precede CATALOG directive. Exiting'
         go to 599
      endif
      read(jff9,*,err=5018)latmin,latmax,longmn,longmx
      write(jff6,*)latmin,latmax,longmn,longmx
 5012 if (catkey.eq.'all')write(6,*)
     1 "Including all earthquake locations"
      if (catkey.eq.'poly')write(6,*)
     1 "Including all locations inside polgon"
      read(jff9,*,err=5017)y1,m1,d1,h1,mn1,s1,
     1y2,m2,d2,h2,mn2,s2,m0,depmin,depmax,depdel
      write(jff6,*)y1,m1,d1,y2,m2,d2,m0,depmin,depmax,depdel
      yref=y1-1
      tmin=dctime(y1,m1,d1,0,0,0.0,yref)
      tmax=dctime(y2,m2,d2,23,59,59.999,yref)
      write(jff6,*)"tmin,tmax=",tmin,tmax
 5014 i=0
      write(14,5016)
 5016 format("Reading data from catalogue",//,"Index, Time(days), "
     1,"Lat, Long, Mag, In polygon? (1/0), "
     1,"In depth margin? (0/1)")
 100  read(jff10,*,end=99,err=100) year,month,day,hour,minute,second,
     1lattd,longtd,depth,magtd
      if (yref.eq.0)yref=year-1
      tdec=dctime(year,month,day,hour,minute,second,yref)
      if((catkey.eq.'all').or.(catkey.eq.'poly'))go to 5013
      if((lattd.lt.latmin).or.(lattd.gt.latmax).or.(longtd.lt.longmn)
     1 .or.(longtd.gt.longmx))go to 100
 5013 if(catoth.eq.'all')go to 5015
      if ((magtd.lt.m0).or.
     1 (depth.lt.(depmin-depdel)).or.(depth.gt.(depmax+depdel)).or.
     1 (tdec.lt.tmin).or.(tdec.gt.tmax))go to 100
 5015 inros=inside(longtd,lattd,xpoly,ypoly,npoly,cx,cy)
      if ((inros.eq.0).and.(catkey.eq.'poly'))go to 100
      i=i+1
      time(i)=tdec
      yr(i)=year
      mth(i)=month
      dy(i)=day
      hr(i)=hour
      mnt(i)=minute
      scnd(i)=second
      lat(i)=lattd
      long(i)=longtd
      dep(i)=depth
      mag(i)=magtd
      inout(1,i)=inros
      inout(2,i)=1
      if ((depth.lt.depmin).or.(depth.gt.depmax))inout(2,i)=0
      if (catoth.eq.'all')inout(2,i)=1
      write(14,*) i,time(i),lat(i),long(i),mag(i),inout(1,i),
     1inout(2,i)
      go to 100
 99   continue
      n=i
      if(tmin.eq.0.)tmin=dctime(yr(1),mth(1),dy(1),0,0,0.0,yref)
      if(tmax.eq.0.)tmax=dctime(yr(n),mth(n),dy(n),0,0,0.0,yref)+1.
      write(jff6,*)'n=',n
      write(14,*)'Finished reading catalogue'
      write(14,*)"No of earthquakes =",n
      ncat=n
      go to 60
 5017 backspace(jff9)
      read(jff9,*)catoth
      if (catoth.eq.'all')write(6,*)
     1 "Including all times of occurrence, magnitudes and depths"
      if(catoth.ne.'all')go to 5019
      go to 5014
 5018 backspace(jff9)
      read(jff9,*)catkey
 5011 format(a4)
      if((catkey.eq.'all').or.(catkey.eq.'poly'))go to 5012
 5019 write(jff6,*)"Error reading catalogue delimiters. Exiting."
      go to 599
C========CATPRint
c print the selected data from the catalogue
 502  read(jff9,*) nf
      filenm=jointx(fil9nm,nf)
      open(unit=nf,file=filenm,status='new')
      do i=1,ncat
         write(nf,5021)yr(i),mth(i),dy(i),hr(i),mnt(i),scnd(i),
     1   lat(i),long(i),dep(i),mag(i)
      enddo
      close(nf)
 5021 format(1x,i4,4i3,f5.1,f7.2,f8.2,f7.1,f4.1)
      go to 60
C========POLYgon
C     read in polygon vertices and compute area
 503  i=0
      read(20,*,err=5039) cy,cx
c----- file20 has point inside polygon and polygon vertices
c----- cx,cy is any point inside the polygon
      write(11,*)"Polygon Vertices"
      write(11,*)
 201  read(20,*,end=299,err=5039) y,x
      i=i+1
      xpoly(i)=x
      ypoly(i)=y
      write (11,5031)i,xpoly(i),ypoly(i)
 5031 format(i4,2f12.3)
      go to 201  
 299  npoly=i
      write(jff6,*)'npoly =',npoly
      xpoly(npoly+1)=xpoly(1)
      ypoly(npoly+1)=ypoly(1)
c----  end setup of inside polygon test
      write(jff6,*)'Finished reading polygon'
      write(6,*)
      apoly=areain(cx,cy,xpoly,ypoly,npoly,360)
      area=apoly
      write(11,*)
      write(11,*)"Area inside polygon: ",area, " sq. km"
      polyfl=1
      go to 60
 5039  write(jff6,*)"Error reading polygon vertices. Exiting"
      go to 599
C========PARAmeters
 504  read(jff9,*,err=5049)pars,par
      if (pars.eq.parstr(npar+1))go to 5043
      do i=1,npar
         if (pars.eq.parstr(i))go to 5041
      enddo
      do i=1,npar2
         if (pars.eq.parst2(i))go to 5042
      enddo
      do i=1,npar3
         if (pars.eq.parst3(i))go to 5045
      enddo
      backspace(jff9)
      read(jff9,*)pars
      if (pars.eq.parstr(npar+1))go to 5043
      if (jff9.eq.7)go to 5048
      backspace(jff9)
      read(jff9,*)filenm
      jff9=7
      open(unit=jff9,file=filenm,status='old',err=5044)
      write(6,*)"Reading parameter values from file ",filenm
      go to 504
 5044 write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5041 param(i)=par
      write(6,*)pars,par
      go to 504
 5042 param2(i)=par
      write(6,*)pars,par
c     check if last or lost etc has been set
      if (i.eq.1)mstpst=1
      if (i.eq.10)tstpst=1
      if (i.eq.16)lastst=1
      if (i.eq.17)lostst=1
      if (i.eq.18)lastst=0
      if (i.eq.19)lostst=0
      if (i.eq.23)tstpst=0
      if (i.eq.22)mstpst=0
      if ((i.eq.2).or.(i.eq.3))mrange=1
      if (i.eq.15)mrange=0
      if ((i.eq.13).or.(i.eq.14))trange=1
      if (i.eq.20)trange=0
      if (i.eq.21)nfflag=0
c     flags unit nfile as unused 
      go to 504
 5045 backspace(jff9)
      read(jff9,*)pars,par3
      do i=1,npar3
         if (pars.eq.parst3(i))go to 5046
      enddo
 5046 param3(i)=par3
      write(6,*)pars,par
      go to 504
 5043 continue
c-----reset parameters
      mag0=param(1)
      minmag=param(2)
      maxmag=param(3)
      b=param(4)
      a=param(5)
      d=param(6)
      s=param(7)
      am=param(8)
      bm=param(9)
      sigm=param(10)
      at=param(11)
      bt=param(12)
      sigt=param(13)
      ba=param(14)
      siga=param(15)
      mueep=param(16)
      mu=mueep
      c=param(17)
      p=param(18)
      kappa=param(19)
      sigu=param(20)
      kjmu=param(21)
      deltam=param(22)
      delay=param(23)
      beepas=param(24)
      balpha=param(25)
      delgm2=param(26)
      zeta=param(27)
      stmu=param(28)
      jkappa=param(29)
      jp=param(30)
      jc=param(31)
      jsig=param(32)
      jmu=param(33)
      jd=param(34)
      jq=param(35)
      jb=param(36)
      veepas=int(param(37))
      vjanus=int(param(38))
      mstp=param2(1)
      mmin=param2(2)
      mmax=param2(3)
      xlat=param2(4)
      lamn=param2(5)
      lamx=param2(6)
      xlon=param2(7)
      lomn=param2(8)
      lomx=param2(9)
      tstp=param2(10)
      mnthtm=int(param2(11))
      daytm=int(param2(12))
      yrmn=int(param2(13))
      yrmx=int(param2(14))
      xmag=param2(15)
      last=param2(16)
      lost=param2(17)
      latn=int(param2(18))
      lonn=int(param2(19))
      yeartm=int(param2(20))
      nfile=int(param2(21))
      if ((nfile.lt.25.or.nfile.gt.99))go to 5047
      inquire(unit=nfile,opened=unitop)
      if (.not. unitop)then
         filenm=jointx(fil9nm,nfile)
         open(unit=nfile,file=filenm,status='new')
      endif
      nmstp=int(param2(22))
      ntstp=int(param2(23))
      glast=param2(24)
      glost=param2(25)
      gyr1=int(param2(26))
      gmo1=int(param2(27))
      gdy1=int(param2(28))
      ghr1=int(param2(29))
      gmn1=int(param2(30))
      gsc1=param2(31)
      gyr2=int(param2(32))
      gmo2=int(param2(33))
      gdy2=int(param2(34))
      ghr2=int(param2(35))
      gmn2=int(param2(36))
      gsc2=param2(37)
      rtrfl=int(param2(38))
      gmtfl=int(param2(39))
      colfl=int(param2(40))
      contfl=int(param2(41))
      titfl=int(param2(42))
      nsim=int(param2(43))
      stcom=int(param2(44))
      optst=int(param2(45))
      mask=int(param2(46))
      filino(7)=nfile
      title=param3(1)
      contfn=param3(2)
      cptfn=param3(3)
c now reset n values where step sizes declared
      if (lastst.eq.1)then
         latn=int((lamx-lamn)/last)+1
         param2(18)=latn
         lamx=lamn+(latn-1)*last
         param2(6)=lamx
         write(jff6,*)"Latitude maximum is", lamx
         lastst=0
      endif
      if (lostst.eq.1)then
         lonn=int((lomx-lomn)/lost)+1
         param2(19)=lonn
         lomx=lomn+(lonn-1)*lost
         param2(9)=lomx
         write(jff6,*)"Longitude maximum is", lomx
         lostst=0
      endif
      if (tstpst.eq.1)then
         ntstp=int((yrmx-yrmn)/tstp)+1
         param2(20)=ntstp
         yrmx=int(yrmn+(ntstp-1)*tstp)
         param2(14)=yrmx
         write(jff6,*)"Adjusted maximum year to", yrmx
         tstpst=0
      endif
      if (mstpst.eq.1)then
         nmstp=int((mmax-mmin)/mstp)+1
         param2(22)=nmstp
         mmax=int(mmin+(nmstp-1)*mstp)
         param2(3)=mmax
         write(jff6,*)"Adjusted top of magnitude range to", mmax
         mstpst=0
      endif
      jff9=9
      go to 60
 5049 continue
      backspace(jff9)
      read(jff9,*)pars
      do i=1,npar3
         if (pars.eq.parst3(i))go to 5045
      enddo
      if (pars.eq.parstr(npar+1))go to 5043
      if (jff9.eq.7)go to 5048
      backspace(jff9)
      read(jff9,*)filenm
      jff9=7
      open(unit=jff9,file=filenm,status='old')
      write(6,*)"Reading parameter values from file ",filenm
      go to 504
 5047 write(jff6,*)nfile," Invalid nfile value. Try value in range ",
     1 "26 - 98. Exiting"
      go to 599
 5048 write(jff6,*)"Error reading parameter values. Exiting"
      go to 599
C=======WEIGhting strategy
 505  read(jff9,*,err=5059)iwgt
      if ((iwgt.ne.0).and.(iwgt.ne.1).and.(iwgt.ne.2))go to 5059
      if (iwgt.eq.2) then
         iread=1
      else
         isave=iwgt
      endif
      go to 60
 5059  write(jff6,*)"Incorrect weighting declaration. Exiting"
      go to 599
C=======PERIod for testing
 506  read(jff9,*,err=5069)y1,m1,d1,y2,m2,d2
      if (dctime(y1,m1,d1,0,0,0.0,yref).ge.
     1 dctime(y2,m2,d2,0,0,0.0,yref)) go to 5069
      go to 60
 5069  write(jff6,*)"Incorrect period specification. Exiting"
      go to 599
C=======COMPute weights
 507  continue
c calculate hazard components
      t0=time(1)-1.0
      do l=1,4
         call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1        a,minmag,d,s,inout,8,f0rsum)
         ncount=0
         sumgt0=0.0
         do i=1,n
            if (f0rsum(i).gt.0.)then
               sumgt0=sumgt0+f0rsum(i)
               if((inout(1,i).eq.1).and.(inout(2,i).eq.1))
     1         ncount=ncount+1
            endif
         enddo
c         write(jff14,*)"sumgt0, ncount, aploy ",sumgt0,ncount,apoly
c         a=a*(1-((sumgt0-ncount)/(sumgt0-apoly*ncount*s)))
         a=abs(a)
      enddo
      write(jff14,*)"a,d,s=",a,d,s
c      write(jff6,*)"a,d,s=",a,d,s
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
c      write(jff6,*) "got through ckjbgd"
c      call cbckgd(n,lat,long,mag,bckgrd,b,r5pd)
c      write(jff6,*) "got through cbckgd r5pd", r5pd
      if (iread.eq.1) then
       wsum=0.0
       wsumd=0.0
       do i=1,n
         read(21,*)w(i)
        if(inout(2,i).eq.1)wsumd=wsumd+w(i)
         wsum=wsum+w(i)
       enddo
      endif 
      if (iread.eq.0) then
       if (iwgt.eq.1) then
       call comori(n,kappa,c,p,b,deltam,sigu,lat,long,mag,time,
     1 omor,0.)
c       write(jff6,*) "got through comori"
       endif
       wsumd=0.0
       wsum=0.0
       do i=1,n
        if ((omor(i).eq.0.0).or.(iwgt.eq.0))then
           w(i)=1.0
        else
         w(i)=kjmu*bgdkj(i)/(kjmu*bgdkj(i)+omor(i))
c         w(i)=sqrt(w(i))
        endif 
        if (isave.eq.1) write(21,*)w(i),i
        wsum=wsum+w(i)
        if(inout(2,i).eq.1)wsumd=wsumd+w(i)
        eqmag(i)=eqmagi       
       enddo
      endif
      write(14,*)'wsum=',wsum
      wbar=wsum/n
      extraf=wsumd/wsum
c extraf compensates for precursors at other depths
      write(6,*)"wbar=",wbar
      if (veepas.eq.2) then
       call ceta3(n,beepas,am,sigm,delgm2,zeta,mu,wbar,balpha,eta)
      else
       call ceta1(n,beepas,bm,mag,eta1,extraf)
c      write(6,*)"got through ceta1"
       call ceta(eta1,n,beepas,am,sigm,mueep,wbar,eta)
      endif
c end of compute weights?
      go to 60
C=====LIKElihoods of SUP,PPE and EEPAS models
 524  continue
      if (veepas.eq.2)go to 533
c-----if any model parameters have changed, may have to recompute weights
      if (npoly.eq.0) go to 5249
      t1=dctime(y1,m1,d1,0,0,0.0,yref)
      t2=dctime(y2,m2,d2,23,59,59.999,yref)
      if (t2.le.t1)go to 5069
      do i=1,n
       if (time(i).lt.t1)n1=i+1
       if (time(i).lt.t2)n2=i
      enddo
      do i=n1,n2
         if (mag(i).ge.minmag)write(14,*)time(i),mag(i),lat(i),
     1    long(i),bgdkj(i),bckgrd(i)
      enddo
c count no. of eqs with mag  >= minmag in ros between n1 and n2 
      ncount=0
      do i=n1,n2
       if((mag(i).ge.minmag).and.(mag(i).le.maxmag).and.
     1(inout(1,i).eq.1).and.(inout(2,i).eq.1))then
          ncount=ncount+1
          nlist(ncount)=i
       endif   
      enddo       
      write (jff6,*) "No in ros in range",minmag,"-",maxmag,
     1 " from ",y1,m1,d1," to ",y2,m2,d2,":",ncount
      neq=ncount
      n5pd=ncount*(10**(b*(minmag-4.95))/(t2-t1)
     1 +10**(b*(minmag-maxmag))/(tmax-tmin))
      r5pd=n5pd/area
      write(jff6,*)"n5pd,r5pd=", n5pd,r5pd
      call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1  a,minmag,d,s,inout,8,f0rsum)
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
      call cbckgd(n,lat,long,mag,bckgrd,b,r5pd)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,beepas,mag0)
      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
     1ss,mag,minmag,inout)
      inquire(unit=filino(11),exist=unitok,opened=unitop)
      if (unitok .and. unitop) then
         if (steflg.ne.1) then
           call cstep(n,lat,long,yr,mth,dy,hr,mnt,mag,bgdkj,step,
     1optst)
           steflg=1
         endif
         oclstp=ocllst(n1,n2,bckgrd,omor,evson,
     1        bgdkj,step,0.,0.,0.,0.,1.0,ss,mag,minmag,inout)
         noclst=real(ncount)
         totlst=oclstp-noclst
      endif
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,ncat,
     1 ll0,ll1,ll2,ll3)
      totll3=ocllkj-ll3
      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
     1ss,mag,minmag,inout)
      totll0=oclsup-ll0
      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
     1       0.,0.,1.,mueep,ss,mag,minmag,inout)
      totll1=oclogl-mueep*ll3-ll1
      write(11,*)"EEPAS parameters"
      write(11,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep,
     1eta(1)
c now print out table of log likelihoods
      write(11,*)
      write(11,*)'Table of log likelihoods'
      write(11,*)
      write(11,*)'Model    Occurrence   Non-occurrence    ',
     1'  Total   Neq   Info.rate'
      write(11,5241)'  SUP',oclsup,-ll0,totll0,neq,
     1(totll0-totll0)/neq
      write(11,5241)'  PPE',ocllkj,-ll3,totll3,neq,
     1(totll3-totll0)/neq
      write(11,5241)'EEPAS',oclogl,-(ll1+mueep*ll3),totll1,neq,
     1(totll1-totll0)/neq
      write(6,*)'Model    Occurrence   Non-occurrence      Total'
      write(6,5241)'  SUP',oclsup,-ll0,totll0
      write(6,5241)'  PPE',ocllkj,-ll3,totll3
      write(6,5241)'EEPAS',oclogl,-(ll1+mueep*ll3),totll1
      if (unitop.and.unitok) then
         write(6,5241)' STEP',oclstp,-noclst,totlst
         write(11,5241)' STEP',oclstp,-noclst,totlst
      endif
c==== Likelihood of Janus model-only etas at the moment
      if (vjanus.ne.0) then
         if (vjanus.eq.2) then
         call comorj(n,kappa,c,p,b,deltam,sigu,lat,long,mag,time,
     1   jomor,delay,minmag)
         call jnoct2(t1,t2,w,time,mag,inout,lat,long,bt,bm,ba,
     1   sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,jkappa,jb,jc,jp,
     1   jsig,minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1   ll0,ll1,ll2,ll3,ll4)
         oclogj=ocll(n1,n2,bckgrd,jomor,evson,bgdkj,0.,
     1   1.,0.,jmu,ss,mag,minmag,inout)
         noclj=jmu*ll3+ll2
         totll4=oclogj-noclj
         endif
      endif   
      if (vjanus.ne.0) then
         write(6,5241)' ETAS',oclogj,-noclj,totll4
         write(11,5241)' ETAS',oclogj,-noclj,totll4,
     1   neq,(totll4-totll0)/neq
      endif

 5241 format(a6,3f14.3,i6,f12.3)
      go to 60
C=====EASL Likelihoods of SUP,PPE and EAS models
 533  continue
c-----if any model parameters have changed, may have to recompute weights
      if (npoly.eq.0) go to 5249
      t1=dctime(y1,m1,d1,0,0,0.0,yref)
      t2=dctime(y2,m2,d2,23,59,59.999,yref)
      if (t2.le.t1)go to 5069
      do i=1,n
       if (time(i).lt.t1)n1=i+1
       if (time(i).lt.t2)n2=i
      enddo
      do i=n1,n2
         if (mag(i).ge.minmag)write(14,*)time(i),mag(i),lat(i),
     1    long(i),bgdkj(i),bckgrd(i)
      enddo
c count no. of eqs with mag  >= minmag in ros between n1 and n2 
      ncount=0
      do i=n1,n2
       if((mag(i).ge.minmag).and.(mag(i).le.maxmag).and.
     1(inout(1,i).eq.1).and.(inout(2,i).eq.1))then
          ncount=ncount+1
          nlist(ncount)=i
       endif   
      enddo       
      write (jff6,*) "No in ros in range",minmag,"-",maxmag,
     1 " from ",y1,m1,d1," to ",y2,m2,d2,":",ncount
      neq=ncount
      n5pd=ncount*(10**(b*(minmag-4.95))/(t2-t1)
     1 +10**(b*(minmag-maxmag))/(tmax-tmin))
      r5pd=n5pd/area
      write(jff6,*)"n5pd,r5pd=", n5pd,r5pd
      call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1  a,minmag,d,s,inout,8,f0rsum)
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
      call cbckgd(n,lat,long,mag,bckgrd,b,r5pd)
      call cevre2(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,beepas,mag0,
     1  delgm2,zeta,balpha)
c      write(6,*)"flag1 n1 n2",n1,n2
      call no2clt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,balpha,c,p,ss,n5pd,area,1.0,kappa,eta,delgm2,
     1  zeta,minmag,delay,f0rsum,xpoly,ypoly,npoly,ncat,
     1 ll0,ll1,ll2,ll3)
      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
     1ss,mag,minmag,inout)
      totll3=ocllkj-ll3
      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
     1ss,mag,minmag,inout)
      totll0=oclsup-ll0
      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
     1       0.,0.,1.,mueep,ss,mag,minmag,inout)
      totll1=oclogl-mueep*ll3-ll1
      write(11,*)"EEPAS2 parameters"
      write(11,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep,delgm2,zeta,
     1eta(1)
c now print out table of log likelihoods
      write(11,*)
      write(11,*)'Table of log likelihoods'
      write(11,*)
      write(11,*)'Model    Occurrence   Non-occurrence    ',
     1'  Total   Neq   Info.rate'
      write(11,5331)'   SUP',oclsup,-ll0,totll0,neq,
     1(totll0-totll0)/neq
      write(11,5331)'   PPE',ocllkj,-ll3,totll3,neq,
     1(totll3-totll0)/neq
      write(11,5331)'EEPAS2',oclogl,-(ll1+mueep*ll3),totll1,neq,
     1(totll1-totll0)/neq
      write(6,*)'Model     Occurrence   Non-occurrence      Total'
      write(6,5331)'   SUP',oclsup,-ll0,totll0
      write(6,5331)'   PPE',ocllkj,-ll3,totll3
      write(6,5331)'EEPAS2',oclogl,-(ll1+mueep*ll3),totll1
 5331 format(a6,3f14.3,i6,f12.3)
c      write(6,*)"flag2 n1 n2",n1,n2
      go to 60
C======PERFormance factor vs time
 526  continue
         do i=1,neq
        call nocllt(t1,time(nlist(i)),w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,mueep,kappa,eta,minmag,
     1  deltam,delay,f0rsum,xpoly,ypoly,npoly,ncat,ll0,ll1,ll2,ll3)
        evson(nlist(i))=evitmx(time(nlist(i)),mag(nlist(i)),ncat,
     1  lat(nlist(i)),long(nlist(i)),eta,am,bm,
     1  sigm,at,bt,sigt,ba,siga,lat,long,mag,time,w,b,mag0)
            write(19,*) nlist(i),yr(nlist(i)),mth(nlist(i)),
     1      dy(nlist(i)),lat(nlist(i)),long(nlist(i)),mag(nlist(i)),
     1      bckgrd(nlist(i)),bgdkj(nlist(i)),(evson(nlist(i))+mueep*
     1       bgdkj(nlist(i))),ll0,ll3,(ll1+mueep*ll3)
         enddo
        call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,minmag,
     1  deltam,delay,f0rsum,xpoly,ypoly,npoly,ncat,ll0,ll1,ll2,ll3)
        write(19,*) y2,m2,d2,ll0,ll3,(ll1+mueep*ll3)
c end of performance factor vs time
      go to 60 
 5249 write(jff6,*)"Polygon not defined. Exiting"
      go to 599
C=======PPEOpt (optimisation of PPE model parameters)
 508  continue
      ptry(1)=a
      ptry(2)=1+abs(asin(d/30.))
      ptry(3)=s
      call ceta1(n,beepas,bm,mag,eta1,extraf)
      mp=4
      np=3
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)*1.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
c            write (6,*) "changing ptry",j,i
         enddo
c        write(6,*)"evaluating llppe"
         yvec(j)=llppe(ptry)
         write(6,*)"ptry,llppe",(ptry(i),i=1,3),yvec(j)
      enddo
      write(14,*)"Stopping values"
      ndim=np
      ftol=0.0000001
      iter=500
      call matvec(20,19,mp,np,pmat,pvec)
      call amoeba(pvec,yvec,mp,np,ndim,ftol,llppe,iter)
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,np
         write(19,*)(pmat(j,i),i=1,3),yvec(j)
      enddo
      param(5)=a
      param(6)=d
      param(7)=s
      go to 60
C=======STPOpt (optimisation of STEP-PPE model parameters)
 536  continue
      if (steflg.ne.1)then
         call cstep(ncat,lat,long,yr,mth,dy,hr,mnt,mag,bgdkj,step,
     1optst)
         steflg=1
      endif
 5363 read(jff9,*,err=5369)pars,parmin,parmax
      write(jff6,*)pars,parmin,parmax
      if ((parmin.lt.0.).or.((parmax-parmin).le.0.))go to 5368
      if (pars.eq.parstr(npar+1))go to 5362
      do i=5,7
         if (pars.eq.parstr(i))go to 5361
      enddo
      if (pars.eq.parstr(28))then
         i=28
         go to 5361
         endif
      write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5361 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=pmin(i)+abs(asin((param(i)-pmin(i))/prange(i)))
      go to 5363
 5362 continue
      call ceta1(n,beepas,bm,mag,eta1,extraf)
      mp=j+1
      np=j
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)*1.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      if (stcom.eq.1)then
       do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
c        write(6,*)"evaluating llstpp"
         yvec(j)=llstpp(ptry)
         write(6,*)"ptry,llstpp",(ptry(i),i=1,np),yvec(j)
       enddo
       write(14,*)"Stopping values"
       ndim=np
       ftol=0.0000001
       iter=500
       call matvec(20,19,mp,np,pmat,pvec)
       call amoeba(pvec,yvec,mp,np,ndim,ftol,llstpp,iter)
      else if (stcom.eq.2)then
       do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
c        write(6,*)"evaluating lstpp2"
         yvec(j)=lstpp2(ptry)
         write(6,*)"ptry,lstpp2",(ptry(i),i=1,np),yvec(j)
       enddo
       write(14,*)"Stopping values"
       ndim=np
       ftol=0.0000001
       iter=500
       call matvec(20,19,mp,np,pmat,pvec)
       call amoeba(pvec,yvec,mp,np,ndim,ftol,lstpp2,iter)
      endif
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,np
         write(19,*)(pmat(j,i),i=1,3),yvec(j)
      enddo
      param(5)=a
      param(6)=d
      param(7)=s
      param(28)=stmu
      go to 60
 5368 backspace(jff9)
      read(jff9,*)pars
      if (pars.eq.parstr(npar+1))go to 5362
      write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5369 write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599

C=======EEPOpt Optimisation of EEPAS model parameters
 509  continue
      if (veepas.eq.2)go to 528 
      j=0
 5093 read(jff9,*,err=5099)pars,parmin,parmax
      write(jff6,*)pars,parmin,parmax
      if ((parmin.lt.0.).or.((parmax-parmin).le.0.))go to 5098
      if (pars.eq.parstr(npar+1))go to 5092
      do i=8,16
         if (pars.eq.parstr(i))go to 5091
      enddo
      write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5091 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=abs(asin((param(i)-pmin(i))/prange(i)))
      if ((parstr(i).eq.'nu').and.(parmax.gt.1.))go to 5098
      go to 5093
 5092 continue
      np=j
      mp=j+1
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)+0.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
        write(6,*)"evaluating lleep"
         yvec(j)=lleep(ptry)
         write(6,*)"ptry,lleep",(ptry(i),i=1,3),yvec(j)
      enddo
      write(14,*)"Stopping values"
      ndim=np
      ftol=0.0000001
      iter=500
      call matvec(20,19,mp,np,pmat,pvec)
      call amoeba(pvec,yvec,mp,np,ndim,ftol,lleep,iter)
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,mp
         do i=1,np
            pmat(j,i)=pmin(pnum(i))+prange(pnum(i))*
     1      abs(sin(pmat(j,i)))
         enddo   
         write(19,*)(pmat(j,i),i=1,np),yvec(j)
      enddo
      param(8)=am
      param(9)=bm
      param(10)=sigm
      param(11)=at
      param(12)=bt
      param(13)=sigt
      param(14)=ba
      param(15)=siga
      param(16)=mueep
      mu=mueep
      go to 60
 5098 backspace(jff9)
      read(jff9,*)pars
      if (pars.eq.parstr(npar+1))go to 5092
      write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5099 write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599
C=======STEOpt Optimisation of EEPAS model parameters in STEP-EEPAS model
 535  continue
      if (veepas.eq.2) then
         write(6,*)"Error: Cannot optimise STEP-EEPAS model using ',
     1   'EEPAS with aftershocks model (veep=2). Exiting"
         go to 599
      endif   
      j=0
 5353 read(jff9,*,err=5359)pars,parmin,parmax
      write(jff6,*)pars,parmin,parmax
      if ((parmin.lt.0.).or.((parmax-parmin).le.0.))go to 5358
      if (pars.eq.parstr(npar+1))go to 5352
      do i=8,16
         if (pars.eq.parstr(i))go to 5351
      enddo
      i=28
      if (pars.eq.parstr(i))go to 5351
      write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5351 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=abs(asin((param(i)-pmin(i))/prange(i)))
      if ((parstr(i).eq.'nu').and.(parmax.gt.1.))go to 5358
      if ((parstr(i).eq.'stmu').and.(parmax.gt.1.))go to 5358
      go to 5353
 5352 continue
      if (steflg.ne.1)then
         call cstep(ncat,lat,long,yr,mth,dy,hr,mnt,mag,bgdkj,step,
     1optst)
         steflg=1
      endif   
      np=j
      mp=j+1
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)+0.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      if (stcom.eq.1)then
       do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
        write(6,*)"evaluating llstpe"
         yvec(j)=llstpe(ptry)
         write(6,*)"ptry,llstpe",(ptry(i),i=1,np),yvec(j)
       enddo
       write(14,*)"Stopping values"
       ndim=np
       ftol=0.0000001
       iter=500
       call matvec(20,19,mp,np,pmat,pvec)
       call amoeba(pvec,yvec,mp,np,ndim,ftol,llstpe,iter)
      else if (stcom.eq.2) then
       do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
        write(6,*)"evaluating lstpe2"
         yvec(j)=lstpe2(ptry)
         write(6,*)"ptry,lstpe2",(ptry(i),i=1,np),yvec(j)
       enddo
       write(14,*)"Stopping values"
       ndim=np
       ftol=0.0000001
       iter=500
       call matvec(20,19,mp,np,pmat,pvec)
       call amoeba(pvec,yvec,mp,np,ndim,ftol,lstpe2,iter)
      endif
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,mp
         do i=1,np
            pmat(j,i)=pmin(pnum(i))+prange(pnum(i))*
     1      abs(sin(pmat(j,i)))
         enddo   
         write(19,*)(pmat(j,i),i=1,np),yvec(j)
      enddo
      param(8)=am
      param(9)=bm
      param(10)=sigm
      param(11)=at
      param(12)=bt
      param(13)=sigt
      param(14)=ba
      param(15)=siga
      param(16)=mueep
      param(28)=stmu
      mu=mueep
      go to 60
 5358 backspace(jff9)
      read(jff9,*)pars
      if (pars.eq.parstr(npar+1))go to 5352
      write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5359 write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599
C=======ASOPt Optimisation of aftershock model parameters
 510  continue
      j=0
 5103 read(jff9,*,err=5109)pars,parmin,parmax
      write(6,*)pars,parmin,parmax
      if ((parmin.lt.0.).or.((parmax-parmin).le.0.))go to 5108
      if (pars.eq.parstr(npar+1))go to 5102
      do i=17,21
         if (pars.eq.parstr(i))go to 5101
      enddo
      write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5101 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=abs(asin((param(i)-pmin(i))/prange(i)))
      if ((parstr(i).eq."nu").and.(parmax.gt.1.))go to 5108
      go to 5103
 5102 continue
      np=j
      mp=j+1
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)+0.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      write(6,*)"np,mp=",np,mp
      do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
         write(6,*)"evaluating llas"
         yvec(j)=llas(ptry)
         write(6,*)"ptry,llas",(ptry(i),i=1,np),yvec(j)
      enddo
      write(14,*)"Stopping values"
      ndim=np
      ftol=0.000002
      iter=1000
      call matvec(20,19,mp,np,pmat,pvec)
      call amoeba(pvec,yvec,mp,np,ndim,ftol,llas,iter)
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,mp
         do i=1,np
            pmat(j,i)=pmin(pnum(i))+prange(pnum(i))*
     1      abs(sin(pmat(j,i)))
         enddo   
         write(19,*)(pmat(j,i),i=1,np),yvec(j)
      enddo
      param(17)=c
      param(18)=p
      param(19)=kappa
      param(20)=sigu
      param(21)=kjmu
      go to 60
 5108 write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5109 backspace(jff9)
      read(jff9,*)pars
      write(jff6,*)pars,parstr(npar+1)
      if (pars.eq.parstr(npar+1))go to 5102
      write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599
C=======JANOpt Optimisation of Janus model parameters
c     If vjanus=1, model is SUPE (of Console et al., 2006)
c     If vjanus=2, model is PPE-ETAS (similar to SVPE of Console et al., 2006)
c     If vjanus=3, model is EEPAS-ETAS
c     In this version, only option is vjanus=2
 537  continue
      j=0
 5373 read(jff9,*,err=5379)pars,parmin,parmax
      write(6,*)pars,parmin,parmax
      if ((parmin.lt.0.).or.((parmax-parmin).le.0.))go to 5378
      if (pars.eq.parstr(npar+1))go to 5372
      do i=21,36
         if (pars.eq.parstr(i))go to 5371
      enddo
      write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5371 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=abs(asin((param(i)-pmin(i))/prange(i)))
      if ((parstr(i).eq."nu").and.(parmax.gt.1.))go to 5378
      go to 5373
 5372 continue
      np=j
      mp=j+1
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)+0.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      write(6,*)"np,mp=",np,mp
      do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
            write (6,*) "changing ptry",j,i
         enddo
         write(6,*)"evaluating lljans"
         yvec(j)=lljans(ptry)
         write(6,*)"ptry,lljans",(ptry(i),i=1,np),yvec(j)
      enddo
      write(14,*)"Stopping values"
      ndim=np
      ftol=0.000002
      iter=1000
      call matvec(20,19,mp,np,pmat,pvec)
      call amoeba(pvec,yvec,mp,np,ndim,ftol,lljans,iter)
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,mp
         do i=1,np
            pmat(j,i)=pmin(pnum(i))+prange(pnum(i))*
     1      abs(sin(pmat(j,i)))
         enddo   
         write(19,*)(pmat(j,i),i=1,np),yvec(j)
      enddo
      param(21)=kjmu
      param(22)=deltam
      param(23)=delay
      param(24)=beepas
      param(25)=balpha
      param(26)=delgm2
      param(27)=zeta
      param(28)=stmu
      param(29)=jkappa
      param(30)=jp
      param(31)=jc
      param(32)=jsig
      param(33)=jmu
      param(34)=jd
      param(35)=jq
      param(36)=jb
      go to 60
 5378 write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5379 backspace(jff9)
      read(jff9,*)pars
      write(jff6,*)pars,parstr(npar+1)
      if (pars.eq.parstr(npar+1))go to 5372
      write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599
C=======PPETM Spatial matrix of PPE rate density for fixed t & m
 511  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing PPE rate density array to file",
     1 filenm
      write(6,*)"Time ",yeartm,mnthtm,daytm
      write(6,*)"Magnitude ",xmag
      write(6,*)"Latitude range",lamn,lamx,". ",latn," grid points"
      write(6,*)"Longitude range",lomn,lomx,". ",lonn,
     1" grid points"
      tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
      call ckjbtm(tyr,xmag,lamn,lamx,lomn,lomx,latn,lonn,
     1  lat,long,time,mag,ncat,kjbtm,b,a,d,s,minmag,t0,
     1  delay,nfile,rtrfl)
      nfflag=1
      if (eepfl.eq.1)go to 5141
      modnm="PPE"
      if (gmtfl.eq.1)go to 517
c-----flags unit nfile as used 
      go to 60
C=======PPEMx PPE rate density versus time for fixed m & location
 512  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing PPE rate density array to file",
     1 filenm
      tyr1=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
      tyr2=dctime(yrmx,mnthtm,daytm,0,0,0.0,yref)
      if (mrange.eq.0) then
         write(6,*)"Magnitude ",xmag
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1   daytm,".",ntstp," time points"
       call ckjbmx(tyr1,tyr2,xmag,xlat,xlon,ntstp,
     1  lat,long,time,mag,ncat,kjbmx,b,a,d,s,m0,t0,
     1  delay,nfile,rtrfl)
      elseif (mrange.eq.1) then
         write(6,*)"Magnitude range",mmin,mmax,". ",nmstp,
     1   " points"
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1   daytm,".",ntstp," time points"
        do i=1,nmstp
           xm=mmin+(i-1)*(mmax-mmin)/(nmstp-1)
           call ckjbmx(tyr1,tyr2,xm,xlat,xlon,ntstp,
     1      lat,long,time,mag,ncat,kjbmx,b,a,d,s,m0,t0,
     1      delay,nfile,rtrfl)
        enddo   
      endif
      nfflag=1
      if (eepfl.eq.1)go to 5151
      go to 60
C=======PPEXt PPE rate density versus magnitude for fixed t & location 
 513  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing PPE rate density array to file",
     1 filenm
      if (trange.eq.0) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time ",yeartm,mnthtm,daytm
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
       tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
       call ckjbxt(mmin,mmax,tyr,xlat,xlon,nmstp,
     1  lat,long,time,mag,ncat,kjbxt,b,a,d,s,m0,t0,
     1  delay,nfile,rtrfl)
       elseif (trange.eq.1) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1daytm,".",ntstp," time points"
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
        tymn=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
        do i=1,ntstp
         tyr=tymn+(i-1)*(yrmx-yrmn)/(ntstp-1)  
         call ckjbxt(mmin,mmax,tyr,xlat,xlon,nmstp,
     1   lat,long,time,mag,ncat,kjbxt,b,a,d,s,m0,t0,
     1   delay,nfile,rtrfl)
        enddo
       endif
       nfflag=1
       if(eepfl.eq.1)go to 5151
      go to 60
C=======EEPTm Spatial matrix of EEPAS rate density for fixed t & m
 514  continue
      if (veepas.eq.2)go to 529
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      write(6,*)"Time ",yeartm,mnthtm,daytm
      write(6,*)"Magnitude ",xmag
      write(6,*)"Latitude range",lamn,lamx,". ",latn," grid points"
      write(6,*)"Longitude range",lomn,lomx,". ",lonn,
     1" grid points"
      modnm="EEPAS"
      tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
      call cevitm(tyr,xmag,lamn,lamx,lomn,lomx,latn,lonn,
     1 eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1 evitm1,b,mag0,nfile,rtrfl)
      nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 511
      endif
      nfflag=1
      if(gmtfl.eq.1)go to 517
      go to 60
 5141 continue
      eepfl=0
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)'Parameter mu >0. Writing full EEPAS ',
     1 'rate density array to file ',filenm
      nf2=nfile-1
      nf1=nfile-2
      rewind(nf1)
      rewind(nf2)
      call com2fl(nf1,nf2,mueep,nfile)
      if(gmtfl.eq.1)go to 517
      go to 60
C=======EEPMx EEPAS rate density versus time for fixed m & location
 515  continue
      if (veepas.eq.2)go to 530
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      tyr1=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
      tyr2=dctime(yrmx,mnthtm,daytm,0,0,0.0,yref)
      if (mrange.eq.0)then
         write(6,*)"Magnitude ",xmag
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1daytm,".",ntstp," time points"
       call cevimx(tyr1,tyr2,xmag,xlat,xlon,ntstp,
     1 eta,am,bm,sigm,at,bt,sigt,
     1 ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nfile,rtrfl)
c      subroutine cevimx(t1,t2,m,ylat,xlong,n,eta,am,bm,sigm,at,bt,
c     1sigt,ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nf,rtr)
      elseif (mrange.eq.1) then
         write(6,*)"Magnitude range",mmin,mmax,". ",nmstp,
     1   " points"
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1   daytm,".",ntstp," time points"
        do j=1,nmstp
           xm=mmin+(i-1)*(mmax-mmin)/ntstp
           call cevimx(tyr1,tyr2,xm,xlat,xlon,ntstp,
     1      eta,am,bm,sigm,at,bt,sigt,
     1      ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nfile,
     1      rtrfl)
        enddo   
       endif  
       nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 512
      endif   
       go to 60
 5151  continue
      eepfl=0
      if (nfflag.eq.1)then
         nfile=nfile+1
         nfflag=0
         param2(21)=nfile
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)'Parameter mu >0. Writing full EEPAS ',
     1 'rate density array to file ',filenm
      nf2=nfile-1
      nf1=nfile-2
      rewind(nf1)
      rewind(nf2)
      call com2fl(nf1,nf2,mueep,nfile)
      nfflag=1
      go to 60
C=======EEPXt EEPAS rate density versus magnitude for fixed t & location 
 516  continue
      if (veepas.eq.2)go to 531
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      if (trange.eq.0) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time ",yeartm,mnthtm,daytm
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
       tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
        call cevixt(mmin,mmax,tyr,xlat,xlon,nmstp,
     1  eta,am,bm,sigm,at,bt,sigt,
     1  ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,nfile,rtrfl)
       elseif (trange.eq.1) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1daytm,".",ntstp," time points"
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
        tymn=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
        do i=1,ntstp
         tyr=tymn+(i-1)*(yrmx-yrmn)/(ntstp-1)  
         call cevixt(mmin,mmax,tyr,xlat,xlon,nmstp,
     1    eta,am,bm,sigm,at,bt,sigt,
     1    ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,nfile,
     1    rtrfl)
        enddo 
       endif  
       nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 513
      endif
      go to 60
C========GMTPrep
 517  continue
      write(6,*)"Preparing to write gmt script"
c prepare files for GMT mapping tool
c write unix script to do colour plot and or contours
c options for contours/colours or both (sort out later)
      if (titfl.eq.1)then
         title1=ttlgen(modnm,xmag,yeartm,mnthtm,daytm)
c----generate header for gmt plot
      else if (titfl.eq.2) then
         title1=title
      else
         title1=""
c-----no header for gmt plot
c-----use title on file as header for gmt plot 
      endif   
c      write(6,*)"GMTP flag1"
      inquire(unit=nfile,name=datafn)
      close(nfile)
c      write(6,*)"Closed unit ", nfile
      gmtfn=joinst('gmt',datafn)
c      write(6,*)"gmtfn= ",gmtfn
c----now calculate grint
      grint=(lomx-lomn)/(lonn-1)
      grint2=(lamx-lamn)/(latn-1)
      if (grint.ne.grint2)write(6,*)"Warning: Different grid ",
     1 "spacing in x and y directions. GMT script will not run"
      open(unit=nfile,file=gmtfn,status='new')
      write(6,*)"Writing gmt script to file",
     1 gmtfn
      call wscrpt(nfile,rtrfl,title1,contfn,datafn,cptfn,
     1grint,lomn,lomx,lamn,lamx,colfl,contfl)
c      close(nfile)
      nfflag=1
      go to 60
C========LICENCE key filename, and check if licence valid
 518  continue
      read(jff9,*)fil8nm
      write(6,*)"LICENCEKEYFILENAME",fil8nm
      open(unit=8,file=fil8nm,status='old')
      call checky(8)
      close(8)
      licval=1
      go to 60
C========NULL POLYGON declaration
 519  continue
      polyfl=1
      write(6,*)'Null polygon declared. WARNING: No ',
     1 'commands other than CATALOG should follow' 
      go to 60
c========EEPGrid Grid of expected no. earthquakes for EEPAS model
 520  continue
      if (veepas.eq.2)go to 532
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      tyr1=dctime(gyr1,gmo1,gdy1,ghr1,gmn1,gsc1,yref)
      tyr2=dctime(gyr2,gmo2,gdy2,ghr2,gmn2,gsc2,yref)
      write(11,*)gyr1,gmo1,gdy1,gyr2,gmo2,gdy2,(tyr2-tyr1)
      if (tyr1.ge.tyr2) go to 5209
      inquire(unit=nfile,name=filenm)
      write(6,*)'Writing EEPAS exp. no. earthquakes array to file ',
     1 filenm
       call pevrl3(tyr1,tyr2,glost,glast,3,3,
     1 eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1 evitm1,b,mag0,nfile,maxmag,mask,cx,cy)
      nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 527
      endif   
      go to 60
 5201 continue
      eepfl=0
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)'Parameter mu >0. Writing full EEPAS ',
     1 'expected. number of earthquakes array to file ',filenm
      nf2=nfile-1
      nf1=nfile-2
      rewind(nf1)
      rewind(nf2)
      call combfl(nf1,nf2,mueep,nfile)
      go to 60
 5209 write(jff6,*)'Invalid time limits for expected number of ',
     1'earthquakes array.',' gyr1,gmo1,gdy1=',gyr1,gmo1,gdy1,
     1 '; gyr2,gmo2,gdy2=',gyr2,gmo2,gdy2,'. Exiting'
      go to 599
c========PPEGrid Grid of expected no. earthquakes for PPE model
 527  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      tyr1=dctime(gyr1,gmo1,gdy1,ghr1,gmn1,gsc1,yref)
      tyr2=dctime(gyr2,gmo2,gdy2,ghr1,gmn1,gsc1,yref)
      write(11,*)gyr1,gmo1,gdy1,gyr2,gmo2,gdy2,(tyr2-tyr1)
      if (tyr1.ge.tyr2) go to 5279
      inquire(unit=nfile,name=filenm)
      write(6,*)'Writing PPE exp. no. earthquakes array to file ',
     1 filenm
       call pkjrl3(tyr1,tyr2,glost,glast,3,t0,delay,
     1 a,d,s,lat,long,time,mag,ncat,b,minmag,nfile,maxmag,mask,
     1 cx,cy)
      nfflag=1
      if (eepfl.eq.1) go to 5201
      go to 60
 5279 write(jff6,*)'Invalid time limits for expected number of ',
     1'earthquakes array.',' gyr1,gmo1,gdy1=',gyr1,gmo1,gdy1,
     1 '; gyr2,gmo2,gdy2=',gyr2,gmo2,gdy2,'. Exiting'
      go to 599
C========EEPF EEPAS grid points read from file (Imoto collaboration) 
 538  read(jff9,*,err=5389)maglim,magdel
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      rewind(jff91)
c     read one grid point from background file
 5381 read(jff91,*,end=5384,err=5389)year,month,day,lattd,
     1longtd,depth
 5382 format(2x,i4,2i3,2f8.3,f7.2,f5.2,e12.4)
 5385 format(2x,i4,2i3,2f8.3,f7.2,e12.4)
      if ((depth.lt.depmin).or.(depth.ge.depmax))then
         backspace(jff91)
         read(jff91,51,end=5384)astrng
         write(nfile,51)astrng
         nfflag=1
         go to 5381
      endif
c     now calculate rate for m>=maglim at gridpoint
      timed=dctime(year,month,day,0,0,0.0,yref)
      magtd=maglim
      rated=evtfmx(timed,magtd,maxmag,ncat,lattd,longtd,eta,
     1am,bm,sigm,at,bt,sigt,ba,siga,lat,long,mag,time,w,b,mag0)+
     1mu*ppertd(timed,magtd,lattd,longtd,n,lat,long,time,mag,
     1b,a,d,s,minmag,t0,delay)*(1.-10**(-b*(maxmag-magtd)))/
     1(b*log(10.))
c     use rate density at min mag, divided by depth range, with mag factor
      rated=rated/(depmax-depmin)
      write(nfile,5385)year,month,day,lattd,longtd,depth,rated
      nfflag=1
      go to 5381
 5384 rewind(jff92)
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
c     read one grid point from conditional file
 5383 read(jff92,*,end=5388,err=5389) year,month,day,lattd,
     1longtd,depth,magtd
      if ((depth.lt.depmin).or.(depth.ge.depmax))then
         backspace(jff92)
         read(jff92,51,end=5388)astrng
         write(nfile,51)astrng
         nfflag=1
         go to 5383
      endif
c     now calculate rate density for particular earthquake
      timed=dctime(year,month,day,0,0,0.0,yref)
      rated=evitmx(timed,magtd,ncat,lattd,longtd,eta,am,bm,sigm,
     1at,bt,sigt,ba,siga,lat,long,mag,time,w,b,mag0)+mu*
     1ppertd(timed,magtd,lattd,longtd,n,lat,long,time,mag,
     1b,a,d,s,minmag,t0,delay)
c     use rate density at min mag, divided by depth range, with mag factor
      rated=rated/(depmax-depmin)
      rated=rated*magdel
      nfflag=1
      write(nfile,5382)year,month,day,lattd,longtd,depth,magtd,rated
      go to 5383
 5388 continue
      go to 60
 5389 continue
      write(6,*)"Input error, command EEPF or file ",jff91,
     1"or ",jff92,". Exiting"
      go to 599
C========PPEF PPE grid points read from file (Imoto collaboration) 
 539  read(jff9,*,err=5399)maglim,magdel
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      rewind(jff91)
c     read one grid point from background file
 5391 read(jff91,*,end=5394,err=5399)year,month,day,lattd,
     1longtd,depth
 5392 format(2x,i4,2i3,2f8.3,f7.2,f5.2,e12.4)
 5395 format(2x,i4,2i3,2f8.3,f7.2,e12.4)
      if ((depth.lt.depmin).or.(depth.ge.depmax))then
         backspace(jff91)
         read(jff91,51,end=5394)astrng
         write(nfile,51)astrng
         nfflag=1
         go to 5391
      endif
c     now calculate rate for m>=maglim at gridpoint
      timed=dctime(year,month,day,0,0,0.0,yref)
      magtd=maglim
      rated=ppertd(timed,magtd,lattd,longtd,n,lat,long,time,mag,
     1b,a,d,s,minmag,t0,delay)
c     use rate density at min mag, divided by depth range, with mag factor
      rated=rated/(depmax-depmin)
      rated=rated/(b*log(10.))
      rated=rated*(1.-10**(-b*(maxmag-magtd)))
      write(nfile,5395)year,month,day,lattd,longtd,depth,rated
      nfflag=1
      go to 5391
 5394 rewind(jff92)
c      write(6,*)"ppef flag1",nfile
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
c      write(6,*)"ppef flag2", nfile,jff92
c     read one grid point from conditional file
 5393 read(jff92,5392,end=5398,err=5399) year,month,day,lattd,
     1longtd,depth,magtd
      write(6,5392)year,month,day,lattd,longtd,depth,magtd
      if ((depth.lt.depmin).or.(depth.ge.depmax))then
         backspace(jff92)
         read(jff92,51,end=5398)astrng
         write(nfile,51)astrng
c         write(6,*)"ppef flag4", nfile,jff92      
         nfflag=1
         go to 5393
      endif
cc     now calculate rate density for particular earthquake
      timed=dctime(year,month,day,0,0,0.0,yref)
      rated=ppertd(timed,magtd,lattd,longtd,n,lat,long,time,mag,
     1b,a,d,s,minmag,t0,delay)
c     use rate density at min mag, divided by depth range, with mag factor
      rated=rated/(depmax-depmin)
      rated=rated*magdel
      nfflag=1
      write(nfile,5392)year,month,day,lattd,longtd,depth,magtd,rated
c      write(6,*)"ppef flag 3"
      go to 5393
 5398 continue
      go to 60
 5399 continue
      write(6,*)"Input error, command PPEF or file ",jff91,
     1"or ",jff92,". Exiting"
      go to 599
C========PARPRINT Write parameter values to file
 521  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
      endif
         inquire(unit=nfile,opened=unitop)
      if (.not. unitop)then
          filenm=jointx(fil9nm,nfile)
          open(unit=nfile,file=filenm,status='new')
      endif
      write(6,*)"Writing parameters to file ",filenm
      call prpars(nfile,param,parstr,npar,param2,parst2,npar2)
      nfflag=1
      go to 60
C========BOPTIMISE maximum likelihood estimate of bvalue for range
C========of magnitude thresholds
 522  read(jff9,*,err=5228)m0min,m0max,m0stp
      tyr1=dctime(y1,m1,d1,0,0,0.0,yref)
      tyr2=dctime(y2,m2,dy,23,59,59.99,yref)
      if (tyr1.ge.tyr2) go to 5229
      write(6,*) "m0    Neq    bval  se(bval)"
      write(11,*)
      write(11,*) "Gutenberg-Richter b-value estimates"
      write(11,*) "     m0     Neq     b     se(b)"
      m0i=m0min
 5221 call bfit(ncat,time,mag,tyr1,tyr2,m0i,bi,neqi,sei)
      write(6,*) m0i,neqi,bi,sei
      write(11,5222) m0i,neqi,bi,sei
 5222 format(f8.2,i8,f8.2,f8.3)
      m0i=m0i+m0stp
      if (m0i.le.m0max)go to 5221
      go to 60
 5228 write(jff6,*)'Invalid or missing magnitude threshold',
     1' specification for b-value optimisation. Exiting'
      go to 599
 5229 write(jff6,*)'Invalid time limits for bvalue optimisation: ',
     1 'y1,m1,d1=',y1,m1,d1,
     1 '; y2,m2,d2=',y2,m2,d2,'. Exiting'
      go to 599
C========WBOPTIMISE maximum likelihood estimate of bvalue for range
C========of magnitude thresholds (allowing for EEPAS weights)
 525  read(jff9,*,err=5258)m0min,m0max,m0stp
      tyr1=dctime(y1,m1,d1,0,0,0.0,yref)
      tyr2=dctime(y2,m2,dy,23,59,59.99,yref)
      if (tyr1.ge.tyr2) go to 5259
      write(6,*) "m0    Neq    bval  se(bval)"
      write(11,*)
      write(11,*) "Weighted Gutenberg-Richter b-value estimates"
      write(11,*) "     m0     Neq     b     se(b)"
      m0i=m0min
 5251 call wbfit(ncat,time,mag,w,tyr1,tyr2,m0i,bi,neqi,sei)
      write(6,*) m0i,neqi,bi,sei
      write(11,5252) m0i,neqi,bi,sei
 5252 format(f8.2,i8,f8.2,f8.3)
      m0i=m0i+m0stp
      if (m0i.le.m0max)go to 5251
      go to 60
 5258 write(jff6,*)'Invalid or missing magnitude threshold',
     1' specification for b-value optimisation. Exiting'
      go to 599
 5259 write(jff6,*)'Invalid time limits for bvalue optimisation: ',
     1 'y1,m1,d1=',y1,m1,d1,
     1 '; y2,m2,d2=',y2,m2,d2,'. Exiting'
      go to 599
C========NVST Number of earthquakes vs time in catalogue
 523  read(jff9,*,err=5238)m0min,m0max,m0stp
      m0i=m0min
      write(11,22)
 22   format(//,"Number of Earthquakes Versus Time"//,
     1 "Cum(Neq)=Cumulative no. earthquakes with mag >= m0 ", 
     1 "to date",/,
     1 "R1=Neq(m0)/Neq(m0+0.5) in current year",/,
     1 "R3=Neq(m0)/Neq(m0+0.5) in current year plus or minus one ",
     1 "year",/,
     1 "R5=Neq(m0)/Neq(m0+0.5) in current year plus or minus two ",
     1 "years",/,
     1 "se=standard error",/,
     1 "Under catalogue completeness with b-value 1, ",
     1 "E(Ri)=0.32, i=1,3,5",/,
     1 "Incompleteness: *  = (R5-2*se(R5) > 0.32)",/,
     1 "                ** = (R5-3*se(R5) > 0.32)")
 5231 call cumnvt(ncat,yr,mag,m0i)
      m0i=m0i+m0stp
      if (m0i.le.m0max)go to 5231
      go to 60
 5238  write(jff6,*)'Invalid or missing magnitude threshold',
     1' specification for Neq vs time. Exiting'
      go to 599
C========EASOptimise  Fit EEPAS with aftershocks model parameters
 528  continue
      j=0
 5283 read(jff9,*,err=5289)pars,parmin,parmax
      write(jff6,*)pars,parmin,parmax
      if ((parmax-parmin).le.0.)go to 5288
      if ((parmin.lt.0.).and.(pars.ne.'omeg').and.
     1 (pars.ne.'zeta'))go to 5288
      if (pars.eq.parstr(npar+1))go to 5282
      do i=8,16
         if (pars.eq.parstr(i))go to 5281
      enddo
      do i=25,27
         if (pars.eq.parstr(i))go to 5281
      enddo
       write(jff6,*)'Unknown parameter name ',pars,'. Exiting'
      go to 599
 5281 j=j+1
      pmin(i)=parmin
      prange(i)=parmax-parmin
      pnum(j)=i
      if ((param(i).lt.parmin).or.(param(i).gt.parmax))
     1 param(i)=(parmin+parmax)/2.
      ptry(j)=abs(asin((param(i)-pmin(i))/prange(i)))
      if ((parstr(i).eq.'nu').and.(parmax.gt.1.))go to 5288
      go to 5283
 5282 continue
c      write(6,*)"flag3 n1 n2",n1,n2
      np=j
      mp=j+1
      do i=1,np
         do j=1,mp
            pmat(j,i)=ptry(i)
         enddo
      enddo
      do i=2,mp
         pmat(i,i-1)=pmat(i,i-1)+0.05
      enddo
c  pmat values set
c     now calculate values of -loglik for starting simplex
      do j=1,mp
         do i=1,np
            ptry(i)=pmat(j,i)
c            write (6,*) "changing ptry",j,i
         enddo
c        write(6,*)"evaluating lleep2"
c         write(6,*)"flag4 n1 n2",n1,n2
         yvec(j)=lleep2(ptry)
         write(6,*)"ptry,lleep2",(ptry(i),i=1,np),yvec(j)
      enddo
      write(14,*)"Stopping values"
      ndim=np
      ftol=0.0000001
      iter=500
      call matvec(20,19,mp,np,pmat,pvec)
      call amoeba(pvec,yvec,mp,np,ndim,ftol,lleep2,iter)
      call vecmat(20,19,mp,np,pmat,pvec)
      do j=1,mp
         do i=1,np
            pmat(j,i)=pmin(pnum(i))+prange(pnum(i))*
     1      abs(sin(pmat(j,i)))
         enddo   
         write(19,*)(pmat(j,i),i=1,np),yvec(j)
      enddo
      param(8)=am
      param(9)=bm
      param(10)=sigm
      param(11)=at
      param(12)=bt
      param(13)=sigt
      param(14)=ba
      param(15)=siga
      param(16)=mueep
      param(25)=balpha
      param(26)=delgm2
      mu=mueep
      go to 60
 5288 backspace(jff9)
      read(jff9,*)pars
      if (pars.eq.parstr(npar+1))go to 5282
      write(jff6,*)"Invalid range for parameter ",pars,
     1 ". Exiting"
      go to 599
 5289 write(jff6,*)"Error in parameter names and limits. Exiting"
      go to 599
C========EASTm rate density array
 529  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      write(6,*)"Time ",yeartm,mnthtm,daytm
      write(6,*)"Magnitude ",xmag
      write(6,*)"Latitude range",lamn,lamx,". ",latn," grid points"
      write(6,*)"Longitude range",lomn,lomx,". ",lonn,
     1" grid points"
      modnm="EEPAS2"
      tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
      call cevtm2(tyr,xmag,lamn,lamx,lomn,lomx,latn,lonn,
     1 eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,
     1 evitm1,b,mag0,delgm2,zeta,balpha,nfile,rtrfl)
      nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 511
      endif
      nfflag=1
      if(gmtfl.eq.1)go to 517
      go to 60
C========EASMx rate density array
 530  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      tyr1=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
      tyr2=dctime(yrmx,mnthtm,daytm,0,0,0.0,yref)
      if (mrange.eq.0)then
         write(6,*)"Magnitude ",xmag
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1daytm,".",ntstp," time points"
       call cevimx(tyr1,tyr2,xmag,xlat,xlon,ntstp,
     1 eta,am,bm,sigm,at,bt,sigt,
     1 ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nfile,rtrfl)
c      subroutine cevimx(t1,t2,m,ylat,xlong,n,eta,am,bm,sigm,at,bt,
c     1sigt,ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nf,rtr)
      elseif (mrange.eq.1) then
         write(6,*)"Magnitude range",mmin,mmax,". ",nmstp,
     1   " points"
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1   daytm,".",ntstp," time points"
        do j=1,nmstp
           xm=mmin+(i-1)*(mmax-mmin)/ntstp
           call cevmx2(tyr1,tyr2,xm,xlat,xlon,ntstp,
     1      eta,am,bm,sigm,at,bt,sigt,
     1      ba,siga,lat,long,time,mag,w,evimx,b,mag0,
     1      delgm2,zeta,balpha,nfile,rtrfl)
        enddo   
       endif  
       nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 512
      endif   
       go to 60
C========EASXt rate density array
 531  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS rate density array to file",
     1 filenm
      if (trange.eq.0) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time ",yeartm,mnthtm,daytm
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
       tyr=dctime(yeartm,mnthtm,daytm,0,0,0.0,yref)
        call cevxt2(mmin,mmax,tyr,xlat,xlon,nmstp,
     1  eta,am,bm,sigm,at,bt,sigt,
     1  ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,
     1  delgm2,zeta,balpha,nfile,rtrfl)
       elseif (trange.eq.1) then
         write(6,*)"Location ",xlat,xlon
         write(6,*)"Time range ",yrmn,mnthtm,daytm,yrmx,mnthtm,
     1daytm,".",ntstp," time points"
         write(6,*)"Magnitude range ",mmin,mmax,". ",nmstp,
     1   " levels"
        tymn=dctime(yrmn,mnthtm,daytm,0,0,0.0,yref)
        do i=1,ntstp
         tyr=tymn+(i-1)*(yrmx-yrmn)/(ntstp-1)  
         call cevxt2(mmin,mmax,tyr,xlat,xlon,nmstp,
     1    eta,am,bm,sigm,at,bt,sigt,
     1    ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,
     1    delgm2,zeta,balpha,nfile,rtrfl)
        enddo 
       endif  
       nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 513
      endif
      go to 60
C========EASGrid Expected number of earthquakes array for EEPAS2
 532  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      tyr1=dctime(gyr1,gmo1,gdy1,0,0,0.0,yref)
      tyr2=dctime(gyr2,gmo2,gdy2,23,59,59.99,yref)
      write(11,*)gyr1,gmo1,gdy1,gyr2,gmo2,gdy2,(tyr2-tyr1)
      if (tyr1.ge.tyr2) go to 5329
      inquire(unit=nfile,name=filenm)
      write(6,*)'Writing EEPAS exp. no. earthquakes array to file ',
     1 filenm
       call pevrl4(tyr1,tyr2,glost,glast,3,3,
     1 eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1 evitm1,b,mag0,delgm2,zeta,balpha,nfile,maxmag,mask,cx,cy)
      nfflag=1
      if (mueep.gt.0.)then
         eepfl=1
         go to 527
      endif   
      go to 60
 5329 write(jff6,*)'Invalid time limits for expected number of ',
     1'earthquakes array.',' gyr1,gmo1,gdy1=',gyr1,gmo1,gdy1,
     1 '; gyr2,gmo2,gdy2=',gyr2,gmo2,gdy2,'. Exiting'
      go to 599
C========EEPSYN Synthetic catalogue from EEPAS model
 534  continue
      if (nfflag.eq.1)then
         nfile=nfile+1
         param2(21)=nfile
         nfflag=0
         inquire(unit=nfile,opened=unitop)
         if (.not. unitop)then
            filenm=jointx(fil9nm,nfile)
            open(unit=nfile,file=filenm,status='new')
         endif
      endif   
      inquire(unit=nfile,name=filenm)
      write(6,*)"Writing EEPAS synthetic catalogue to file",
     1 filenm
       x=rand()
       call synset(minmag,inflam,cdfmag)
      do isyn=1,nsim
         if(abs(isyn/100.-int(isyn/100.)).le.0.001)
     1   write(6,*)"isyn=",isyn
         call synyni(n,eta,mag,inflam,syn01)
c        write(17,*)"Synthetic catalog"
         do i=1,n
          if(syn01(i).eq.1) call synteq(time(i),mag(i),
     1     lat(i),long(i),minmag,cdfmag)
         enddo
         rewind(17)
         i=0
 5346    i=i+1
         read(17,*,end=5349)timsyn(i),latsyn(i),lonsyn(i),magsyn(i)
         go to 5346
 5349    nsyn=i-1
         call sort2(timsyn,timsrt,nsyn,order)
         call reord(latsyn,latsrt,nsyn,order)
         call reord(lonsyn,lonsrt,nsyn,order)
         call reord(magsyn,magsrt,nsyn,order)
c        write(nfile,22)nsyn
         do i=1,nsyn
          call adtime(timsrt(i),yref,year,month,day,hour,minute,
     1    second)
          if ((t1.le.timsrt(i)).and.(timsrt(i).le.t2))
     1    write(nfile,5342)year,month,day,hour,minute,second,
     1    latsrt(i),lonsrt(i),depth,magsrt(i)
 5342     format(i5,4i3,f5.1,2f8.2,f5.1,f4.1)
         enddo
         rewind(17)
         do i=1,1000
          write(17,*)"                                           "
         enddo
         rewind(17)
      enddo
      go to 60
C-----end of command file
 598  continue
c      write(6,*)"Missing STOP command"
C========STOP
 599  continue
      do i=11,99
         inquire(unit=i,exist=unitok,opened=unitop)
         if (unitok .and. unitop) close(i)
      enddo
      stop
      end


c      real f1tval,g1mval,h1xval,f2tval,g2mval,h2xval
c      real lat,long,lati,longi,x,y,xmu,sigma
c2     write (6,*) 'Enter x'
c      read (5,*) x,xmu,sigma
c      if (x.lt.-100) go to 3
c      y=pnorml(x,xmu,sigma)
c      write (6,*) y
c      go to 2
c3     write(6,*) 'Enter am,bm,sigm'
c      read(5,*) am,bm,sigm
c      write(6,*) 'Enter at,bt,sigt'
c      read(5,*) at,bt,sigt
c      write(6,*) 'Enter siga,sigu,b,c,p'
c      read(5,*) siga,sigu,b,c,p
c1     write(6,*) 'Enter ti,mi,lati,longi,t,m,lat,long'
c      read(5,*) ti,xmi,lati,longi,t,xm,lat,long
c      tstcos=cos(3.14159*(lati+lat)/360.)
c      write(6,*) tstcos
c      write(6,*) distkm(lat,long,lati,longi) 
c      if (ti.lt.0) go to 99
c      f1tval=f1t(t,ti,xmi,at,bt,sigt)
c      write(6,*) 'f1t=',f1tval
c      g1mval=g1m(xm,xmi,am,bm,sigm)
c      write(6,*) 'g1m=',g1mval
c      h1xval=h1x(lat,long,lati,longi,xmi,siga,ba)
c      write(6,*) 'h1x=',h1xval
c      f2tval=f2t(t,ti,c,p)
c      write(6,*) 'f2t=', f2tval
c      g2mval=g2m(xm,xmi,b,deltam)
c      write(6,*) 'g2m=',g2mval
c      h2xval=h2x(lat,long,lati,longi,xmi,sigu)
c      write(6,*) 'h2x=',h2xval
c      go to 1
c99    continue
c      stop
c      end

      subroutine matvec(n1,m1,np,mp,pmat,pvec)
      real pmat(n1,m1),pvec(n1*m1)
       do i=1,np
         do j=1,mp
            pvec(((j-1)*np+i))=pmat(i,j)
         enddo
      enddo
      return
      end

      subroutine vecmat(n1,m1,np,mp,pmat,pvec)
      real pmat(n1,m1),pvec(n1*m1)
       do i=1,np
         do j=1,mp
            pmat(i,j)=pvec(((j-1)*np+i))
         enddo
      enddo
      return
      end
 
      real function dctime(yr,mth,day,hr,min,sec,start)
      implicit none
      real sec,t
      integer nd(12),yr,mth,day,hr,min,start,i,ndays
      data nd/31,28,31,30,31,30,31,31,30,31,30,31/
      t=0.0
      do i=start,yr-1
       t=t+ndays(i)*1.
      enddo
c      write(6,*)t
      do i=1,mth-1
       t=t+nd(i)*1.
       if ((i.eq.2).and.(ndays(yr).eq.366))t=t+1.
      enddo
c      write(6,*)t
      t=t+day-1.+hr/24.+min/(24.*60.)+sec/(24.*60.*60.)
c      write(6,*)yr,mth,day,hr,min,sec,start,t
      dctime=t
      return
      end
       

      integer function ndays(year)
      integer year
      real yover4
      ndays=365
      yover4=1.0*int(year/4.0)
      if (yover4.eq.year/4.0) ndays=366
c      write (6,*)year,ndays
      return
      end
      

      real function hvysid(x)
      implicit none
      real x
      if (x.gt.0.) then
       hvysid=1.
      else
       hvysid=0.
      endif
      return
      end

      real function diskm2(lat1,long1,lat2,long2)
      real lat1,long1,lat2,long2,degkm,dx,dy
      degkm=111.0
      dx=(lat1-lat2)*degkm
      dy=(long1-long2)*degkm*cos(3.14159*(lat1+lat2)/360.)
      diskm2=sqrt(dx**2+dy**2)
      return
      end

      real function distkm(lat1,long1,lat2,long2)
      implicit none
      real lat1,long1,lat2,long2,diskm2
      real theta1,theta2,phi1,phi2,pi,cosdis,erad
      pi=3.14159
      erad=111.*180/pi
      theta1=lat1*pi/180.
      theta2=lat2*pi/180.
      phi1=long1*pi/180.
      phi2=long2*pi/180.
      cosdis=sin(theta1)*sin(theta2)+cos(theta1)*cos(theta2)*
     1cos(phi1-phi2)
      if ((cosdis.gt.1.0).or.(cosdis.lt.-1.0))then
         distkm=diskm2(lat1,long1,lat2,long2)
         return
      endif
      distkm=erad*acos(cosdis)
      return
      end


      real function f1t(t,ti,xmi,at,bt,sigt)
      implicit none
      real t,ti,xmi,at,bt,sigt,xmu,sigi,y,kjmu
      real wbar,inout,sigu,area,kappa,delay,hvysid
      integer n5pd
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      xmu=log(10.0)*(at+bt*xmi)
      sigi=sigt*log(10.0)
      if (t.le.ti) then
       f1t=0.0
      else
       y=(log(t-ti)-xmu)/sigi
c      write(6,*) t,ti,xmi,at,bt,sigt,xmu,sigi,y
       f1t=hvysid(t-ti-delay)*exp(-0.5*y**2)/
     1 (sqrt(2*3.14159)*sigi*(t-ti))
      endif
      return
      end

c This function follows the published formula but is wrong!
c      real function f1t(t,ti,xmi,at,bt,sigt)
c      real t,ti,xmi,at,bt,sigt,xmu,sigi,y
c      xmu=(at+bt*xmi)*log(10.0)
c      sigi=sigt*log(10.)
c      if (t.le.ti) then
c       f1t=0.0
c      else
c       y=(log(t-ti)-xmu)/sigi
cc      write(6,*) t,ti,xmi,at,bt,sigt,xmu,sigi,y
c       f1t=hvysid(t-ti-50.)*exp(-0.5*y**2)/
c     1 (sqrt(2*3.14159)*sigt*(t-ti))
c      endif
c      return
c      end

      real function g1mint(xm1,xm2,xmi,am,bm,sigm)
      implicit none
      real xm1,xm2,xmi,am,bm,sigm,xmu,y1,y2,pnorml
c      write(6,*) xm,xmi,am,bm,sigm
      xmu=am+bm*xmi
      y1=(xm1-xmu)/sigm
      y2=(xm2-xmu)/sigm
c      write(6,*)xmu,y
      g1mint=pnorml(y2,0.,1.)-pnorml(y1,0.,1.)
c      write(6,*)g1mint
      return
      end

      real function g1m(xm,xmi,am,bm,sigm)
      implicit none
      real xm,xmi,am,bm,sigm,xmu,y
c      write(6,*) xm,xmi,am,bm,sigm
      xmu=am+bm*xmi
      y=(xm-xmu)/sigm
c      write(6,*)xmu,y
      g1m=exp(-0.5*y**2)/(sqrt(2*3.14159)*sigm)
c      write(6,*)g1m
      return
      end

      real function g1m3o(xm,xmi,am,bm,sigm,b,balpha,delgm2)
      implicit none
      real xm,xmi,am,bm,sigm,xmu,b,delgm2,beta,balpha,y
      real alpha,g1msrv,pnorml
c      write(6,*) "g1m3",xm,xmi,am,bm,sigm,b,balpha,delgm2
      xmu=am+bm*xmi
      y=(xm-xmu)/sigm
c      write(6,*)xmu,y
      alpha=balpha*log(10.)
      beta=b*log(10.)
      g1m3o=exp(-0.5*y**2)/(sqrt(2*3.14159)*sigm)
      g1msrv=1-pnorml(y,0.0,1.0)
c create table of normal integral and interpolate
      g1m3o=g1m3o+g1msrv*exp(-alpha*(xm-am-bm*xmi+delgm2))
c      write(6,*)g1m3
      return
      end

      real function g1m3(xm,xmi,am,bm,sigm,b,balpha,delgm2,zeta)
      implicit none
      real xm,xmi,am,bm,sigm,xmu,b,delgm2,beta,balpha,y
      real alpha,g1msrv,pnorml,zeta
c      write(6,*) "g1m3",xm,xmi,am,bm,sigm,b,balpha,delgm2
      xmu=am+bm*xmi
      y=(xm-xmu)/sigm
c      write(6,*)xmu,y
      alpha=balpha*log(10.)
      beta=b*log(10.)
      g1m3=exp(-0.5*y**2)/(sqrt(2*3.14159)*sigm)
      y=y+zeta/sigm
      g1msrv=1-pnorml(y,0.0,1.0)
c create table of normal integral and interpolate
      g1m3=g1m3+g1msrv*exp(-alpha*(xm-am-bm*xmi+delgm2))
c      write(6,*)g1m3
      return
      end



      real function h1x(lat,long,lati,longi,xmi,siga,ba)
      implicit none
      real lat,long,lati,longi,xmi,siga,ba,r,sigi,distkm
      r=distkm(lat,long,lati,longi)
      sigi=siga*10**(ba*xmi/2.)
      h1x=exp(-0.5*(r/sigi)**2)/(2*3.14159*sigi**2)
      return
      end

      real function f2t(t,ti,c,p)
      implicit none
      real t,ti,c,p,hvysid
      f2t=hvysid(t-ti)*((p-1)*c**(p-1))*(t-ti+c)**(-p)
      return
      end

      real function g2m(xm,xmi,b,deltam)
      implicit none
c not a density, doesn't integrate to 1
c expected no of aftershocks depends on xmi
      real xm,xmi,b,beta,deltam
      beta=b*log(10.)
      g2m=beta*exp(-beta*(xm-xmi))
      if (xm.ge.xmi-deltam) g2m=0.
      return
      end

      real function h2x(lat,long,lati,longi,xmi,sigu)
      implicit none
      real lat,long,lati,longi,xmi,sigu
      real r,sigi,distkm
      sigi=sigu*10.0**(xmi/2.0)
      r=distkm(lat,long,lati,longi)
      h2x=exp(-0.5*(r/sigi)**2)/(2.0*3.14159*sigi**2)
      return
      end

      real function backgd(lati,longi,magi,b,r5pd)
      implicit none
      real lati,longi,magi,b,r5pd
      backgd=r5pd*10**(-b*(magi-5))
      return
      end

      real function omori(i,kappa,c,p,b,deltam,sigu,lat,long,mag,
     1time,delay)
      implicit none
      integer i,j
      real lat(90000),long(90000),mag(90000),time(90000)
      real s,kappa,c,p,b,sigu,deltam,f2t,h2x,g2m,delay
      s=0.
      do j=1,i-1
         if(time(j).lt.(time(i)-delay))then
       s=s+kappa*f2t(time(i),time(j),c,p)*g2m(mag(i),mag(j),b,deltam)
     1 *h2x(lat(i),long(i),lat(j),long(j),mag(j),sigu)
         endif
      enddo
      omori=s
      return
      end

      real function omotmx(t,m,ylat,xlong,kappa,c,p,b,deltam,sigu,
     1lat,long,mag,time)
      integer j
      real lat(90000),long(90000),mag(90000),time(90000)
      real s,kappa,c,p,b,sigu,t,m,ylat,xlong,deltam
      s=0.
      j=0
 100  j=j+1
       if(time(j).ge.t)go to 99
       s=s+kappa*f2t(t,time(j),c,p)*g2m(m,mag(j),b,deltam)
     1 *h2x(ylat,xlong,lat(j),long(j),mag(j),sigu)
       go to 100
 99    continue
      omotmx=s
      return
      end
 
      real function evison(i,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1lat,long,mag,time,w,b,mag0)
      implicit none
      integer i,j
      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
      real s,eta(90000),am,bm,sigm,at,bt,sigt,siga,ba,limupp
      real b,mag0,div,f1t,g1m,h1x,pnorml
      s=0.
      do j=1,i-1
       s=s+eta(j)*w(j)*f1t(time(i),time(j),mag(j),at,bt,sigt)*
     1 g1m(mag(i),mag(j),am,bm,sigm)*h1x(lat(i),long(i),lat(j),
     1 long(j),mag(j),siga,ba)
c       if (mag(i).eq.4.98)write(89,*)w(j),
c     1 f1t(time(i),time(j),mag(j),at,bt,sigt),
c     1 g1m(mag(i),mag(j),am,bm,sigm),
c     1 h1x(lat(i),long(i),lat(j),long(j),mag(j),siga,ba)
      enddo
      limupp=(mag(i)-am-bm*mag0-sigm**2*b*log(10.))/sigm
      div=pnorml(limupp,0.0,1.0)
      if(div.lt.0.01)div=0.01
      evison=s/div
c      if(i.eq.2095)write(15,*)"evison",i,mag(i),s,div,limupp
      return
      end

c      real function evitmx(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,
c     1sigt,ba,siga,lat,long,mag,time,w,b,mag0)
c      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
c      real s,evmu,am,bm,sigm,at,bt,sigt,siga,t,m,ylat,xlong,t,m
c      real ylat,xlong,eta(90000),ba,b,mag0,div
c      s=0.
c      j=0
c 100  j=j+1
c       if(time(j).ge.t)go to 99
c       s=s+eta(j)*w(j)*f1t(t,time(j),mag(j),at,bt,sigt)*
c     1 g1m(m,mag(j),am,bm,sigm)*h1x(ylat,xlong,lat(j),
c     1 long(j),mag(j),siga,ba)
c      go to 100
c 99   continue
c      limupp=(m-am-bm*mag0-sigm**2*b*log(10.))/sigm
c      div=pnorml(limupp,0.0,1.0)
c      if(div.lt.0.01)div=0.01
c      evitmx=s/div
c      write(19,*)'t,m,ylat,xlong,evmu,evitmx'
c      write(19,*)t,m,ylat,xlong,evmu,evitmx
c      return
c      end

      real function evitmx(t,m,ncat,ylat,xlong,eta,am,bm,sigm,
     1at,bt,sigt,ba,siga,lat,long,mag,time,w,b,mag0)
      implicit none
      real t,m,ylat,xlong,eta(90000),am,bm,sigm,at,bt,sigt,ba,siga
      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
      real b,mag0,s,div,f1t,g1m,h1x,limupp,pnorml
      integer ncat,j
      s=0.
      j=0
 100  j=j+1
       if(time(j).ge.t)go to 99
       if (j.gt.ncat) go to 99
       s=s+eta(j)*w(j)*f1t(t,time(j),mag(j),at,bt,sigt)*
     1 g1m(m,mag(j),am,bm,sigm)*h1x(ylat,xlong,lat(j),
     1 long(j),mag(j),siga,ba)
      go to 100
 99   continue
      limupp=(m-am-bm*mag0-sigm**2*b*log(10.))/sigm
      div=pnorml(limupp,0.0,1.0)
      if(div.lt.0.01)div=0.01
      evitmx=s/div
c      write(19,*)'t,m,ylat,xlong,ncat,evitmx'
c      write(19,*)t,m,ylat,xlong,ncat,evitmx,div
      return
      end

      real function evtfmx(t,m1,m2,ncat,ylat,xlong,eta,am,bm,sigm,
     1at,bt,sigt,ba,siga,lat,long,mag,time,w,b,mag0)
c integrates eepas rate density over magnitude range
      implicit none
      real t,m1,m2,ylat,xlong,eta(90000),am,bm,sigm,at,bt,sigt,
     1ba,siga,m
      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
      real b,mag0,s,div,f1t,g1m,h1x,limupp,pnorml,g1mint
      integer ncat,j
      evtfmx=0.0
      m=m1-0.1
 50   m=m+0.1
      if (m.gt.m2)go to 299
      s=0.
      j=0
      limupp=(m-am-bm*mag0-sigm**2*b*log(10.))/sigm
      div=pnorml(limupp,0.0,1.0)
      if(div.lt.0.01)div=0.01
      if (div.ge.0.99)go to 150
 100  j=j+1
       if(time(j).ge.t)go to 99
       if (j.gt.ncat) go to 99
       s=s+eta(j)*w(j)*f1t(t,time(j),mag(j),at,bt,sigt)*
     1 g1m(m,mag(j),am,bm,sigm)*h1x(ylat,xlong,lat(j),
     1 long(j),mag(j),siga,ba)
      go to 100
 99   continue
       evtfmx=evtfmx+0.1*s/div
       go to 50
 150    j=j+1
       if(time(j).ge.t)go to 99
       if (j.gt.ncat) go to 99
       s=s+eta(j)*w(j)*f1t(t,time(j),mag(j),at,bt,sigt)*
     1 g1mint(m,m2,mag(j),am,bm,sigm)*h1x(ylat,xlong,lat(j),
     1 long(j),mag(j),siga,ba)
      go to 150
 199   continue
       evtfmx=evtfmx+s/div
 299   continue
c      write(19,*)'t,m,ylat,xlong,ncat,evitmx'
c      write(19,*)t,m,ylat,xlong,ncat,evitmx,div
      return
      end

      subroutine comori(n,kappa,c,p,b,deltam,sigu,lat,long,mag,
     1time,omor,delay)
      implicit none
      integer n,i
      real kappa,c,p,b,sigu,deltam,omori,delay
      real lat(90000),long(90000),mag(90000),time(90000),omor(90000)
      do i=1,n
       omor(i)=omori(i,kappa,c,p,b,deltam,sigu,lat,long,mag,time,
     1delay)
      enddo
      return
      end
      

       subroutine comorj(n,kappa,c,p,b,deltam,sigu,lat,long,mag,
     1time,omor,delay,minmag)
      implicit none
      integer n,i
      real kappa,c,p,b,sigu,deltam,omori,delay,minmag
      real lat(90000),long(90000),mag(90000),time(90000),omor(90000)
      do i=1,n
       if (mag(i).ge.minmag)then
        omor(i)=omori(i,kappa,c,p,b,deltam,sigu,lat,long,mag,time,
     1  delay)
       endif 
      enddo
      return
      end
      
       subroutine cevisn(n,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1lat,long,time,mag,w,evson,b,mag0)
      implicit none
      integer n,i
      real am,bm,sigm,at,bt,sigt,ba,siga,eta(90000),b,mag0
      real lat(90000),long(90000),evson(90000),w(90000)
      real mag(90000),time(90000),evison
      do i=1,n
       evson(i)=evison(i,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1 lat,long,mag,time,w,b,mag0)
      enddo
      return
      end
      
  
      subroutine cevimx(t1,t2,m,ylat,xlong,n,eta,am,bm,sigm,at,bt,
     1sigt,ba,siga,lat,long,time,mag,w,ncat,evimx,b,mag0,nf,rtr)
      implicit none
      integer n,i,ncat,nf,rtr
      real am,bm,sigm,at,bt,sigt,ba,siga,t1,t2,t,step,b,mag0,m
      real lat(90000),long(90000),evimx(10000),w(90000),eta(90000)
      real ylat,xlong,mag(90000),time(90000),evitmx
      character*256 fname,fn,jointx
      logical unitop
c      write(6,*)"cevimx ",t1,t2,m,ylat,xlong,n,
c     1 am,bm,sigm,at,bt,sigt,ba,siga,ncat,b,mag0,nf,rtr
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf .ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      step=(t2-t1)/(n-1)
      do i=1,n
       t=t1+(i-1)*step
       evimx(i)=evitmx(t,m,ncat,ylat,xlong,eta,am,bm,sigm,at,bt,
     1 sigt,ba,siga,lat,long,mag,time,w,b,mag0)
       if (rtr.eq.1)evimx(i)=evimx(i)*10.**m*365.25/(log(10.0))
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evimx(i)
      enddo
      return
      end
 
       
      subroutine cevmx2(t1,t2,m,ylat,xlong,n,eta,am,bm,sigm,at,bt,
     1sigt,ba,siga,lat,long,time,mag,w,evimx,b,mag0,delgm2,zeta,
     1balpha,nf,rtr)
      implicit none
      integer n,i,rtr,nf
      real am,bm,sigm,at,bt,sigt,ba,siga,t1,t2,t,step,b,mag0
      real lat(80000),long(80000),evimx(5000),w(80000),eta(80000)
      real ylat,xlong,delgm2,m,time(80000),mag(80000),evtmx2
      real balpha,zeta
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf .ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      step=(t2-t1)/(n-1)
      do i=1,n
         t=t1+(i-1)*step
       evimx(i)=evtmx2(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,
     1 sigt,ba,siga,lat,long,mag,time,w,b,mag0,delgm2,zeta,
     1 balpha)
       if (rtr.eq.1)evimx(i)=evimx(i)*10.**m*365.25/(log(10.0))
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evimx(i)
      enddo
      return
      end
       
        subroutine cevixt(m1,m2,t,ylat,xlong,n,eta,am,bm,sigm,at,bt,
     1sigt,ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,nf,rtr)
      implicit none
      integer n,i,ncat,nf,rtr
      real am,bm,sigm,at,bt,sigt,ba,siga,t,step,b,mag0,m
      real lat(90000),long(90000),evixt(10000),w(90000),eta(90000)
      real ylat,xlong,mag(90000),time(90000),evitmx,m1,m2
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      step=(m2-m1)/(n-1)
      do i=1,n
       m=m1+(i-1)*step
       evixt(i)=evitmx(t,m,ncat,ylat,xlong,eta,am,bm,sigm,at,bt,
     1 sigt,ba,siga,lat,long,mag,time,w,b,mag0)
       if (rtr.eq.1)evixt(i)=evixt(i)*10.**m*365.25/(log(10.0))
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evixt(i)
      enddo
      return
      end
 
        subroutine cevxt2(m1,m2,t,ylat,xlong,n,eta,am,bm,sigm,at,bt,
     1sigt,ba,siga,lat,long,time,mag,w,ncat,evixt,b,mag0,
     1delgm2,zeta,balpha,nf,rtr)
      implicit none
      integer n,i,ncat,nf,rtr
      real am,bm,sigm,at,bt,sigt,ba,siga,t,step,b,mag0,m
      real lat(90000),long(90000),evixt(10000),w(90000),eta(90000)
      real ylat,xlong,mag(90000),time(90000),evtmx2,m1,m2
      real balpha,delgm2,zeta
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      step=(m2-m1)/(n-1)
      do i=1,n
       m=m1+(i-1)*step
       evixt(i)=evtmx2(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,
     1 sigt,ba,siga,lat,long,mag,time,w,b,mag0,delgm2,zeta,
     1 balpha)
       if (rtr.eq.1)evixt(i)=evixt(i)*10.**m*365.25/(log(10.0))
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evixt(i)
      enddo
      return
      end
 
      subroutine cevitm(t,m,ylat1,ylat2,xlong1,xlong2,nlat,nlon,
     1eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1evitm,b,mag0,nf,rtr)
      implicit none
      integer nlat,nlon,i,nf,j,k,ncat,rtr
      real am,bm,sigm,at,bt,sigt,ba,siga,t,m,stplat,stplon
      real lat(90000),long(90000),evitm(10000),w(90000),eta(90000)
      real time(90000),mag(90000),evitmx
      real ylat,xlong,ylat1,ylat2,xlong1,xlong2,b,mag0
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and.(nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      stplat=(ylat2-ylat1)/(nlat-1)
      stplon=(xlong2-xlong1)/(nlon-1)
c      write(6,*)"EEPTM",t,m,ylat1,ylat2,xlong1,xlong2,nlat,
c     1 nlon, nf,am,bm,sigm,at,bt,sigt,ba,siga,b,mag0,ncat
      do j=1,nlat
         do k=1,nlon
            i=nlon*(j-1)+k
            ylat=ylat1+(j-1)*stplat
            xlong=xlong1+(k-1)*stplon
c      real function evitmx(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,
c     1sigt,ba,siga,lat,long,mag,time,w,b,mag0)
        evitm(i)=evitmx(t,m,ncat,ylat,xlong,eta,am,bm,sigm,at,bt,
     1 sigt,ba,siga,lat,long,mag,time,w,b,mag0)
       if (rtr.eq.1)evitm(i)=evitm(i)*10.**m*365.25/(log(10.0))
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evitm(i)
       enddo
      enddo
      return
      end         
 
      subroutine cevtm2(t,m,ylat1,ylat2,xlong1,xlong2,n,n2,eta,am,bm,
     1sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,evitm,b,mag0,
     1delgm2,zeta,balpha,nf,rtr)
      implicit none
      integer n,i,k,j,nf,rtr,n2
      real am,bm,sigm,at,bt,sigt,ba,siga,t,stplat,stplon
      real lat(80000),long(80000),evitm(5000),w(80000),eta(80000)
      real ylat,xlong,ylat1,ylat2,xlong1,xlong2,b,mag0,delgm2
      real m,time(80000),mag(80000),evtmx2,balpha,zeta
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and.(nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      stplat=(ylat2-ylat1)/(n-1)
      stplon=(xlong2-xlong1)/(n2-1)
      do j=1,n
c         write(6,*)"cevtm2 flag1 j",j 
         do k=1,n2
            i=n*(j-1)+k
c         write(6,*)"cevtm2 flag2 i",i 
            ylat=ylat1+(j-1)*stplat
            xlong=xlong1+(k-1)*stplon
       evitm(i)=evtmx2(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,sigt,
     1 ba,siga,lat,long,mag,time,w,b,mag0,delgm2,zeta,balpha)
c         write(6,*)"cevtm2 flag3 jki",j,k,i 
       if (rtr.eq.1)evitm(i)=evitm(i)*10.**m*365.25/(log(10.0))
c         write(6,*)"cevtm2 flag4 jki",j,k,i 
       if (nf.ne.0)write(nf,*)t,m,xlong,ylat,evitm(i)
       enddo
      enddo
      return
      end
       
       
      subroutine ckjbtm(t,m,ylat1,ylat2,xlong1,xlong2,nlat,nlong,
     1  lat,long,time,mag,ncat,kjbtm,b,a,d,s,m0,t0,
     1  delay,nf,rtr)
      implicit none
      integer nlat,nlong,i,nf,j,k,l,ncat,rtr
      real t,m,stplat,stplon,b,a,d,s,r,delay,distkm,kjf0r
      real lat(90000),long(90000),kjbtm(90000)
      real time(90000),mag(90000),m0,t0
      real ylat(90000),xlong(90000),ylat1,ylat2,xlong1,xlong2
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      stplat=(ylat2-ylat1)/(nlat-1)
      stplon=(xlong2-xlong1)/(nlong-1)
c      write(6,*)"entered ckjbtm",t,m,ylat1,ylat2,xlong1,xlong2,nlat,
c     1 nlong,nf,b,m0,ncat,stplat,stplon
      do i=1,nlat*nlong
        kjbtm(i)=0.0
      enddo
      l=0
 1    l=l+1
      if (l.gt.ncat)go to 89
      if (time(l).ge.(t-delay))go to 89
      if (mag(l).ge.m0) then
       do j=1,nlat
         do k=1,nlong
            i=nlong*(j-1)+k
            ylat(i)=ylat1+(j-1)*stplat
            xlong(i)=xlong1+(k-1)*stplon
            r=distkm(ylat(i),xlong(i),lat(l),long(l))
            kjbtm(i)=kjbtm(i)+kjf0r(a,mag(l),m0,d,r,s)
         enddo
        enddo
       endif
      go to 1
 89   continue
      do i=1,nlat*nlong
        kjbtm(i)=kjbtm(i)*10**(-b*(m-m0))
     1  *b*log(10.0)/(t-delay-t0) 
        if (rtr.eq.1)kjbtm(i)=kjbtm(i)*10.**m*365.25/(log(10.0))
        if (nf.ne.0)write(nf,*)t,m,xlong(i),ylat(i),kjbtm(i)
c        write(18,*)t,m,xlong(i),ylat(i),kjbtm(i)
      enddo
      return
      end

      subroutine ckjbmx(t1,t2,m,ylat,xlong,n,
     1  lat,long,time,mag,ncat,kjbmx,b,a,d,s,m0,t0,
     1  delay,nf,rtr)
      implicit none
      integer n,i,nf,k,l,ncat,rtr
      real t(n),m,stpt,b,a,d,s,r,delay,distkm,kjf0r
      real lat(90000),long(90000),kjbmx(90000)
      real time(90000),mag(90000),t0,t1,t2
      real ylat,xlong,m0
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and. (nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      stpt=(t2-t1)/(n-1)
c      write(6,*)"entered ckjbmx",t1,t2,m,ylat,xlong,n,
c     1 nf,b,m0,ncat,stpt
      do i=1,n
        kjbmx(i)=0.0
        t(i)=t1+(i-1)*stpt
      enddo
        l=0
 1      l=l+1
        if (l.gt.ncat)go to 89
        if (mag(l).ge.m0) then
        r=distkm(ylat,xlong,lat(l),long(l))
        do k=1,n
        if (time(l).ge.(t(k)-delay))go to 79
            kjbmx(k)=kjbmx(i)+kjf0r(a,mag(l),m0,d,r,s)
 79         continue
         enddo
        endif
       go to 1
 89   continue
      do i=1,n
        kjbmx(i)=kjbmx(i)*10**(-b*(m-m0))
     1  *b*log(10.0)/(t(i)-delay-t0) 
        if (rtr.eq.1)kjbmx(i)=kjbmx(i)*10.**m*365.25/(log(10.0))
        if (nf.ne.0)write(nf,*)t(i),m,xlong,ylat,kjbmx(i)
      enddo
      return
      end

      subroutine ckjbxt(m1,m2,t,ylat,xlong,n,
     1  lat,long,time,mag,ncat,kjbxt,b,a,d,s,m0,t0,
     1  delay,nf,rtr)
      implicit none
      integer n,i,nf,l,ncat,rtr
      real t,m(n),stpm,b,a,d,s,r,delay,distkm,kjf0r
      real lat(90000),long(90000),kjbxt(10000)
      real time(90000),mag(90000),m0,t0
      real ylat,xlong,m1,m2
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop .and.(nf.ne.0)) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      stpm=(m2-m1)/(n-1)
c      write(6,*)"entered ckjbxt",t,m1,m2,ylat,xlong,n,
c     1 nf,b,m0,ncat,stpm
      do i=1,n
        kjbxt(i)=0.0
        m(i)=m1+(i-1)*stpm
      enddo
        l=0
 1      l=l+1
        if (l.gt.ncat)go to 89
        if (time(l).ge.(t-delay))go to 89
        if (mag(l).ge.m0) then
        r=distkm(ylat,xlong,lat(l),long(l))
        do i=1,n
            kjbxt(i)=kjbxt(i)+kjf0r(a,mag(l),m0,d,r,s)
         enddo
        endif
       go to 1
 89   continue
      do i=1,n
        kjbxt(i)=kjbxt(i)*10**(-b*(m(i)-m0))
     1  *b*log(10.0)/(t-delay-t0) 
        if (rtr.eq.1)kjbxt(i)=kjbxt(i)*10.**m(i)*365.25/
     1  (log(10.0))
        if (nf.ne.0)write(nf,*)t,m(i),xlong,ylat,kjbxt(i)
      enddo
      return
      end

      
 
      subroutine cbckgd(n,lat,long,mag,bckgrd,b,r5pd)
      integer n,i
      real lat(90000),long(90000),mag(90000),bckgrd(90000),b,r5pd
      do i=1,n
       bckgrd(i)=backgd(lat(i),long(i),mag(i),b,r5pd)
      enddo
      return
      end    
      
      subroutine csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1a,m0,d,s,inout,ndiam,f0rsum)
      implicit none
      real lat(90000),long(90000),xpoly(100),ypoly(100),apoly
      real a,mag(90000),m0,d,s,sumf0r
      real f0rsum(90000)
      integer n,inout(2,90000),ndiam,npoly,i
      do i=1,n
       f0rsum(i)=0.0
       if (mag(i).ge.m0)then
          f0rsum(i)=sumf0r(long(i),lat(i),xpoly,ypoly,npoly,apoly,
     1    a,mag(i),m0,d,s,inout(1,i),ndiam)
       endif
       if (f0rsum(i).lt.0.)write(6,*)"ERROR f0rsum<0 f0rsum(", i,"=",
     1 f0rsum(i)
      enddo
      return
      end


      real function ppertd(timed,magtd,lattd,longtd,n,lat,long,t,mag,
     1b,a,d,s,m0,t0,delay)
      implicit none
      integer n,i
      real lat(90000),long(90000),mag(90000)
      real m0,r,b,a,d,s,t(90000),t0,kjf0r,distkm,delay,timed,magtd
      real lattd,longtd
      ppertd=0.0
      do i=1,n
       if ((t(i).lt.(timed-delay)).and.(mag(i).ge.m0)) then
             r=distkm(lat(i),long(i),lattd,longtd)
             ppertd=ppertd+kjf0r(a,mag(i),m0,d,r,s)
c             write(14,*)"kjf0r (",a,mag(i),m0,d,r,s,')=',
c     1kjf0r(a,mag(i),m0,d,r,s)
       endif
      enddo
      ppertd=ppertd*10**(-b*(magtd-m0))
     1  *b*log(10.0)/(timed-delay-t0) 
c       write(6,*) "pperd",ppertd
      return
      end    
 

      subroutine ckjbgd(n,lat,long,t,mag,bgdkj,b,a,d,s,m0,t0,delay)
      implicit none
      integer n,i,j
      real lat(90000),long(90000),mag(90000),bgdkj(90000)
      real m0,r,b,a,d,s,t(90000),t0,kjf0r,distkm,delay
      do i=1,n
       bgdkj(i)=0.0
       do j=1,i-1
          if ((mag(j).ge.m0).and.(t(j).lt.t(i)-delay)) then
             r=distkm(lat(i),long(i),lat(j),long(j))
             bgdkj(i)=bgdkj(i)+kjf0r(a,mag(j),m0,d,r,s)
          endif
       enddo
       bgdkj(i)=bgdkj(i)*10**(-b*(mag(i)-m0))
     1  *b*log(10.0)/(t(i)-delay-t0) 
c       write(6,*) "bgdkj(",i,")",bgdkj(i)
      enddo
      return
      end    
  
      real function ocll(n1,n2,bckgrd,omor,evson,bgdkj,
     1 mu,kappa,evmu,kjmu,ss,mag,minmag,inout)
      implicit none
      integer n1,n2,i,ss(90000),inout(2,90000)
      real bckgrd(90000),omor(90000),evson(90000),mag(90000),ll
      real mu,kappa,evmu,minmag,kjmu,bgdkj(90000)
      ll=0.0
      do i=n1,n2
       if ((ss(i).eq.1).and.(inout(1,i).eq.1).and.(inout(2,i).eq.1)
     1.and.(mag(i).ge.minmag))then
          ll=ll+
     1    log(mu*bckgrd(i)+kappa*omor(i)+evmu*evson(i)+kjmu*bgdkj(i))
c          if (mag(i).eq.4.98)
c     1     write(89,*)mag(i),evson(i),bgdkj(i),bckgrd(i),omor(i)
       endif
      enddo
      ocll=ll
      return
      end

      real function ocllst(n1,n2,bckgrd,omor,evson,bgdkj,step,
     1 mu,kappa,evmu,kjmu,stmu,ss,mag,minmag,inout)
      implicit none
      integer n1,n2,i,ss(90000),inout(2,90000)
      real bckgrd(90000),omor(90000),evson(90000),mag(90000),ll
      real mu,kappa,evmu,minmag,kjmu,stmu,step(90000),bgdkj(90000)
      write(6,*)"ocllst:mu,evmu,kjmu,stmu",mu,evmu,kjmu,stmu
      ll=0.0
      do i=n1,n2
       if ((ss(i).eq.1).and.(inout(1,i).eq.1).and.(inout(2,i).eq.1)
     1.and.(mag(i).ge.minmag))then
          ll=ll+
     1    log(mu*bckgrd(i)+kappa*omor(i)+evmu*evson(i)+kjmu*bgdkj(i)+
     1    stmu*step(i))
c          if (mag(i).eq.4.98)
c     1     write(89,*)mag(i),evson(i),bgdkj(i),bckgrd(i),omor(i)
       endif
      enddo
      ocllst=ll
      return
      end

      real function ocll2(n1,n2,bgdkj,
     1 kjmu,ss,mag,minmag,inout)
      implicit none
      integer n1,n2,i,ss(90000),inout(2,90000)
      real mag(90000),ll
      real minmag,kjmu,bgdkj(90000)
      ll=0.0
      do i=n1,n2
       if ((ss(i).eq.1).and.(inout(1,i).eq.1).and.(inout(2,i).eq.1)
     1 .and.(mag(i).ge.minmag))ll=ll+log(kjmu*bgdkj(i))
      enddo
      ocll2=ll
      return
      end

      real function jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,
     1 mu,kappa,evmu,kjmu,jmu,jkappa,ss,mag,minmag,inout)
      implicit none
      integer n1,n2,i,ss(90000),inout(90000)
      real bckgrd(90000),omor(90000),evson(90000),mag(90000),ll
      real mu,kappa,evmu,minmag,kjmu,bgdkj(90000)
      real jmu,jkappa,jomor(90000)
      ll=0.0
      do i=n1,n2
       if ((ss(i).eq.1).and.(inout(i).eq.1).and.(mag(i).ge.minmag))
     1 then
          ll=ll+
     1    log(mu*bckgrd(i)+kappa*omor(i)+evmu*evson(i)+kjmu*bgdkj(i)
     1         +jkappa*jomor(i)+jmu*evson(i))
c          write(15,*)mag(i),evson(i),bgdkj(i),omor(i),jomor(i),ll,
c     1jkappa,mu
       endif
      enddo
      jocll=ll
      return
      end

      subroutine jcomor(n,kappa,c,p,b,sigu,lat,long,mag,
     1time,jomor,delay)
      implicit none
      integer n,i
      real kappa,c,p,b,sigu,jomori,delay
      real lat(90000),long(90000),mag(90000),time(90000),
     1jomor(90000)
      do i=1,n
c         write(6,*)"jcomor doing i=", i
       jomor(i)=jomori(i,kappa,c,p,b,sigu,lat,long,mag,time,
     1 delay)
      enddo
      return
      end
      
       subroutine cjomor(n,kappa,c,p,b,sigu,lat,long,mag,
     1time,jomor,delay,minmag)
      implicit none
      integer n,i
      real kappa,c,p,b,sigu,jomori,delay,minmag
      real lat(90000),long(90000),mag(90000),time(90000),
     1jomor(90000)
      do i=1,n
c      write(6,*)"jcomor doing i=", i
       if (mag(i).ge.minmag)then
        jomor(i)=jomori(i,kappa,c,p,b,sigu,lat,long,mag,time,
     1  delay)
       endif
      enddo
      return
      end
      
       subroutine jcomo2(n,kappa,c,p,b,jd,jq,lat,long,mag,
     1time,jomor,delay)
      implicit none
      integer n,i
      real kappa,c,p,b,jomor2,jd,jq,delay
      real lat(90000),long(90000),mag(90000),time(90000),
     1jomor(90000)
      do i=1,n
       jomor(i)=jomor2(i,kappa,c,p,b,jd,jq,lat,long,mag,time,
     1delay)
      enddo
      return
      end

      subroutine jnocll(n1,n2,w,time,mag,inout,lat,long,bt,
     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
     1jc,jp,jsig,minmag,delay,f0rsum,xpoly,ypoly,npoly,
     1ll0,ll1,ll2,ll3,ll4)
      implicit none
      integer n1,n2,i,ss(90000),inout(90000),npoly,nmin,nmin2,j
      real xpoly(100),ypoly(100),t0,ti,plocin,pnorm,ba
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,logti,sigti,xmui,logt1i,tmui,ll0,ll1,ll2,ll3,ll4
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,jkappa,jb,jc,jp,jsig,eppxin(90000),nepexp(90000)
      real epptin(90000),maxmag,f2t
      external f2t
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocll params",n1,n2,w(n2),time(n2),mag(n2),
c     1inout(n2),lat(n2),long(n2),bt,
c     1bm,ba,sigu,b,c,p,ss(n2),n5pd,area,mu,kappa,eta(n2),
c     1minmag,delay,f0rsum(n2),xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorm(maghi,xmui,sigm)-pnorm(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorm(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
         scafac(i)=powsum/psum
      enddo
c      write(6,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
c  plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c      call pxinrg(n2,lat,long,mag,siga,0.25,evpxin)
      sigti=log(10.0)*sigt
      do i=1,n2-1
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i),8)
       logti=log(time(n2)-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorm(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorm(ahigh,0.0,1.0)-pnorm(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if (time(i).lt.time(n1)) then
        logt1i=log(time(n1)-time(i))
        evptin(i)=evptin(i)-pnorm(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
c integrate aftershock component
c       call pxinrg(n2,lat,long,mag,sigu,0.5,aspxin) 
      do i=1,n2-1
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-10**(b*0))
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (time(i).lt.time(n1))then
        asptin(i)=c**(p-1)*((c+time(n1)-time(i))**(1-p)-
     1  (c+time(n2)-time(i))**(1-p))
       else 
        asptin(i)=1-c**(p-1)*(c+time(n2)-time(i))**(1-p)
       endif
      enddo
c integrate epidemic component
      do i=1,n2-1
       sigma=jsig*10**(mag(i)*0.5)/111.0
       eppxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i),8)
       nepexp(i)=jkappa*(10**(jb*(mag(i)-minmag))-
     1 10**(jb*(mag(i)-maxmag)))
       if (nepexp(i).lt.0.) nepexp(i)=0.
       if (time(i).lt.time(n1))then
        epptin(i)=jc**(jp-1)*((jc+time(n1)-time(i))**(1-jp)-
     1  (jc+time(n2)-time(i))**(1-jp))
       else 
        epptin(i)=1-jc**(jp-1)*(jc+time(n2)-time(i))**(1-jp)
       endif
       epptin(i)=abs(epptin(i))
c          epptin(i)=simint(f2t,0.0,5000.)
      enddo
c calculate log likelihoods:0=static,1=long range,2=aftershock,3=kj,4=ep
      ll1=0.0
      ll2=0.0
      ll3=0.0
      ll4=0.0
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n2-1
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3) 
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*sc(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
       ll4=ll4+ss(i)*nepexp(i)*epptin(i)*eppxin(i)
       ti=time(i)+delay
       if (time(n1).gt.ti) ti=time(n1)
       if ((mag(i).ge.minmag).and.(ti.lt.time(n2))) then
          ll3=ll3+(log(time(n2)-t0)-log(ti-t0))*f0rsum(i)
       endif
      enddo
      ll0=mu*n5pd*(time(n2)-time(n1))*10**(b*(4.95-minmag))      
      return
      end
  
       subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
     1ll2,ll3,ll4)
      implicit none
      integer n1,n2,i,ss(90000),inout(90000),npoly,nmin,nmin2,j
      real xpoly(100),ypoly(100),t0,ti,plocin,pnorm,ba
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,logti,sigti,xmui,logt1i,tmui,ll0,ll1,ll2,ll3,ll4
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,jkappa,jb,jc,jp,eppxin(90000),nepexp(90000)
      real epptin(90000),plo2in,jd,jq,maxmag,f2temp
      external f2temp
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocll params",n1,n2,w(n2),time(n2),mag(n2),
c     1inout(n2),lat(n2),long(n2),bt,
c     1bm,ba,sigu,b,c,p,ss(n2),n5pd,area,mu,kappa,eta(n2),
c     1minmag,delay,f0rsum(n2),xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
c      maxmag=8.0
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorm(maghi,xmui,sigm)-pnorm(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorm(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
         scafac(i)=powsum/psum
      enddo
c      write(6,*)"jnocl2 flag1"
c      write(6,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
c  plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c      call pxinrg(n2,lat,long,mag,siga,0.25,evpxin)
c      write(6,*)"jnocl2 flag2"
      sigti=log(10.0)*sigt
      do i=1,n2-1
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i),8)
       logti=log(time(n2)-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorm(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorm(ahigh,0.0,1.0)-pnorm(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if (time(i).lt.time(n1)) then
        logt1i=log(time(n1)-time(i))
        evptin(i)=evptin(i)-pnorm(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
c      write(6,*)"jnocl2 flag3"
c integrate aftershock component
      do i=1,n2-1
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-10**(b*0))
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (time(i).lt.time(n1))then
        asptin(i)=c**(p-1)*((c+time(n1)-time(i))**(1-p)-
     1  (c+time(n2)-time(i))**(1-p))
       else 
        asptin(i)=1-c**(p-1)*(c+time(n2)-time(i))**(1-p)
       endif
      enddo
c integrate epidemic component
c      write(6,*)"jnocl2 flag4"
      do i=1,n2-1
c         write(6,*)"jnocl2 flag5",i
       eppxin(i)=plo2in(long(i),lat(i),jd,jq,xpoly,ypoly,
     1 npoly,inout(i),8)
       nepexp(i)=jkappa*(10**(jb*(mag(i)-minmag))-
     1 10**(jb*(mag(i)-maxmag)))
       if (nepexp(i).lt.0.) nepexp(i)=0.
       if (time(i)+delay.lt.time(n1))then
        epptin(i)=jc**(jp-1)*((jc+time(n1)-delay-time(i))**(1-jp)-
     1  (jc+time(n2)-time(i))**(1-jp))
       else if (time(i)+delay.lt.time(n2))then
        epptin(i)=jc**(jp-1)*((jc+delay)**(1-jp)-
     1 (jc+time(n2)-time(i))**(1-jp))
       else 
          epptin(i)=0.
       endif
cc       epptin(i)=simint(f2temp,0.0,1.)+simint(f2temp,1.,5000.)
       epptin(i)=abs(epptin(i))
       write(14,*)"i mi, eppxin nepexp epptin",i,mag(i),eppxin(i), 
     1 nepexp(i),epptin(i),ss(i)
      enddo
c      write(6,*)"jnocl2 flag5"
c calculate log likelihoods:0=static,1=long range,2=aftershock,3=kj,4=ep
      ll1=0.0
      ll2=0.0
      ll3=0.0
      ll4=0.0
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n2-1
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3) 
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*sc(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
       ll4=ll4+ss(i)*nepexp(i)*epptin(i)*eppxin(i)
       ti=time(i)+delay
       if (time(n1).gt.ti) ti=time(n1)
       if ((mag(i).ge.minmag).and.(ti.lt.time(n2))) then
          ll3=ll3+(log(time(n2)-t0)-log(ti-t0))*f0rsum(i)
       endif
      enddo
      ll0=mu*n5pd*(time(n2)-time(n1))*(10**(b*(4.95-minmag))-
     1 10**(b*(4.95-maxmag)))     
      return
      end
  
      real function jg2m(xm,xmi,b)
      implicit none
c not a density, doesn't integrate to 1
c expected no of aftershocks depends on xmi
      real xm,xmi,b,beta
      beta=b*log(10.)
      jg2m=beta*exp(-beta*(xm-xmi))
      return
      end

      real function jh2sum(jd,jq)
c test integral of jh2x is 1
      implicit none
      integer i,j
      real lat,long,lati,longi,jd,jq,jh2x
      lat=0.
      long=0.
      jh2sum=0.
      do i=-333,333
        lati=i/111.0
        do j=-333,333
           longi=j/111.0
           jh2sum=jh2sum+jh2x(lat,long,lati,longi,jd,jq)
        enddo
      enddo
      return
      end

      real function jh2x(lat,long,lati,longi,jd,jq)
      implicit none
      real lat,long,lati,longi,jd,jq
      real r,distkm
      r=distkm(lat,long,lati,longi)
      jh2x=((jq-1.0)/3.14159)*jd**(2*(jq-1.0))/(r**2+jd**2)**jq
      return
      end



      real function jomori(i,kappa,c,p,b,sigu,lat,long,mag,
     1time,delay)
      implicit none
      real f2t,jg2m,h2x,delay
      integer i,j
      real lat(90000),long(90000),mag(90000),time(90000)
      real s,kappa,c,p,b,sigu
      s=0.
      do j=1,i-1
       if ((time(j)+delay).le.time(i)) then  
        s=s+kappa*f2t(time(i),time(j),c,p)*jg2m(mag(i),mag(j),b)
     1  *h2x(lat(i),long(i),lat(j),long(j),mag(j),sigu)
       endif
      enddo
      jomori=s
      return
      end

      real function jomor2(i,kappa,c,p,b,jd,jq,lat,long,mag,
     1time,delay)
      implicit none
      real f2t,jg2m,jh2x,delay,tdelay,hvysid
      integer i,j
      real lat(90000),long(90000),mag(90000),time(90000)
      real s,kappa,c,p,b,jd,jq
      s=0.
      do j=1,i-1
       tdelay=time(i)-time(j)-delay
       s=s+kappa*hvysid(tdelay)*f2t(time(i),time(j),c,p)*
     1 jg2m(mag(i),mag(j),b)
     1 *jh2x(lat(i),long(i),lat(j),long(j),jd,jq)
      enddo
      jomor2=s
      return
      end


      subroutine nocll(n1,n2,w,time,mag,inout,lat,long,bt,
     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,
     1minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,ll3)
      implicit none
      integer n1,n2,i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j
      real xpoly(100),ypoly(100),t0,ti,plocin,pnorml,ba
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,logti,sigti,xmui,logt1i,tmui,ll0,ll1,ll2,ll3
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,maxmag,mfactr
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocll params",n1,n2,w(n2),time(n2),mag(n2),
c     1inout(1,n2),lat(n2),long(n2),bt,
c     1bm,ba,sigu,b,c,p,ss(n2),n5pd,area,mu,kappa,eta(n2),
c     1minmag,delay,f0rsum(n2),xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorml(maghi,xmui,sigm)-pnorml(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
c         write(31,*)i,magi,powsum,psum
         scafac(i)=powsum/psum
      enddo
c      write(15,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
c  plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c      call pxinrg(n2,lat,long,mag,siga,0.25,evpxin)
      sigti=log(10.0)*sigt
      do i=1,n2-1
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(time(n2)-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorml(ahigh,0.0,1.0)-pnorml(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if (time(i).lt.time(n1)) then
        logt1i=log(time(n1)-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
c integrate aftershock component
c       call pxinrg(n2,lat,long,mag,sigu,0.5,aspxin) 
      do i=1,n2-1
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-10**(b*0))
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (time(i).lt.time(n1))then
        asptin(i)=c**(p-1)*((c+time(n1)-time(i))**(1-p)-
     1  (c+time(n2)-time(i))**(1-p))
       else 
        asptin(i)=1-c**(p-1)*(c+time(n2)-time(i))**(1-p)
       endif
      enddo
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n2-1
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3) 
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*sc(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
       ti=time(i)+delay
       if (time(n1).gt.ti) ti=time(n1)
       if ((mag(i).ge.minmag).and.(ti.lt.time(n2))) then
          ll3=ll3+(log(time(n2)-t0)-log(ti-t0))*f0rsum(i)*mfactr
       endif
      enddo
      ll0=n5pd*(time(n2)-time(n1))*(10**(b*(4.95-minmag))-10**(b*
     1(4.95-maxmag)))     
      return
      end
  
      subroutine no2cll(n1,n2,w,time,mag,inout,lat,long,bt,
     1bm,ba,sigu,b,balpha,c,p,ss,n5pd,area,mu,kappa,eta,delgm2,
     1zeta,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,ll3)
      implicit none
      integer n1,n2,i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j
      integer nmax2
      real xpoly(100),ypoly(100),t0,ti,plocin,pnorml,ba
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,magi,mueep,zeta
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,logti,sigti,xmui,logt1i,tmui,ll0,ll1,ll2,ll3
      real scafac(80),powsum,psum,magj,wj,pj,maghi,maglo,mfactr
      real limupp,sumpm2(80),delgm2,g1m3,balpha,area,maxmag
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocll params",n1,n2,w(n2),time(n2),mag(n2),
c     1inout(1,n2),lat(n2),long(n2),bt,
c     1bm,ba,sigu,b,c,p,ss(n2),n5pd,area,mu,kappa,eta(n2),
c     1minmag,delay,f0rsum(n2),xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*100)
      nmax2=int(maxmag*100)
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,nmax2
            magj=0.01*j
            maglo=magj-0.005
            maghi=magj+0.005
            pj=0.01*g1m3(magj,magi,am,bm,sigm,b,balpha,delgm2,zeta)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
         scafac(i)=powsum/psum
         sumpm2(i)=powsum
      enddo
c      write(6,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
c  plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c      call pxinrg(n2,lat,long,mag,siga,0.25,evpxin)
      sigti=log(10.0)*sigt
      do i=1,n2-1
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(time(n2)-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
c now do magnitudes allowing for scale up at low magnitudes
       j=int(10.*(mag(i)+0.05))
       evpmin(i)=sumpm2(j)
       if (time(i).lt.time(n1)) then
        logt1i=log(time(n1)-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
c integrate aftershock component
c       call pxinrg(n2,lat,long,mag,sigu,0.5,aspxin) 
      do i=1,n2-1
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-10**(b*0))
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (time(i).lt.time(n1))then
        asptin(i)=c**(p-1)*((c+time(n1)-time(i))**(1-p)-
     1  (c+time(n2)-time(i))**(1-p))
       else 
        asptin(i)=1-c**(p-1)*(c+time(n2)-time(i))**(1-p)
       endif
      enddo
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n2-1
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3) 
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
       ti=time(i)+delay
       if (time(n1).gt.ti) ti=time(n1)
       if ((mag(i).ge.minmag).and.(ti.lt.time(n2))) then
          ll3=ll3+(log(time(n2)-t0)-log(ti-t0))*f0rsum(i)*mfactr
       endif
      enddo
      ll0=mu*n5pd*(time(n2)-time(n1))*(10**(b*(4.95-minmag))-10**(b*
     1(4.95-maxmag)))      
      return
      end
  
      subroutine no2clt(t1,t2,w,time,mag,inout,lat,long,bt,
     1bm,ba,sigu,b,balpha,c,p,ss,n5pd,area,mu,kappa,eta,delgm2,zeta,
     1minmag,delay,f0rsum,xpoly,ypoly,npoly,ncat,ll0,ll1,ll2,ll3)
      implicit none
      integer i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j
      integer nmax2,ncat
      real xpoly(100),ypoly(100),t0,ti,plocin,pnorml,ba,t1,t2
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,magi,mueep,zeta
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,logti,sigti,xmui,logt1i,tmui,ll0,ll1,ll2,ll3
      real scafac(80),powsum,psum,magj,wj,pj,maghi,maglo,mfactr
      real limupp,sumpm2(80),delgm2,g1m3,balpha,area,maxmag
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocll params",n1,n2,w(n2),time(n2),mag(n2),
c     1inout(1,n2),lat(n2),long(n2),bt,
c     1bm,ba,sigu,b,c,p,ss(n2),n5pd,area,mu,kappa,eta(n2),
c     1minmag,delay,f0rsum(n2),xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*100)
      nmax2=int(maxmag*100)
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,nmax2
            magj=0.01*j
            maglo=magj-0.005
            maghi=magj+0.005
            pj=0.01*g1m3(magj,magi,am,bm,sigm,b,balpha,delgm2,zeta)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
         scafac(i)=powsum/psum
         sumpm2(i)=powsum
      enddo
c      write(6,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
c  plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c      call pxinrg(n2,lat,long,mag,siga,0.25,evpxin)
      sigti=log(10.0)*sigt
      do i=1,ncat-1
       if (time(i).ge.(t2-delay))go to 199
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(t2-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
c now do magnitudes allowing for scale up at low magnitudes
       j=int(10.*(mag(i)+0.05))
       evpmin(i)=sumpm2(j)
       if (time(i).lt.t1) then
        logt1i=log(t1-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
 199  continue
c integrate aftershock component
c       call pxinrg(n2,lat,long,mag,sigu,0.5,aspxin) 
      do i=1,ncat
       if(time(i).ge.t2)go to 299
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-10**(b*0))
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (time(i).lt.t1)then
        asptin(i)=c**(p-1)*((c+t1-time(i))**(1-p)-
     1  (c+t2-time(i))**(1-p))
       else 
        asptin(i)=1-c**(p-1)*(c+t2-time(i))**(1-p)
       endif
      enddo
 299  continue
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,ncat
c         write(6,*)"no2clt time t2",time(i),t2,i
       if(time(i).ge.t2)go to 399
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3) 
c       write(6,*)"ss eta w evptin evpmin evpxin i",
c     1 ss(i),eta(i),w(i),evptin(i),evpmin(i),evpxin(i),i
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
       ti=time(i)+delay
       if (t1.gt.ti) ti=t1
       if ((mag(i).ge.minmag).and.(ti.lt.t2)) then
          ll3=ll3+(log(t2-t0)-log(ti-t0))*f0rsum(i)*mfactr
c          write (6,*)"log(t2-t0)-log(ti-t0) f0rsum mfactr i",
c     1    (log(t2-t0)-log(ti-t0)),f0rsum(i),mfactr,i
       endif
      enddo
 399  continue
      ll0=mu*n5pd*(t2-t1)*(10**(b*(4.95-minmag))-10**(b*
     1(4.95-maxmag)))      
      return
      end
  



      subroutine nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1 bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,minmag,
     1 deltam,delay,f0rsum,xpoly,ypoly,npoly,n,ll0,ll1,ll2,ll3)
      implicit none
      integer i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j,n
      real xpoly(100),ypoly(100),t0,plocin,pnorml,ba,t1,t2
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa,mfactr
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real minmag,maxmag,logti,sigti,xmui,logt1i,tmui
      real ll0,ll1,ll2,ll3
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,hvysid,deltam
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocllt params",t1,t2,bt,
c     1bm,ba,sigu,b,c,p,n5pd,area,mu,kappa,eta(1),
c     1minmag,delay,xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
      do i=nmin+1,80
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorml(maghi,xmui,sigm)-pnorml(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
c         write(31,*)i,magi,powsum,psum
         scafac(i)=powsum/psum
      enddo
c      write(15,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
      sigti=log(10.0)*sigt
      do i=1,n-1
       if (time(i).ge.(t2-delay)) then
          evptin(i)=0.0
          go to 199
       endif
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(t2-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorml(ahigh,0.0,1.0)-pnorml(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if ((time(i)+delay).lt.t1) then
        logt1i=log(t1-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       else
        logt1i=log(delay)
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
 199  continue
c integrate aftershock component
      do i=1,n
       if(time(i).ge.t2)go to 299
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-
     1 exp(b*log(10.)*deltam))*hvysid(mag(i)-minmag-deltam)
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (p.ne.1.) then
        if (time(i).lt.t1)then
         asptin(i)=c**(p-1)*(c+t1-time(i))**(1-p)-
     1   (c+t2-time(i))**(1-p)
        else 
         asptin(i)=1-c**(p-1)*(c+t2-time(i))**(1-p)
        endif
       else if (p.eq.1.)then
        if (time(i).lt.t1)then
         asptin(i)=c**(p-1)*((c+t1-time(i))**(1-p)-
     1   (c+t2-time(i))**(1-p))
        else 
         asptin(i)=1-c**(p-1)*(c+t2-time(i))**(1-p)
        endif
       endif
       asptin(i)=abs(asptin(i))
      enddo
 299  continue
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n
       if(time(i).ge.t2-delay)go to 399
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3)
       if (nasexp(i).lt.0.)write(13,*)"Warning:nasexp(i)<0)",i,
     1 nasexp(i)
       if (asptin(i).lt.0.)write(13,*)"Warning:asptin(i)<0)",i,
     1 asptin(i)
       if (aspxin(i).lt.0.)write(13,*)"Warning:aspxin(i)<0)",i,
     1 aspxin(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
c       ti=time(i)+delay
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*
     1   sc(i)
       if (t1.gt.time(i)+delay) then
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(t1-delay-t0))*f0rsum(i)*
     1   mfactr
         endif
       else
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(time(i)-t0))*
     1   f0rsum(i)*mfactr
         endif
       endif
      enddo
 399  ll0=n5pd*(t2-t1)*(10**(b*(4.95-minmag))-10**(b*(4.95-maxmag)))    
      return
      end
  
      subroutine jnoclt(t1,t2,w,time,mag,inout,lat,long,bt,
     1 bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,jc,jp,
     1 jsig,minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1 ll0,ll1,ll2,ll3,ll4)
      implicit none
      integer i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j,n
      real xpoly(100),ypoly(100),t0,plocin,pnorml,ba,t1,t2
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa,mfactr
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real eppxin(90000),epptin(90000),nepexp(90000),jc,jp,jkappa
      real jsig,jb
      real minmag,maxmag,logti,sigti,xmui,logt1i,tmui
      real ll0,ll1,ll2,ll3,ll4
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,hvysid,deltam
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocllt params",t1,t2,bt,
c     1bm,ba,sigu,b,c,p,n5pd,area,mu,kappa,eta(1),
c     1minmag,delay,xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
      do i=nmin+1,80
c         write(6,*)" jnoclt flag1 i=",i
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorml(maghi,xmui,sigm)-pnorml(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
c         write(31,*)i,magi,powsum,psum
         scafac(i)=powsum/psum
      enddo
c      write(15,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
      sigti=log(10.0)*sigt
      do i=1,n-1
       if (time(i).ge.(t2-delay)) then
          evptin(i)=0.0
          go to 199
       endif
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(t2-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorml(ahigh,0.0,1.0)-pnorml(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if ((time(i)+delay).lt.t1) then
        logt1i=log(t1-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       else
        logt1i=log(delay)
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
 199  continue
c integrate aftershock component
      do i=1,n
c         write(6,*)"noclt flag2 i=",i
       if(time(i).ge.t2)go to 299
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-
     1 exp(b*log(10.)*deltam))*hvysid(mag(i)-minmag-deltam)
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (p.ne.1.) then
        if (time(i).lt.t1)then
         asptin(i)=c**(p-1)*(c+t1-time(i))**(1-p)-
     1   (c+t2-time(i))**(1-p)
        else 
         asptin(i)=1-c**(p-1)*(c+t2-time(i))**(1-p)
        endif
       else if (p.eq.1.)then
        if (time(i).lt.t1)then
         asptin(i)=log(c+t1-time(i))-log(c+t2-time(i))
        else 
         asptin(i)=log(c)-log(c+t2-time(i))
        endif
       endif
       asptin(i)=abs(asptin(i))
      enddo
 299  continue
c integrate epidemic component
c      write(6,*)"jnoclt:jsig,jp,jc,jkappa,delay",jsig,
c     1jp,jc,jkappa,delay
      do i=1,n
c         write(6,*)"noclt flag3 i=",i
       if((time(i)+delay).ge.t2)go to 399
       sigma=jsig*10**(mag(i)*0.5)/111.0
       eppxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i,1),8)
       nepexp(i)=jkappa*(10**(jb*(mag(i)-minmag))-
     1 10**(jb*(mag(i)-maxmag)))
c -----need to build in delay for horizon work
       if (nepexp(i).lt.0.) nepexp(i)=0.
       if (jp.ne.1.) then
        if ((time(i)+delay).lt.t1)then
         epptin(i)=jc**(jp-1)*(jc+t1-time(i))**(1-jp)-
     1   (jc+t2-time(i))**(1-jp)
        else 
         epptin(i)= jc**(jp-1)*(jc+delay)**(1-jp)-
     1   (jc+t2-time(i))**(1-jp)
        endif
       else if (jp.eq.1.)then
        if ((time(i)+delay).lt.t1)then
         epptin(i)=log(jc+t1-time(i))-log(jc+t2-time(i))
        else 
         epptin(i)=log(jc+delay)-log(jc+t2-time(i))
        endif
       endif
       epptin(i)=abs(epptin(i))
      enddo
 399  continue
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      ll4=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n
c         write(6,*)"noclt flag4 i=",i
       if(time(i).ge.t2-delay)go to 499
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3)
       if (nasexp(i).lt.0.)write(13,*)"Warning:nasexp(i)<0)",i,
     1 nasexp(i)
       if (asptin(i).lt.0.)write(13,*)"Warning:asptin(i)<0)",i,
     1 asptin(i)
       if (aspxin(i).lt.0.)write(13,*)"Warning:aspxin(i)<0)",i,
     1 aspxin(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
c       ti=time(i)+delay
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*
     1   sc(i)
       ll4=ll4+ss(i)*nepexp(i)*epptin(i)*eppxin(i)
c       write(15,*)"i,nepexp(i),epptin(i),eppxin(i)",
c     1 i,nepexp(i),epptin(i),eppxin(i)
       if (t1.gt.time(i)+delay) then
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(t1-delay-t0))*f0rsum(i)*
     1   mfactr
         endif
       else
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(time(i)-t0))*
     1   f0rsum(i)*mfactr
         endif
       endif
      enddo
 499  ll0=n5pd*(t2-t1)*(10**(b*(4.95-minmag))-10**(b*(4.95-maxmag)))    
      return
      end
  
      subroutine jnoct2(t1,t2,w,time,mag,inout,lat,long,bt,
     1 bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,jc,jp,
     1 jsig,minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1 ll0,ll1,ll2,ll3,ll4)
      implicit none
      integer i,ss(90000),inout(2,90000),npoly,nmin,nmin2,j,n
      real xpoly(100),ypoly(100),t0,plocin,pnorml,ba,t1,t2
      real w(90000),time(90000),mag(90000),lat(90000),long(90000)
      real delay,sigma,eta(90000),mag0,alow,ahigh,magi,mueep
      real at,bt,sigt,am,bm,sigm,siga,sigu,b,c,p,mu,kappa,mfactr
      real evpxin(90000),evptin(90000),evpmin(90000),n5pd,area
      real aspxin(90000),asptin(90000),nasexp(90000),f0rsum(90000)
      real eppxin(90000),epptin(90000),nepexp(90000),jc,jp,jkappa
      real jsig,jb
      real minmag,maxmag,logti,sigti,xmui,logt1i,tmui
      real ll0,ll1,ll2,ll3,ll4
      real scafac(80),powsum,psum,magj,wj,pj,sc(90000),maghi,maglo
      real limupp,hvysid,deltam
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(19,*)"nocllt params",t1,t2,bt,
c     1bm,ba,sigu,b,c,p,n5pd,area,mu,kappa,eta(1),
c     1minmag,delay,xpoly,ypoly,npoly
      nmin=int(mag0*10)
      nmin2=int(minmag*10)
      do i=nmin+1,80
c         write(6,*)" jnoclt flag1 i=",i
         magi=0.1*i
         xmui=am+bm*magi
         powsum=0.0
         psum=0.0
         do j=nmin2+1,80
            magj=0.1*j
            maglo=magj-0.05
            maghi=magj+0.05
            pj=pnorml(maghi,xmui,sigm)-pnorml(maglo,xmui,sigm)
            if (pj.lt.0.0)pj=0.0
            limupp=(magj-am-bm*mag0-b*log(10.)*sigm**2)/sigm
            wj=pnorml(limupp,0.0,1.0)
            powsum=powsum+pj/wj
            psum=psum+pj
c            write(19,*)magi,xmui,magj,maglo,maghi,pj,wj,powsum,psum
         enddo
c         write(31,*)i,magi,powsum,psum
         scafac(i)=powsum/psum
      enddo
c      write(15,*)(scafac(i),i=nmin+1,80)
      t0=time(1)-1.0
c integrate long range forecasting component
      sigti=log(10.0)*sigt
      do i=1,n-1
       if (time(i).ge.(t2-delay)) then
          evptin(i)=0.0
          go to 199
       endif
       sigma=siga*10**(ba*mag(i)*0.5)/111.0
       evpxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       logti=log(t2-time(i))
       tmui=log(10.0)*(at+bt*mag(i))
       evptin(i)=pnorml(logti,tmui,sigti)
       xmui=am+bm*mag(i)
c now do magnitudes allowing for scale up at low magnitudes
       alow=(minmag-xmui)/sigm
       ahigh=(maxmag-xmui)/sigm
       magi=mag(i)
c       write (15,*)"mag(i),magi,mag0,sigm,xmui,alow,ahigh",
c     1mag(i),magi,mag0,sigm,xmui,alow,ahigh
       evpmin(i)=pnorml(ahigh,0.0,1.0)-pnorml(alow,0.0,1.0)
       j=int(10.*(mag(i)+0.05))
       sc(i)=scafac(j)
       if ((time(i)+delay).lt.t1) then
        logt1i=log(t1-time(i))
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       else
        logt1i=log(delay)
        evptin(i)=evptin(i)-pnorml(logt1i,tmui,sigti)
       endif
c       write(15,*)"i,eta(i),ss(i),w(i),evpxin(i),evptin(i),
c     1 sc(i)","evpmin(i)",i,eta(i),ss(i),w(i),evpxin(i),
c     1 evptin(i),sc(i),evpmin(i)
      enddo
 199  continue
c integrate aftershock component (allowing for delay)
      do i=1,n
c         write(6,*)"noclt flag2 i=",i
       if((time(i)+delay).ge.t2)go to 299
       sigma=sigu*10**(mag(i)*0.5)/111.0
       aspxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(1,i),8)
       nasexp(i)=kappa*(10**(b*(mag(i)-minmag))-
     1 exp(b*log(10.)*deltam))*hvysid(mag(i)-minmag-deltam)
       if (nasexp(i).lt.0.) nasexp(i)=0.
       if (p.ne.1.) then
        if ((time(i)+delay).lt.t1)then
         asptin(i)=c**(p-1)*(c+t1-time(i))**(1-p)-
     1   (c+t2-time(i))**(1-p)
        else 
         asptin(i)=c**(p-1)*(c+delay)**(1-p)-
     1   c**(p-1)*(c+t2-time(i))**(1-p)
        endif
       else if (p.eq.1.)then
        if ((time(i)+delay).lt.t1)then
         asptin(i)=log(c+t1-time(i))-log(c+t2-time(i))
        else 
         asptin(i)=log(c+delay)-log(c+t2-time(i))
        endif
       endif
       asptin(i)=abs(asptin(i))
      enddo
 299  continue
c integrate epidemic component
c      write(6,*)"jnoclt:jsig,jp,jc,jkappa,delay",jsig,
c     1jp,jc,jkappa,delay
      do i=1,n
c         write(6,*)"noclt flag3 i=",i
       if((time(i)+delay).ge.t2)go to 399
       sigma=jsig*10**(mag(i)*0.5)/111.0
       eppxin(i)=plocin(long(i),lat(i),sigma,xpoly,ypoly,
     1 npoly,inout(i,1),8)
       nepexp(i)=jkappa*(10**(jb*(mag(i)-minmag))-
     1 10**(jb*(mag(i)-maxmag)))
c -----need to build in delay for horizon work
       if (nepexp(i).lt.0.) nepexp(i)=0.
       if (jp.ne.1.) then
        if ((time(i)+delay).lt.t1)then
         epptin(i)=jc**(jp-1)*(jc+t1-time(i))**(1-jp)-
     1   (jc+t2-time(i))**(1-jp)
        else 
         epptin(i)=jc**(jp-1)*(jc+delay)**(1-jp)-
     1   (jc+t2-time(i))**(1-jp)
        endif
       else if (jp.eq.1.)then
        if ((time(i)+delay).lt.t1)then
         epptin(i)=log(jc+t1-time(i))-log(jc+t2-time(i))
        else 
         epptin(i)=log(jc+delay)-log(jc+t2-time(i))
        endif
       endif
       epptin(i)=abs(epptin(i))
      enddo
 399  continue
c calculate log likelihoods (0=static,1=long range,2=aftershock,3=kj)
      ll1=0.0
      ll2=0.0
      ll3=0.0
      ll4=0.0
      mfactr=(10.**(-b*minmag)-10.**(-b*maxmag))/10**(-b*minmag)
c ll3 is kagan & jackson type model
c note that spatial integral of kjf0r is already stored in f0rsum
      do i=1,n
c         write(6,*)"noclt flag4 i=",i
       if(time(i).ge.t2-delay)go to 499
c       write(12,22) ss(i),w(i),evptin(i),evpmin(i),evpxin(i)
c       write(13,22) ss(i),nasexp(i),asptin(i),aspxin(i)
22     format(i4,4f11.3)
       if (nasexp(i).lt.0.)write(13,*)"Warning:nasexp(i)<0)",i,
     1 nasexp(i)
       if (asptin(i).lt.0.)write(13,*)"Warning:asptin(i)<0)",i,
     1 asptin(i)
       if (aspxin(i).lt.0.)write(13,*)"Warning:aspxin(i)<0)",i,
     1 aspxin(i)
       ll2=ll2+ss(i)*nasexp(i)*asptin(i)*aspxin(i)
c       ti=time(i)+delay
       ll1=ll1+ss(i)*eta(i)*w(i)*evptin(i)*evpmin(i)*evpxin(i)*
     1   sc(i)
       ll4=ll4+ss(i)*nepexp(i)*epptin(i)*eppxin(i)
c       write(15,*)"i,nepexp(i),epptin(i),eppxin(i)",
c     1 i,nepexp(i),epptin(i),eppxin(i)
       if (t1.gt.(time(i)+delay)) then
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(t1-delay-t0))*f0rsum(i)*
     1   mfactr
         endif
       else
         if (mag(i).ge.minmag)then
         ll3=ll3+(log(t2-delay-t0)-log(time(i)-t0))*
     1   f0rsum(i)*mfactr
         endif
       endif
      enddo
 499  ll0=n5pd*(t2-t1)*(10**(b*(4.95-minmag))-10**(b*(4.95-maxmag)))    
      return
      end
  
      subroutine pxinrg(n,lat,long,mag,sig0,scafac,pxin)
      integer n
      real lat(90000),long(90000),mag(90000),sig0,scafac,pxin(90000)
      real sigi(90000),pn37(90000),ps47(90000),pwtvz(90000),pntvz(90000)
      real sigiy(90000),wtvz(90000)
      do i=1,n
       sigi(i)=sig0*10**(mag(i)*scafac)/111
       sigiy(i)=sigi(i)/cos(3.14159*lat(i)/180)
       pn37(i)=1-pnorml(-37.0,lat(i),sigi(i))
       ps47(i)=pnorml(-47.0,lat(i),sigi(i))
       wtvz(i)=175.55+0.9*(lat(i)+39.3)
       pwtvz(i)=pnorml(wtvz(i),long(i),sigiy(i))
       pntvz(i)=1-pnorml(-39.3,lat(i),sigi(i))
       pxin(i)=(1-pn37(i)-ps47(i))*(1-pwtvz(i)*pntvz(i))
      enddo
      return
      end        

      real function pnorm(x,mu,sigma)
      real x,mu,sigma,y,p
      external dnorm
c normal integral up to (x-mu)/sigma
      y=(x-mu)/sigma
      if (y.lt.-3.0)then
       p=simint(dnorm,y,-3.0)
      else if (y.lt.-1.96) then
       p=0.0005+simint(dnorm,-3.0,y)
      else if (y.lt.0.0) then
       p=0.025+simint(dnorm,-1.96,y)
      else if (y.lt.1.96) then
       p=0.5+simint(dnorm,0.0,y)
      else if (y.lt.3.00) then
       p=0.975+simint(dnorm,1.96,y)
      else 
       p=1.0
      endif
      if (p.gt.1.0)p=1.0
      pnorm=p
      return
      end

      real function pnorsc(alow,ahigh,sig)
      implicit none
      real xout,alow,ahigh,sig,y,simint
      real aschi,asclo,pnorml
      external dnorsc,dnorm
c integral of dnorsc between alow and ahigh
      aschi=ahigh*sig
      asclo=alow*sig
c      y=simint(dnorm,alow,ahigh)
      y=1.0-pnorml(alow,0.0,sig)
      xout=simint(dnorsc,asclo,aschi)
c      write(15,*)"alow ahigh pnorsc pnorm",alow,ahigh,xout,y
      pnorsc=xout+y
      return
      end


      real function dnorm(xin)
      implicit none
      real xin
      dnorm=exp(-0.5*xin**2)/sqrt(2*3.14159)
      return
      end

      real function dnorsc(xin)
      implicit none
      real xin,am,sigm,at,sigt,siga,mueep,pnorml
      real b,bt,bm,ba,a,d,s,c,p,deltam,w,bgdkj,zeta
      real xsc,mag0,magi,y,z,maxmag,beepas,balpha,delgm2
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
       c=b*log(10.)*sigm+bm*(mag0-magi)/sigm
       xsc=xin/sigm
       y=pnorml(xsc,c,1.0)
c       write(15,*)"xin,c,b,sigm,bm,mag0,magi,pnorm",xin,c,b,sigm,bm,
c     1 mag0,magi,y
       z=exp(-0.5*xsc**2)/(sigm*sqrt(2*3.14159))
      dnorsc=z/y-z
c      write(15,*)"dnorsc,dnorm",dnorsc,z
      return
      end

c      real function dnorsc(xin)
c      implicit none
c      real xin,am,sigm,at,sigt,siga,mueep,dnorm,pnorm
c      real b,bt,bm,ba,a,d,s,c,p,deltam,w,bgdkj
c      real mag0,magi,y,z,beepas,zeta
c      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c     1bgdkj(90000),balpha,beepas,zeta
c      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c       c=b*log(10.)*sigm+bm*(mag0-magi)/sigm
c       y=pnorml(xin,c,1.0)
cc       write(15,*)"xin,c,b,sigm,bm,mag0,magi,pnorm",xin,c,b,sigm,bm,
cc     1 mag0,magi,y
c       z=dnorm(xin)
c     dnorsc=dnorm(xin)/y-z
cc      write(15,*)"dnorsc,dnorm",dnorsc,z
c      return
c      end


       
      REAL FUNCTION SIMINT(F,S,T)
      real s,t,h,f1,f2,f3,x
      integer npar,m1,i
      npar=16
      H = (T-S)/(NPAR*2.0)
      F1=F(S)
      F2=F(T)
      F3=F(T-H)
      X = F1 + F2 + 4.0*F3
      M1=NPAR-1
      DO 1 I=1,M1
1     X = X + 2.0*F(S + 2.0*I*H) + 4.0*F(S + (2.0*I-1.0)*H)
      SIMINT = H*X/3.0
      RETURN
      END


      real function weight(i,n,w,mag,lat,long,time,siga,ba
     1eqmagi)
      real w(90000),mag(90000),lat(90000),long(90000),time(90000)
      integer i,j,n
      real siga,eqmagi,h1xi,ba
      wgt=0.0
      eqmagi=mag(i)
      h1xi=h1x(lat(i),long(i),lat(i),long(i),mag(i),siga,ba)
      do j=1,n
       if ((mag(j).ge.(mag(i)-0.7)).and.
     1 (abs(time(i)-time(j)).lt.50.)) then
        h1xj=h1x(lat(j),long(j),lat(i),long(i),mag(i),siga,ba)
        wgt=wgt+w(j)*hvysid(h1xj/h1xi-0.2)
        if ((mag(j).gt.eqmagi).and.(h1xj.gt.0.2*h1xi))eqmagi=mag(j)
       endif
      enddo
      if (eqmagi.gt.(mag(i)+0.7)) wgt=w(i)
      if (wgt.gt.2*w(i))wgt=2*w(i)
      weight=w(i)*(wgt-w(i))
      return
      end

      integer function inside(x,y,xpoly,ypoly,npoly,cx,cy)
      implicit real*4 (a-h,o-z)
      real*4 x,y,cx,cy,sx,sy,a1,b1,c1,a2,b2,c2,cx3,cy3
      integer i,npoly,onoff1,onoff2,ncross
      real*4 xpoly(100),ypoly(100)
      ncross=0
c check whether x=cx or y=cy. If so redefine cx,cy
      cx3=cx
      cy3=cy
      if (x.eq.cx) cx=cx+0.01
      if (y.eq.cy) cy=cy+0.01
c----check whether x,y is inside polygon
c----if so, line joining x,y to cx,cy must cross boundary an even no. times
      call conlin(x,y,cx,cy,a1,b1,c1)
c      write(6,*)'exit conlin'
      do i=1,npoly
       call conlin(xpoly(i),ypoly(i),xpoly(i+1),ypoly(i+1),a2,b2,c2)
c      write(6,*)'exit conlin'
       call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
c      write(6,*)'exit intsct'
       call online(x,y,cx,cy,sx,sy,onoff1)
c      write(6,*)'exit online'
       call online(xpoly(i),ypoly(i),xpoly(i+1),ypoly(i+1),sx,sy,
     1 onoff2)
c      write(6,*)'exit online'
       ncross=ncross+onoff1*onoff2
      enddo
c       write(11,*) "inside",ncross, x,y,cx,cy,npoly
c      write(6,*)'about to test in or out'
      if (ncross/2.0-int(ncross/2.0).ge.0.01) then
         inside=0
      else 
         inside=1
      endif
      cx=cx3
      cy=cy3
      return
      end


      subroutine conlin(x1,y1,x2,y2,a,b,c)
c---- (a,b,c) coefficients of line connecting (x1,y1) & (x2,y2)
c---- ax+by=c
c---- assumes x1.ne.0.and.x2.ne.0 (ok for most zones)
      implicit none
      real x1,y1,x2,y2,a,b,c
      if (y1*x2.eq.x1*y2) then
         c=0
         b=1
         a=-y1/x1
         return
      else
         c=1
         b=(x2-x1)/(x2*y1-x1*y2)
         a=(c-b*y1)/x1
         return
      endif
      end

      subroutine intsct(a1,b1,c1,a2,b2,c2,x,y)
c---- (x,y) coordinates of intersection of lines (a1,b1,c1),(a2,b2,c2)
      implicit none
      real a1,b1,c1,a2,b2,c2,x,y
      if (a1*b2.eq.b1*a1) then
c---- parallel or coincident lines
         x=-9999.9
         y=-9999.9
c---- this must define a point outside polygon in both dimensions
      else
         y=(c1*a2-c2*a1)/(b1*a2-b2*a1)
         if (a1.ne.0) then
            x=(c1-b1*y)/a1
         else
            x=(c2-b2*y)/a2
         endif
      endif
      return
      end

      subroutine online(x1,y1,x2,y2,x3,y3,onoff)
c---- does (x3,y3) lie between (x1,y1) and (x2,y2)
c---- if yes, onoff=1
      implicit none
      real x1,y1,x2,y2,x3,y3,xm,ym,ss1,ss3,ss13
      integer onoff
      xm=0.5*(x1+x2)
      ym=0.5*(y1+y2)
      ss1=(x1-xm)**2+(y1-ym)**2
      ss3=(x3-xm)**2+(y3-ym)**2
      ss13=(x3-x1)**2+(y3-y1)**2
      if (ss3.gt.ss1) go to 9
      if (ss13.eq.0) go to 9
      onoff=1
      return
 9    onoff=0
      return
      end

      subroutine onlold(x1,y1,x2,y2,x3,y3,onoff)
c---- does (x3,y3) lie between (x1,y1) and (x2,y2)
c---- if yes, onoff=1
      implicit none
      real x1,y1,x2,y2,x3,y3
      integer onoff
c      write(14,*) 'online',x1,y1,x2,y2,x3,y3
      if ((x3.lt.x1-0.00000001).and.(x3.le.x2+0.00000001)) go to 9
      if ((x3.gt.x1+0.00000001).and.(x3.ge.x2-0.00000001)) go to 9
      if ((y3.lt.y1-0.00000001).and.(y3.le.y2+0.00000001)) go to 9
      if ((y3.gt.y1+0.00000001).and.(y3.ge.y2-0.00000001)) go to 9
      onoff=1
      return
 9    onoff=0
      return
      end

      real function kjf0r(a,m,m0,d,r,s)
      implicit none
      real a,m,m0,d,r,s,pi
      pi=3.14159
      kjf0r=a*(m-m0)/(pi*(d**2+r**2))+s
c      write(6,*)"kjfor",a,m,m0,d,r,s,kjf0r
      return
      end

c
c      function sumf0r(x,y,xpoly,ypoly,npoly,apoly,a,m,m0,d,s,
c     1 inros,ndiam)
cc integral of spatial density over region of surveillance
c      implicit none
c      real xmean
c      real sumf0r,apoly
c      integer inros,npoly,ndiam,i,j,onoff1,nint,npos,nneg
c      real x,y,xpoly(100),ypoly(100),a,m,m0,d,s,pi,theta,theta0
c      real a1,b1,c1,a2,b2,c2,x1,y1,sx,sy,angle(10),radius(10)
c      real radsrt(10),delta,ydelta,xdelta,elemnt(10),elepos,eleneg
cc      write(6,*)"sumf0r parms",
cc     1 x,y,xpoly,ypoly,npoly,a,m,m0,d,s,inros,ndiam
c      pi=3.14159
cc find intersections of diameters with boundaries of region
cc first find equations of diameters
c      theta0=0.5*pi/ndiam
c      do i=1,ndiam
c       theta=i*pi/ndiam+theta0
cc one point on the diameter
c       delta=100.0
c       ydelta=delta*sin(theta)
c       xdelta=delta*cos(theta)
c       x1=x+xdelta/(111.1*cos(y*pi/180))
c       y1=y+ydelta/111.1
cc       write(6,*)"x,y,x1,y1,theta,theta0,delta,xdelta,ydelta",
cc     1 x,y,x1,y1,theta,theta0,delta,xdelta,ydelta
cc equation of diameter
c       call conlin(x,y,x1,y1,a1,b1,c1)
cc       write(6,*)"a1,b1,c1",a1,b1,c1
cc intersections of diameters with sides of polygon
c       nint=0
c       do j=1,npoly
c        call conlin(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),a2,b2,c2)
c        call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
cc        write(6,*) "intsct",sx,sy
c        call online(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),sx,sy,
c     1  onoff1)
cc        write(6,*) "online-parms", xpoly(j),ypoly(j),xpoly(j+1),
cc     1   ypoly(j+1),sx,sy,onoff1
c        if (onoff1.eq.1)then
c          nint=nint+1
cc calculate angle and measure distance from x,y
c          if (x.lt.sx) angle(nint)= -1.0
c          if (x.gt.sx) angle(nint)= 1.0
c          if (x.eq.sy) then
c           if (y.lt.sy) angle(nint)= -1.0
c           if (y.gt.sy) angle(nint)= 1.0
c          endif
c          radius(nint)=111.1*sqrt((x-sx)**2*cos(0.5*(y+sy)*pi/180)**2
c     1     +(y-sy)**2)
c          radius(nint)=radius(nint)*angle(nint)
c        endif
c       enddo
c       call sort(radius,radsrt,nint)
cc       write(6,*)"radius,radsrt,nint",radius,radsrt,nint
c       if (inros.eq.1) then   
c         call posneg(radsrt,nint,npos,nneg)
c         if (npos.le.1) then 
c            elepos=log(d**2+radsrt(nint)**2)
c         else
c            elepos=0.
c            do j=1,npos
c              elepos=elepos+(-1)**(j+1)*log(d**2+radsrt(j+nneg)**2)
c            enddo
c         endif   
c         if (nneg.le.1) then 
c            eleneg=log(d**2+radsrt(1)**2)
c         else
c            eleneg=0.
c            do j=1,nneg
c              eleneg=eleneg+(-1)**(j+1)*log(d**2+radsrt(j)**2)
c            enddo
c         endif
c         elemnt(i)=0.5*(elepos+eleneg-2*log(d**2))
c       else
c         elemnt(i)=0.
c         if (nint.gt.0) then
c          do j=1,nint
c           elemnt(i)=elemnt(i)+(-1)**(j+1)*log(d**2+radsrt(j)**2)
c          enddo
c          elemnt(i)=abs(elemnt(i))
c         endif
c       endif
c      enddo
cc      write(6,*) "elemnt,ndiam",elemnt,ndiam
c      sumf0r=xmean(elemnt,ndiam)
c      sumf0r=sumf0r*a*(m-m0)+s*apoly
c      if (sumf0r.lt.0.)write(52,*)x,y,npoly,apoly,a,m,m0,d,s,
c     1 inros,ndiam,sumf0r
c      return
c      end

      function sumf0r(x,y,xpoly,ypoly,npoly,apoly,a,m,m0,d,s,
     1 inros,ndiam)
c integral of spatial density over region of surveillance
      implicit none
      real xmean
      real sumf0r,apoly
      integer inros,npoly,ndiam,i,j,onoff1,nint,npos,nneg
      real x,y,xpoly(100),ypoly(100),a,m,m0,d,s,pi,theta,theta0
      real a1,b1,c1,a2,b2,c2,x1,y1,sx,sy,angle(10),radius(10)
      real radsrt(10),delta,ydelta,xdelta,elemnt(10),elepos,eleneg
c      write(6,*)"sumf0r parms",
c     1 x,y,xpoly,ypoly,npoly,a,m,m0,d,s,inros,ndiam
      pi=3.14159
c find intersections of diameters with boundaries of region
c first find equations of diameters
      theta0=0.5*pi/ndiam
      do i=1,ndiam
       theta=i*pi/ndiam+theta0
c one point on the diameter
       delta=100.0
       ydelta=delta*sin(theta)
       xdelta=delta*cos(theta)
       x1=x+xdelta/(111.1*cos(y*pi/180))
       y1=y+ydelta/111.1
c       write(6,*)"x,y,x1,y1,theta,theta0,delta,xdelta,ydelta",
c     1 x,y,x1,y1,theta,theta0,delta,xdelta,ydelta
c equation of diameter
       call conlin(x,y,x1,y1,a1,b1,c1)
c       write(6,*)"a1,b1,c1",a1,b1,c1
c intersections of diameters with sides of polygon
       nint=0
       do j=1,npoly
        call conlin(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),a2,b2,c2)
        call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
c        write(6,*) "intsct",sx,sy
        call online(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),sx,sy,
     1  onoff1)
c        write(6,*) "online-parms", xpoly(j),ypoly(j),xpoly(j+1),
c     1   ypoly(j+1),sx,sy,onoff1
        if (onoff1.eq.1)then
           write(53,*)sx,sy
          nint=nint+1
c calculate angle and measure distance from x,y
          if (x.lt.sx) angle(nint)= -1.0
          if (x.gt.sx) angle(nint)= 1.0
          if (x.eq.sx) then
           if (y.lt.sy) angle(nint)= -1.0
           if (y.gt.sy) angle(nint)= 1.0
          endif
          radius(nint)=111.1*sqrt((x-sx)**2*cos(0.5*(y+sy)*pi/180)**2
     1     +(y-sy)**2)
          radius(nint)=radius(nint)*angle(nint)
        endif
       enddo
       if (nint.gt.0)then
       call sort(radius,radsrt,nint)
       if ((nint.eq.1).or.(nint.eq.3).or.(nint.eq.5)) write(54,*)
     1 "nint,j,x,y,xpoly,ypoly,inros",nint,x,y,(xpoly(j),ypoly(j),
     1 j=1,npoly),inros,npos,nneg
c       write(6,*)"radius,radsrt,nint",radius,radsrt,nint
       if (inros.eq.1) then   
         call posneg(radsrt,nint,npos,nneg)
         if (npos.lt.1) then 
c            elepos=log(d**2+radsrt(nint)**2)
            elepos=0.0
         else
            elepos=0.
            do j=1,npos
              elepos=elepos+(-1)**(j+1)*log(d**2+radsrt(nint+1-j)**2)
            enddo
            if ((npos.ne.2).and.(npos.ne.4))elepos=elepos-log(d**2)
         endif   
         if (nneg.lt.1) then
            eleneg=0.
c            eleneg=log(d**2+radsrt(1)**2)
         else
            eleneg=0.
            do j=1,nneg
              eleneg=eleneg+(-1)**(j+1)*log(d**2+radsrt(j)**2)
            enddo
            if ((nneg.ne.2).and.(nneg.ne.4))eleneg=eleneg-log(d**2)
         endif
         elemnt(i)=0.5*(elepos+eleneg)
c         elemnt(i)=abs(elemnt(i))
       else
         elemnt(i)=0.
         if (nint.gt.0) then
          do j=1,nint
           elemnt(i)=elemnt(i)+(-1)**(j+1)*log(d**2+radsrt(j)**2)
          enddo
          elemnt(i)=abs(elemnt(i))
         endif
       endif
c if nint=0
       else 
          elemnt(i)=0.0
       endif
      if (elemnt(i).lt.0.)write(52,*)"element(i)<0",i,x,y,npoly,
     1 apoly,a,m,m0,d,s,inros,ndiam,elemnt(i)
      enddo
c      write(6,*) "elemnt,ndiam",elemnt,ndiam
      sumf0r=xmean(elemnt,ndiam)
c      write(52,*)"xmean",sumf0r
      sumf0r=sumf0r*a*(m-m0)+s*apoly
      if (sumf0r.lt.0.)then
         write(52,*)x,y,npoly,apoly,a,m,m0,d,s,inros,ndiam,sumf0r
         write(52,*)(elemnt(i),i=1,ndiam)
      endif
      return
      end

       function plocin(x,y,sigma,xpoly,ypoly,npoly,inros,ndiam)
c probability circular normal with sd sigma, centred on x,y
c takes value inside region of surveillance
      implicit none
      real xmean
      real plocin,pnorml,sigma
      integer inros,npoly,ndiam,i,j,onoff1,nint,npos,nneg
      real x,y,xpoly(100),ypoly(100),pi,theta,theta0
      real a1,b1,c1,a2,b2,c2,x1,y1,sx,sy,angle(10),radius(10)
      real radsrt(10),delta,ydelta,xdelta,elemnt(10),elepos,eleneg
c      write(6,*)"sumf0r parms",
c     1 x,y,xpoly,ypoly,npoly,a,m,m0,d,s,inros,ndiam
      pi=3.14159
c find intersections of diameters with boundaries of region
c first find equations of diameters
      theta0=0.5*pi/ndiam
      do i=1,ndiam
       theta=i*pi/ndiam+theta0
c one point on the diameter
       delta=100.0
       ydelta=delta*sin(theta)
       xdelta=delta*cos(theta)
       x1=x+xdelta/(111.1*cos(y*pi/180))
       y1=y+ydelta/111.1
c       write(6,*)"x,y,x1,y1,theta,theta0,delta,xdelta,ydelta",
c     1 x,y,x1,y1,theta,theta0,delta,xdelta,ydelta
c equation of diameter
       call conlin(x,y,x1,y1,a1,b1,c1)
c       write(6,*)"a1,b1,c1",a1,b1,c1
c intersections of diameters with sides of polygon
       nint=0
       do j=1,npoly
        call conlin(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),a2,b2,c2)
        call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
c        write(6,*) "intsct",sx,sy
        call online(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),sx,sy,
     1  onoff1)
c        write(6,*) "online-parms", xpoly(j),ypoly(j),xpoly(j+1),
c     1   ypoly(j+1),sx,sy,onoff1
        if (onoff1.eq.1)then
          nint=nint+1
c calculate angle and measure distance from x,y
          if (x.lt.sx) angle(nint)= -1.0
          if (x.gt.sx) angle(nint)= 1.0
          if (x.eq.sy) then
           if (y.lt.sy) angle(nint)= -1.0
           if (y.gt.sy) angle(nint)= 1.0
          endif
          radius(nint)=111.1*sqrt((x-sx)**2*cos(0.5*(y+sy)*pi/180)**2
     1     +(y-sy)**2)
          radius(nint)=radius(nint)*angle(nint)
        endif
       enddo
       call sort(radius,radsrt,nint)
c       write(6,*)"radius,radsrt,nint",radius,radsrt,nint
       if (inros.eq.1) then   
         call posneg(radsrt,nint,npos,nneg)
         if (npos.le.1) then 
            elepos=pnorml(abs(radsrt(nint)),0.,sigma)-0.5
         else
            elepos=0.
            do j=1,npos
              elepos=elepos+(-1)**(j+1)*
     1        (pnorml(abs(radsrt(j+nneg)),0.,sigma)-0.5)
            enddo
         endif   
         if (nneg.le.1) then 
            eleneg=pnorml(abs(radsrt(1)),0.,sigma)-0.5
         else
            eleneg=0.
            do j=1,nneg
              eleneg=eleneg+(-1)**(j+1)*
     1        (pnorml(abs(radsrt(j)),0.,sigma)-0.5)
            enddo
         endif
         elemnt(i)=(elepos+eleneg)
       else
         elemnt(i)=0.
         if (nint.gt.0) then
          do j=1,nint
           elemnt(i)=elemnt(i)+(-1)**(j+1)*
     1     pnorml(abs(radsrt(j)),0.,sigma)
          enddo
          elemnt(i)=abs(elemnt(i))
         endif
       endif
      enddo
c      write(6,*) "elemnt,ndiam",elemnt,ndiam
      plocin=xmean(elemnt,ndiam)
      return
      end

      real function plo2in(x,y,jd,jq,xpoly,ypoly,npoly,inros,ndiam)
c probability circular dn a la Rodolfo param d,q, centred on x,y
c takes value inside region of surveillance
      implicit none
      real*4 xmean,jd,jq
      real*4 prodol
      integer inros,npoly,ndiam,i,j,onoff1,nint,npos,nneg
      real*4 x,y,xpoly(100),ypoly(100),pi,theta,theta0
      real*4 a1,b1,c1,a2,b2,c2,x1,y1,sx,sy,angle(10),radius(10)
      real*4 radsrt(10),delta,ydelta,xdelta,elemnt(10),elepos,eleneg
c      write(6,*)"sumf0r parms",
c     1 x,y,xpoly,ypoly,npoly,a,m,m0,d,s,inros,ndiam
      pi=3.14159
c find intersections of diameters with boundaries of region
c first find equations of diameters
      theta0=0.5*pi/ndiam
      do i=1,ndiam
       theta=i*pi/ndiam+theta0
c one point on the diameter
       delta=100.0
       ydelta=delta*sin(theta)
       xdelta=delta*cos(theta)
       x1=x+xdelta/(111.1*cos(y*pi/180))
       y1=y+ydelta/111.1
c       write(6,*)"x,y,x1,y1,theta,theta0,delta,xdelta,ydelta",
c     1 x,y,x1,y1,theta,theta0,delta,xdelta,ydelta
c equation of diameter
       call conlin(x,y,x1,y1,a1,b1,c1)
c       write(6,*)"a1,b1,c1",a1,b1,c1
c intersections of diameters with sides of polygon
       nint=0
       do j=1,npoly
        call conlin(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),a2,b2,c2)
        call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
c        write(6,*) "intsct",sx,sy
        call online(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),sx,sy,
     1  onoff1)
c        write(6,*) "online-parms", xpoly(j),ypoly(j),xpoly(j+1),
c     1   ypoly(j+1),sx,sy,onoff1
        if (onoff1.eq.1)then
          nint=nint+1
c calculate angle and measure distance from x,y
          if (x.lt.sx) angle(nint)= -1.0
          if (x.gt.sx) angle(nint)= 1.0
          if (x.eq.sy) then
           if (y.lt.sy) angle(nint)= -1.0
           if (y.gt.sy) angle(nint)= 1.0
          endif
          radius(nint)=111.1*sqrt((x-sx)**2*cos(0.5*(y+sy)*pi/180)**2
     1     +(y-sy)**2)
          radius(nint)=radius(nint)*angle(nint)
        endif
       enddo
       call sort(radius,radsrt,nint)
c       write(6,*)"radius,radsrt,nint",radius,radsrt,nint
       if (inros.eq.1) then   
         call posneg(radsrt,nint,npos,nneg)
         if(npos.le.1)then  
            elepos=0.5*prodol(abs(radsrt(nint)),jd,jq)     
         else
            elepos=0.
            do j=1,npos
              elepos=elepos+(-1)**(j+1)*
c###prodol     1        (pnorm(abs(radsrt(j+nneg)),0.,sigma)-0.5)
     1        (0.5*prodol(abs(radsrt(j+nneg)),jd,jq))     
            enddo
         endif   
         if (nneg.le.1) then 
c###prodol            eleneg=pnorm(abs(radsrt(1)),0.,sigma)-0.5
            eleneg=(0.5*prodol(abs(radsrt(1)),jd,jq))
         else
            eleneg=0.
            do j=1,nneg
              eleneg=eleneg+(-1)**(j+1)*
c###prodol     1        (pnorm(abs(radsrt(j)),0.,sigma)-0.5)
     1        (0.5*prodol(abs(radsrt(j)),jd,jq))     
            enddo
         endif
         elemnt(i)=(elepos+eleneg)
       else
         elemnt(i)=0.
         if (nint.gt.0) then
          do j=1,nint
           elemnt(i)=elemnt(i)+(-1)**(j+1)*
c##prodol     1     pnorm(abs(radsrt(j)),0.,sigma)
     1     (0.5*(prodol(abs(radsrt(j)),jd,jq)+1.0))       
          enddo
          elemnt(i)=abs(elemnt(i))
         endif
       endif
      enddo
c      write(6,*) "elemnt,ndiam",elemnt,ndiam
      plo2in=xmean(elemnt,ndiam)
      return
      end


       real function prodol(r,jd,jq)
c probability rodolfo's power law distribution has radius less than r
       implicit none
       real r,jd,jq
       prodol=1.0-jd**(2*(jq-1))/(jd**2+r**2)**(jq-1)
       return
       end



      function areain(x,y,xpoly,ypoly,npoly,ndiam)
c area inside region (with npoly vertices) defined by xpoly,ypoly
c x,y is point inside region
c ndiam = no of diameters thru x,y used for approximation
      implicit none
      real xmean
      real areain
      integer npoly,ndiam,i,j,onoff1,nint,npos,nneg
      real x,y,xpoly(100),ypoly(100),pi,theta,theta0
      real a1,b1,c1,a2,b2,c2,x1,y1,sx,sy,angle(10),radius(10)
      real radsrt(10),delta,ydelta,xdelta,elemnt(500),elepos,eleneg
c      write(6,*)"sumf0r parms",
c     1 x,y,xpoly,ypoly,npoly,a,m,m0,d,s,inros,ndiam
      pi=3.14159
c find intersections of diameters with boundaries of region
c first find equations of diameters
      theta0=0.5*pi/ndiam
      do i=1,ndiam
       theta=i*pi/ndiam+theta0
c one point on the diameter
       delta=100.0
       ydelta=delta*sin(theta)
       xdelta=delta*cos(theta)
       x1=x+xdelta/(111.1*cos(y*pi/180))
       y1=y+ydelta/111.1
c       write(6,*)"x,y,x1,y1,theta,theta0,delta,xdelta,ydelta",
c     1 x,y,x1,y1,theta,theta0,delta,xdelta,ydelta
c equation of diameter
       call conlin(x,y,x1,y1,a1,b1,c1)
c       write(6,*)"a1,b1,c1",a1,b1,c1
c intersections of diameters with sides of polygon
       nint=0
       do j=1,npoly
        call conlin(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),a2,b2,c2)
        call intsct(a1,b1,c1,a2,b2,c2,sx,sy)
c        write(6,*) "intsct",sx,sy
        call online(xpoly(j),ypoly(j),xpoly(j+1),ypoly(j+1),sx,sy,
     1  onoff1)
c        write(6,*) "online-parms", xpoly(j),ypoly(j),xpoly(j+1),
c     1   ypoly(j+1),sx,sy,onoff1
        if (onoff1.eq.1)then
          nint=nint+1
c calculate angle and measure distance from x,y
          if (x.lt.sx) angle(nint)= -1.0
          if (x.gt.sx) angle(nint)= 1.0
          if (x.eq.sy) then
           if (y.lt.sy) angle(nint)= -1.0
           if (y.gt.sy) angle(nint)= 1.0
          endif
          radius(nint)=111.1*sqrt((x-sx)**2*cos(0.5*(y+sy)*pi/180)**2
     1     +(y-sy)**2)
          radius(nint)=radius(nint)*angle(nint)
        endif
       enddo
       call sort(radius,radsrt,nint)
c       write(6,*)"radius,radsrt,nint",radius,radsrt,nint
         call posneg(radsrt,nint,npos,nneg)
         if (npos.le.1) then 
            elepos=radsrt(nint)**2
         else
            elepos=0.
            do j=1,npos
              elepos=elepos+(-1)**(j+1)*radsrt(j+nneg)**2
            enddo
         endif   
         if (nneg.le.1) then 
            eleneg=radsrt(1)**2
         else
            eleneg=0.
            do j=1,nneg
              eleneg=eleneg+(-1)**(j+1)*radsrt(j)**2
            enddo
         endif
         elemnt(i)=0.5*(elepos+eleneg)
      enddo
c      write(6,*) "elemnt,ndiam",elemnt,ndiam
      areain=xmean(elemnt,ndiam)*pi
      return
      end


      subroutine sort(x,y,n)
c sorts the first n elements of x into ascending order and stores in y
      implicit none
      real x(10),y(10)
      integer i,j,n,order(10)
      do i=1,10
        y(i)=0.0
      enddo
      if (n.gt.0) then
       do i=1,n
         order(i)=0
         do j=1,n
            if((x(i).gt.x(j)).or.((x(i).eq.x(j)).and.(i.ge.j))) 
     1       order(i)=order(i)+1
         enddo
         y(order(i))=x(i)
       enddo
      endif
c      write(53,*)"sort",(y(i),i=1,n)
      return
      end

      subroutine posneg(x,n,npos,nneg)
      implicit none
      real x(10)
      integer n,npos,nneg,i
      npos=0
      nneg=0
      do i=1,n
         if(x(i).lt.0)nneg=nneg+1
         if(x(i).gt.0)npos=npos+1
      enddo
      return
      end
      
      real function xmean(x,n)
      implicit none
c mean of first n elements of x
      real x(500),y
      integer n,i
      y=0.
      do i=1,n
         y=y+x(i)
      enddo
      xmean=y/n
      return
      end

      subroutine smwsel(n1,n2,time,lat,long,mag,w,at,bt,siga,sigu,
     1 difmag,sumwts)
      implicit none
      real time(90000),lat(90000),long(90000),mag(90000),w(90000)
      real at,bt,siga,sigu,difmag,sumwts(90000),s,tdiff,dist,distkm
      integer i,j,n1,n2,imax
      do i=1,n2
         s=0.0
         imax=max(n1,i)
         do j=1,imax
            tdiff=abs(time(i)-time(j))
            dist=distkm(lat(i),long(i),lat(j),long(j))
            if(dist.gt.siga*10**(mag(i)/4.))go to 199
c            if (mag(i).lt.mag(j)) go to 199
            if (abs(mag(i)-mag(j)).gt.difmag)go to 199
            if (tdiff.gt.0.5*10**(at+bt*mag(i)))go to 199
            if((tdiff.lt.5.0).and.(dist.lt.
     1       (1.5*sigu*10**(mag(i)/2.))))go to 199
            s=s+w(j)
 199        continue
         enddo
         if (s.ge.1) then
          do j=1,imax
            tdiff=abs(time(i)-time(j))
            dist=distkm(lat(i),long(i),lat(j),long(j))
            if(dist.gt.siga*10**(mag(i)/4.))go to 299
c            if (mag(i).lt.mag(j)) go to 299
            if (abs(mag(i)-mag(j)).gt.difmag)go to 299
            if (tdiff.gt.0.5*10**(at+bt*mag(i)))go to 299
            if((tdiff.lt.5.0).and.(dist.lt.
     1       (1.5*sigu*10**(mag(i)/2.))))s=s+w(j)
            s=s+w(j)
 299        continue
          enddo
          endif
         sumwts(i)=s
      enddo
      return
      end


      subroutine ceta1(n,b,bm,mag,eta1,extraf)
      implicit none
      integer n,i
      real b,bm,mag(90000),eta1(90000),extraf
      do i=1,n
        eta1(i)=extraf*bm*10**(-b*(bm-1.)*mag(i))
      enddo
      return
      end

      subroutine ceta(eta1,n,b,am,sigm,mu,wbar,eta)
      implicit none
      integer n,i
      real eta(90000),eta1(90000),b,am,sigm,mu,wbar
      do i=1,n
        eta(i)=eta1(i)*(1-mu)*10**(-b*(am+b*log(10.)*sigm**2/2))
     1/wbar
      enddo
      return
      end

      subroutine ceta3o(n,b,am,sigm,delgm2,mu,wbar,balpha,eta)
      implicit none
      integer n,i
      real b,am,sigm,mu,wbar,beta,delgm2,eta3,eta(90000)
      real balpha,alpha
      if (balpha.eq.b)then
         write(6,*)"ceta3 error balpha=b, exiting"
      endif
      beta=b*log(10.)
      alpha=balpha*log(10.)
      eta3=((1-mu)/wbar)*exp(-beta*
     1(am+beta*sigm**2/2))/
     1(1+alpha*exp(-beta*(alpha*am+beta**2*sigm**2/2+
     1(beta-alpha)**2/2))/
     1((1+sigm**2*(beta-alpha)*wbar)))
      do i=1,n
         eta(i)=eta3
      enddo
      return
      end

      subroutine ceta3(n,b,am,sigm,delgm2,zeta,mu,wbar,balpha,eta)
      implicit none
      integer n,i
      real b,am,sigm,mu,wbar,beta,delgm2,eta3,eta(90000)
      real balpha,alpha,zeta
      if (balpha.ge.b)then
         write(6,*)"ceta3 error balpha>=b, exiting"
      endif
      beta=b*log(10.)
      alpha=balpha*log(10.)
      eta3=((1.-mu)/wbar)*exp(-beta*(am+beta*sigm**2/2.))/
     1(1.+(alpha/(beta-alpha))*exp(-alpha*delgm2+(alpha-beta)*zeta+
     1sigm**2*alpha*(alpha-2.*beta)/2.))
      do i=1,n
         eta(i)=eta3
      enddo
      return
      end



      subroutine cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1lat,long,time,mag,w,evson,minmag,inout,b,mag0)
      implicit none
      integer n1,n2,i,inout(2,90000)
      real am,bm,sigm,at,bt,sigt,siga,minmag,evison,ba
      real lat(90000),long(90000),evson(90000),w(90000)
      real time(90000),mag(90000),eta(90000),b,mag0
      do i=n1,n2
       if ((mag(i).ge.minmag).and.(inout(1,i).eq.1).and.
     1(inout(2,i).eq.1)) then  
       evson(i)=evison(i,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1 lat,long,mag,time,w,b,mag0)
       if (evson(i).le.0)write(6,*)"Warning: evson(",i,")",
     1 "=",evson(i)
c       write(15,*)"cevres",i,mag(i),time(i),eta(i),evson(i)
       else
          evson(i)=0.0
       endif
      enddo
      return
      end

      subroutine cevre2(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1lat,long,time,mag,w,evson,minmag,inout,b,mag0,delgm2,zeta,
     1balpha)
      implicit none
      integer n1,n2,i,inout(2,90000)
      real am,bm,sigm,at,bt,sigt,siga,minmag,eviso2,ba,balpha
      real lat(90000),long(90000),evson(90000),w(90000)
      real time(90000),mag(90000),eta(90000),b,mag0,delgm2,zeta
c      write(6,*)"entering cevre2",n1,n2,eta(n2),am,bm,sigm,at,bt,
c     1 sigt,ba,siga,delgm2,balpha
      do i=n1,n2
c         write(6,*)"doing i=",i
       if ((mag(i).ge.minmag).and.(inout(1,i).eq.1).and.
     1(inout(2,i).eq.1)) then  
       evson(i)=eviso2(i,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1 lat,long,mag,time,w,b,mag0,delgm2,zeta,balpha)
       if (evson(i).le.0)write(6,*)"Warning cevre2: evson(",i,")",
     1 "=",evson(i)
c       write(15,*)"cevre2",i,mag(i),time(i),eta(i),balpha,
c     1 evson(i)
       else
          evson(i)=0.0
       endif
      enddo
      return
      end

      real function eviso2(i,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1lat,long,mag,time,w,b,mag0,delgm2,zeta,balpha)
      implicit none
      integer i,j
      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
      real s,eta(90000),am,bm,sigm,at,bt,sigt,siga,ba,limupp,s2
      real b,mag0,div,f1t,g1m3,h1x,pnorm,delgm2,balpha,zeta
c      write(6,*)"Entering eviso2 i=",i
      s=0.
      s2=0.
      do j=1,i-1
c         write(6,*)"eviso2 j=",j
       s=s+eta(j)*w(j)*f1t(time(i),time(j),mag(j),at,bt,sigt)*
     1 g1m3(mag(i),mag(j),am,bm,sigm,b,balpha,delgm2,zeta)*
     1 h1x(lat(i),long(i),lat(j),long(j),mag(j),siga,ba)
      enddo
      limupp=(mag(i)-am-bm*mag0-sigm**2*b*log(10.))/sigm
      div=pnorm(limupp,0.0,1.0)
      if(div.lt.0.01)div=0.01
      eviso2=s/div
c      write(15,*)"eviso2",i,mag(i),s,div,limupp
      return
      end

      real function evtmx2(t,m,ylat,xlong,eta,am,bm,sigm,at,bt,
     1sigt,ba,siga,lat,long,mag,time,w,b,mag0,delgm2,zeta,balpha)
      implicit none
      integer j
      real lat(90000),long(90000),mag(90000),time(90000),w(90000)
      real s,evmu,am,bm,sigm,at,bt,sigt,siga,t,m
      real ylat,xlong,eta(90000),ba,b,mag0,div,delgm2,balpha,g1m3
      real f1t,h1x,pnorml,limupp,zeta
      s=0.
      j=0
 100  j=j+1
c      write(6,*)"evtmx2 flag j",j
       if((time(j).ge.t).or.(time(j).eq.0))go to 99
       s=s+eta(j)*w(j)*f1t(t,time(j),mag(j),at,bt,sigt)*
     1 g1m3(m,mag(j),am,bm,sigm,b,balpha,delgm2,zeta)*
     1 h1x(ylat,xlong,lat(j), long(j),mag(j),siga,ba)
      go to 100
 99   continue
      limupp=(m-am-bm*mag0-sigm**2*b*log(10.))/sigm
      div=pnorml(limupp,0.0,1.0)
      if(div.lt.0.01)div=0.01
      evtmx2=s/div
      write(19,*)'t,m,ylat,xlong,evmu,evtmx2'
      write(19,*)t,m,ylat,xlong,evmu,evtmx2
      return
      end




      SUBROUTINE amoeba(p,y,mp,np,ndim,ftol,funk,iter)
      INTEGER iter,mp,ndim,np,NMAX,ITMAX
      REAL ftol,p(mp,np),y(mp),funk
      PARAMETER (NMAX=20,ITMAX=1000)
      EXTERNAL funk
CU    USES amotry,funk
      INTEGER i,ihi,ilo,inhi,j,m,n
      REAL rtol,sum,swap,ysave,ytry,psum(NMAX),amotry
      iter=0
1     do 12 n=1,ndim
        sum=0.
        do 11 m=1,ndim+1
          sum=sum+p(m,n)
11      continue
        psum(n)=sum
12    continue
2     ilo=1
      if (y(1).gt.y(2)) then
        ihi=1
        inhi=2
      else
        ihi=2
        inhi=1
      endif
      do 13 i=1,ndim+1
        if(y(i).le.y(ilo)) ilo=i
        if(y(i).gt.y(ihi)) then
          inhi=ihi
          ihi=i
        else if(y(i).gt.y(inhi)) then
          if(i.ne.ihi) inhi=i
        endif
13    continue
      rtol=2.*abs(y(ihi)-y(ilo))/(abs(y(ihi))+abs(y(ilo)))
      if (rtol.lt.ftol) then
        swap=y(1)
        y(1)=y(ilo)
        y(ilo)=swap
        do 14 n=1,ndim
          swap=p(1,n)
          p(1,n)=p(ilo,n)
          p(ilo,n)=swap
14      continue
        return
      endif
      if (iter.ge.ITMAX) pause 'ITMAX exceeded in amoeba'
      iter=iter+2
      ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,-1.0)
      if (ytry.le.y(ilo)) then
        ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,2.0)
      else if (ytry.ge.y(inhi)) then
        ysave=y(ihi)
        ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,0.5)
        if (ytry.ge.ysave) then
          do 16 i=1,ndim+1
            if(i.ne.ilo)then
              do 15 j=1,ndim
                psum(j)=0.5*(p(i,j)+p(ilo,j))
                p(i,j)=psum(j)
15            continue
              y(i)=funk(psum)
            endif
16        continue
          iter=iter+ndim
          goto 1
        endif
      else
        iter=iter-1
      endif
      goto 2
      END
C  (C) Copr. 1986-92 Numerical Recipes Software K'VIkanW-1,1'9.

      SUBROUTINE amoeb2(p,y,mp,np,ndim,ftol,funk,iter)
      INTEGER iter,mp,ndim,np,NMAX,ITMAX
      REAL ftol,p(mp,np),y(mp),funk
      PARAMETER (NMAX=20,ITMAX=1000)
      EXTERNAL funk
CU    USES amotr2,funk
      INTEGER i,ihi,ilo,inhi,j,m,n
      REAL rtol,sum,swap,ysave,ytry,psum(NMAX),amotr2
c      write(6,*)"amoeb2 flag 0",ndim
      iter=0
1     do 12 n=1,ndim
c      write(6,*)"amoeb2 flag 01",n,ndim,mp,np
        sum=0.
        do 11 m=1,ndim+1
          sum=sum+p(m,n)
c      write(6,*)"amoeb2 flag 02",m,n,ndim
11      continue
c      write(6,*)"amoeb2 flag 03"
        psum(n)=sum
c      write(6,*)"amoeb2 flag 04"
12    continue
c      write(6,*)"amoeb2 flag 05"
2     ilo=1
      if (y(1).gt.y(2)) then
        ihi=1
        inhi=2
      else
        ihi=2
        inhi=1
      endif
c      write(6,*)"amoeb2 flag 06"
      do 13 i=1,ndim+1
c      write(6,*)"amoeb2 flag 07a"
        if(y(i).le.y(ilo)) ilo=i
        if(y(i).gt.y(ihi)) then
          inhi=ihi
          ihi=i
c      write(6,*)"amoeb2 flag 07b"
        else if(y(i).gt.y(inhi)) then
          if(i.ne.ihi) inhi=i
c      write(6,*)"amoeb2 flag 07c"
        endif
13    continue
c      write(6,*)"amoeb2 flag 08"
      rtol=2.*abs(y(ihi)-y(ilo))/(abs(y(ihi))+abs(y(ilo)))
c      write(6,*)"amoeb2 flag 09"
      if (rtol.lt.ftol) then
        swap=y(1)
        y(1)=y(ilo)
        y(ilo)=swap
        do 14 n=1,ndim
          swap=p(1,n)
          p(1,n)=p(ilo,n)
          p(ilo,n)=swap
14      continue
        return
      endif
c      write(6,*)"amoeb2, flag1"
      if (iter.ge.ITMAX) pause 'ITMAX exceeded in amoeba'
      iter=iter+2
c      write(6,*)"amoeb2, flag2"
      ytry=amotr2(p,y,psum,mp,np,ndim,funk,ihi,-1.0)
c      write(6,*)"amoeb2, flag3"
      if (ytry.le.y(ilo)) then
c      write(6,*)"amoeb2, flag4"
        ytry=amotr2(p,y,psum,mp,np,ndim,funk,ihi,2.0)
c      write(6,*)"amoeb2, flag5"
      else if (ytry.ge.y(inhi)) then
        ysave=y(ihi)
c      write(6,*)"amoeb2, flag6"
        ytry=amotr2(p,y,psum,mp,np,ndim,funk,ihi,0.5)
c      write(6,*)"amoeb2, flag7"
        if (ytry.ge.ysave) then
          do 16 i=1,ndim+1
            if(i.ne.ilo)then
              do 15 j=1,ndim
                psum(j)=0.5*(p(i,j)+p(ilo,j))
                p(i,j)=psum(j)
15            continue
              y(i)=funk(psum)
            endif
16        continue
          iter=iter+ndim
          goto 1
        endif
      else
        iter=iter-1
      endif
      goto 2
      END
C  (C) Copr. 1986-92 Numerical Recipes Software K'VIkanW-1,1'9.

      FUNCTION amotry(p,y,psum,mp,np,ndim,funk,ihi,fac)
      INTEGER ihi,mp,ndim,np,NMAX
      REAL amotry,fac,p(mp,np),psum(np),y(mp),funk
      PARAMETER (NMAX=20)
      EXTERNAL funk
CU    USES funk
      INTEGER j
      REAL fac1,fac2,ytry,ptry(NMAX)
      fac1=(1.-fac)/ndim
      fac2=fac1-fac
      do 11 j=1,ndim
        ptry(j)=psum(j)*fac1-p(ihi,j)*fac2
11    continue
      ytry=funk(ptry)
      if (ytry.lt.y(ihi)) then
        y(ihi)=ytry
        do 12 j=1,ndim
          psum(j)=psum(j)-p(ihi,j)+ptry(j)
          p(ihi,j)=ptry(j)
12      continue
      endif
      amotry=ytry
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software K'VIkanW-1,1'9.

      FUNCTION amotr2(p,y,psum,mp,np,ndim,funk,ihi,fac)
      INTEGER ihi,mp,ndim,np,NMAX
      REAL amotr2,fac,p(mp,np),psum(np),y(mp),funk
      PARAMETER (NMAX=20)
      EXTERNAL funk
CU    USES funk
      INTEGER j
      REAL fac1,fac2,ytry,ptry(NMAX)
c      write(6,*)"amotr2, flag1"
      fac1=(1.-fac)/ndim
      fac2=fac1-fac
      do 11 j=1,ndim
        ptry(j)=psum(j)*fac1-p(ihi,j)*fac2
11    continue
c      write(6,*)"amotr2, flag2"
      ytry=funk(ptry)
c      write(6,*)"amotr2, flag3"
      if (ytry.lt.y(ihi)) then
        y(ihi)=ytry
        do 12 j=1,ndim
          psum(j)=psum(j)-p(ihi,j)+ptry(j)
          p(ihi,j)=ptry(j)
12      continue
      endif
      amotr2=ytry
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software K'VIkanW-1,1'9.

      real function lleep(ptry)
      implicit none
      integer ss,i,n,n1,n2,inout,npoly,np,pnum
      real ptry(6),am,sigm,at,sigt,siga,mueep,t1,t2
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,param
      real xpoly,ypoly,evson(90000),pmin,prange
      real lat,long,minmag,area,kappa,beepas,kjmu
      real bckgrd,wbar,eta1,eta(90000),delay,zeta
      real ll0,ll1,ll2,ll3,ocll,omor,apoly,maxmag
      real oclogl,totll1,eta0(90000),mag0,magi,delgm2,balpha
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
c      write(6,*)"entering lleep"
      data eta0/90000*0.0/
c      write(6,*)"lleep flag1"
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c      write(6,*)"lleep flag2"
c now reset eepas parameters
      am=param(8)
      bm=param(9)
      sigm=param(10)
      at=param(11)
      bt=param(12)
      sigt=param(13)
      ba=param(14)
      siga=param(15)
      mueep=param(16)
      call ceta(eta1,n,beepas,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lleep got through cevres"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"lleep passed nocll",ll0,ll1,ll2,ll3
c      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
c     1ss,mag,minmag,inout)
c      write(6,*)"lleep ocllkj=",ocllkj
      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
     1       0.,0.,1.,mueep,ss,mag,minmag,inout)
      totll1=oclogl-mueep*ll3-ll1
      write(6,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(6,*)"lleep oclogl totll=",oclogl,totll1
      write(19,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(19,*)"lleep oclogl totll=",oclogl,totll1
      lleep=-totll1
c      lleep=-oclogl
      return
      end

      real function llstpe(ptry)
c     step-eepas likelihood
      implicit none
      integer ss,i,n,n1,n2,inout,npoly,np,pnum
      real ptry(6),am,sigm,at,sigt,siga,mueep,t1,t2
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,param,stmu,step
      real xpoly,ypoly,evson(90000),pmin,prange
      real lat,long,minmag,area,kappa,beepas,kjmu
      real bckgrd,wbar,eta1,eta(90000),delay,zeta,enumeq
      real ll0,ll1,ll2,ll3,ocllst,omor,apoly,maxmag
      real oclogl,totll1,eta0(90000),mag0,magi,delgm2,balpha
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blocki/stmu,step(90000)
c      write(6,*)"entering lleep"
      data eta0/90000*0.0/
c      write(6,*)"lleep flag1"
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c      write(6,*)"lleep flag2"
c now reset eepas parameters
      am=param(8)
      bm=param(9)
      sigm=param(10)
      at=param(11)
      bt=param(12)
      sigt=param(13)
      ba=param(14)
      siga=param(15)
      mueep=param(16)
      stmu=param(28)
      write(6,*)"stmu=",stmu
      call ceta(eta1,n,beepas,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lleep got through cevres"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"lleep passed nocll",ll0,ll1,ll2,ll3
c      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
c     1ss,mag,minmag,inout)
c      write(6,*)"lleep ocllkj=",ocllkj
      oclogl=ocllst(n1,n2,bckgrd,omor,evson,bgdkj,step,
     1       0.,0.,(1.-stmu),((1.-stmu)*mueep),stmu,ss,mag,minmag,
     1       inout)
      enumeq=mueep*(1.-stmu)*ll3+(1.-stmu)*ll1+stmu*ll0
      write(6,*)"enumeq=",enumeq
      totll1=oclogl-enumeq
      write(6,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(6,*)"lleep oclogl totll=",oclogl,totll1
      write(19,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(19,*)"lleep oclogl totll=",oclogl,totll1
      llstpe=-totll1
      return
      end


      real function lstpe2(ptry)
c     step-eepas likelihood, full weight to step, (1-stmu) to eepas
      implicit none
      integer ss,i,n,n1,n2,inout,npoly,np,pnum
      real ptry(6),am,sigm,at,sigt,siga,mueep,t1,t2
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,param,stmu,step
      real xpoly,ypoly,evson(90000),pmin,prange
      real lat,long,minmag,area,kappa,beepas,kjmu
      real bckgrd,wbar,eta1,eta(90000),delay,zeta,enumeq
      real ll0,ll1,ll2,ll3,ocllst,omor,apoly,maxmag
      real oclogl,totll1,eta0(90000),mag0,magi,delgm2,balpha
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blocki/stmu,step(90000)
c      write(6,*)"entering lleep"
      data eta0/90000*0.0/
c      write(6,*)"lleep flag1"
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c      write(6,*)"lleep flag2"
c now reset eepas parameters
      am=param(8)
      bm=param(9)
      sigm=param(10)
      at=param(11)
      bt=param(12)
      sigt=param(13)
      ba=param(14)
      siga=param(15)
      mueep=param(16)
      stmu=param(28)
      write(6,*)"stmu=",stmu
      call ceta(eta1,n,beepas,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lleep got through cevres"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"lleep passed nocll",ll0,ll1,ll2,ll3
c      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
c     1ss,mag,minmag,inout)
c      write(6,*)"lleep ocllkj=",ocllkj
      oclogl=ocllst(n1,n2,bckgrd,omor,evson,bgdkj,step,
     1       0.,0.,(1.-stmu),((1.-stmu)*mueep),1.0,ss,mag,minmag,
     1       inout)
      enumeq=mueep*(1.-stmu)*ll3+(1.-stmu)*ll1+ll0/2.0
      write(6,*)"enumeq=",enumeq
      totll1=oclogl-enumeq
      write(6,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(6,*)"lleep oclogl totll=",oclogl,totll1
      write(19,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep
      write(19,*)"lleep oclogl totll=",oclogl,totll1
      lstpe2=-totll1
      return
      end



      real function lleep2(ptry)
      implicit none
      integer i,n,n1,n2,inout,npoly,np,pnum,ss
      real ptry(8),am,sigm,at,sigt,siga,mueep,delgm2
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,balpha
      real xpoly,ypoly,evson(90000),maxmag
      real lat,long,minmag,area,kappa,t1,t2
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ocll,omor,beepas,kjmu
      real oclogl,totll1,eta0(90000),mag0,magi,apoly
      real param,pmin,prange,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
c      write(6,*)"entering lleep2"
c      write(6,*)"lleep2,a,d,s=",a,d,s
      data eta0/90000*0.0/
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c now reset eepas parameters
      am=param(8)
      bm=param(9)
      sigm=param(10)
      at=param(11)
      bt=param(12)
      sigt=param(13)
      ba=param(14)
      siga=param(15)
      mueep=param(16)
      balpha=param(25)
      delgm2=param(26)
      zeta=param(27)
c      write(6,*)"lleep2 parameters",am,bm,sigm,at,bt,sigt,ba,siga,
c     1      mueep,balpha,delgm2,zeta,np,n,(pnum(i),i=1,np)
      call ceta3(n,beepas,am,sigm,delgm2,zeta,mueep,wbar,
     1balpha,eta)
c       call ceta3(n,beepas,am,sigm,delgm2,zeta,mu,wbar,balpha,eta)
c      write(6,*)"got through ceta"
c      write(14,*)"beepas,balpha,ptry delgm2 eta",beepas,balpha,ptry,
c     1 delgm2,eta(1)
      write(6,*)"beepas balpha ptry delgm2 eta",beepas,balpha,ptry,
     1 delgm2,eta(1)
c      write(6,*)"n1 n2",n1,n2
      call cevre2(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,beepas,mag0,delgm2,
     1  zeta,balpha)
c      call cevre2(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
c     1  lat,long,time,mag,w,evson,minmag,inout,beepas,mag0,
c     1  delgm2,zeta,balpha)
c      write(6,*)"flag1 n1 n2",n1,n2
c      call no2clt(t1,t2,w,time,mag,inout,lat,long,bt,
c     1  bm,ba,sigu,b,balpha,c,p,ss,n5pd,area,1.0,kappa,eta,delgm2,
c     1  zeta,minmag,delay,f0rsum,xpoly,ypoly,npoly,ncat,
c     1 ll0,ll1,ll2,ll3)
c      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
c     1ss,mag,minmag,inout)
c      totll3=ocllkj-ll3
c      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
c     1ss,mag,minmag,inout)
c      totll0=oclsup-ll0
c      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
c    1       0.,0.,1.,mueep,ss,mag,minmag,inout)
c      totll1=oclogl-mueep*ll3-ll1

c      write(6,*)"lleep2 got through cevre2"
c      call no2cll(n1,n2,w,time,mag,inout,lat,long,bt,
c     1  bm,ba,sigu,beepas,balpha,c,p,ss,n5pd,area,1.0,kappa,eta,
c     1  delgm2,zeta,
c     1  minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,ll3)
      call no2clt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,beepas,balpha,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  delgm2,zeta,
     1  minmag,delay,f0rsum,xpoly,ypoly,npoly,n,ll0,ll1,ll2,ll3)
      write(6,*)"lleep2 passed no2clt",ll0,ll1,ll2,ll3
c      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
c     1ss,mag,minmag,inout)
c      write(6,*)"lleep ocllkj=",ocllkj
      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
     1       0.,0.,1.,mueep,ss,mag,minmag,inout)
      totll1=oclogl-mueep*ll3-ll1
      write(6,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep,delgm2,zeta,
     1eta(1)
      write(6,*)"lleep oclogl totll=",oclogl,totll1
      write(19,*) am,bm,sigm,at,bt,sigt,siga,ba,mueep,delgm2,zeta,
     1eta(1)
      write(19,*)"lleep oclogl totll=",oclogl,totll1
      lleep2=-totll1
      return
      end

      real function lljans(ptry)
c janus with bivariate normal spatial distribution for etas
      implicit none
      integer i,n,n1,n2,inout,npoly,ss,np,pnum,vjanus
      real param,pmin,prange,delgm2,balpha,beepas,zeta,t1,t2,apoly
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jsig,jb
      real xpoly,ypoly,evson(90000),jomor,jocll
      real lat,long,minmag,area,kappa,jd,jq
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ll4,omor
      real oclogl,totll1,mag0,magi,maxmag
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)

c      write(6,*)"entering lljans"
      write(6,*)"lljans,a,d,s=",a,d,s
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c now reset as parameters
      jkappa=param(29)
      jp=param(30)
      jc=param(31)
      jsig=param(32)
      jmu=param(33)
c      jd=param(34)
c      jq=param(35)
      jb=param(36)
      kjmu=param(21)
      mueep=param(16)
      vjanus=param(38)
      if (vjanus.eq.3)then
       call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
       write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
       call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan got through cevres"
      endif
c      write(6,*)"entering jcomor"
      call cjomor(n,jkappa,jc,jp,jb,jsig,lat,long,mag,
     1time,jomor,delay,minmag)
      write(6,*)"got through jcomor"
       call jnoclt(t1,t2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,jkappa,jb,jc,jp,
     1 jsig,minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1 ll0,ll1,ll2,ll3,ll4)
      write(6,*)"lljans passed jnoclt",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljans passed jnoclt",ll0,ll1,ll2,ll3,ll4
      oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,0.,0.,
     10.,jmu,0.,1.0,ss,mag,minmag,inout)
      write(6,*)"lljans jocll=",oclogl
      totll1=oclogl-jmu*ll3-ll4
      write(6,*) jkappa,jp,jc,jsig,jmu,totll1
      write(6,*)"lljans oclogl totll=",oclogl,totll1
      write(19,*) jkappa,jp,jc,jsig,jmu,totll1
      write(19,*)"lljans oclogl totll=",oclogl,totll1
      lljans=-totll1
      write(6,*)"lljans",lljans
      return
      end

      real function lljan2(ptry)
c janus with power law spatial distribution
      implicit none
      integer i,n,n1,n2,inout,npoly,ss
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jd,jq,jb
      real xpoly,ypoly,evson(90000),jomor,jocll
      real lat,long,minmag,area,kappa,jsig,apoly
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ll4,ocllkj,ocll,ocll2,omor
      real oclogl,totll1,eta0(90000),mag0,magi,maxmag
      real delgm2,balpha,beepas,zeta,t1,t2
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,w(90000),
c    1bgdkj(90000)
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(90000),sigu,n5pd,area,kappa,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
c      write(6,*)"entering lljan2"
c      write(6,*)"lljan2,a,d,s=",a,d,s
c      data eta0/90000*0.0/
       jkappa=abs(ptry(1))
       jmu=abs(ptry(2))
       jmu=0.5+abs(jmu-0.5)
       jc=abs(ptry(3))
       jc=min(jc,0.005)
c       jp=abs(ptry(3))
c       jsig<-abs(ptry(4)
      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan2 got through cevres"
c       subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
c     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
c     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
c     1ll2,ll3,ll4)
       call jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,jkappa,jb,jc,jp,
     1 jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,
     1 ll3,ll4)
      write(6,*)"lljan2 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljan2 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      call jcomo2(n,1.0,jc,jp,jb,jd,jq,lat,long,mag,time,jomor,
     1 delay)
      write(6,*) "got through jcomor"
      oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,0.,0.,
     10.,0.,jmu,jkappa,ss,mag,minmag,inout)
c      write(6,*)"lljan2 jocll=",oclogl
      totll1=oclogl-jmu*ll1-ll4
      write(6,*) jkappa,jmu,jc,jp,totll1
      write(6,*)"lljan2 oclogl totll=",oclogl,totll1
      write(19,*) jkappa,jmu,jc,jp,totll1
      write(19,*)"lljan2 oclogl totll=",oclogl,totll1
      lljan2=-totll1
      write(6,*)"lljan2",lljan2
      return
      end


      real function lljan3(ptry)
      implicit none
      integer i,n,n1,n2,inout,npoly,ss,j,iter2,ndim2,mp2,np2
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jd,jq,jb
      real xpoly,ypoly,evson(90000),jomor,jocll
      real lat,long,minmag,area,kappa,jsig,apoly
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ll4,ocllkj,ocll,ocll2,omor
      real oclogl,totll1,eta0(90000),mag0,magi,lljan4
      real ptry2(2),pmat2(3,2),yvec2(3),ftol2,maxmag
      real delgm2,balpha,beepas,zeta,t1,t2
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,w(90000),
c    1bgdkj(90000)
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(90000),sigu,n5pd,area,kappa,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
      external lljan4
c      write(6,*)"entering lljan3"
c      write(6,*)"lljan3,a,d,s=",a,d,s
c      data eta0/90000*0.0/
c       jkappa=abs(ptry(1))
c       jmu=abs(ptry(2))
c       jmu=0.5+abs(jmu-0.5)
       jc=abs(ptry(1))
c       jc=min(jc,0.05)
       jp=abs(ptry(2))
       jp=1.0+abs(1.0-jp)
       jd=abs(ptry(3))
      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan3 got through cevres"
c       subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
c     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
c     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
c     1ll2,ll3,ll4)
       call jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,jkappa,jb,jc,jp,
     1 jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,
     1 ll3,ll4)
      write(6,*)"lljan3 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljan3 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      call jcomo2(n,1.0,jc,jp,jb,jd,jq,lat,long,mag,time,jomor,
     1delay)
      write(6,*) "lljan3 got through jcomor"
      oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     10.,0.,0.,jkappa,ss,mag,minmag,inout)
c      write(6,*)"lljan3 jocll=",oclogl
      totll1=oclogl-jmu*ll0-ll4
      write(6,*) jkappa,jmu,jc,jp,totll1
      write(6,*)"lljan3 oclogl totll=",oclogl,totll1
      write(19,*) jkappa,jmu,jc,jp,totll1
      write(19,*)"lljan3 oclogl totll=",oclogl,totll1
      lljan3=-totll1
c begin iteration on jkappa, jmu
      ptry2(1)=jkappa
      ptry2(2)=jmu
      write (6,*)"ptry2",(ptry2(i),i=1,2)
      mp2=3
      np2=2
      do i=1,np2
         do j=1,mp2
            pmat2(j,i)=ptry2(i)
         enddo
      enddo
      do i=2,mp2
         pmat2(i,i-1)=pmat2(i,i-1)*0.9
      enddo
      write(6,*)"pmat2 values set"
c  pmat values set
c     now calculate values of -loglik for starting simplex
      do j=1,mp2
         do i=1,np2
            ptry2(i)=pmat2(j,i)
         enddo
         yvec2(j)=lljan4(ptry2)
         write(6,*)"ptry2,lljan4",(ptry2(i),i=1,np2),yvec2(j)
      enddo
      ndim2=2
      ftol2=0.000001
      iter2=100
      write(6,*)"calling amoeb2",((pmat2(i,j),j=1,np2),i=1,mp2),
     1(yvec2(i),i=1,3),mp2,np2,ndim2,ftol2,iter2
      call amoeb2(pmat2,yvec2,mp2,np2,ndim2,ftol2,lljan4,iter2)
      jkappa=abs(pmat2(1,1))
      jmu=abs(pmat2(1,2))
c end iteration on jkappa, jmu
      lljan3=yvec2(1)
      write(6,*)"lljan3",jkappa,jmu,jc,jp,jd,lljan3
      return
      end

      real function lljan4(ptry)
c for optimising two parameters only-jkappa and jmu-doesnt call jcomo2
      implicit none
      integer i,n,n1,n2,inout,npoly,ss
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jd,jq,jb
      real xpoly,ypoly,evson(90000),jomor,jocll
      real lat,long,minmag,area,kappa,jsig,apoly
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ll4,ocllkj,ocll,ocll2,omor
      real oclogl,totll1,eta0(90000),mag0,magi,maxmag
      real delgm2,balpha,beepas,zeta,t1,t2
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,w(90000),
c    1bgdkj(90000)
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(90000),sigu,n5pd,area,kappa,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
c      write(6,*)"entering lljan4"
c      write(6,*)"lljan4,a,d,s=",a,d,s
c      data eta0/90000*0.0/
       jkappa=abs(ptry(1))
       jmu=abs(ptry(2))
c       jmu=0.1+abs(jmu-0.1)
c       jc=abs(ptry(3))
c       jc=min(jc,0.05)
c       jp=abs(ptry(3))
c       jsig<-abs(ptry(4)
c      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
c      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
c     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan4 got through cevres"
c       subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
c     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
c     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
c     1ll2,ll3,ll4)
       call jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,jkappa,jb,jc,jp,
     1 jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,
     1ll1,ll2,ll3,ll4)
      write(6,*)"lljan4 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljan4 passed jnocl2",ll0,ll1,ll2,ll3,ll4
c      call jcomo2(n,1.0,jc,jp,jb,jd,jq,lat,long,mag,time,jomor,
c     1 delay)
c      write(6,*) "lljan4 got through jcomo2"
      oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     10.,0.,0.,jkappa,ss,mag,minmag,inout)
c      write(6,*)"lljan4 jocll=",oclogl
      totll1=oclogl-jmu*ll0-ll4
      write(6,*) jkappa,jmu,jc,jp,jd,totll1
      write(6,*)"lljan4 oclogl totll=",oclogl,totll1
      write(19,*) jkappa,jmu,jc,jp,jd,totll1
      write(19,*)"lljan4 oclogl totll=",oclogl,totll1
      lljan4=-totll1
      write(6,*)"lljan4",lljan4
      return
      end


      real function lljan5(ptry)
      implicit none
      integer i,n,n1,n2,inout,npoly,ss,j,iter2,ndim2,mp2,np2
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jd,jq,jb
      real xpoly,ypoly,evson(90000),jomor,jocll,oclmax
      real lat,long,minmag,area,kappa,jsig,llmax,jkappf
      real bckgrd,wbar,eta1,eta(90000),delay,jkmax,jmumax,jkmx1
      real ll0,ll1,ll2,ll3,ll4,ocllkj,ocll,ocll2,omor,jmumx1
      real oclogl,totll1,eta0(90000),mag0,magi,lljan4
      real ptry2(2),pmat2(3,2),yvec2(3),ftol2,maxmag,apoly
      real delgm2,balpha,beepas,zeta,t1,t2
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,w(90000),
c    1bgdkj(90000)
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(90000),sigu,n5pd,area,kappa,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
c      write(6,*)"entering lljan5"
c      write(6,*)"lljan5,a,d,s=",a,d,s
c      data eta0/90000*0.0/
c       jkappa=abs(ptry(1))
c       jmu=abs(ptry(2))
c       jmu=0.5+abs(jmu-0.5)
       jc=abs(ptry(1))
c       jc=min(jc,0.05)
       jp=abs(ptry(2))
       if ((jp.gt.0.999).and.(jp.lt.1.001))jp=1.0001
       jd=abs(ptry(3))
      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan5 got through cevres"
c       subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
c     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
c     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
c     1ll2,ll3,ll4)
       call jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,1.0,jb,jc,jp,
     1 jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,
     1 ll3,ll4)
      write(6,*)"lljan5 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljan5 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      call jcomo2(n,1.0,jc,jp,jb,jd,jq,lat,long,mag,time,jomor,
     1 delay)
      write(6,*) "lljan5 got through jcomor"
c      oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,0.,0.,
c     1        0.,0.,0.,1.,ss,mag,minmag,inout)
c      write(6,*) "oclogl jmu=0 jkappa=1", oclogl 
      jkappf=ll0/ll4
c      write(6,*)"jkappf",jkappf,ll0/ll4
      llmax=-n2*10.0
      do i=0,10
         jkappa=jkappf*i*0.1
         jmu=abs(1.0-jkappa/jkappf)      
         oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     1        0.,0.,0.,jkappa,ss,mag,minmag,inout)
         totll1=oclogl-jmu*ll0-jkappa*ll4
         if (totll1.ge.llmax) then
            oclmax=oclogl
            llmax=totll1
            jkmax=jkappa
            jmumax=jmu
         endif
      enddo
      jkmx1=jkmax
      jmumx1=jmumax
c      write(6,*)"progress jkmax,jmumax",jkmax,jmumax,
c     1jkmax/jkappf,ll0,ll4,jkappf,ll0/ll4
      do i=0,10
         jkappa=min(jkappf,(jkmax+(-5+i)*jkappf*0.01))
         jmu=abs(1.0-jkappa/jkappf)
c         jkappa=abs(jkmax+(-5+i)*jkappf*0.01)
c         jmu=abs(jmumax+(5-i)*0.01)
         oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     1        0.,0.,0.,jkappa,ss,mag,minmag,inout)
         totll1=oclogl-jmu*ll0-jkappa*ll4
         if (totll1.ge.llmax) then
            oclmax=oclogl
            llmax=totll1
            jkmx1=jkappa
            jmumx1=jmu
         endif
      enddo
      jkmax=jkmx1
      jmumax=jmumx1
c      write(6,*)"progress jkmax,jmumax",jkmax,jmumax,jkmax/jkappf
      do i=0,10
         jkappa=min(jkappf,(jkmx1+(-5+i)*jkappf*0.001))
         jmu=abs(1.0-jkappa/jkappf)
         oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     1        0.,0.,0.,jkappa,ss,mag,minmag,inout)
         totll1=oclogl-jmu*ll0-jkappa*ll4
         if (totll1.ge.llmax) then
            oclmax=oclogl
            llmax=totll1
            jkmax=jkappa
            jmumax=jmu
         endif
      enddo
c      write(6,*)"progress jkmax,jmumax",jkmax,jmumax,jkmax/jkappf
      write(6,*)"lljan5 jocll=",oclmax
      write(6,*) jkmax,jmumax,jc,jp,jd,llmax
      write(6,*)"lljan5 oclogl totll=",oclmax,llmax
      write(19,*)jkmax,jmumax,jc,jp,jd,llmax
      write(19,*)"lljan5 oclogl totll=",oclmax,llmax
      lljan5=-llmax
      return
      end


      real function lljan6(ptry)
c does sup-etas model with given parameters (no internal optimisation)
      implicit none
      integer i,n,n1,n2,inout,npoly,ss,j,iter2,ndim2,mp2,np2
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj,apoly
      real time,mag,f0rsum,sigu,n5pd,jkappa,jmu,jc,jp,jd,jq,jb
      real xpoly,ypoly,evson(90000),jomor,jocll,oclmax
      real lat,long,minmag,area,kappa,jsig,llmax,jkappf
      real bckgrd,wbar,eta1,eta(90000),delay,jkmax,jmumax,jkmx1
      real ll0,ll1,ll2,ll3,ll4,ocllkj,ocll,ocll2,omor,jmumx1
      real oclogl,totll1,eta0(90000),mag0,magi,lljan4,oclol2
      real ptry2(2),pmat2(3,2),yvec2(3),ftol2,maxmag,oclol3
      real oclol4,oclol5
      real delgm2,balpha,beepas,zeta,t1,t2
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,w(90000),
c    1bgdkj(90000)
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
c     common/blocke/wbar,inout(90000),sigu,n5pd,area,kappa,
c    1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockj/jkappa,jmu,jc,jp,jsig,jb,jd,jq,jomor(90000)
c      write(6,*)"entering lljan5"
c      write(6,*)"lljan5,a,d,s=",a,d,s
c      data eta0/90000*0.0/
c       jkappa=abs(ptry(1))
c       jmu=abs(ptry(2))
c       jmu=0.5+abs(jmu-0.5)
       jc=abs(ptry(1))
c       jc=min(jc,0.05)
       jp=abs(ptry(2))
c       if ((jp.gt.0.999).and.(jp.lt.1.001))jp=1.0001
       jd=abs(ptry(3))
      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lljan5 got through cevres"
c      subroutine jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,
c     1bm,ba,sigu,b,c,p,ss,n5pd,area,mu,kappa,eta,jkappa,jb,
c     1jc,jp,jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,
c     1ll2,ll3,ll4)
       call jnocl2(n1,n2,w,time,mag,inout,lat,long,bt,bm,ba,
     1 sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,1.0,jb,jc,jp,
     1 jd,jq,minmag,delay,f0rsum,xpoly,ypoly,npoly,ll0,ll1,ll2,
     1 ll3,ll4)
      write(6,*)"lljan6 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      write(19,*)"lljan6 passed jnocl2",ll0,ll1,ll2,ll3,ll4
      call jcomo2(n,1.0,jc,jp,jb,jd,jq,lat,long,mag,time,jomor,
     1delay)
      write(6,*) "lljan5 got through jcomor"
         oclogl=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     1        0.,0.,0.,jkappa,ss,mag,minmag,inout)
         oclol2=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,0.,0.,
     1        0.,0.,0.,jkappa,ss,mag,minmag,inout)
         oclol3=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,jmu,0.,
     1        0.,0.,0.,0.,ss,mag,minmag,inout)
         oclol4=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,1.0,0.,
     1        0.,0.,0.,0.,ss,mag,minmag,inout)
         oclol5=jocll(n1,n2,bckgrd,omor,evson,bgdkj,jomor,1.0,0.,
     1        0.,0.,0.,jkappa/(1.-jmu),ss,mag,minmag,inout)
         totll1=oclogl-jmu*ll0-jkappa*ll4
      write(6,*)"lljan6 jocll=",oclogl
      write(6,*)"lljan6 jocll2=",oclol2
      write(6,*)"lljan6 jocll3=",oclol3
      write(6,*)"lljan6 jocll4=",oclol4
      write(6,*)"lljan6 jocll5=",oclol5
      write(6,*) jkappa,jmu,jc,jp,jd,totll1
      write(6,*)"lljan6 oclogl totll=",oclogl,totll1
      write(19,*)jkappa,jmu,jc,jp,jd,totll1
      write(19,*)"lljan6 oclogl totll=",oclogl,totll1
      lljan6=-totll1
      return
      end

      real function pnorml(x,mu,sigma)
      implicit none
      integer i
      real x,mu,sigma,y,tval,pval
      common/blockg/tval(251),pval(251)
      external dnorm
c normal integral up to (x-mu)/sigma
c      write(6,*)"pnorml",x,mu,sigma
      y=(x-mu)/sigma
      if (y.lt.tval(1)) then
         pnorml=0.0
         go to 99
      else if (y.ge.tval(251)) then
         pnorml=1.0
         go to 99
      else
         i=int(y*25)+126
c         do i=1,251
c            if ((y.ge.tval(i-1)).and.(y.lt.tval(i))) then
               pnorml=pval(i-1)+(pval(i)-pval(i-1))*
     1              (y-tval(i-1))/(tval(i)-tval(i-1))     
c         go to 99
c            endif
c         enddo
      endif
 99   continue
      return
      end


      real function llppe(ptry)
      implicit none
      integer n,n1,n2,inout,npoly,ss
      real ptry(6),am,sigm,at,sigt,siga,mueep
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,t0,maxmag
      real xpoly,ypoly,apoly,evson(90000)
      real lat,long,minmag,area,kappa,t1,t2
      real bckgrd,wbar,eta1,eta(90000),delay,kjmu
      real ll0,ll1,ll2,ll3,ocllkj,ocll,omor
      real totll1,mag0,magi,beepas,delgm2,balpha,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(6,*)"entering llppe"
      a=abs(ptry(1))
c      a=0.0
      d=1.+30.0*abs(sin(ptry(2)))
c      if(d.gt.100.0)d=100.0
      s=abs(ptry(3))
c      write(6,*)"llppe parameters renamed"
      t0=time(1)-1.0
      call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1  a,minmag,d,s,inout,8,f0rsum)
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
c      write(6,*) "got through ckjbgd"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"llppe passed nocll",ll0,ll1,ll2,ll3
      ocllkj=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,0.,0.,1.0,
     1ss,mag,minmag,inout)
c      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
c     1ss,mag,minmag,inout)
c      write(6,*)"llppe ocllkj=",ocllkj
      totll1=ocllkj-ll3
      write(6,*) a,d,s
      write(6,*)"llppe ocllkj totll=",ocllkj,totll1
      write(19,*) a,d,s
      write(19,*)"llppe ocllkj totll=",ocllkj,totll1
c      write(6,*)"llsup oclsup nolsup=",oclsup,ll0
      llppe=-totll1
      return
      end

      real function llstpp(ptry)
      implicit none
      integer n,n1,n2,inout,npoly,ss,np,pnum,i
      real ptry(6),am,sigm,at,sigt,siga,mueep,param,prange,pmin
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,t0,maxmag
      real xpoly,ypoly,apoly,evson(90000),enumeq
      real lat,long,minmag,area,kappa,t1,t2,ocllst
      real bckgrd,wbar,eta1,eta(90000),delay,kjmu
      real ll0,ll1,ll2,ll3,ocllkj,omor,stmu,step
      real totll1,mag0,magi,beepas,delgm2,balpha,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blocki/stmu,step(90000)
c      write(6,*)"entering llstpp"
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
      a=param(5)
      d=param(6)
      s=param(7)
      stmu=param(28)
c      write(6,*)"llstpp parameters renamed"
      t0=time(1)-1.0
      call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1  a,minmag,d,s,inout,8,f0rsum)
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
c      write(6,*) "got through ckjbgd"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"llstpp passed nocll",ll0,ll1,ll2,ll3
      ocllkj=ocllst(n1,n2,bckgrd,omor,evson,bgdkj,step,0.,0.,0.,
     1(1.0-stmu),stmu,ss,mag,minmag,inout)
c      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
c     1ss,mag,minmag,inout)
c      write(6,*)"llstpp ocllkj=",ocllkj
      enumeq=(1.0-stmu)*ll3+stmu*ll0
      totll1=ocllkj-enumeq
      write(6,*) a,d,s,stmu
      write(6,*)"llstpp ocllkj totll=",ocllkj,totll1
      write(19,*) "a,d,s,stmu",a,d,s,stmu
      write(19,*)"llstpp ocllkj totll=",ocllkj,totll1
c      write(6,*)"llsup oclsup nolsup=",oclsup,ll0
      llstpp=-totll1
      return
      end

      real function lstpp2(ptry)
c gives full weight to STEP, (1-stmu) to PPE
      implicit none
      integer n,n1,n2,inout,npoly,ss,np,pnum,i
      real ptry(6),am,sigm,at,sigt,siga,mueep,param,prange,pmin
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,t0,maxmag
      real xpoly,ypoly,apoly,evson(90000),enumeq
      real lat,long,minmag,area,kappa,t1,t2,ocllst
      real bckgrd,wbar,eta1,eta(90000),delay,kjmu
      real ll0,ll1,ll2,ll3,ocllkj,omor,stmu,step
      real totll1,mag0,magi,beepas,delgm2,balpha,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
      common/blocki/stmu,step(90000)
c      write(6,*)"entering llstpp"
      do i=1,np
c         write (6,*)"lstppe i=",i,"pnum(i)=",pnum(i)
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
      a=param(5)
      d=param(6)
      s=param(7)
      stmu=param(28)
c      write(6,*)"llstpp parameters renamed"
      t0=time(1)-1.0
      call csmf0r(n,lat,long,mag,xpoly,ypoly,npoly,apoly,
     1  a,minmag,d,s,inout,8,f0rsum)
      call ckjbgd(n,lat,long,time,mag,bgdkj,b,a,d,s,minmag,t0,delay)
c      write(6,*) "got through ckjbgd"
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"llstpp passed nocll",ll0,ll1,ll2,ll3
      ocllkj=ocllst(n1,n2,bckgrd,omor,evson,bgdkj,step,0.,0.,0.,
     1(1.0-stmu),1.0,ss,mag,minmag,inout)
c      oclsup=ocll(n1,n2,bckgrd,omor,evson,bgdkj,1.,0.,0.,0.,
c     1ss,mag,minmag,inout)
c      write(6,*)"llstpp ocllkj=",ocllkj
      enumeq=(1.0-stmu)*ll3+ll0/2.0
      totll1=ocllkj-enumeq
      write(6,*) a,d,s,stmu
      write(6,*)"llstpp ocllkj totll=",ocllkj,totll1
      write(19,*) "a,d,s,stmu",a,d,s,stmu
      write(19,*)"llstpp ocllkj totll=",ocllkj,totll1
c      write(6,*)"llsup oclsup nolsup=",oclsup,ll0
      lstpp2=-totll1
      return
      end

      real function llas(ptry)
      implicit none
      integer i,n,n1,n2,inout,npoly,ss,np,pnum
      real ptry(6),am,sigm,at,sigt,siga,mueep,kjmu
      real b,bm,bt,ba,a,d,s,c,p,deltam,w,bgdkj
      real time,mag,f0rsum,sigu,n5pd,param,prange
      real xpoly,ypoly,evson(90000),delgm2,balpha,zeta
      real lat,long,minmag,area,kappa,pmin,t1,t2
      real bckgrd,wbar,eta1,eta(90000),delay
      real ll0,ll1,ll2,ll3,ocll,omor,maxmag,apoly
      real oclogl,totll1,eta0(90000),mag0,magi,beepas
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
     1f0rsum(90000)
c     common/blockb/n,n1,n2,t1,t2,time(90000),mag(90000),
c    1f0rsum(90000)
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
      common/blockd/lat(90000),long(90000),ss(90000),minmag,
     1omor(90000),bckgrd(90000)
      common/blocke/wbar,inout(2,90000),sigu,n5pd,area,kappa,kjmu,
     1delay
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      common/blockh/np,param(38),pnum(36),pmin(36),prange(36)
c      write(6,*)"entering llas"
      data eta0/90000*0.0/
      do i=1,np
       param(pnum(i))=pmin(pnum(i))+prange(pnum(i))*
     1 abs(sin(ptry(i)))
      enddo
c now reset as parameters
      c=param(17)
      p=param(18)
      kappa=param(19)
      sigu=param(20)
      kjmu=param(21)

c      write(6,*)"llas,a,d,s=",a,d,s
c      data eta0/90000*0.0/
c      call ceta(eta1,n,b,am,sigm,mueep,wbar,eta)
c      write(6,*)"got through ceta"
c      write(14,*)b,ptry,(mag(i),eta(i),i=1,100)
c      call cevres(n1,n2,eta,am,bm,sigm,at,bt,sigt,ba,siga,
c     1  lat,long,time,mag,w,evson,minmag,inout,b,mag0)
c      write(6,*)"lleep got through cevres"
      call comorj(n,kappa,c,p,b,deltam,sigu,lat,long,mag,time,
     1omor,0.,minmag)
      call nocllt(t1,t2,w,time,mag,inout,lat,long,bt,
     1  bm,ba,sigu,b,c,p,ss,n5pd,area,1.0,kappa,eta,
     1  minmag,deltam,delay,f0rsum,xpoly,ypoly,npoly,n,
     1  ll0,ll1,ll2,ll3)
      write(6,*)"llas passed nocll",ll0,ll1,ll2,ll3
      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,0.,1.0,0.,kjmu,
     1ss,mag,minmag,inout)
c      write(6,*)"lleep ocllkj=",ocllkj
c      oclogl=ocll(n1,n2,bckgrd,omor,evson,bgdkj,
c     1       0.,0.,1.,mueep,ss,mag,minmag,inout)
c      totll1=oclogl-kjmu*ll3*10**(b*(5.95-4.15))-ll2
      totll1=oclogl-kjmu*ll3-ll2
      write(6,*) c,p,kappa,sigu,kjmu,totll1
      write(6,*)"llas oclogl totll=",oclogl,totll1
      write(19,*) c,p,kappa,sigu,kjmu,totll1
      write(19,*)"llas oclogl totll=",oclogl,totll1
      llas=-totll1
      write(6,*)"llas",llas
      return
      end


      character*256 function jointx(tx1,fileno)
      implicit none
      character*256 tx1
      character*3 bstr,cstr
      character*1 astr(256)
      integer fileno,i,lenga
      cstr="eep"
      write(99,25) cstr,tx1
 25   format(a3,a256)
 21   format(a256)
 22   format(256a1)
      backspace(99)
      read(99,22) astr
      do i=1,256
         if(astr(i).eq.'.')then
            lenga=i+1
            go to 31
         endif
      enddo
 31   do i=lenga,256
         astr(i)=' '
      enddo
      if(fileno.eq.11)then
         bstr='ou1'
         write(99,23)bstr
 23      format(a3)
      elseif(fileno.eq.14) then
         bstr='ou2'
         write(99,23)bstr
      else
         write(99,24)fileno
 24      format(i2)
      endif
      backspace(99)
      read (99,22)(astr(i),i=lenga,256)
      backspace(99)
      write(99,22)(astr(i),i=1,256)
      backspace(99)
      read(99,21) jointx
      return
      end

      subroutine makeky(nfile,nfile2)
      implicit none
      character*1 astr(72),bstr(16),cstr(16),dstr(16)
      integer nfile,nfile2,lq,date(8),k,i,j,lquery
      read(nfile,22)(astr(i),i=1,72)
      lq=lquery(astr,72)
      write(nfile2,22)(astr(i),i=1,lq)
 22   format(72a1)
c      write(6,*)lq,(astr(i),i=1,lq)
      call encode(astr,bstr,lq,date)
c      write(6,*)bstr,lq,(date(i),i=1,8)
      do i=1,8
         k=(i-date(i))*(-1)**i+(-1)*i
         call shift(bstr,cstr,16,k)
         call shift(cstr,dstr,16,date(4))
         write(nfile2,22)(dstr(j),j=1,16)
      enddo   
      end

      subroutine checky(nfile)
      implicit none
      character*10 curra,currb,currc
      character*1 astr(72),bstr(16),cstr(16),dstr(16)
      integer nfile,lq,date(8),k,i,j,il,curr(3),licexp(3)
      integer val(8),lquery
      real dctime
 24   format(a8)
      read(nfile,22) (astr(i),i=1,72)
      lq=lquery(astr,72)
c      write(6,*)lq,(astr(i),i=1,lq)
 22   format(72a1)
      call encode(astr,bstr,lq,date)
 26   format(8i1)
c      write(6,*)bstr,lq,(date(i),i=1,8)
      do i=1,8
         k=(i-date(i))*(-1)**i+(-1)*i
         call shift(bstr,cstr,16,k)
         call shift(cstr,dstr,16,date(4))
         read(nfile,22)(cstr(j),j=1,16)
c         write(6,*)"cstr ",(cstr(j),j=1,16)
c         write(6,*)"dstr ",(dstr(j),j=1,16)
         do j=1,16
            if (cstr(j).ne.dstr(j))go to 2
         enddo
      enddo
      call date_and_time(curra,currb,currc,val)
      write(99,24)curra
      backspace(99)
      read(99,25)(curr(i),i=1,3)
c      write(6,*)"current date",(curr(i),i=1,3)
 25   format(i4,i2,i2)
      backspace(99)
      write(99,26)(date(i),i=1,8)
      backspace(99)
      read(99,25)(licexp(i),i=1,3)
c      write(6,*)"licence expires",(licexp(i),i=1,3)
      if ((dctime(licexp(1),licexp(2),licexp(3),0,0,0.,2000)+7.)
     1.lt.dctime(curr(1),curr(2),curr(3),0,0,0.,2000)) go to 2
c      write(6,*)"Checked dates"
       if ((dctime(licexp(1),licexp(2),licexp(3),0,0,0.,2000)-30.)
     1 .lt.dctime(curr(1),curr(2),curr(3),0,0,0.,2000)) 
     1 write(6,23)(date(il),il=1,8)
 23   format(" WARNING: Licence expires on ",4i1,'-',2i1,'-',2i1) 
      return
 2    write(6,*)"Invalid or expired licence"
      stop
      end

      subroutine encode(astr,bstr,lq,date)
      implicit none
      character*1 astr(72),bstr(16),cstr(10),dstr(8)
      integer lq,nstart,date(8),i,j,k
      do i=1,lq
         if (astr(i).eq.'2')go to 1
      enddo
 2    write(6,*)"Subroutine encode: Invalid string ",
     1 (astr(i),i=1,lq)
      stop
 1    nstart=i
      write(99,21)(astr(i),i=nstart,(nstart+9))
 21   format(72a1)
      backspace(99)
      read(99,22,err=2)(date(i),i=1,8)
 22   format(4i1,1x,2i1,1x,2i1)
      backspace(99)
      write(99,23)
 23   format(72x)
      i=0
      j=0
 3    i=i+1
 4    j=j+1    
c      write(6,*)"encode: i j",i,j
      if (astr(j).eq.' ') go to 4
      if (astr(j).eq.'/') go to 4
      if (astr(j).eq.',')go to 4
      if (astr(j).eq.'.')go to 4
      if (astr(j).eq.';')go to 4
      if (astr(j).eq.':')go to 4
      if (astr(j).eq.'!')go to 4
      if (astr(j).eq.'@')go to 4
      if (astr(j).eq.'#')go to 4
      if (astr(j).eq.'$')go to 4
      if (astr(j).eq.'%')go to 4
      if (astr(j).eq.'^')go to 4
      if (astr(j).eq.'&')go to 4
      if (astr(j).eq.'*')go to 4
      if (astr(j).eq.'(')go to 4
      if (astr(j).eq.')')go to 4
      if (astr(j).eq.'_')go to 4
      if (astr(j).eq.'-')go to 4
      if (astr(j).eq.'+')go to 4
      if (astr(j).eq.'=')go to 4
      if (astr(j).eq.'{')go to 4
      if (astr(j).eq.'}')go to 4
      if (astr(j).eq.'[')go to 4
      if (astr(j).eq.']')go to 4
      if (astr(j).eq.'"')go to 4
      if (astr(j).eq.'?')go to 4
      if (astr(j).eq.'<')go to 4
      if (astr(j).eq.'>')go to 4
      if (astr(j).eq."'")go to 4
      if (i.gt.1) then
         do k=1,(i-1)
            if (astr(k).eq.astr(j))go to 4
         enddo
      endif   
 9    cstr(i)=astr(j)
      if (i.lt.10) go to 3
c-----finished assigning cstr values
 10   continue
c-----now fix dstr
      i=0
      j=lq
 5    i=i+1
 6    j=j-1
      if(j.lt.1)j=lq-1
      if (astr(j).eq.' ') go to 6
      if (astr(j).eq.'/') go to 6
      if (astr(j).eq.',')go to 6
      if (astr(j).eq.'.')go to 6
      if (astr(j).eq.';')go to 6
      if (astr(j).eq.':')go to 6
      if (astr(j).eq.'!')go to 6
      if (astr(j).eq.'@')go to 6
      if (astr(j).eq.'#')go to 6
      if (astr(j).eq.'$')go to 6
      if (astr(j).eq.'%')go to 6
      if (astr(j).eq.'^')go to 6
      if (astr(j).eq.'&')go to 6
      if (astr(j).eq.'*')go to 6
      if (astr(j).eq.'(')go to 6
      if (astr(j).eq.')')go to 6
      if (astr(j).eq.'_')go to 6
      if (astr(j).eq.'-')go to 6
      if (astr(j).eq.'+')go to 6
      if (astr(j).eq.'=')go to 6
      if (astr(j).eq.'{')go to 6
      if (astr(j).eq.'}')go to 6
      if (astr(j).eq.'[')go to 6
      if (astr(j).eq.']')go to 6
      if (astr(j).eq.'"')go to 6
      if (astr(j).eq.'?')go to 6
      if (astr(j).eq.'<')go to 6
      if (astr(j).eq.'>')go to 6
      if (astr(j).eq."'")go to 6
 11   dstr(i)=astr(j)
      if (i.lt.8) go to 5
c-----finished assigning cstr values
 12   continue
c-----now mix cstr and dstr
      do i=1,8
         bstr(2*(i-1)+1)=cstr(date(i)+1)
         bstr(16-(2*(i-1)))=dstr(i)
      enddo
      return
      end

      
      subroutine shift(xstr,ystr,n,freq)
      implicit none
      integer n,freq,i,j
      character*1 xstr(n),ystr(n),refstr(56)
      data refstr/"0","1","2","3","4","5","6","7","8","9","b","4",
     1 "p","c","e","g","x","h","z","i","u","j","l","2","k","n","a",
     1 "q","o","r","d","s","t","v","w","y","f","0","1","3","m","7",
     1 "5","9","6","8","a","b","c","d","e","f","g","h","i","j"/
 1    if (abs(freq).le.10)go to 2
      freq=abs(freq)-10
      go to 1
 2    continue
      do j=1,n
       do i=11,46
         if (xstr(j).eq.refstr(i)) go to 3
       enddo
 3     ystr(j)=refstr(i+(-1)**j*freq)
      enddo
      return
      end

      subroutine pevrl3(t1,t2,stplon,stplat,ninstp,ntime,
     1eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1evitm,b,mag0,nf,maxmag,mask,cx,cy)
c integrates magnitude to get expected no. events per yr per 100km2
c aims to do same calcs as pevrlm, but more efficiently
      implicit none
      integer nlat,nlon,i,nf,j,k,ncat,ninstp,in1,in2,ntime,it
      integer hlo,hhi,nmint,im,i4,jlon,sigi,npoly,mask,inpoly
      integer inside
      real g1m,f1t,distkm,pnorml,g1m1(41,90000),limupp,divi(51)
      real mloi(100),mhii(100),f1t1(10,90000),r,cx,cy
      real t1,t2,timei(20),minlon,maxlon,minlat,maxlat
      real cmnlon,cmxlon,cmnlat,cmxlat,mlo,mhi,delm
      real am,bm,sigm,at,bt,sigt,ba,siga,stplat,stplon
      real lat(90000),long(90000),evitm(90000),w(90000),eta(90000)
      real time(90000),mag(90000),evtmx3,maxmag,mj,instep(10)
      real ylat,xlong,b,mag0,evitmi,h1x1(10,90000),psum
      real h1y1(10,90000),f1t1mn(90000),h1x1mn(90000)
      real h1y1mn(90000),xpoly,ypoly,eta1,apoly
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
c      write(6,*)"entered pevrl2",t1,t2,stplon,stplat,ninstp,ntime,
c     1 nf,am,bm,sigm,at,bt,sigt,ba,siga,b,mag0,ncat
      psum=0.0
      hlo=0
      hhi=30
      do i4=1,51
         mj=4.9+0.1*i4
         do j=1,ncat
         limupp=(mj-am-bm*mag0-sigm**2*b*log(10.))/sigm
         divi(i4)=pnorml(limupp,0.0,1.0)
         if(divi(i4).le.0.01)divi(i4)=0.01
         if (i4.le.41) then
          g1m1(i4,j)=g1m(mj,mag(j),am,bm,sigm)/divi(i4)
         else
          g1m1(41,j)=g1m1(41,j)+g1m(mj,mag(j),am,bm,sigm)/divi(i4)
         endif
         enddo
c         write(6,*)"mj,divi",mj,divi(i4)
      enddo
      nmint=0
 20         read(24,*,end=89)mlo,mhi
            nmint=nmint+1
            mloi(nmint)=mlo
            mhii(nmint)=mhi
            go to 20
 89         continue
            rewind(24)
      do it=1,ntime
         timei(it)=t1+((it-0.5)/ntime)*(t2-t1)
         do j=1,ncat
            f1t1(it,j)=f1t(timei(it),time(j),mag(j),at,bt,sigt)
            if(it.eq.1) then
               f1t1mn(j)=f1t1(it,j)/ntime
            else
               f1t1mn(j)=f1t1mn(j)+ f1t1(it,j)/ntime
            endif
         enddo
      enddo
      do i=1,ninstp
         instep(i)=0.1*(i-0.5)/ninstp
      enddo
 10   read(23,*,end=99)minlon,maxlon,minlat,maxlat
      nlon=(maxlon-minlon)/stplon
      nlat=(maxlat-minlat)/stplat
      do jlon=1,nlon
         cmnlon=minlon+(jlon-1)*stplon
         cmxlon=minlon+jlon*stplon
c calculate and store longitude contributions to rate density
         do in1=1,ninstp
          xlong=cmnlon+instep(in1)
          do j=1,ncat
           r=distkm(lat(j),long(j),lat(j),xlong)
           sigi=siga*10**(ba*mag(j)/2.)
           h1x1(in1,j)=exp(-0.5*(r/sigi)**2)/
     1     sqrt(2*3.14159*sigi**2)
            if(in1.eq.1) then
               h1x1mn(j)=h1x1(in1,j)/ninstp
            else
               h1x1mn(j)=h1x1mn(j)+ h1x1(in1,j)/ninstp
            endif
          enddo
c          write(6,*)"h1x1",h1x1(in1,50000)
         enddo
          do k=1,nlat
            cmnlat=minlat+(k-1)*stplat
            cmxlat=minlat+k*stplat
            i=(j-1)*nlon+k
c now calculate and store latitude contributions to rate density
          do in2=1,ninstp
             ylat=cmnlat+instep(in2)
             do j=1,ncat
              r=distkm(lat(j),long(j),ylat,long(j))
              sigi=siga*10**(ba*mag(j)/2.)
              h1y1(in2,j)=exp(-0.5*(r/sigi)**2)/
     1        sqrt(2*3.14159*sigi**2)
            if(in2.eq.1) then
               h1y1mn(j)=h1y1(in2,j)/ninstp
            else
               h1y1mn(j)=h1y1mn(j)+ h1y1(in2,j)/ninstp
            endif
             enddo
          enddo 
c          write (6,*)"pevrl2",cmnlon,cmxlon,cmnlat,cmxlat
          do im=1,nmint
            evitmi=0.0
                   evitmi=evitmi+evtmx3(im,ncat,eta,w,
     1             g1m1,f1t1mn,h1x1mn,h1y1mn)
           delm=min(0.1,(mhi-mlo))
           evitmi=evitmi*delm*111.1**2*stplat*stplon*
     1     cos(3.14159*0.5*(cmnlat+cmxlat)/180.0)*(t2-t1)
           if (mask.eq.1)then
            if (nf.ne.0)write(nf,21)cmnlon,
     1      cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi,
     1       mask
 21         format(4f12.4,i4,i5,2f8.2,e14.4,i2)
           else
            inpoly=inside((cmxlon+cmnlon)/2.,(cmxlat+cmnlat)/2.,
     1       xpoly,ypoly,npoly,cx,cy)
            if (nf.ne.0)write(nf,21)cmnlon,
     1      cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi,
     1       inpoly
c            write(6,21)cmnlon,
c     1      cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi
           endif 
           psum=psum+evitmi
           enddo
         enddo
         write(6,*)"Done", cmnlon,cmxlon
      enddo
      go to 10
 99   continue
      rewind(23)
      write(6,*)"EEPGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      write(11,*)"EEPGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      rewind(31)
      return
      end    


      subroutine pevrl4(t1,t2,stplon,stplat,ninstp,ntime,
     1eta,am,bm,sigm,at,bt,sigt,ba,siga,lat,long,time,mag,w,ncat,
     1evitm,b,mag0,delgm2,zeta,balpha,nf,maxmag,mask,cx,cy)
c integrates magnitude to get expected no. events per yr per 100km2
c aims to do same calcs as pevrlm, but more efficiently
      implicit none
      integer nlat,nlon,i,nf,j,k,ncat,ninstp,in1,in2,ntime,it
      integer hlo,hhi,nmint,im,i4,jlon,sigi,mask,inpoly
      integer npoly, inside
      real g1m3,f1t,distkm,pnorml,g1m1(41,90000),limupp,divi(51)
      real mloi(100),mhii(100),f1t1(10,90000),r
      real t1,t2,timei(20),minlon,maxlon,minlat,maxlat
      real cmnlon,cmxlon,cmnlat,cmxlat,mlo,mhi,delm
      real am,bm,sigm,at,bt,sigt,ba,siga,stplat,stplon
      real lat(90000),long(90000),evitm(90000),w(90000),eta(90000)
      real time(90000),mag(90000),evtmx3,maxmag,mj,instep(10)
      real ylat,xlong,b,mag0,evitmi,h1x1(10,90000),psum
      real h1y1(10,90000),f1t1mn(90000),h1x1mn(90000),cx,cy
      real h1y1mn(90000),delgm2,balpha,zeta,xpoly,ypoly,eta1,apoly
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
c      write(6,*)"entered pevrl2",t1,t2,stplon,stplat,ninstp,ntime,
c     1 nf,am,bm,sigm,at,bt,sigt,ba,siga,b,mag0,ncat
      psum=0.0
      hlo=0
      hhi=30
      do i4=1,51
         mj=4.9+0.1*i4
         do j=1,ncat
         limupp=(mj-am-bm*mag0-sigm**2*b*log(10.))/sigm
         divi(i4)=pnorml(limupp,0.0,1.0)
         if(divi(i4).le.0.01)divi(i4)=0.01
         if (i4.le.41) then
          g1m1(i4,j)=g1m3(mj,mag(j),am,bm,sigm,b,delgm2,zeta,
     1    balpha)/divi(i4)
         else
          g1m1(41,j)=g1m1(41,j)+g1m3(mj,mag(j),am,bm,sigm,b,delgm2,
     1    zeta,balpha)/divi(i4)
         endif
         enddo
c         write(6,*)"mj,divi",mj,divi(i4)
      enddo
      nmint=0
 20         read(24,*,end=89)mlo,mhi
            nmint=nmint+1
            mloi(nmint)=mlo
            mhii(nmint)=mhi
            go to 20
 89         continue
            rewind(24)
      do it=1,ntime
         timei(it)=t1+((it-0.5)/ntime)*(t2-t1)
         do j=1,ncat
            f1t1(it,j)=f1t(timei(it),time(j),mag(j),at,bt,sigt)
            if(it.eq.1) then
               f1t1mn(j)=f1t1(it,j)/ntime
            else
               f1t1mn(j)=f1t1mn(j)+ f1t1(it,j)/ntime
            endif
         enddo
      enddo
      do i=1,ninstp
         instep(i)=0.1*(i-0.5)/ninstp
      enddo
 10   read(23,*,end=99)minlon,maxlon,minlat,maxlat
      nlon=(maxlon-minlon)/stplon
      nlat=(maxlat-minlat)/stplat
      do jlon=1,nlon
         cmnlon=minlon+(jlon-1)*stplon
         cmxlon=minlon+jlon*stplon
c calculate and store longitude contributions to rate density
         do in1=1,ninstp
          xlong=cmnlon+instep(in1)
          do j=1,ncat
           r=distkm(lat(j),long(j),lat(j),xlong)
           sigi=siga*10**(ba*mag(j)/2.)
           h1x1(in1,j)=exp(-0.5*(r/sigi)**2)/
     1     sqrt(2*3.14159*sigi**2)
            if(in1.eq.1) then
               h1x1mn(j)=h1x1(in1,j)/ninstp
            else
               h1x1mn(j)=h1x1mn(j)+ h1x1(in1,j)/ninstp
            endif
          enddo
c          write(6,*)"h1x1",h1x1(in1,50000)
         enddo
          do k=1,nlat
            cmnlat=minlat+(k-1)*stplat
            cmxlat=minlat+k*stplat
            i=(j-1)*nlon+k
c now calculate and store latitude contributions to rate density
          do in2=1,ninstp
             ylat=cmnlat+instep(in2)
             do j=1,ncat
              r=distkm(lat(j),long(j),ylat,long(j))
              sigi=siga*10**(ba*mag(j)/2.)
              h1y1(in2,j)=exp(-0.5*(r/sigi)**2)/
     1        sqrt(2*3.14159*sigi**2)
            if(in2.eq.1) then
               h1y1mn(j)=h1y1(in2,j)/ninstp
            else
               h1y1mn(j)=h1y1mn(j)+ h1y1(in2,j)/ninstp
            endif
             enddo
          enddo 
c          write (6,*)"pevrl2",cmnlon,cmxlon,cmnlat,cmxlat
          do im=1,nmint
            evitmi=0.0
                   evitmi=evitmi+evtmx3(im,ncat,eta,w,
     1             g1m1,f1t1mn,h1x1mn,h1y1mn)
           delm=min(0.1,(mhi-mlo))
           evitmi=evitmi*delm*111.1**2*stplat*stplon*
     1     cos(3.14159*0.5*(cmnlat+cmxlat)/180.0)*(t2-t1)
           if (mask.eq.1)then
            if (nf.ne.0)write(nf,21)cmnlon,
     1      cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi,
     1       mask
 21         format(4f12.4,i4,i5,2f8.2,e14.4,i2)
c            write(6,21)cmnlon,
c     1      cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi
            else
             inpoly=inside((cmxlon+cmnlon)/2.,(cmxlat+cmnlat)/2.,
     1       xpoly,ypoly,npoly,cx,cy)
             if (nf.ne.0)write(nf,21)cmnlon,
     1       cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),evitmi,
     1       inpoly
            endif
           psum=psum+evitmi
           enddo
         enddo
         write(6,*)"Done", cmnlon,cmxlon
      enddo
      go to 10
 99   continue
      rewind(23)
      write(6,*)"EEPGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      write(11,*)"EEPGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      rewind(31)
      return
      end    


      subroutine pkjrl3(t1,t2,stplon,stplat,ninstp,t0,delay,
     1a,d,s,lat,long,time,mag,ncat,b,mag0,nf,maxmag,mask,cx,cy)
c integrates magnitude to get expected no. events per yr per 100km2
c aims to do similar calcs as pevrlm, but for PPE model
      implicit none
      integer nlat,nlon,i,nf,k,ncat,ninstp,in1,in2,mask,inpoly
      integer hlo,hhi,nmint,im,jlon,neq,nleq(90000),l
      integer npoly,inside
      real distkm,t0,kjf0r,delay,cx,cy
      real mloi(100),mhii(100),r,mfac(51)
      real t1,t2,minlon,maxlon,minlat,maxlat
      real cmnlon,cmxlon,cmnlat,cmxlat,mlo,mhi
      real a,d,s,stplat,stplon,tfac
      real lat(90000),long(90000),xpoly,ypoly,eta1,apoly
      real time(90000),mag(90000),maxmag,instep(10)
      real ylat,xlong,b,mag0,kjbtmi,psum
      common/blockc/xpoly(100),ypoly(100),npoly,eta1(90000),apoly
c      write(6,*)"entered pkjrl3",t1,t2,stplon,stplat,ninstp,t0,
c     1 delay,nf,b,mag0,ncat
c find earthquakes exceeding m0 in catalogue and note their indices
      neq=0
      do i=1,ncat
         if ((mag(i).ge.mag0).and.(time(i).le.(t1-delay)))then
            neq=neq+1
            nleq(neq)=i
         endif   
      enddo
c      write(6,*)'neq=',neq
c      write(6,*),(mag(nleq(i)),i=1,neq)
      psum=0.0
      hlo=0
      hhi=30
      nmint=0
 20         read(24,*,end=89)mlo,mhi
            nmint=nmint+1
            mloi(nmint)=mlo
            mhii(nmint)=mhi
            go to 20
 89         continue
c            write(6,*) 'nmint= ',nmint
            rewind(24)
      tfac=(t2-t1)/(t1-t0-delay)
c      write(6,*) 'tfac= ',tfac
      do i=1,ninstp
         instep(i)=0.1*(i-0.5)/ninstp
      enddo
      do i=1,nmint
         mfac(i)=(10**(b*(mag0-mloi(i)))
     1    -10**(b*(mag0-mhii(i))))*tfac
      enddo   
c      write(6,*)(mfac(i),i=1,nmint)
 10   read(23,*,end=99)minlon,maxlon,minlat,maxlat
      nlon=(maxlon-minlon)/stplon
      nlat=(maxlat-minlat)/stplat
      do jlon=1,nlon
         cmnlon=minlon+(jlon-1)*stplon
         cmxlon=minlon+jlon*stplon
          do k=1,nlat
           cmnlat=minlat+(k-1)*stplat
           cmxlat=minlat+k*stplat
           kjbtmi=0.0
           do in1=1,ninstp
            xlong=cmnlon+instep(in1)
            do in2=1,ninstp
             ylat=cmnlat+instep(in2)
             do l=1,neq
              r=distkm(ylat,xlong,lat(nleq(l)),long(nleq(l)))
              kjbtmi=kjbtmi+kjf0r(a,mag(nleq(l)),mag0,d,r,s)
             enddo
            enddo
           enddo 
           kjbtmi=kjbtmi*111.1**2*stplat*stplon*
     1     cos(3.14159*0.5*(cmnlat+cmxlat)/180.0)/(ninstp**2)
c           write(6,*)'cmnlat,cmxlat,kjbtmi ',cmnlat,cmxlat,kjbtmi
           do im=1,nmint
            if (mask.eq.1)then
             if (nf.ne.0)write(nf,21)cmnlon,
     1       cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),
     1       kjbtmi*mfac(im),mask
            else
             inpoly=inside((cmxlon+cmnlon)/2.,(cmxlat+cmnlat)/2.,
     1       xpoly,ypoly,npoly,cx,cy)
             if (nf.ne.0)write(nf,21)cmnlon,
     1       cmxlon,cmnlat,cmxlat,hlo,hhi,mloi(im),mhii(im),
     1       kjbtmi*mfac(im),inpoly
            endif  
 21         format(4f12.4,i4,i5,2f8.2,e14.4,i2)
            psum=psum+kjbtmi*mfac(im)
           enddo
         enddo
         write(6,*)"Done", cmnlon,cmxlon
      enddo
      go to 10
 99   continue
      rewind(23)
      write(6,*)"PPEGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      write(11,*)"PPEGRID - total expected number of earthquakes ",
     1 "in window = ",psum
      rewind(31)
      return
      end    


      real function evtmx3(i4,ncat,eta,w,g1m1,f1t1,
     1 h1x1,h1y1)
      implicit none
      real w(90000),s,h1x1(90000),h1y1(90000)
      real eta(90000),f1t1(90000),g1m1(41,90000)
      integer ncat,j,i4
      s=0.
      do j=1,ncat
       s=s+eta(j)*w(j)*f1t1(j)*g1m1(i4,j)*h1x1(j)*
     1 h1y1(j)
      enddo
      evtmx3=s
      return
      end

      subroutine prpars(nf,par1,pst1,n1,par2,pst2,n2)
c prints parameter values to file nf
      implicit none
      integer i,nf,n1,n2
      real par1(n1),par2(n2)
      character*4 pst1(n1),pst2(n2)
      character*256 fname,fn,jointx
      logical unitop
      inquire(unit=nf,opened=unitop)
      if (.not. unitop) then
         inquire(unit=9,name=fname)
         fn=jointx(fname,nf)
         open(unit=nf,file=fn,status='new')
      endif
      do i=1,n1
         write(nf,*)pst1(i),par1(i)
      enddo
      do i=1,n2
         write(nf,*)pst2(i),par2(i)
      enddo
      write(nf,*)"endp /"
      return
      end
  
      subroutine bfit(ncat,time,mag,t1,t2,m0,b,neq,se)
c-----maximum likelihood estimate of bvalue and its standard error
      implicit none
      integer neq,i,ncat
      real mag(90000),time(90000),mdiff(90000),t1,t2,m0,b,se,msum
      real sumvec
      neq=0
      do i=1,ncat
         mdiff(i)=mag(i)-m0
         if ((mdiff(i).le.0.).or.(time(i).lt.t1).or.
     1   (time(i).gt.t2)) then
            mdiff(i)=0.
         else
            neq=neq+1
         endif
      enddo
      msum=sumvec(mdiff,ncat)
      b=(neq/msum)/log(10.)
      if (neq.gt.0) se=b/sqrt(neq*1.)
      return
      end

      real function sumvec(avec,n)
      integer n,i
      real avec(n),s
      s=0.
      do i=1,n
         s=s+avec(i)
      enddo
      sumvec=s
      return
      end
      
      subroutine wbfit(ncat,time,mag,w,t1,t2,m0,b,neq,se)
c-----maximum likelihood estimate of bvalue and its standard error
      implicit none
      integer neq,i,ncat
      real mag(90000),time(90000),mdiff(90000),t1,t2,m0,b,se,msum
      real sumvec,w(90000),wcount(90000),wmdiff(90000),wsum
      neq=0
      do i=1,ncat
         mdiff(i)=(mag(i)-m0)
         wmdiff(i)=w(i)*mdiff(i)
         wcount(i)=w(i)
         if ((mdiff(i).le.0.).or.(time(i).lt.t1).or.
     1   (time(i).gt.t2)) then
            mdiff(i)=0.
            wmdiff(i)=0.
            wcount(i)=0.
         else
            neq=neq+1
         endif
      enddo
      msum=sumvec(wmdiff,ncat)
      wsum=sumvec(wcount,ncat)
      b=(wsum/msum)/log(10.)
      if (wsum.gt.0) se=b/sqrt(wsum)
      return
      end

      
      subroutine cumnvt(ncat,yr,mag,m0)
c-----cumulative neq exceeding magnitude m0 vs time, and ratios
      implicit none
      character*2 siglev(300)
      integer i,j,index,ncat,yr(90000),cumneq(300),cumnpl(300)
      integer year
      real mag(90000),m0,ratio1(300),seprat
      real ratio3(300),ratio5(300),se1(300),se3(300),se5(300)
      real df1neq(300),df3neq(300),df5neq(300)
      real df1npl(300),df3npl(300),df5npl(300)
      do i=1,300
        cumneq(i)=0
        cumnpl(i)=0
        ratio1(i)=0.
        ratio3(i)=0.
        ratio5(i)=0.
      enddo
      write(6,*)"Doing m0 = ",m0,".  Results to file out1"
      do j=1,ncat
       do i=yr(1),yr(ncat)
         if ((yr(j).le.i))then 
            index=i-yr(1)+1
            if (mag(j).ge.m0)cumneq(index)=cumneq(index)+1
            if (mag(j).ge.m0+0.5)cumnpl(index)=cumnpl(index)+1
         endif
       enddo
 10   continue
      enddo
      cumneq(index+1)=cumneq(index)
      cumneq(index+2)=cumneq(index)
      cumnpl(index+1)=cumnpl(index)
      cumnpl(index+2)=cumnpl(index)
c----now have cumulative numbers, so calculate diffs & ratios
      df1neq(1)=1.*cumneq(1)
      df3neq(1)=1.*cumneq(2)
      df3neq(2)=1.*cumneq(3)
      df5neq(1)=1.*cumneq(3)
      df5neq(2)=1.*cumneq(4)
      df5neq(3)=1.*cumneq(5)
      df1npl(1)=1.*cumnpl(1)
      df3npl(1)=1.*cumnpl(2)
      df3npl(2)=1.*cumnpl(3)
      df5npl(1)=1.*cumnpl(3)
      df5npl(2)=1.*cumnpl(4)
      df5npl(3)=1.*cumnpl(5)
      do i=2,index
         df1neq(i)=1.0*(cumneq(i)-cumneq(i-1))
         df1npl(i)=1.0*(cumnpl(i)-cumnpl(i-1))
         if (i.gt.2)then
          df3neq(i)=1.0*(cumneq(i+1)-cumneq(i-2))
          df3npl(i)=1.0*(cumnpl(i+1)-cumnpl(i-2))
         endif
         if (i.gt.3) then
          df5neq(i)=1.0*(cumneq(i+2)-cumneq(i-3))
          df5npl(i)=1.0*(cumnpl(i+2)-cumnpl(i-3))
         endif 
      enddo
      do i=1,index
         if (df1neq(i).gt.0.) then
            ratio1(i)=df1npl(i)/df1neq(i)
            se1(i)=seprat(df1npl(i),df1neq(i))
         endif   
         if (df3neq(i).gt.0.) then
            ratio3(i)=df3npl(i)/df3neq(i)
            se3(i)=seprat(df3npl(i),df3neq(i))
         endif   
         if (df5neq(i).gt.0.) then
            ratio5(i)=df5npl(i)/df5neq(i)
            se5(i)=seprat(df5npl(i),df5neq(i))
         endif   
         if ((ratio5(i)-3*se5(i)).gt.0.32) then
            siglev(i)="**"
         else if ((ratio5(i)-2*se5(i)).gt.0.32) then
            siglev(i)="*"
         else
            siglev(i)=" "
         endif
      enddo
c-------now write results to file 11
      write(11,23) m0
 23   format(/,"m0 =",f5.2,//,"Year Cum(Neq)  R1  se(R1)  R3  "
     1 ,"se(R3)  R5  se(R5)  Incompleteness")
      do i=1,index
         year=yr(1)+i-1
         write(11,21)year,cumneq(i),ratio1(i),se1(i),
     1   ratio3(i),se3(i),ratio5(i),se5(i),siglev(i)
 21      format(i4,i9,3(f6.2,f6.2),7x,a2)
      enddo
      return
      end

      real function seprat(rn1,rn2)
c--------standard error of ratio rn1/rn2 of Poisson counts
c--------where rn1 is a subset of rn2
      implicit none
      real rn1,rn2,se1,se2,ratio,cov
      if (rn1.eq.0.)then
c--------replace zero rn1 by expected value, given rn2
         ratio=0.316
      else
         ratio=rn1/rn2
      endif
      if (rn1.eq.0.) then
         se1=sqrt(rn2*0.316)
      else   
         se1=sqrt(rn1)
      endif
      se2=sqrt(rn2)
      cov=se1**2
      if (rn1.eq.0) then
         seprat=sqrt(ratio**2*(1./se1**2+se2**2/rn2**2
     1   -2*cov/(se1**2*rn2)))
      else
         seprat=sqrt(ratio**2*(se1**2/rn1**2+se2**2/rn2**2
     1   -2*cov/(rn1*rn2)))
      endif
      return
      end
      

      subroutine wscrpt(nfile,rtrfl,title,contfn,datafn,cptfn,
     1grint,longmn,longmx,latmn,latmx,col,cont)
c-----writes unix shell script to plot rate density array using gmt
      implicit none
      character*72 str(31),bstr(31),cstr(31)
      character*1 astr1(72),astr2(72),astr3(72),rstr1(72),
     1 rstr2(72),rstr3(72),rstr4(72),backsl
      character*32 title,datafn,contfn,cptfn
      integer i,j,nfile,lq1,lq2,lq3,rlq1,rlq2,rlq3,rlq4,lquery
      integer rb1,rb2,rb3,rb4,nstr(31),rtrfl,col,cont,con2
      real longmn,longmx,latmn,latmx,b17,b4,c4,d4,e4,b8,grint
      parameter (backsl = '\\')
      data nstr/1,3,3,4,3,1,1,4,3,1,1,1,1,1,2,1,4,1,1,3,1,1,1,1,
     1     1,1,1,1,2,1,2/
c      write(6,*)"entering wscript ",nfile,rtrfl,title,contfn,
c     1 datafn,cptfn,
c     1 grint,longmn,longmx,latmn,latmx,col,cont
      con2=cont
      if (col.eq.0)con2=1
      str(1)='#!;bin;sh'
      str(2)='CPT="'
      bstr(2)=cptfn
      cstr(2)='"'
      str(3)='CONT="'
      bstr(3)=contfn
      cstr(3)='"'
      str(4)='RANGE="-R'
      b4=longmn
      bstr(4)=';'
      c4=longmx
c----- repeat bstr(4) next
      d4=latmn
c----- repeat bstr(4)
      e4=latmx
      cstr(4)='"'
      str(5)='RAW="'
      bstr(5)=datafn
      cstr(5)='"'
      str(6)='GRD="fullgrd.grd"'
      str(7)='GRD1="fullgrd1.grd"'
      str(8)='INT="-I'
      b8=grint
      bstr(8)='"'
      str(9)='TITLE="'
      bstr(9)=title
      cstr(9)='"'
      str(10)='COL=5'
      str(11)="nawk '{"
      str(12)=" if ($c>0.0) {"
      str(13)='  printf("%s %s %g^n", $3, $4, $c)'
      str(14)='  }'
      str(15)=" }' c=${COL} ${RAW} | xyz2grd ${RANGE} ${INT}"
      bstr(15)=' -G${GRD} #-N0.0'
      str(16)='grdsample ${GRD} -G${GRD1} -I0.05 -Lg -Q'
      str(17)='PROJ="-JT'
      b17=(longmn+longmx)/2.
      bstr(17)=';6.0i"'
      str(18)='ANOT="-B2f2WSne"'
      str(19)='FLAGS=" -X1.0i -Y2.5i -P -K "'
      str(20)='psbasemap ${RANGE} ${PROJ} -B2f2WSne'
      bstr(20)=':."${TITLE}":'
      cstr(20)=' ${FLAGS}'
      str(21)='FLAGS="-C${CPT} -O -K "'
      str(22)='grdimage ${GRD1} ${RANGE} ${PROJ} ${FLAGS}'
      if (col.eq.0)str(22)=
     1'#grdimage ${GRD1} ${RANGE} ${PROJ} ${FLAGS}'
      str(23)='FLAGS="-O -K -N1 -N3 -I1 -W3;0;0;0 -Di"'
      str(24)='pscoast ${RANGE} ${PROJ} ${FLAGS}'
      str(25)='FLAGS="  -O -P -K "'
      str(26)='psbasemap ${RANGE} ${PROJ} "${ANOT}" ${FLAGS}'
      str(27)='FLAGS="-O -K"'
      if (con2.eq.0)str(27)='FLAGS="-O"'
      str(28)='FLAGS2="-L -D3.0i;-2.5;6i;0.25ih"'
      str(29)='psscale ${FLAGS2} -C${CPT} ${FLAGS}'
      if (col.eq.0)str(29)='#psscale ${FLAGS2} -C${CPT} ${FLAGS}'
      bstr(29)=' -B:"Rate density":;:RTR:'
      if (rtrfl.eq.0)bstr(29)=' -B:"Rate density":;:km-2d-1:'
      str(30)='FLAGS3="-A50+s10 -Gd5c -T -Wc1.0p,- -Wa1.5p -O"'
      str(31)='grdcontour ${GRD1} ${RANGE} ${PROJ}'
      if(con2.eq.0)str(31)='#grdcontour ${GRD1} ${RANGE} ${PROJ}'
      bstr(31)=' -C${CONT} ${FLAGS3}'
      do j=1,31
           if (j.eq.4)then
              rewind(99)
              write(99,23)str(j)
              write(99,23)bstr(j)
              write(99,23)cstr(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              read(99,21)(astr2(i),i=1,72)
              lq2=lquery(astr2,72)
              read(99,21)(astr3(i),i=1,72)
              lq3=lquery(astr3,lq3)
              call shortn(astr1,lq1)
              call shortn(astr2,lq2)
              call shortn(astr3,lq3)
              do i=1,72
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr2(i).eq.";")astr2(i)="/"
                 if(astr3(i).eq.";")astr3(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
                 if(astr2(i).eq."^")astr2(i)=backsl
                 if(astr3(i).eq."^")astr3(i)=backsl
              enddo   
              rewind(99)
              write(99,*)b4
              write(99,*)c4
              write(99,*)d4
              write(99,*)e4
              rewind(99)
              read(99,21)(rstr1(i),i=1,72)
              rlq1=lquery(rstr1,72)
              read(99,21)(rstr2(i),i=1,72)
              rlq2=lquery(rstr2,72)
              read(99,21)(rstr3(i),i=1,72)
              rlq3=lquery(rstr3,72)
              read(99,21)(rstr4(i),i=1,72)
              rlq4=lquery(rstr4,72)
              rb1=0
              rb2=0
              rb3=0
              rb4=0
              do i=1,rlq1
                 if (rstr1(i).eq.' ')then 
                    rb1=i
                 else
              go to 10
              endif
              enddo
 10           do i=1,rlq2
                 if (rstr2(i).eq.' ')then 
                    rb2=i
                 else
                    go to 20
                 endif
              enddo
 20           do i=1,rlq3
                 if (rstr3(i).eq.' ')then 
                    rb3=i
                 else
                    go to 30
                 endif
              enddo
 30           do i=1,rlq4
                 if (rstr4(i).eq.' ')then 
                    rb4=i
                 else
                    go to 40
                 endif
              enddo
 40           continue
              write(nfile,22)(astr1(i),i=1,lq1),(rstr1(i),
     1        i=rb1+1,rlq1),(astr2(i),i=1,lq2),(rstr2(i),
     1        i=rb2+1,rlq2),(astr2(i),i=1,lq2),(rstr3(i),
     1        i=rb3+1,rlq3),(astr2(i),i=1,lq2),(rstr4(i),
     1        i=rb4+1,rlq4),(astr3(i),i=1,lq3)
           else if (j.eq.8)then
              rewind(99)
              write(99,23)str(j)
              write(99,23)bstr(j)
              write(99,23)cstr(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              read(99,21)(astr2(i),i=1,72)
              lq2=lquery(astr2,72)
              read(99,21)(astr3(i),i=1,72)
              lq3=lquery(astr3,72)
              call shortn(astr1,lq1)
              call shortn(astr2,lq2)
              call shortn(astr3,lq3)
              do i=1,72
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr2(i).eq.";")astr2(i)="/"
                 if(astr3(i).eq.";")astr3(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
                 if(astr2(i).eq."^")astr2(i)=backsl
                 if(astr3(i).eq."^")astr3(i)=backsl
              enddo   
              rewind(99)
              write(99,*)b8
              rewind(99)
              read(99,21)(rstr1(i),i=1,72)
              rlq1=lquery(rstr1,72)
              rb1=0
              do i=1,rlq1
                 if (rstr1(i).eq.' ')then 
                    rb1=i
                 else
                    go to 50
                 endif
              enddo
 50           continue
              write(nfile,22)(astr1(i),i=1,lq1),(rstr1(i),
     1        i=rb1+1,rlq1),(astr2(i),i=1,lq2)
           else if (j.eq.17)then
              rewind(99)
              write(99,23)str(j),bstr(j),cstr(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              read(99,21)(astr2(i),i=1,72)
              lq2=lquery(astr2,72)
              read(99,21)(astr3(i),i=1,72)
              lq3=lquery(astr3,72)
              call shortn(astr1,lq1)
              call shortn(astr2,lq2)
              call shortn(astr3,lq3)
              do i=1,72
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr2(i).eq.";")astr2(i)="/"
                 if(astr3(i).eq.";")astr3(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
                 if(astr2(i).eq."^")astr2(i)=backsl
                 if(astr3(i).eq."^")astr3(i)=backsl
              enddo   
              rewind(99)
              write(99,*)b17
              rewind(99)
              read(99,21) (rstr1(i),i=1,rlq1)
              rb1=0
              do i=1,rlq1
                 if (rstr1(i).eq.' ')then 
                    rb1=i
                 else
                    go to 60
                 endif
              enddo
 60           continue
              write(nfile,22)(astr1(i),i=1,lq1),(rstr1(i),
     1        i=rb1+1,rlq1),(astr2(i),i=1,lq2)
           else if (nstr(j).eq.3) then
              rewind(99)
c              write(6,*)str(j)
c              write(6,*)bstr(j)
c              write(6,*)cstr(j)
              write(99,23)str(j)
              write(99,23)bstr(j)
              write(99,23)cstr(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              read(99,21)(astr2(i),i=1,72)
              lq2=lquery(astr2,72)
              read(99,21)(astr3(i),i=1,72)
              lq3=lquery(astr3,72)
              call shortn(astr1,lq1)
              call shortn(astr2,lq2)
              call shortn(astr3,lq3)
              do i=1,72
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr2(i).eq.";")astr2(i)="/"
                 if(astr3(i).eq.";")astr3(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
                 if(astr2(i).eq."^")astr2(i)=backsl
                 if(astr3(i).eq."^")astr3(i)=backsl
              enddo   
              write(nfile,22)(astr1(i),i=1,lq1),(astr2(i),i=1,lq2),
     1             (astr3(i),i=1,lq3)
c              write(6,*)(astr1(i),i=1,lq1),(astr2(i),i=1,lq2),
c     1             (astr3(i),i=1,lq3)
 21           format(72a1)
 22           format(132a1)
 23           format(a72)
           else if (nstr(j).eq.2) then
              rewind(99)
c              write(6,*)str(j)
c              write(6,*)bstr(j)
              write(99,23)str(j)
              write(99,23)bstr(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              read(99,21)(astr2(i),i=1,72)
              lq2=lquery(astr2,72)
              call shortn(astr1,lq1)
              call shortn(astr2,lq2)
              do i=1,72
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr2(i).eq.";")astr2(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
                 if(astr2(i).eq."^")astr2(i)=backsl
              enddo   
              write(nfile,22)(astr1(i),i=1,lq1),(astr2(i),i=1,lq2)
c              write(6,*)(astr1(i),i=1,lq1),(astr2(i),i=1,lq2)
           else if (nstr(j).eq.1) then
              rewind(99)
c              write(6,*)str(j)
              write(99,23)str(j)
              rewind(99)
              read(99,21)(astr1(i),i=1,72)
              lq1=lquery(astr1,72)
              call shortn(astr1,lq1)
              do i=1,lq1
                 if(astr1(i).eq.";")astr1(i)="/"
                 if(astr1(i).eq."^")astr1(i)=backsl
              enddo   
              write(nfile,22)(astr1(i),i=1,lq1)
c              write(6,*)(astr1(i),i=1,lq1)
           endif   
      enddo
      return
      end

      subroutine shortn(astr,lq)
      implicit none
      character*1 astr(72)
      integer lq,i,n
      n=lq
      do i=n,1,-1
         if (astr(i).eq." ")then
            lq=lq-1
         else
            go to 10
         endif
      enddo
 10   continue
      return
      end
 
      character*72 function joinst(str1,str2)
      implicit none
      character*3 str1
      character*72 str2
      character*1 astr(72),bstr(72)
      integer lq1,lq2,i,lquery
c      write(6,*)"joinst str1 str2",str1,str2
      rewind(99)
 21   format(72a1)
 22   format(72a1)
 23   format(a72)
 24   format(a3)
      write(99,24)str1
      write(99,23)str2
      rewind(99)
c      write(6,*)"joinst flag1"
      read(99,21) (astr(i),i=1,72)
      lq1=lquery(astr,72)
c      write(6,*)"joinst flag1",lq1,(astr(i),i=1,lq1)
      read(99,21) (bstr(i),i=1,72)
      lq2=lquery(bstr,72)
c      write(6,*)"joinst flag2",lq2,(bstr(i),i=1,lq2)
c-----remove trailing blanks, if any
      call shortn(astr,lq1)
      call shortn(bstr,lq2)
c      write(6,*)"joinst flag3"
      write(99,22)(astr(i),i=1,lq1),(bstr(i),i=1,lq2)," ","/"
      backspace(99)
      read(99,*)joinst
      return
      end

      character*32 function ttlgen(modnm,xmag,yr,mth,dy)
      implicit none
      character*32 modnm
      character*1 astr(72),bstr(72)
      integer yr,mth,dy,lq,lq2,i,lquery
      real xmag
      rewind(99)
      write(99,21)modnm
      write(99,23)xmag,yr,mth,dy
      rewind(99)
c      write(6,*)"ttlgen flag1",modnm,xmag,yr,mth,dy
      read(99,22)(astr(i),i=1,72)
      lq=lquery(astr,72)
      read(99,22)(bstr(i),i=1,72)
      lq2=lquery(bstr,72)
      call shortn(astr,lq)
      call shortn(bstr,lq2)
c      write(6,*)"ttlgen flag2"
 21   format(a32)
 22   format(72a1)
 23   format(" M",f3.1,i5,"/",i2,"/",i2)
      rewind(99)
      write(99,22)(astr(i),i=1,lq),(bstr(i),i=1,lq2)
      rewind(99)
c      write(6,*)"ttlgen flag3"
      read(99,21) ttlgen
c      write(6,*)"ttlgen flag4"
      return
      end


      subroutine synyni(n,eta,mag,inflam,syn01)
c randomly decides how many offspring of eq i
      implicit none
      integer syn01(90000),n,k,i,j
      real mag(90000),beepas,rand,delgm2,balpha,zeta
      real eta(90000),addk,poissk,inflam(100,2),inflai
      real b,bt,bm,ba,a,d,s,c,p,deltam,w,bgdkj,probi,x
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
c call ceta(eta1,n,beepas,am,sigm,mueep,wbar,eta) must be in main
      do i=1,n
         x=rand()
         do j=1,100
            if (inflam(j,1).eq.mag(i)) inflai=inflam(j,2)
         enddo
         probi=w(i)*eta(i)*inflai
c         write(6,*)x,inflai,probi,i,n
         poissk=exp(-probi)
         if (x.le.exp(-probi)) then
            syn01(i)=0
         else
           k=0
           addk=exp(-probi)
 1         k=k+1
           addk=addk*probi/k
           poissk=poissk+addk
c           write(6,*)"k=",k,x,poissk
           if (x.le.poissk) then
              syn01(i)=k
           else
              go to 1
           endif
         endif
c         if (syn01(i).gt.0)write(17,*)i,x,probi,syn01(i)
      enddo
      return
      end

      subroutine norran(r1,r2,rn1,rn2)
      implicit none
      real r1,r2,rn1,rn2
      rn1=sqrt(-2.0*log(r1))*sin(2*3.14159*r2)
      rn2=sqrt(-2.0*log(r1))*cos(2*3.14159*r2)
      return
      end

      subroutine synteq(ti,mi,lati,longi,mc,cdfmag)
      implicit none
      integer i,j
      real rannum(4),ti,mi,lati,longi,mc,rannor(4)
      real tsyn,msyn,latsyn,lonsyn,degkm,maxmag,rand
      real b,bt,bm,ba,a,d,s,c,p,deltam,w,bgdkj,cdfmag(100,100)
      real am,sigm,at,sigt,siga,mueep,mag0,magi,beepas
      real delgm2,balpha,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(17,*)"entering synteq", ti,mi,lati,longi,mc
      degkm=111.0
      do i=1,4
         rannum(i)=rand()
      enddo
      call norran(rannum(1),rannum(2),rannor(1),rannor(2))
      call norran(rannum(3),rannum(4),rannor(3),rannor(4))
      tsyn=ti+10**(at+bt*mi+sigt*rannor(1))
      i=int((mi-mag0)/0.1+0.51)
c      write(6,*) "synteq i, ran, cdf", i,rannum(2),cdfmag(i,1)
      j=0
      msyn=mc+0.05
 1    j=j+1
      if (rannum(2).gt.cdfmag(i,j)) then
         msyn=msyn+0.1
c         write(6,*)i,j,cdfmag(i,j),msyn
         if (msyn.gt.maxmag) return
         go to 1
      endif   
      latsyn=lati+siga*sqrt(10**ba*mi)*rannor(3)/degkm
      lonsyn=longi+siga*sqrt(10**ba*mi)*rannor(4)/
     1(degkm*cos(lati*3.14159/180.0))
      if (msyn.ge.mc) write(17,21)tsyn,latsyn,lonsyn,msyn
c     1,(rannor(i),i=1,4)
 21   format(f10.3,2f10.2,f4.1,4f5.2)
      return
      end
      
      real function magden(m)
      implicit none
      real m,pnorml,x,g1m,b,bt,bm,ba,a,d,s,c,p,deltam,w,bgdkj
      real am,sigm,at,sigt,siga,mueep,mag0,magi,delm,maxmag
      real beepas,delgm2,balpha,zeta
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
c      write(6,*)"entering magden"
      x=(m-am-bm*mag0-sigm**2*b*log(10.))/sigm
      delm=pnorml(x,0.0,1.0)
c      delm=1.0
c      write(6,*)"got thru pnorm",m,magi,x,delm
      magden=g1m(m,magi,am,bm,sigm)/delm
      return
      end
      
      subroutine synset(minmag,inflam,cdfmag)
      implicit none
      real am,bm,sigm,at,sigt,siga,mueep,mag0,magi,x,y
      real inflam(100,2),cdfmag(100,100),minmag,maxmag
      real pnorml,simint,magden,upper,beepas
      real b,bt,ba,a,d,s,c,p,deltam,w,bgdkj,delgm2,balpha,zeta
      integer i,j 
      common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
     1bgdkj(90000),balpha,beepas,zeta
c     common/blocka/b,bt,bm,ba,a,d,s,c,p,deltam,delgm2,w(90000),
c    1bgdkj(90000),balpha,beepas,zeta
      common/blockf/am,sigm,at,sigt,siga,mueep,mag0,magi,maxmag
      external magden
c      write(6,*)"entering synset"
      i=0
 1    i=i+1
c      write(6,*)"i=",i
      magi=mag0+0.05+(i-1)*0.1
      if (magi.gt.maxmag)go to 2
      inflam(i,1)=magi
      x=simint(magden,minmag,maxmag)
      y=(maxmag-am-bm*magi)/sigm
      x=x+1.0-pnorml(y,0.0,1.0)
      inflam(i,2)=x
c      write(6,*) maxmag,am,bm,magi,sigm
c      write(6,*)"inflam",inflam(i,1),inflam(i,2),x,y
      j=0
 3    j=j+1
      upper=minmag+0.1*j
      if (upper.gt.maxmag) go to 1
      cdfmag(i,j)=simint(magden,minmag,upper)/inflam(i,2)
      go to 3
 2    continue
      do j=1,23
         write(14,*)(cdfmag(i,j),i=1,6)
      enddo
      return
      end
      
      subroutine combfl(nf1,nf2,mu,nf3)
c     reads expected no. eartquakes arrays from units nf1,nf2
c     and writes linear combination to unit nf3
      implicit none
      character*32 fn1,fn2
      real mu,cmnln1,cmxln1,cmnlt1,cmxlt1,mlo1,mhi1,expno1
      real cmnln2,cmxln2,cmnlt2,cmxlt2,mlo2,mhi2,expno2,expno3
      integer nf1,nf2,nf3,hlo1,hhi1,hlo2,hhi2,inpol1,inpol2
 1    read(nf1,*,end=99,err=189)cmnln1,
     1 cmxln1,cmnlt1,cmxlt1,hlo1,hhi1,mlo1,mhi1,expno1,inpol1
      read(nf2,*,end=99,err=199)cmnln2,
     1 cmxln2,cmnlt2,cmxlt2,hlo2,hhi2,mlo2,mhi2,expno2,inpol2
      if ((cmxln1.ne.cmxln2).or.(cmnln1.ne.cmnln2))go to 119
      if ((cmxlt1.ne.cmxlt2).or.(cmnlt1.ne.cmnlt2))go to 119
      if ((hlo1.ne.hlo2).or.(hhi1.ne.hhi2))go to 119
      if ((mlo1.ne.mlo2).or.(mhi1.ne.mhi2))go to 119
      if (inpol1.ne.inpol2) go to 119
      expno3=expno1+mu*expno2
      write(nf3,21)cmnln1,
     1 cmxln1,cmnlt1,cmxlt1,hlo1,hhi1,mlo1,mhi1,expno3,inpol1
 21   format(4f12.4,i4,i5,2f8.2,e14.4,i2)
      go to 1 
 99   continue
      return
 119  continue
      inquire(unit=nf1,name=fn1)
      inquire(unit=nf2,name=fn2)
      write(6,*)"Incompatible files ",fn1,"and ",fn2,". Exiting"
      stop
 189  continue
      inquire(unit=nf1,name=fn1)
      write(6,*)"Invalid format, file ",fn1,". Exiting"
      stop
 199  continue
      inquire(unit=nf2,name=fn2)
      write(6,*)"Invalid format, file ",fn2,". Exiting"
      stop
      end
      

      subroutine com2fl(nf1,nf2,mu,nf3)
c     reads rate density arrays from units nf1,nf2
c     and writes linear combination to unit nf3
      implicit none
      character*32 fn1,fn2
      real mu,cm1,xlong1,ct1,ylat1,rated1
      real cm2,xlong2,ct2,ylat2,rated2,rated3
      integer nf1,nf2,nf3
 1    read(nf1,*,end=99,err=189)ct1,cm1,xlong1,ylat1,rated1
      read(nf2,*,end=99,err=189)ct2,cm2,xlong2,ylat2,rated2
      if ((xlong1.ne.xlong2).or.(cm1.ne.cm2))go to 119
      if ((ylat1.ne.ylat2).or.(ct1.ne.ct2))go to 119
      rated3=rated1+mu*rated2
      write(nf3,*)ct1,cm1,xlong1,ylat1,rated3
      go to 1 
 99   continue
      return
 119  continue
      inquire(unit=nf1,name=fn1)
      inquire(unit=nf2,name=fn2)
      write(6,*)"Incompatible files ",fn1,"and ",fn2,". Exiting"
      stop
 189  continue
      inquire(unit=nf1,name=fn1)
      write(6,*)"Invalid format, file ",fn1,". Exiting"
      stop
 199  continue
      inquire(unit=nf2,name=fn2)
      write(6,*)"Invalid format, file ",fn2,". Exiting"
      stop
      end
      
      integer function lquery(a,n)
      integer n,lq
      character*1 a(n)
      lq=n
      do i=n,1,-1
         if (a(i).eq.' ')then
            lq=lq-1
         else
            go to 99
         endif
      enddo
 99   continue
      lquery=lq
      end


      subroutine sort2(x,y,n,order)
c sorts the first n elements of x into ascending order and stores in y
      real*4 x(1000),y(1000)
      integer n,order(1000)
      do i=1,n
         order(i)=0
         do j=1,n
            if((x(i).gt.x(j)).or.((x(i).eq.x(j)).and.(i.ge.j))) 
     1       order(i)=order(i)+1
         enddo
         y(order(i))=x(i)
      enddo
      return
      end

      subroutine reord(x,y,n,order)
c sorts the first n elements of x into order and stores in y
      real*4 x(1000),y(1000)
      integer n,order(1000)
      do i=1,n
         y(order(i))=x(i)
      enddo
      return
      end

      subroutine adtime(t,start,yr,mth,dy,hr,mn,sec)
      implicit none
      real t,sec,ti
      integer nd(12),yr,mth,dy,hr,mn,start,i,ndays
      data nd/31,28,31,30,31,30,31,31,30,31,30,31/
      yr=start
      ti=t
 1    if(ti.le.ndays(yr))then
         go to 2
      else
         ti=ti-ndays(yr)
         yr=yr+1
         go to 1
      endif
 2    if (ndays(yr).eq.366) then
         nd(2)=29
      else
         nd(2)=28
      endif   
c      write(11,*) yr,nd(2)
      mth=1
      do i=1,11
         if(ti.le.nd(i))then
            go to 3
         else
            ti=ti-nd(i)
            mth=mth+1
         endif
      enddo
 3    dy=int(ti)+1
      ti=ti-dy+1
      hr=int(ti*24.0)
      ti=ti-hr/24.0
      mn=int(ti*24.0*60.0)
      ti=ti-mn/(24.0*60.0)
      sec=ti*(24.*60.*60.)
      return
      end
      
      subroutine cstep(n,lat,long,yr,mth,dy,hr,mnt,mag,bgdkj,step,
     1option)
      implicit none
      integer n,i,yr(90000),mth(90000),dy(90000),hr(90000)
      integer mnt(90000),year,month,day,hour,minute,option
      real mag(90000),step(90000),yeardc,lattd,lontd,magtd,expno
      real second,lat(90000),long(90000),bgdkj(90000)
      i=0
 1    read(16,*,end=99,err=199)lattd,lontd,magtd,yeardc,month,
     1 day,hour,minute,second,expno
      year=int(yeardc)
 2    i=i+1
      if(i.gt.n)then
         write(6,*)"ERROR: subroutine cstep, EXITING"
         write(6,*)"Record does not match any eq in catalogue"
         write(6,*)lattd,lontd,magtd,year,month,day,hour,minute
         write(6,*)"n=",n,"i=",i
         STOP
      endif   
      if((year.eq.yr(i)).and.(month.eq.mth(i)).and.(day.eq.dy(i))
     1 .and.(hour.eq.hr(i)).and.(minute.eq.mnt(i)).and.
     1 (abs(lattd-lat(i)).le.0.02).and.(abs(lontd-long(i))
     1 .le.0.02).and.(abs(magtd-mag(i)).le.0.05)) then
         step(i)=10.*expno/(111.0**2*0.1*0.1*
     1   cos(3.14159*lattd/180.))
          write(11,*)i,yr(i),mth(i),dy(i),mag(i),step(i)
          if (option.eq.1)then
           if(step(i).eq.0.)step(i)=bgdkj(i)
          endif
         go to 1
      else
         step(i)=bgdkj(i)
         go to 2
      endif
 199  write(6,*)"ERROR: subroutine cstep, EXITING"
      write(6,*)"Invalid format in input data file"
 99   continue
      if (i.eq.0)then
         write(6,*) "ERROR: subroutine cstep,EXITING"
         write(6,*) "Input data file is empty"
         STOP
      endif   
      return
      end
      
