"""
Module EEPAS1RModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

from EEPASModel import EEPASModel


#--------------------------------------------------------------------------------
#
# EEPAS-1R forecast model.
#
# This class is designed to invoke three-months EEPAS forecast model. 
# It uses 'eepas_1r.par' configuration for the run. It has model weights
# enabled.
#
class EEPAS1RModel (EEPASModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = EEPASModel.Type + "-1R"
    
    
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for EEPAS1RModel class"""
        
        use_weigths = 1
        EEPASModel.__init__(self, dir_path, args, "nzeepas_1r.par", use_weigths)
        

    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type

