"""
Module ERDEEP0FModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import os
from EEPASModel import EEPASModel


#--------------------------------------------------------------------------------
#
# ERDEEP0F forecast model.
#
# This class is designed to invoke three-months EEPAS forecast model. 
# It uses 'eepas_0r.par' configuration for the run. It has model weights
# disabled.
#
class ERDEEP0FModel (EEPASModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = EEPASModel.Type + "-ERDEEP0F"
    
    __executable = "eepasof21sg77" 
    __grid = "ERDGRID"
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for ERDEEP0FModel class"""
        
        EEPASModel.__init__(self, dir_path, args, "nzerdeep.par","0")
        #EEPASModel.__init__(self, dir_path, args, "nzerdeep.par")
        
    def executableFile (self):
        """ Returns the executable file of the EEPAS model."""

        return self.__executable

    def gridFile (self):
        """ Returns the grid file of the EEPAS model."""

        return self.__grid

    def writeLocSeis (self, fhandle):
        """ Writes local seismicity rate, only needed in ERDEEP."""

        fhandle.write("WEIGHTS\n")
        fhandle.write("1\n")
        fhandle.write("PARAMETERS\n")
        fhandle.write("'%s'  /\n" \
                      %os.path.join(EEPASModel._execPath, 'nzerdeep_prelim.par'))
        fhandle.write("COMP\n")
        fhandle.write("LOCR\n")

        return fhandle







    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type

        
