controlFile = Sys.getenv("CONTROLFILE")
origin = "1970/01/01"
require(chron, quietly = TRUE)
require(ssBase, quietly = TRUE)
params <- scan(file=controlFile, what = integer(0), nlines=1, quiet = TRUE)
catstart <- julian(x = params[2], d = params[1], y = params[3])
params <- scan(file = controlFile, what = integer(0), skip = 1, nlines = 1,
  quiet = TRUE)
catend <- julian(x = params[2], d = params[1], y = params[3])
ndays <- scan(file = controlFile, what = numeric(0), skip = 2, nlines = 1,
  quiet = TRUE)
catfile <- scan(file = controlFile, what = "", skip = 3, nlines = 1,
  quiet = TRUE)
outfile <- scan(file = controlFile, what = "", skip = 4, nlines = 1,
  quiet = TRUE)
testArea <- scan(file = controlFile, what = "", skip = 5, nlines = 1,
  quiet = TRUE)

cat("Catalogue start:", format(as.POSIXlt(catstart*24*3600, origin=origin,
  tz = "NZDT")), "\n")
cat("Catalogue end:", format(as.POSIXct((catend)*24*3600, origin=origin,
  tz = "NZDT")), "\n")
ForecastPeriod <- paste(format(as.POSIXct((catend + 1)*24*3600,
  origin=origin, tz = "NZDT"), format = "%F %T"), "-",
  format(as.POSIXct((catend + ndays)*24*3600 - 1, origin=origin,
  tz = "NZDT"), format = "%F %T"))
cat("Forecast period:", ForecastPeriod, "\n")
cat("Forecast length:", ndays, "\n")
