`sequence` <-
function() {
  thisdate <- as.POSIXlt(Sys.time())
  thisyear <- thisdate$year %% 100
  thismonth <- thisdate$mon + 1
  thisday <- thisdate$mday
  return(thisyear*10000 + thismonth*100 + thisday)
}

`output` <- 
function(result, file="testResults.xml") {
  origin = "1970/01/01"
  lat <- tcentres$latitude
  lon <- tcentres$longitude
  minmag <- 5; maxmag <- 9
  sink(file)
# <?xml version='1.0' encoding='UTF-8'?>
  cat("<?xml version='1.0' encoding='UTF-8'?>\n")
# <CSEPForecast xmlns='http://www.scec.org/xml-ns/csep/forecast/0.1'>
  cat("<CSEPForecast xmlns='http://www.scec.org/xml-ns/csep/forecast/0.1'>\n")
#   <forecastData publicID='smi:org.scec/csep/forecast/1'>
  cat(paste("  <forecastData publicID='smi:nz.cri.gns/csep/forecast/",
    sequence(), "'>", sep=""), "\n")
#     <modelName>unknown</modelName>
  cat("    <modelName>M8</modelName>\n")
#     <version>1.0</version>
  cat("    <version>1.0</version>\n")
#     <author>CSEP</author>
  cat("    <author>SRA</author>\n")
#     <issueDate>2005-06-18T10:30:00Z</issueDate>
  Today <- as.POSIXlt(Sys.time())
  cat(paste("    <issueDate>", sub('$', "Z", sub(" ", "T", format(Today))),
    "</issueDate>\n", sep=""))
#     <forecastStartDate>2006-01-01T00:00:00Z</forecastStartDate>
  cat(paste("    <forecastStartDate>", sub('$', "Z", sub(" ", "T",
    format(as.POSIXct((catend + 1)*24*3600, origin=origin, tz="NZDT"),
    format = "%F %T"))), "</forecastStartDate>\n", sep=""))
#     <forecastEndDate>2011-01-01T00:00:00Z</forecastEndDate>
  cat(paste("    <forecastEndDate>", sub('$', "Z", sub(" ", "T", 
    format(as.POSIXct((catend + ndays)*24*3600 - 1, origin=origin,
    tz="NZDT"), format = "%F %T"))), "</forecastEndDate>\n", sep=""))
#     <defaultCellDimension latRange='0.1' lonRange='0.1'/>
  cat("    <defaultCellDimension latRange='0.1' lonRange='0.1'/>\n")
#     <defaultMagBinDimension>0.1</defaultMagBinDimension>
  cat("    <defaultMagBinDimension>0.1</defaultMagBinDimension>\n")
#     <lastMagBinOpen>1</lastMagBinOpen>
  cat("    <lastMagBinOpen>1</lastMagBinOpen>\n")
#     <depthLayer max='30.0' min='0.0'>
  cat("    <depthLayer max='40.0' min='0.0'>\n")
  nmag <- round((maxmag - minmag)*10) + 1
  for (i in 1:length(lat)) {
    cat(paste("      <cell lat='", lat[i],"' lon='", lon[i], "'>\n", sep=""))
    p0 <- result[i]
    if (is.na(p0)) {
      p <- rep(0, nmag)
    } else {
      p <- p0*ndays/183*(exp(-seq(minmag - 0.05, maxmag - 0.05 ,0.1)) -
        exp(-seq(minmag + 0.05, maxmag + 0.05, 0.1)))/exp(-M1)
    }
    for(j in 1:nmag) {
      cat(paste("	<bin m='",
        format(minmag + (j - 1)*0.1, nsmall=1), "'>",
        format(p[j], digits = 4, nsmall=1), "</bin>\n", sep=""))
    }
    cat("      </cell>\n")
  }
  cat("    </depthLayer>\n")
  cat("  </forecastData>\n")
  cat("</CSEPForecast>\n")
  sink()
}
