### Name: subsetpolygon
### Title: Polygon Subset of Events
### Aliases: subset.polygon subsetpolygon
### Keywords: manip

### ** Examples

#  Select events from NZ55 within following polygon
polylong <- c(173.8, 174.3, 174.8, 174.4, 174.8, 175.6,175,174.5)
polylat <- c(-41.5, -40.5, -40.9, -41, -41.4, -41, -41.8, -41.25)

data(NZ55)
a <- subsetpolygon(NZ55, polylong, polylat)

#  plot points within polygon
plot(NZ55$longitude[a$indices], NZ55$latitude[a$indices], cex=2,
     xlim=range(polylong), ylim=range(polylat), pch=16, col="red")
points(c(polylong,polylong[1]), c(polylat, polylat[1]), type='l', lty=2)



