### Name: bvalue.contour
### Title: b-Value Contours at Specified Depth
### Aliases: bvalue.contour
### Keywords: hplot

### ** Examples

#    This example requires the NZ catalogue

require(ssNZ)

#   Remember the parameters of the graphics device
par.reset <- par(no.readonly=TRUE)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

b <- subsetrect(Wellington, maxdepth=100, minmag=3,
                minlat=-42.2, maxlat=-40.5, minlong=173.6, maxlong=176.0,
                minday=julian(1,1,1980), maxday=julian(1,1,2000))

par(pty="s")
bvalue.contour(b, h=c(0.25, 0.2, 2), depth=10)
map("nz", add=TRUE, col="red")
par(par.reset)



