### Name: epicentres
### Title: Epicentral Plot of Selected Events
### Aliases: epicentres
### Keywords: hplot

### ** Examples

#   Remember the parameters of the graphics device

par.reset <- par(no.readonly=TRUE)

#--------------------------------------------------------------------

#    Here the data are contained in a matrix

data <- cbind(latitude=c( -41.70, -39.30, -40.50, -30.62, -28.42, -32.31),
              longitude=c(172.20,  177.00, 175.50, 178.42, 179.97, 181.21),
              depth=c(20, 30, 45, 12, 300, 339),
              magnitude=c(7.8, 7.8, 7.6, 7.4, 7.4, 7.9))

epicentres(data, usr=c(172, 182, -42, -28), cex=2, mapname="nz")
par(par.reset)

#--------------------------------------------------------------------

#    Here the data are contained in a catalogue

data(NZ55)

epicentres(NZ55, mapname="nz")
title(main="Some Large NZ Events")
par(par.reset)

#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

b <- subsetrect(Wellington, minlong=173.6, maxlong=176.0, minlat=-42.1,
                 maxlat=-40.5, mindepth=36, minday=julian(1,1,1988),
                 maxday=julian(1,1,1993))

#   Note that usr specifies the area in the plot
epicentres(b, usr=c(b$minlong-0.01, b$maxlong+0.01,
                    b$minlat-0.005, b$maxlat+0.005),
           depth=c(36, 50, 70, 100, 150, Inf), criteria=FALSE,
           magnitude=c(2, 3, 4, 5, 6, Inf), mapname="nz")
title(sub=expression(paste("Depth (km):  ", 36 <= {red < {50 <= 
      {yellow < {70 <= {green < {100 <= {cyan < {150 <= {blue <
      infinity}}}}}}}}})), line=3)
title(main="Wellington Catalogue:  Deep Events")
par(par.reset)

#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

b <- subsetrect(Wellington, minlong=173.6, maxlong=176.0, minlat=-42.1,
                 maxlat=-40.5, maxdepth=35.99, minday=julian(1,1,1988),
                 maxday=julian(1,1,1993))

#   Note that usr specifies the area in the plot
epicentres(b, usr=c(b$minlong-0.01, b$maxlong+0.01,
                    b$minlat-0.005, b$maxlat+0.005),
           depth=c(0, 10, 15, 20, 25, 36), criteria=FALSE,
           magnitude=c(2, 3, 4, 5, 6, Inf), mapname="nz")
title(sub=expression(paste("Depth (km):  ", 0 <= {red < {10 <= 
      {yellow < {15 <= {green < {20 <= {cyan < {25 <= {blue < 36}}}}}}}}})),
      line=3)
title(main="Wellington Catalogue:  Shallow Events")
par(par.reset)

#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

b <- subsetrect(NZ, minlong=166, maxlong=180, minlat=-48,
                 maxlat=-34, minmag=3, minday=julian(1,1,1970),
                 maxday=julian(1,1,1993), mindepth=36)

epicentres(b, depth=c(36, 70, 100, 140, 200, Inf), criteria=FALSE,
           usr=c(b$minlong, b$maxlong, b$minlat, b$maxlat), mapname="nz")
title(sub=expression(paste("Depth (km):  ", 36 <= {red < {70 <= 
      {yellow < {100 <= {green < {140 <= {cyan < {200 <= {blue <
      infinity}}}}}}}}})), line=3, cex.sub=0.95)
title(main="NZ Catalogue:  Deep Events")
par(par.reset)

#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

b <- subsetcircle(NZ, centrelong=176.8, centrelat=-37.8,
                   minmag=3, minday=julian(1,1,1987),
                   maxday=julian(1,1,1988), maxradius=100)

epicentres(b, cex=1.3, mapname="nz")
title(main="Edgecumbe Earthquake")
par(par.reset)

#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

b <- subsetcircle(NZ, centrelong=177.5, centrelat=-37,
                   minmag=3, minday=julian(1,1,1984),
                   maxday=julian(1,1,1986), maxradius=100)

epicentres(b, cex=1.5, mapname="nz")
title(main="Bay of Plenty Swarm")
par(par.reset)
    
#--------------------------------------------------------------------

#    Requires the NZ Catalogue
require(ssNZ)

b <- subsetcircle(NZ, centrelong=176.4, centrelat=-40.4,
                   minmag=3, minday=julian(1,1,1990),
                   maxday=julian(1,1,1991), maxradius=50)

epicentres(b, cex=1.5, mapname="nz")
title(main="Weber (Dannevirke) Earthquake")
par(par.reset)



