### Name: est.kagan
### Title: Estimate Parameters of Kagan Distribution
### Aliases: est.kagan
### Keywords: distribution

### ** Examples

estimate.alph <- NULL
for (i in 1:100)
{
    # follow Kagan distribution, using default parameters.
    stress <- rkagan(1000, mag = FALSE) # simulate data set of stress which
    # when alpha is unknown.
    alpha <- est.kagan(stress, alpha = NA, Mag = FALSE) # estimate alpha,
    estimate.alph <- rbind(estimate.alph, alpha)
}

# Get distribution of alpha estimated from the 100 samples.  This
# way, we could know possible distance between estimated one
# and real one. 
hist(estimate.alph[, 1], xlab="Alpha", ylab="Frequency", main="")
box()



