### Name: rotation
### Title: Rotates Events to View Plate Boundary
### Aliases: rotation
### Keywords: hplot

### ** Examples

#    These examples require the NZ catalogue

require(ssNZ)
b <- subsetrect(NZ, minlong=170, maxlong=180, minlat=-43,
                 maxlat=-35, minmag=3, minday=julian(1,1,1970),
                 maxday=julian(1,1,1993))

rotation(b, theta=-47)
title(main="NZ Plate Boundary")

#--------------------------------------------------------------------

#   Make the Wellington Catalogue
require(ssNZ)
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")
    
b <- subsetrect(Wellington, minlong=173.6, maxlong=176.1, minlat=-42.0,
                maxlat=-40.3, minmag=2, minday=julian(1,1,1978),
                maxday=julian(1,1,1992), maxdepth=200)

rotation(b, theta=-40, km=FALSE)
title(main="Wellington Plate Boundary")



