### Name: threeD
### Title: Dynamic 3D Plot of Earthquake Hypocentres
### Aliases: threeD
### Keywords: dynamic

### ** Examples

#    This example requires the NZ catalogue

require(ssNZ)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

#   Cape Palliser Sequence
b <- subsetcircle(Wellington, centrelong=175.5, centrelat=-41.65,
                   maxradius=20, minday=julian(1,1,1990),
                   maxday=julian(1,1,1993), maxdepth=40)

threeD(b)



