### Name: M8.series
### Title: Calculates the Seven M8 Series
### Aliases: M8.series
### Keywords: ts

### ** Examples

#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

temp <- M8.series(NZ.mainshocks, M0=7.0, minday=julian(y=1965, x=1, d=1),
                  start.series=julian(y=1975, x=1, d=1), centrelong=176, 
                  centrelat=-39, end.training=julian(y=2000, x=1, d=1))

print(temp$series)



