### Name: plot.M8
### Title: Plot M8 Series
### Aliases: plot.M8
### Keywords: methods hplot

### ** Examples

#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

temp <- M8(NZ.mainshocks, M0=7.0, minday=julian(y=1965, x=1, d=1),
           start.series=julian(y=1975, x=1, d=1), centrelong=176, 
           centrelat=-39, end.training=julian(y=2000, x=1, d=1),
           plotit=FALSE)

savpar <- par(no.readonly=TRUE)
plot(temp, title="M8 Analysis of NZ events")
par(savpar)



