emp.cdf                 package:ssM8                 R Documentation

_E_m_p_i_r_i_c_a_l _C_u_m_u_l_a_t_i_v_e _D_i_s_t_r_i_b_u_t_i_o_n _F_u_n_c_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates the empirical cumulative probability distribution
     function. This is the inverse function of 'quantile'.

_U_s_a_g_e:

     emp.cdf(x, q)

_A_r_g_u_m_e_n_t_s:

       x: is a vector containing the sample data.

       q: is a vector of points where the function is to be evaluated.

_D_e_t_a_i_l_s:

     This function is an _exact_ inverse of the 'quantile' function
     when the points in 'q' are contained in 'x'. This is not the case
     for the function 'ecdf'.

     For example, say 'x' contains 11 unique points. Then according to
     the 'quantile' function, the minimum represents the zero-th
     quantile, and the remaining sorted values represent the 10%ile,
     20%ile, 30%ile, up to 100%ile. The function 'emp.cdf' has been
     defined to be consistent with this.

     This consistency is important for the evaluation of the M8
     algorithm. The TIP declaration within the function 'M8.TIP' is
     calculated by two different methods, one using the 'quantile'
     function, and the other based on the empirical cumulative
     probability distribution function. If they are not consistent then
     the time point of the TIP declaration can be different between the
     two methods.

_V_a_l_u_e:

     A vector of the same length as 'q', containing the cumulative
     probabilities.

_A_u_t_h_o_r(_s):

     David Harte, 2005

_S_e_e _A_l_s_o:

     'quantile', 'ecdf'

_E_x_a_m_p_l_e_s:

     n <- 10
     x <- rep(0:n, 1)
     print(quantile(x, probs=seq(0, 1, 1/n)))
     print(emp.cdf(x, x))

     n <- 12
     x <- rep(0:n, 3)
     print(quantile(x, probs=seq(0, 1, 1/n)))
     print(emp.cdf(x, x))

     n <- 12
     x <- rnorm(n+1)
     print(quantile(x, probs=seq(0, 1, 1/n)))
     print(sort(x))
     print(emp.cdf(x, sort(x)))

