#!/bin/tcsh

#
# Run Dispatcher for RELM Mainshock models evaluation
#

source /home/csep/.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`


# Capture all output produced by Dispatcher into the daily log file
set logdir=/data/csep/dispatcher/logs/"$year"_"$month"
mkdir -p "$logdir"

set logfile="$logdir"/mainshock_"$year-$month-$day"

# Invoke Dispatcher for "today" (with 31-day delay for the testing date):
nohup python $CENTERCODE/src/generic/Dispatcher.py --year="$year" --month="$month" --day="$day" --configFile=/home/csep/NewZealandCode/configuration/crontab/dispatcher_five_years.init.xml --waitingPeriod=31 --enableForecastXMLTemplate --enableForecastMap --numDeclusterSimulations=0 --numVariationsSimulations=0 --numVariationsSimulations=0 --logFile="$logfile" >& "$logfile" & 
