#!/bin/tcsh

# dispatcher_daily.csh:
#
# Run daily Dispatcher for one day models generation and evaluation
#

source /home/csep/.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`


# Capture all output produced by Dispatcher into the daily log file
set logdir=/data/csep/dispatcher/logs/"$year"_"$month"
mkdir -p "$logdir"

set logfile=$logdir/daily_"$year-$month-$day"


# Invoke Dispatcher for "today" (with 31 day delay for the testing date):
nohup python $CENTERCODE/src/generic/Dispatcher.py --year="$year" --month="$month" --day="$day" --configFile=/home/csep/NewZealandCode/configuration/crontab/dispatcher_daily.init.xml --waitingPeriod=31 --enableForecastXMLTemplate --enableForecastMap --numDeclusterSimulations=0 --numVariationsSimulations=0 --publishServer=csep-nz@cseppublishing.usc.edu --publishDirectory=/export/cseppublishing/csep/nz/results/data/nz/gns --logFile="$logfile" >& "$logfile" &


