#!/bin/tcsh

# dispatcher_six_months.csh:
#
# Run daily Dispatcher for six months models generation and evaluation
#

source /home/csep/.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`


# Capture all output produced by Dispatcher into the daily log file
set logdir=/data/csep/dispatcher/logs/"$year"_"$month"
mkdir -p "$logdir"

set logfile="$logdir"/six_months_"$year-$month-$day"


# Invoke Dispatcher for "today" (with 34 day delay for the testing date - to generate initial forecasts with start date of 12/01/2007):
nohup python $CENTERCODE/src/generic/Dispatcher.py --year="$year" --month="$month" --day="$day" --configFile=/home/csep/NewZealandCode/configuration/crontab/dispatcher_six_months.init.xml --waitingPeriod=31 --enableForecastXMLTemplate --enableForecastMap  --numDeclusterSimulations=0 --numVariationsSimulations=0 --publishServer=csep-nz@cseppublishing.usc.edu --publishDirectory=/export/cseppublishing/csep/nz/results/data/nz/gns --logFile="$logfile" >& "$logfile" & 

