"M8" <-
function(catalogue, M0, centrelong = mean(catalogue[, "longitude"]), centrelat
	 = mean(catalogue[, "latitude"]), radius = radius.M8default(M0), minday
	 = catalogue[1, "time"], start.series = datetimes(year = (years1(
	minday) + 12), month = 1, day = 1, hour = 0, minute = 0), 
	training = "user", end.training = NA, time.breaks = Inf, running.total
	 = 12, smoother = 6, TIP.length = 10, plotit = TRUE, title = 
	"M8 Series and TIPs", debug = FALSE)
{
	cat("\n")
	cat("##################################################\n")
	cat("#                  M8()                          #\n")
	cat("##################################################\n")
	attributes(minday) <- attributes(catalogue[, "time"])
	attributes(start.series) <- attributes(catalogue[, "time"])
	attributes(end.training) <- attributes(catalogue[, "time"])
	cat("M0 =", M0, "\n")
	cat("(longitude, latitude) = (", centrelong, ",", centrelat, ")\n")
	cat("radius =", radius, "\n")
	cat("Reliable data start after : ", format(minday), "\n")
	cat("Series start at           : ", format(start.series), "\n")
	cat("Training method\t       : ", training, "\n")
	cat("Training end at           : ", format(end.training), "\n")
	if(!is.data.frame(catalogue) || !any(names(catalogue) == 
		"n.aftershocks")) {
		stop("Please use decluster.M8() function to get mainshocks\n")
	}
	if(time.breaks == Inf & training == "user") {
		if(!(months1(start.series) == 1 | months1(start.series) == 7) | 
			!
			days1(start.series == 1))
			stop("'start.series' does not correspond to the first day of Jan or July.  This is a requirement \nfor 'start.series' AND end.training'"
				)
		if(!(months1(end.training) == 1 | months1(end.training) == 7) | 
			!
			days1(end.training == 1))
			stop("'end.training' does not correspond to the first day of Jan or July"
				)
	}
	if(time.breaks != Inf | running.total != 12 | smoother != 6)
		cat("The default parameters of M8 have been altered - please make sure the parameters are \ncompatible\n"
			)
	if(minday != min(catalogue[, "time"])) catalogue <- catalogue[catalogue[
			, "time"] >= minday,  ]	
	# Get the 7 M8 series and max magnitude in every half year
	series <- M8.series(catalogue = catalogue, M0 = M0, centrelong = 
		centrelong, centrelat = centrelat, radius = radius, minday = 
		minday, start.series = start.series, training = training, 
		end.training = end.training, debug = debug)
	# Generate tips
	if(!is.character(series)) {
		res <- M8.TIP(series, M0, training = training, end.training = 
			end.training, smoother = smoother, TIP.length = 
			TIP.length, debug = debug)
		if(plotit) {
			plot.M8(res, title = title)
		}
		return(res)
	}
	else {
		cat("\n!!!Result not available.\n")
		return("Result not available.")
	}
}


