"M8.TIP" <-
function (series, M0, training = "user", end.training = NA, smoother = 6, 
    TIP.length = 10, debug = FALSE) 
{
    cat("\n\n")
    cat("##################################################\n")
    cat("#                  M8.TIP()                      #\n")
    cat("##################################################\n")
    # The series matrix, 1:7 columns are the 7 series
    x <- series$series
    if(nrow(x)/2 < 7) stoptmp(
        "Not enough years of data to generate TIP!!\n")	
    #   Top quantile used as critical points for each series
    alpha <- c(0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.25)
    #   Number of half years in the series
    n <- nrow(x)
    #   Maximum event in each half year
    max.mag <- series$max.events[, "magnitude"]
    #   top alpha percent of history, just initialise
    tops <- matrix(NA, nrow=n, ncol=7)
    attributes(tops) <- attributes(x[,1:7])
    #   boolean for crossing history top, just initialise
    exceeds <- matrix(FALSE, nrow=n, ncol=7)
    attributes(exceeds) <- attributes(x[,1:7])
    #   The percentile of each series value, just initialise
    percent <- matrix(NA, nrow=n, ncol=7)
    attributes(percent) <- attributes(x[,1:7])
    #   the maximum of percent in past 3 years (6 half years)
    percent.3years <- matrix(NA, nrow=n, ncol=7)
    attributes(percent.3years) <- attributes(x[,1:7])
    #   The second smallest of 1:6 columns of percent.3years, just initialise
    percent6 <- rep(NA, n)
    attributes(percent6) <- attributes(x[,1])
    #   Initialise the critical series
    percent.all <- rep(NA, n)
    attributes(percent.all) <- attributes(x[,1])
    #   Number different types of measures 
    #   exceded top in the past 3 years
    g <- rep(0, n)
    attributes(g) <- attributes(x[,1])
    #   Number of measures exceded top in the past 3 years
    h <- rep(0, n)
    attributes(h) <- attributes(x[,1])
    #   TIP status
    TIP <- rep(FALSE, n)
    attributes(TIP) <- attributes(x[,1])
    #   TIP type
    TIP.type <- rep("", n)
    for (j in 1:7) {
#       ord <- order(-x[, j])
#       above was used to calc quantiles contained in tops
#       wrong for "moving" and "user", see below.
        xj <- as.vector(x[, j])
        if (training == "moving") {
            tops[1:6, j] <- NA
            percent[1:n, j] <- NA
#           for (i in 7:n) tops[i, j] <- xj[ord[ord < i]][ceiling((i - 
#                1) * alpha[j])]
            for (ii in 7:n){
                tops[ii,j] <- quantile(xj[1:(ii-1)], probs=1-alpha[j])
                percent[ii, j] <- emp.cdf(x[1:(ii-1), j], x[ii, j])
            }
            exceeds[1:6, ] <- FALSE
            exceeds[7:n, j] <- (x[7:n, j] >= tops[7:n, j])
            for (ii in 1:n) percent.3years[ii, j] <- max(percent[max(1, 
                (ii - (smoother - 1))):ii, j])
#           percent.3years <- NULL
        }
        else if (training == "all") {
#           tops[1:n, j] <- xj[ord][ceiling(n * alpha[j])]
            tops[1:n, j] <- quantile(xj[1:n], probs=1-alpha[j])
            exceeds[1:n, j] <- (x[1:n, j] >= tops[1:n, j])
            percent[1:n, j] <- emp.cdf(x[1:n, j], x[1:n, j])
            for (ii in 1:n) percent.3years[ii, j] <- max(percent[max(1, 
                (ii - (smoother - 1))):ii, j])
        }
        else if (training == "user") {
            i <- firstGE(x[, "time"], end.training)
#           tops[1:n, j] <- xj[ord[ord < i]][ceiling(i * alpha[j])]
            tops[1:n, j] <- quantile(xj[1:i], probs=1-alpha[j])
            exceeds[1:n, j] <- (x[1:n, j] >= tops[1:n, j])
            percent[1:n, j] <- emp.cdf(x[1:i, j], x[1:n, j])
            for (ii in 1:n) percent.3years[ii, j] <- max(percent[max(1, 
                (ii - (smoother - 1))):ii, j])
        }
        else {
            stop(paste("Unknown value for training: ", training))
        }
        if (debug) {
            cat("\n\n--------- Series", j, "-----------\n")
            print(cbind(original.series = x[7:n, j], history.tops = tops[7:n, 
                j], exceeds = exceeds[7:n, j]))
        }
    }
    if (training == "moving") {
        g[1:6] <- 0
        h[1:6] <- 0
        TIP[1:7] <- NA
        TIP.type[1:7] <- ""
        i.TIP <- 7
    }
    else if (training == "user" || training == "all") {
        i.TIP <- 1
        TIP[1] <- NA
        TIP.type[1] <- ""
    }
    for (i in i.TIP:n) {
        options(warn = -1)
        g[i] <- ((sum(exceeds[max(c(i - 5, 1)):i, 1:2]) > 0) + 
            (sum(exceeds[max(c(i - 5, 1)):i, 3:4]) > 0) + (sum(exceeds[max(c(i - 
            5, 1)):i, 5:6]) > 0) + (sum(exceeds[max(c(i - 5, 
            1)):i, 7]) > 0))
        h[i] <- sum(apply(exceeds[max(c(i - 5, 1)):i, , drop = FALSE], 
            2, sum) > 0)
        percent6[i] <- sort(as.vector(percent.3years[i, 1:6]))[2]
        percent.all[i] <- min(c(percent6[i] - (1-alpha[1]),
                              percent.3years[i, 7] - (1-alpha[7])))
        options(warn = 0)
        if (i > i.TIP && g[i] >= 4 && h[i] >= 6 && g[i - 1] >= 
            4 && h[i - 1] >= 6) {
            TIP[i:min(c(i + (TIP.length - 1), n))] <- TRUE
            if (max(max.mag[(i - 1):i]) >= M0) {
                TIP.type[i:min(c(i + (TIP.length - 1), n))] <- "c.e."
            }
            else if (i < n && max(max.mag[(i + 1):min(c(n, i + 
                TIP.length))]) >= M0) {
                TIP.type[i:min(c(i + (TIP.length - 1), n))] <- "STIP"
            }
            else if (i < n && max(max.mag[(i + 1):min(c(n, i + 
                TIP.length))]) >= M0 - 0.5) {
                TIP.type[i:min(c(i + (TIP.length - 1), n))] <- "STIP-"
            }
            else if (i + (TIP.length - 1) >= n) {
                TIP.type[i:min(c(i + (TIP.length - 1), n))] <- "CTIP"
            }
            else {
                TIP.type[i:(i + (TIP.length - 1))] <- "FTIP"
            }
            cat("\n***TIP Declared ", TIP.type[i], "after half year:", 
                dimnames(x)[[1]][i], "\n")
            if (TIP.type[i] == "c.e.") {
                tmp.i <- ((i - 1):i)[series$max.events[(i - 1):i, 
                  "magnitude"] >= M0]
                prt.mainshocks(series$max.events[tmp.i, ])
            }
            else if (TIP.type[i] == "STIP") {
                tmp.i <- ((i + 1):min(c(i + 10, n)))[series$max.events[(i + 
                  1):min(c(i + TIP.length, n)), "magnitude"] >= 
                  M0]
                prt.mainshocks(series$max.events[tmp.i, ])
            }
            else if (TIP.type[i] == "STIP-") {
                tmp.i <- ((i + 1):min(c(i + 10, n)))[series$max.events[(i + 
                  1):min(c(i + TIP.length, n)), "magnitude"] >= 
                  M0 - 0.5]
                prt.mainshocks(series$max.events[tmp.i, ])
            }
        }
    }
    cat("\n   =============== M8 Result ===============\n")
    cat("g:h  Mmax Half-Year     F1   F2   F3    F4  F5   F6    F7 Pct TIP\n")
    cat(paste(g, ":", h, "  ", format(max.mag), " ", dimnames(series$series)[[1]], 
        " ", format(series$series[, "F1"]), c(" ", "*")[as.numeric(exceeds[, 
            1]) + 1], " ", format(series$series[, "F2"]), c(" ", 
            "*")[as.numeric(exceeds[, 2]) + 1], " ", format(round(series$series[, 
            "F3"])), c(" ", "*")[as.numeric(exceeds[, 3]) + 1], 
        " ", format(round(series$series[, "F4"])), c(" ", "*")[as.numeric(exceeds[, 
            4]) + 1], " ", format(round(series$series[, "F5"])), 
        c(" ", "*")[as.numeric(exceeds[, 5]) + 1], " ", format(round(series$series[, 
            "F6"])), c(" ", "*")[as.numeric(exceeds[, 6]) + 1], 
        " ", format(series$series[, "F7"]), c(" ", "*")[as.numeric(exceeds[, 
            7]) + 1], " ", format(round(percent.all, 2)), " ", 
        TIP.type, "\n", sep = ""), sep = "")
    if (training == "user" || training == "all") {
        cat("tops                  ", round(tops[1, ]), "\n")
    }
    cat("\n")
    x <- list(series = series$series, max.events = series$max.events, 
        tops = tops, exceeds = exceeds, TIP = TIP, TIP.type = TIP.type, 
        TIP.level = percent.all, training = training, M0 = M0, g = g, h = h)
    class(x) <- "M8"
    return(x)
}
