"M8.series"<-
function(catalogue, M0, centrelong = mean(catalogue[, "longitude"]), centrelat
	 = mean(catalogue[, "latitude"]), radius = radius.M8default(M0), minday
	= catalogue[1, "time"], start.series = datetimes(year = (years1(
	minday) + 12), month = 1, day = 1, hour = 0, minute = 0),
	training = "user", end.training = NA, time.breaks = Inf, running.total
	 = 12, debug = FALSE)
{
	# base level
	cat("##################################################\n")
	cat("#                M8.series()                     #\n")
	cat("##################################################\n")
	if(!is.data.frame(catalogue) || !any(names(catalogue) == 
		"n.aftershocks"))
		stop("Please use decluster.M8() function to get mainshocks\n")
	if(years1(max(catalogue[, "time"])) - years1(min(catalogue[, "time"])) < 
		12)
		stop("Not enough years of data avalable in catalogue.\n")
	if(years1(start.series) - years1(min(catalogue[, "time"])) < 10)
		stop("Series generation start too early.\n")
	interval.start <- start.series	
	# this is the end date of the first 6 month interval in which
	#   the 7 series are calculated.
	sel <- (in.circle(catalogue, centrelong = centrelong, centrelat = 
		centrelat, radius = radius))	
	# Use all events in the CI(all date)
	catalogue <- catalogue[sel,  ]
	# Only keep events in CI
	n <- nrow(catalogue)
	cat("Number of mainshocks = ", nrow(catalogue), "\n")
	cat("----- First, last event in CI -----\n")
	prt.mainshocks(catalogue[c(1, n),  ])
	cat("\n")
	data.start <- catalogue[1, "time"]	
	# this is the start of the events in this CI
	data.end <- catalogue[n, "time"]	
	# this is the end of the events in this CI
	if(training == "moving") {
		#level 1
		data.length <- (data.end - data.start)/365.2422
		cat("Number of years in CI: ", data.length, "\n")
		cat("Events per years in CI: ", n/data.length, "\n")
		n.CAT20 <- data.length * 20
		n.CAT10 <- data.length * 10
		if(n.CAT20 > n)
			stop(paste("M8.series(): CAT20 need ", n.CAT20, 
				"events while we have only ", n, "!!\n"))
		ordered.mags <- rev(sort(catalogue[, "magnitude"]))
		cut.CAT20 <- ordered.mags[n.CAT20]
		cut.CAT10 <- ordered.mags[n.CAT10]
	}
	else if(training == "user") {
		#level 1	
		in.training <- (catalogue[, "time"] >= start.series & catalogue[
			, "time"] < end.training)
		n.training <- sum(in.training)
		data.length <- (end.training - start.series)/365.2422
		cat("Number of years in training CI: ", data.length, "\n")
		cat("Events per years in training CI: ", n.training/data.length,
			"\n")
		cat("----- First, last event in training CI -----\n")
		prt.mainshocks(catalogue[in.training,  ][c(1, n.training),  ]
			)
		n.CAT20 <- data.length * 20
		n.CAT10 <- data.length * 10
		if(n.CAT20 > n.training) {
			cat(paste("M8.series(): CAT20 needs ", n.CAT20, 
				"events\n     while we have only ", n.training, 
				"in training CI!!\n"))
			return("Result not available")
		}
		ordered.mags <- rev(sort(catalogue[in.training, "magnitude"]))
		cut.CAT20 <- ordered.mags[n.CAT20]
		cut.CAT10 <- ordered.mags[n.CAT10]
	}
	else if(training == "all") {
		#level 1
		in.training <- (catalogue[, "time"] >= start.series & catalogue[
			, "time"] < data.end)
		n.training <- sum(in.training)
		data.length <- (data.end - start.series)/365.2422
		cat("Number of years in training CI: ", data.length, "\n")
		cat("Events per years in training CI: ", n.training/data.length,
			"\n")
		n.CAT20 <- data.length * 20
		n.CAT10 <- data.length * 10
		if(n.CAT20 > n.training) {
			stop(paste("M8.series(): CAT20 needs ", n.CAT20, 
				"events while we have only ", n.training, 
				"in training CI!!\n"))
		}
		ordered.mags <- rev(sort(catalogue[in.training, "magnitude"]))
		cut.CAT20 <- ordered.mags[n.CAT20]
		cut.CAT10 <- ordered.mags[n.CAT10]
	}
	cat("Cutoff magnitude of CAT20 =", cut.CAT20, "\n")
	cat("Cutoff magnitude of CAT10 =", cut.CAT10, "\n")
	in.CAT20 <- (catalogue[, "magnitude"] >= cut.CAT20)
	in.CAT10 <- (catalogue[, "magnitude"] >= cut.CAT10)
	in.CAT20a <- in.CAT20 & (catalogue[, "magnitude"] < M0 - 0.5)
	in.CAT10a <- in.CAT10 & (catalogue[, "magnitude"] < M0 - 0.5)
	in.CATMS <- (catalogue[, "magnitude"] >= M0 - 2 & catalogue[, 
		"magnitude"] < M0 - 0.2)	
	# Note: we are still not quite clear if these subsets extends
	#   to the whole data length or restricted to series evaluation
	#   period. If training is "user" or "all", then we only
	#   use training period to compute magnitude cutoff, 
	#   but the subset runs through all reliable data.
	#   Now we've got lower cutoff magnitudes for CAT20 and CAT10
	#   and boolean for CAT20 group and CAT10 group and CATMS group
	#   Next we should generate a time grid, 
	#   using series starting time('start.series')
	#   as a grid(in the middle), starting from just <= data 
	#   starting time, ending at just >= data ending time, 
	#   spaced at 6 months.
	if(time.breaks == Inf) {
		#level 1
		if(!(months1(minday) == 1 | months1(minday) == 7) & !(days1(
			minday) == 1)) {
			#level 2
			if(months1(minday) < 7) start.grid <- datetimes(year = 
				  years1(minday), month = 7, day = 1, hour = 1, 
				  minute = 1, second = 1)
			if(months1(minday) >= 7)
				start.grid <- datetimes(year = years1(minday) + 
				  1, month = 1, day = 1, hour = 1, minute = 1, 
				  second = 1)
		} else start.grid <- minday
		if(months1(start.grid) < 7)
			start.type <- 1 else start.type <- 2
		if(!(months1(data.end) == 12 & days1(data.end) == 31) | !(
			months1(data.end) == 6 & days1(data.end) == 30)) {
			# level 2
			if(months1(data.end) < 7) end.grid <- datetimes(year = 
				  years1(data.end), month = 7, day = 1, minute
				   = 1, hour = 1, second = 1)
			if(months1(data.end) >= 7)
				end.grid <- datetimes(year = years1(data.end) + 
				  1, month = 1, day = 1, minute = 1, hour = 1, 
				  second = 1)
		} else end.grid <- data.end

		if(months1(end.grid) < 7)
			end.type <- 1 else end.type <- 2
		n <- as.numeric(years1(end.grid) - years1(start.grid)) +1
		cat("n is:", n, "\n")
		year.grid <- c(1:2 * n)
		month.grid <- c(1:2 * n)
		blocks <- vector("list", n)	# initialise
		for(i in 1:n)
			blocks[[i]] <- c(years1(start.grid) + (i - 1), years1(
				start.grid) + (i - 1))
		year.grid <- unlist(blocks)
		month.grid <- rep(c(1, 7), times = n)
		time.breaks <- datetimes(year = year.grid, month = month.grid, 
			day = rep(1, length(year.grid)), hour = 0, minute = 0, second = 0)
		if(end.type == 1)
			time.breaks <- time.breaks[-2 * n]
		if(start.type == 2) time.breaks <- time.breaks[-1]	
	}
	n <- length(time.breaks)
#	cover.breaks <- (time.breaks[1] <= catalogue[, "time"] <= time.breaks[n
#		])
        cover.breaks <- (time.breaks[1] <= catalogue[, "time"] &
                         catalogue[, "time"] <= time.breaks[n])
	catalogue <- catalogue[cover.breaks,  ]	
	# the above makes sure there is no data outside the range of time.breaks, 
	#otherwise missing values would be created in the 'group' variable.
	#   ( length(time.breaks)-1 intervals )
	n.group <- length(time.breaks) - 1
	group.labels <- format(time.breaks)
	group.labels.end <- format(time.breaks-1)
	#	group.labels <- group.labels[-1]
	group.labels <- paste(substring(group.labels[-length(group.labels)],
		1, 9), "-", substring(group.labels.end[-1], 1, 9), sep = "")
	# labels correspond to end of interval 
	group <- cut(catalogue[, "time"], time.breaks, labels = group.labels, 
		include.lowest = TRUE)	
	# 1, 2, ..., n.group groups of time. We use each groups ending
	#   time to represent each group. Now 
	#       t.grid[n.group] >= data.end
	#       t.grid[1] - 6months <= data.start
	# now compute the basic series
	adj.first <- 1
	adj.last <- 1
	basic.sum20 <- c(table(group[in.CAT20]))
	basic.sum20[1] <- round(basic.sum20[1] * adj.first)
	basic.sum20[n.group] <- round(basic.sum20[n.group] * adj.last)
	basic.sum10 <- c(table(group[in.CAT10]))
	basic.sum10[1] <- round(basic.sum10[1] * adj.first)
	basic.sum10[n.group] <- round(basic.sum10[n.group] * adj.last)
	basic.sum20a <- c(table(group[in.CAT20a]))
	basic.sum10a <- c(table(group[in.CAT10a]))	
	# Number of events in each half year period 
	# in the subsets
	basic.exp20a <- tapply(catalogue[in.CAT20a, "magnitude"], list(group[
		in.CAT20a]), "M8.wgt.sum")
	basic.exp10a <- tapply(catalogue[in.CAT10a, "magnitude"], list(group[
		in.CAT10a]), "M8.wgt.sum")	
	# The side half year for \sum exp(0.46M) need not adjust
	basic.exp20a[is.na(basic.exp20a)] <- 0
	basic.exp10a[is.na(basic.exp10a)] <- 0	
	# sum of 10^magnitude in each half year period
	#   in CAT10a and CAT20a
	basic.maxB <- tapply(catalogue[in.CATMS, "n.aftershocks"], list(group[
		in.CATMS]), "max")
	basic.maxB[is.na(basic.maxB)] <- 0	
	# max of number of aftershocks in each half year period
	#    in CATMS
	time.breaks <- time.breaks[-1]	
	# drop the first interval starting time. Now year.grid
	# has n.group rows, each is a half year ending time
	i0 <- (1:n.group)[time.breaks == start.series]
	cat("i0 is", i0, "\n")	# this is the index satisfying
	#    ym.grid[i0, ] == series starting time(end of the first
	#                    half year series).
	# i0-1 is the start of the first half year
	basic.maxM <- group.max.mag(catalogue, group)
	if(debug) {
		browser()
	}
	# Now compute the seven M8 series, start generating
	#   at the half year ending at ym[i0, ]
	cumsum.1 <- cumsum(basic.sum20)
	series.1 <- cumsum.1[i0:n.group] - cumsum.1[(i0 - running.total):(
		n.group - running.total)]
	cumsum.2 <- cumsum(basic.sum10)
	series.2 <- cumsum.2[i0:n.group] - cumsum.2[(i0 - running.total):(
		n.group - running.total)]
	series.3 <- series.1 - cumsum.1[(i0 - running.total):(n.group - 12)]/(((
		i0 - running.total):(n.group - running.total))/running.total)
	series.4 <- series.2 - cumsum.2[(i0 - running.total):(n.group - 12)]/(((
		i0 - running.total):(n.group - running.total))/running.total)
	cumsum.5 <- cumsum(basic.sum20a)
	cumsum.5e <- cumsum(basic.exp20a)
	series.5 <- ((cumsum.5e[i0:n.group] - cumsum.5e[(i0 - running.total):(
		n.group - running.total)])/(cumsum.5[i0:n.group] - cumsum.5[(i0 -
		running.total):(n.group - running.total)])^(0.67))
	cumsum.6 <- cumsum(basic.sum10a)
	cumsum.6e <- cumsum(basic.exp10a)
	series.6 <- ((cumsum.6e[i0:n.group] - cumsum.6e[(i0 - running.total):(
		n.group - running.total)])/(cumsum.6[i0:n.group] - cumsum.6[(i0 -
		running.total):(n.group - running.total)])^(0.67))
	series.7 <- as.vector(apply(cbind(basic.maxB[i0:n.group], basic.maxB[(
		i0 - 1):(n.group - 1)]), 1, "max"))
	series <- ts(cbind(F1 = series.1, F2 = series.2, F3 = series.3,
		F4 = series.4, F5 = series.5, F6 = series.6, F7 = series.7,
		time = time.breaks[-(1:(i0 - 1))]),
		start = years1(start.series), frequency = 2)
	dimnames(series)[[2]] <- c("F1", "F2", "F3", "F4", "F5", "F6", "F7", 
		"time")
	return(list(series = series, max.events = basic.maxM[-(1:(i0 - 1)), ]))
}


