"decluster.M8" <-
function (catalogue, cutoff.mag = 4, minday = min(catalogue$time), 
    mindepth = -Inf, maxdepth = Inf, debug = FALSE, decluster.name = "", 
    magn.window = c(3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 7.5, 8), 
    space.window = c(30, 40, 40, 40, 50, 50, 50, 100, 100, 150, 
        200), time.window = c(6, 11, 23, 46, 91, 183, 183, 365, 
        730, 913, 1096)) 
{
    if (decluster.name == "") 
        stop("The name of the declustered catalogue must be specified")
    start.compute <- proc.time()[3]
    cat("--------------- decluster.M8 ---------------\n")
    del <- (is.na(catalogue[, "time"]) | is.na(catalogue[, "magnitude"]) | 
        is.na(catalogue[, "longitude"]) | is.na(catalogue[, "latitude"]) | 
        is.na(catalogue[, "depth"]))
    new.catalogue <- catalogue[!del, c("time", "magnitude", "longitude", 
        "latitude")]
    del2 <- (new.catalogue[, "magnitude"] < cutoff.mag | catalogue[!del, 
        "depth"] < mindepth | catalogue[!del, "depth"] >= maxdepth)
    new.catalogue <- new.catalogue[!del2, ]
    del[!del] <- del2
    n0 <- nrow(new.catalogue)
    n.aftershocks <- rep(0, n0)
    order.magnitude <- order(-new.catalogue[, "magnitude"], new.catalogue[, 
        "time"])
    sel <- as.integer(row.names(new.catalogue))
    print("recatalogue(): Before calling .Fortran(\"recat\", --------")
    res <- .Fortran("recat", as.integer(n0), as.double(as.matrix(new.catalogue)), 
        as.integer(order.magnitude), sel = as.integer(sel), n.aftershocks = as.integer(n.aftershocks), 
        magn.window = as.single(magn.window), space.window = as.single(space.window), 
        time.window = as.single(time.window), as.integer(length(magn.window)), 
        NAOK = TRUE, PACKAGE="ssM8")
    print("-------- After calling .Fortran(\"recat\", --------")
    if (debug) {
        print("recatalogue(): Fortran completed")
        browser()
    }
    is.main <- (res$sel == 0)
    catalogue.main <- catalogue
    catalogue.main[, "n.aftershocks"] <- 0
    if (debug) 
        browser()
    catalogue.main[!del, "n.aftershocks"] <- res$n.aftershocks
    catalogue.main[del, "n.aftershocks"] <- NA
    catalogue.main <- catalogue.main[!del, ][is.main, ]
    catalogue.main <- catalogue.main[catalogue.main[, "time"] >= 
        minday, ]
    if (debug) 
        browser()
    cat(paste("Magnitude selection range: [", cutoff.mag, ", Inf)\n"))
    if (minday != min(catalogue$time)) {
        class(minday) <- "datetimes"
        cat("Starting date of the mainshocks as required:\n")
        cat(format(minday), "\n")
    }
    else {
#       class(minday) <- "datetimes"
        cat("Starting date of the mainshocks as first event available:\n")
        cat(format(minday), "\n")
    }
    cat(paste("Depth selection range: [", mindepth, ", ", maxdepth, 
        ")\n"))
    cat("Names of generated data frame: \n")
    print(names(catalogue.main))
    cat(paste("\nFinished recatalogue() in ", (proc.time()[3] - 
        start.compute), "seconds.\n"))
    attr(catalogue.main, "catname") <- decluster.name
    assign(decluster.name, catalogue.main, envir = globalenv())
    return(invisible(res$sel))
}
