"plot.M8" <-
function (x, title = "M8 Series and TIPs", ...) 
{
    #  main title now uses default cex.main
    #  vertical lines (type="h") have been removed
    #  horizontal reference line changed to dashed (lty=2)
    #  colours removed from plotted symbols
    #  8th graph plots only critical series
    if (!is.list(x) || !any(names(x) == "series") || !any(names(x) == 
        "TIP")) {
        stop(paste("Wrong input type for plot.TIP():\n", "should be output of M8()"))
    }
    old.par <- par(tcl = -0.2)
    on.exit(par(old.par))
    w <- x$series
    TIP <- x$TIP
    TIP.level <- x$TIP.level
    par(mfrow = c(4, 2), oma = c(0, 0, 6, 0), mkh = 0.05, mar = 0.1 + 
        c(3, 2, 2, 2), cex.axis = 0.7)
    for (j in 1:7) {
        y <- w[, j]
        plot.ts(y, main = paste("Series ", j), type = "l")
#       lines(y)
        if (x$training == "user" || x$training == "all") {
            abline(h = x$tops[1, j], lty=2)
        }
        if (any(x$TIP.type == "STIP"))
            points(y, cex = 1.5*(x$TIP.type == "STIP"), pch = 5)
        if (any(x$TIP.type == "STIP-"))
            points(y, cex = 1.5*(x$TIP.type == "STIP-"), pch = 2)
        if (any(x$TIP.type == "FTIP"))
            points(y, cex = 1.5*(x$TIP.type == "FTIP"), pch = 4)
        if (any(x$TIP.type == "CTIP"))
            points(y, cex = 1.5*(x$TIP.type == "CTIP"), pch = 3)
        if (any(x$TIP.type == "c.e."))
            points(y, cex = 1.5*(x$TIP.type == "c.e."), pch = 0)
    }
if (0==1){
    #   original code for eighth graph
    max.mag <- x$series[, 1]
    max.mag[1:length(max.mag)] <- x$max.events[, "magnitude"]
    plot.ts(max.mag, main = "Max Events", type = "h", ylim = c(0, 
        10), axes = FALSE)
    abline(h = x$M0)
    saveatt <- attributes(TIP.level)
    freq <- frequency(TIP.level)
    lev <- (0.9 + TIP.level[-(1:5)]) * 4
    saveatt$tsp <- saveatt$tsp + c(5/freq, 0, 0)
    attributes(lev) <- saveatt
    safe <- (lev <= 0.9 * 4)
    warn <- !safe
    abline(h = 0.9 * 4)
    lines(lev, col = 2)
    if (any(warn)) {
        points(lev, col = 2, pch = 5, cex = warn)
    }
    box()
    axis(1)
    axis(2)
    axis(4, at = c(0, 1) * 4, label = c("-0.9", "0.1"), las = 1)
    mtext(side = 3, line = 3, cex = par()$cex.main, font = par()$font.main,
          outer = TRUE, title)
}
    plot.ts(TIP.level, main = "Critical Series", type = "l",
            ylim=c(-0.95, 0.15))
    if (any(x$TIP.type == "STIP"))
        points(TIP.level, cex = 1.5*(x$TIP.type == "STIP"), pch = 5)
    if (any(x$TIP.type == "STIP-"))
        points(TIP.level, cex = 1.5*(x$TIP.type == "STIP-"), pch = 2)
    if (any(x$TIP.type == "FTIP"))
        points(TIP.level, cex = 1.5*(x$TIP.type == "FTIP"), pch = 4)
    if (any(x$TIP.type == "CTIP"))
        points(TIP.level, cex = 1.5*(x$TIP.type == "CTIP"), pch = 3)
    if (any(x$TIP.type == "c.e."))
        points(TIP.level, cex = 1.5*(x$TIP.type == "c.e."), pch = 0)
    abline(h=0, lty=2)
}


