\name{M8}
\alias{M8}
\title{
Run the M8 Algorithm
}
\description{
This function runs the M8 algorithm, i.e. calls the function \code{\link{M8.series}} to calculate the seven time series, calls the function \code{\link{M8.TIP}} to calculate the Times of Increased Probabilities, and finally, optionally calls the function \code{\link{plot.M8}} to plot all seven series plus an eighth critical series.
}

\usage{
M8(catalogue, M0, centrelong=mean(catalogue[, "longitude"]),
   centrelat=mean(catalogue[, "latitude"]), radius=radius.M8default(M0),
   minday=catalogue[1, "time"],
   start.series=datetimes(year=(years1(minday) + 12), month=1, day=1,
   hour=0, minute=0), training="user", end.training=NA, time.breaks=Inf,
   running.total=12, smoother=6, TIP.length=10, plotit=TRUE,
   title="M8 Series and TIPs", debug=FALSE)
}
\arguments{
\item{catalogue}{
the mainshock catalogue (created by the \code{\link{decluster.M8}} function), with the number of aftershocks in following 14 days.
}
\item{M0}{
numeric. The aim of the algorithm is to predict earthquakes with a magnitude greater than or equal to \eqn{M_0}{M0}.
}
\item{centrelong}{
longitude of the centre of the circle of interest.
}
\item{centrelat}{
latitude of the centre of the circle of interest.
}
\item{radius}{
circle of interest radius. The default radius is \eqn{55.5 \{\exp(M_0-5.6)+1\}}{55.5*\{exp(M0-5.6)+1\}}.
}
\item{minday}{
Julian date, events earlier than this are not used in analysis. By default, all the data are used.
}
\item{start.series}{
Julian date of end point of the first bin from which the series are generated. Since the series are calculated using bins (defined by \code{time.breaks}), the \code{start.series} must coincide with an end point of one of the bins. The M8 default is six month bins.
}
\item{training}{
has three possible modes: \code{"moving"}, \code{"user"}, and \code{"all"}. See Details in \code{\link{M8.series}} for further explanation.
}
\item{end.training}{
Julian date for the end of the training period. This date should be the end point of a bin. This is only used when the training mode is \code{"user"}.
}
\item{time.breaks}{
a vector of Julian dates that give the bin boundaries for calculating the series. The (M8) default bin length is 6 months. Care must be taken that the arguments \code{minday}, \code{start.series} and \code{end.training} coincide with a breakpoint in the vector \code{time.breaks}. The breaks should also be at regular intervals.
}
\item{running.total}{
by default, the series are calculated with a six year running total, i.e.12 half years, thus the M8 default is 12.
}
\item{smoother}{
integer, denoting the length of the smoothing window. The series are smoothed at a given point by taking their maximum value over previous values within this window. The default value is 6 (i.e. three years).
}
\item{TIP.length}{
is the duration of the TIP or \dQuote{Time of Increased Probability}. The M8 default is 5 years (i.e. 10 time intervals), and is independent of M0.
}
\item{plotit}{
logical. If set to \code{TRUE} then seven plots for each of the seven smoothed series are generated. There is also a plot of the largest earthquake in each 6 month interval, together with the critical series. The default is \code{TRUE}.
}
\item{title}{
character string giving a title for the page of plots. The default is \code{"M8 Series and TIPs"}.
}
\item{debug}{
logical. The default is \code{FALSE}.
}}
\value{
The same object as that returned by the function \code{\link{M8.TIP}}.
}
\details{
See Details in \code{\link{M8.series}} for an explanation of how the M8 series are calculated, and \code{\link{M8.TIP}} for how the Times of Increased Probabilities are calculated.
}
\author{
Li Dongfeng, 1997; modified by Maaike Vreede, 1998.
}


\seealso{
\code{\link{decluster.M8}}, \code{\link{M8.series}}, \code{\link{M8.TIP}}
}
\examples{
#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

savpar <- par(no.readonly=TRUE)
temp <- M8(NZ.mainshocks, M0=7.0, minday=julian(y=1965, x=1, d=1),
           start.series=julian(y=1975, x=1, d=1), centrelong=176, 
           centrelat=-39, end.training=julian(y=2000, x=1, d=1))
par(savpar)
}

\keyword{ts}
