\name{M8.series}
\alias{M8.series}
\title{
Calculates the Seven M8 Series
}
\description{
This functions calculates the seven time series of the M8 Algorithm.
}

\usage{
M8.series(catalogue, M0, centrelong=mean(catalogue[, "longitude"]),
          centrelat=mean(catalogue[, "latitude"]),
          radius=radius.M8default(M0), minday=catalogue[1, "time"],
          start.series=datetimes(year=(years1(minday) + 12), month=1,
          day=1, hour=0, minute=0), training="user", end.training=NA,
          time.breaks=Inf, running.total=12, debug=FALSE)
}
\arguments{
\item{catalogue}{
the mainshock catalogue (created by the \code{\link{decluster.M8}} function), with the number of aftershocks in following 14 days.
}
\item{M0}{
numeric. The aim of the algorithm is to predict earthquakes with a magnitude greater than or equal value to \eqn{M_0}{M0}.
}
\item{centrelong}{
longitude of the centre of the circle of interest.
}
\item{centrelat}{
latitude of the centre of the circle of interest.
}
\item{radius}{
circle of interest radius. The default radius is \eqn{55.5 \{\exp(M_0-5.6)+1\}}{55.5*{exp(M0-5.6)+1}}.
}
\item{minday}{
Julian date, events earlier than this are not used in analysis. By default, all the data are used.
}
\item{start.series}{
Julian date of end point of the first bin from which the series are generated. Since the series are calculated using bins (defined by \code{time.breaks}), the \code{start.series} must coincide with an end point of one of the bins. The M8 default is six month bins.
}
\item{training}{
has three possible modes: \code{"moving"}, \code{"user"}, and \code{"all"}. See Details in \code{\link{M8.series}} for further explanation.
}
\item{end.training}{
Julian date for the end of the training period. This date should be the end point of a bin. This is only used when the training mode is \code{"user"}.
}
\item{time.breaks}{
a vector of Julian dates that give the bin boundaries for calculating the series. The (M8) default bin length is 6 months. Care must be taken that the arguments \code{minday}, \code{start.series} and \code{end.training} coincide with a breakpoint in the vector \code{time.breaks}. The breaks should also be at regular intervals.
}
\item{running.total}{
by default, the series are calculated with a six year running total, i.e.12 half years, thus the M8 default is 12.
}
\item{debug}{
logical. The default is \code{FALSE}.
}}
\value{
The function produces a list object with the following components.

\item{series}{
is a regular time series (rts) object with n rows and 8 columns. The first 7 columns are the seven series, and the last is the datetime corresponding to the series values.
}
\item{max.events}{
is a data frame with the same column structure as the catalogue. However, the columns are regular time series (with 6 month intervals) containing attributes of the largest earthquake in that 6 month period.


}}
\details{
Initially, a training period is defined. This period is used to estimate various magnitude cutoffs, described below. Three time points are specified in the arguments to this function: \code{minday} \eqn{\le}{leq} \code{start.series} \eqn{\le}{leq} \code{end.training}. Further, there are three possible training modes:
\describe{
\item{\code{"usr"}}{
the training period starts at \code{start.series} and finishes at \code{end.training}.
}
\item{\code{"moving"}}{
the training period starts at \code{minday} and finishes on the date of the last event in the catalogue.
}
\item{\code{"all"}}{
the training period starts at \code{start.series} and finishes on the date of the last event in the catalogue.
}}

Using the training period, the algorithm then determines the required magnitude cutoffs to produce the following subcatalogues: CAT20, CAT10, CAT20a, CAT10a, and CATMS. The subset CAT20 has smaller earthquakes cut out so that it has an average of 20 earthquakes per year.
Similarly for CAT10, though with an average of 10 events per year. The subset CAT20a is the same as CAT20, except that earthquakes stronger than a half magnitude below the target magnitude are omitted. Similarly for CAT10a.
The subset CATMS contains the events in the catalogue that have magnitudes between \eqn{(M_0 - 2)}{(M0 - 2)} and \eqn{(M_0 - 0.2)}{(M0 - 0.2)}, where \eqn{M_0}{M0} is the target magnitude.

Using the vector \code{time.breaks}, the algorithm computes, for each time interval, the value of the seven series as follows. Note that these series start being calculated from the date \code{start.series}.

\describe{
\item{Series 1}{is the number of earthquakes in CAT20.}

\item{Series 2}{is the number of earthquakes in CAT10.}

\item{Series 3 and 4}{are derived from series 1 and 2 respectively. They are the difference between the number of earthquakes in the past 6 years and the number expected, based on all data 6 years before the date when the series start being calculated.}

\item{Series 5 and 6}{have the same lower magnitude thresholds as the first 4 series, but earthquakes used in their calculation must also be a at least half a point less in magnitude than \eqn{M_0}{M0} (the magnitude targeted for prediction). Series 5 uses CAT20a, and series 6 uses CAT10a. These series are the average magnitude multiplied by the 2/3 power of the number of events.}

\item{Series 7}{is based on CATMS. It is the maximum number of aftershocks after any event in this magnitude range over the past year.
}}

These are regular time series, with intervals of 6 months, and a 6 year running total incorporated into their calculation. Before they are used for prediction they are smoothed again by taking the maximum value over the past 3 years. Then the M8 decision rule is applied: if 5 out of the first 6 series are above their 90th percentile, and the 7th series is above its 75th percentile, a \dQuote{TIP} is declared.
}

\author{
Li Dongfeng, 1997; modified by Maaike Vreede, 1998.
}


\seealso{
\code{\link{decluster.M8}}, \code{\link{M8}}, \code{\link{M8.TIP}}
}
\examples{
#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

temp <- M8.series(NZ.mainshocks, M0=7.0, minday=julian(y=1965, x=1, d=1),
                  start.series=julian(y=1975, x=1, d=1), centrelong=176, 
                  centrelat=-39, end.training=julian(y=2000, x=1, d=1))

print(temp$series)
}

\keyword{ts}
