\name{changes}
\alias{changes}
\title{
Changes Made to the Package
}
\description{
The M8 algorithm is based on seven different time series (see Keilis-Borok \& Kossobokov, 1990; and Kossobokov, 1997). If the 7th time series and 5 out of the first 6 time series are above certain thresholds, a \dQuote{Time of Increased Probability} (or TIP) is declared. This means there is an increased probability of an earthquake (of or greater than \eqn{M_0}{M0}) in the next 5 years. Details for the calculation of the seven series can be found in under \code{\link{M8.series}}, and details for the calling of a TIP can be found under \code{\link{M8.TIP}}.

Li (1997) converted the original M8 FORTRAN code in Kossobokov (1997) into S-PLUS, which was then included into the Statistical Seismology Library (Harte, 1998). Ray Brownrigg subsequently packaged it into \R.

Analyses using the M8 Algorithm, applied to New Zealand data, have been carried out by Ma \& Vere-Jones (1997), Harte et al. (2003), and Harte et al. (2007).

This page contains a listing of recent changes made to functions, and known general problems.
}

\details{
\enumerate{
\item \code{\link{decluster.M8}}: The line near the bottom within an else loop: \code{class(minday) <- "datetimes"} has been commented. (March 2002)

\item \code{\link{plot.M8}}: Main title now uses default \code{cex.main}, vertical lines (\code{type="h"}) have been removed, horizontal reference line changed to dashed (\code{lty=2}), colours removed from plotted symbols, and 8th graph plots only critical series. (January 2003)

\item Occurrences of \code{T} and \code{F} have been changed to \code{TRUE} and \code{FALSE}, respectively. (January 2003)

\item \code{\link{M8.TIP}}: When \code{(training == "moving")} the line \code{TIP.type[1:7] <- NA} has been changed to \code{TIP.type[1:7] <- ""}. When \code{(training == "user" || training == "all")} the line \code{TIP.type[1] <- NA} has been changed to \code{TIP.type[1] <- ""}. The earlier versions caused errors when running \code{R CMD check} in \R\ version 1.6.2. (February 2003)

\item \code{\link{plot.M8}}: argument \code{M8} changed to \code{x}, and argument \ldots added to fix generic/method inconsistencies. (June 2003)

\item \code{print.mainshocks} has been renamed to \code{\link{prt.mainshocks}} to fix generic/method confusion. (June 2003)

\item \code{time.grid} has been renamed to \code{\link{timegrid}} to fix generic/method confusion. (June 2003)

\item \code{\link{M8.TIP}}: the check to see if the critical series has length less than seven now uses function \code{nrow} rather than \code{start} and \code{end}. (October 2003)

\item \code{\link{decluster.M8}}: a vector is now returned that identifies the mainshock to which each aftershock belongs. (October 2003)

\item Minor formatting corrections to manual pages. (December 2003)

\item Minor documentation formatting changes, mainly to use \code{\\dQuote}. (January 2004)

\item \code{\link{in.circle}}: correct documentation mismatch with code. (7 May 2004)

\item \code{\link{decluster.M8}}: \code{PACKAGE="ssM8"} has been added to the \code{.Fortran("recat", ...)} call within the function. (7 May 2004)

\item \code{sum.row} renamed to \code{\link{sumrow}}. (7 May 2004)

\item A statement \code{require(ssNZ)} has been added to the examples that use the NZ catalogue. Hence \pkg{ssNZ} is no longer a \dQuote{package} requirement of \pkg{ssM8}. (25 May 2004)

\item \code{\link{M8.series}}: statement with incorrect logical syntax corrected: \newline
\code{
cover.breaks <- (time.breaks[1] <= catalogue[, "time"] <= time.breaks[n])}. \newline (17 Feb 2005)

\item \code{\link{M8.TIP}}: make documentation consistent with Harte et al (2003). (17 Feb 2005)

\item \code{\link{M8.TIP}}: method of calculating the quantiles in variable \code{tops} incorrect, redone using the function \code{\link[base]{quantile}}. Values of \code{g} and \code{h} included in output list object. Variable initialisation rewritten. Code included to calculate \code{TIP.level} when \code{training=="moving"}, previously not working for this option. (24 Mar 2005)

\item \code{\link{emp.cdf}}: completely rewritten, see documentation. (11 Apr 2005)

\item Old package ``stepfun'' not now ``required''. Part of \pkg{base}. (19 Apr 2005)

\item \code{\link{decluster.M8}}: on manual page, units added for space and time windows. (9 Jul 2006)

\item All occurences of \code{subset.rect} in the Examples have been changed to \code{\link[ssBase]{subsetrect}}. See Changes in \pkg{ssBase}. (8 Nov 2007)

\item \pkg{ssNZ} added to \code{Suggests} in the DESCRIPTION file. Corresponding changes made to examples on manual pages. (10 Jan 2008)

\item Use of \code{require(ssNZ)} in examples made consistent with package \pkg{ssEDA}. (28 Jan 2008)

\item References updated below. (28 Jan 2008)

\item Package vignettes added. (28 Jan 2008)
}}


\references{
Harte, D. (1998). Documentation for the Statistical Seismology Library. School of Mathematical and Computing Sciences Research Report No. 98-10 (Updated Edition June 1999), Victoria University of Wellington. (ISSN 1174-4545)

Harte, D.; Li, D.-F.; Vreede, M. \& Vere-Jones, D. (2003). Quantifying the M8 prediction algorithm: Reduction to a single critical variable and stability results. \emph{NZ Journal of Geology and Geophysics} \bold{46(1)}, 141--152. URL: \url{http://www.rsnz.org/publish/nzjgg/2003/010.php}

Harte, D.; Li, D.-F.; Vere-Jones, D.; Vreede, M. \& Wang, Q. (2007). Quantifying the M8 algorithm: Model, forecast and evaluation. \emph{NZ Journal of Geology and Geophysics} \bold{50(2)}, 117--130. URL: \url{http://www.rsnz.org/publish/nzjgg/2007/012.php}

Keilis-Borok, V.I. and Kossobokov, V.G. (1990). Premonitory activation of earthquake flow: algorithm M8. \emph{Physics of the Earth and Planetary Interiors} \bold{61}, 73--83. URL: \url{http://dx.doi.org/10.1016/0031-9201(90)90096-G}

Kossobokov, V.G. (1997). User manual for M8. In: \emph{Algorithms for Earthquake Statistics and Prediction. International Association of Seismology and Physics of the Earth's Interior (IASPEI) Library Volume 6.} Pages 167--222. (Edited by J.H. Healy, V.I. Keilis-Borok and W.H.K. Lee). IASPEI, Menlo Park CA.

Li, Dongfeng. (1997). M8-Splus Documentation. Internal Report, Institute of Statistics and Operations Research, Victoria University of Wellington.

Ma, L. and Vere-Jones, D. (1997). Application of the M8 and Lin-Lin algorithms to New Zealand Earthquake data. \emph{NZ Journal of Geology and Geophysics} \bold{40}, 77--89. URL: \url{http://www.rsnz.org/publish/nzjgg/1997/7.php}
}


\keyword{documentation}
