\name{decluster.M8}
\alias{decluster.M8}
\title{
Decluster Catalogue Using M8 Method
}
\description{
The function reads an earthquake catalogue (with class \code{"catalogue"}), deletes events with magnitude below a cutoff level and all aftershocks, optionally deletes events with depth too deep or too shallow, and counts the number of aftershocks in the 14 days following each remaining mainshock. The output is also a \code{"catalogue"} object containing the mainshock information and an additional variable with the corresponding number of aftershocks.
}
\usage{
decluster.M8(catalogue, cutoff.mag=4, minday=min(catalogue$time),
	mindepth= - Inf, maxdepth=Inf, debug=FALSE, decluster.name="",
	magn.window = c(3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 7.5, 8),
	space.window = c(30, 40, 40, 40, 50, 50, 50, 100, 100, 150, 200),
	time.window = c(6, 11, 23, 46, 91, 183, 183, 365, 730, 913, 1096))
}
\arguments{
\item{catalogue}{
the catalogue. It should be a \code{"catalogue"} object.
}
\item{decluster.name}{
character string containing the name of the declustered catalogue.
}
\item{cutoff.mag}{
the magnitude below which the record is cutoff before going through the mainshock-aftershock separation. Default 4.0.
}
\item{minday}{
number of days from 1 January 1970 (julian). If specified, then after mainshocks have been separated out, mainshocks before this date are dropped. If not specified, no mainshocks are dropped.
}
\item{mindepth}{
all events with depth less than mindepth are deleted before entering algorithm. Default is \code{-Inf}.
}
\item{maxdepth}{
all events with depth greater than or equal to maxdepth are deleted before entering algorithm. Default is \code{Inf}.
}
\item{magn.window}{
a vector giving the magnitude window boundaries. The default \code{c(3, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0)}.
}
\item{time.window}{
a vector giving the time window boundaries (days). The default is \code{c(6, 11, 23, 46, 91, 183, 183, 365, 730, 913, 1096)}.
}
\item{space.window}{
a vector giving the space window boundaries (km). The default is \code{c(30, 40, 40, 40, 50, 50, 50, 100, 100, 150, 200)}.
}
\item{debug}{
boolean; default is \code{FALSE}.
}}
\value{
The value returned is the vector identifying the mainshock to which each aftershock belongs. The mainshocks themselves are identified by zeros.

A \code{"catalogue"} object with name given by the argument \code{decluster.name} is written to the session workspace. It contains the mainshock hypocentral information and an additional variable, \code{n.aftershocks}, containing the number of aftershocks following the mainshock within 14 days.
}

\details{
All events with magnitude less than \code{magn.window[1]} are assumed to have no aftershocks. Those events with magnitude less than \code{magn.window[i+1]} but greater than or equal to \code{magn.window[i]} have aftershock time and space windows given by \code{time.window[i]} and \code{space.window[i]} respectively, for \code{i = 1, \dots, length(magn.window)-1}.  All events with magnitude greater than or equal to \code{magn.window[length( magn.window)]} have aftershock time and space windows given by \code{time.window[length(magn.window)]} and 
\newline \code{space.window[length(magn.window)]} respectively. 
}

\author{
Li Dongfeng, 1997; modified November 1999
}
\seealso{
\code{\link{M8}}, \code{\link{M8.series}}, \code{\link{M8.TIP}},
\code{\link{plot.M8}}
}
\examples{
#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

print(summary(NZ.mainshocks))
}

\keyword{ts}
