\name{emp.cdf}
\alias{emp.cdf}
\title{Empirical Cumulative Distribution Function}
\description{
Calculates the empirical cumulative probability distribution function. This is the inverse function of \code{\link{quantile}}.
}
\usage{
emp.cdf(x, q)
}

\arguments{
  \item{x}{is a vector containing the sample data.}
  \item{q}{is a vector of points where the function is to be evaluated.}
}

\details{
This function is an \emph{exact} inverse of the \code{\link{quantile}} function when the points in \code{q} are contained in \code{x}. This is not the case for the function \code{\link[stepfun]{ecdf}}.

For example, say \code{x} contains 11 unique points. Then according to the \code{\link{quantile}} function, the minimum represents the zero-th quantile, and the remaining sorted values represent the 10\%ile, 20\%ile, 30\%ile, up to 100\%ile. The function \code{emp.cdf} has been defined to be consistent with this.

This consistency is important for the evaluation of the M8 algorithm. The TIP declaration within the function \code{\link{M8.TIP}} is calculated by two different methods, one using the \code{\link{quantile}} function, and the other based on the empirical cumulative probability distribution function. If they are not consistent then the time point of the TIP declaration can be different between the two methods.
}

\value{
A vector of the same length as \code{q}, containing the cumulative probabilities.
}

\author{David Harte, 2005}

\seealso{\code{\link{quantile}}, \code{\link[stepfun]{ecdf}}}

\examples{
n <- 10
x <- rep(0:n, 1)
print(quantile(x, probs=seq(0, 1, 1/n)))
print(emp.cdf(x, x))

n <- 12
x <- rep(0:n, 3)
print(quantile(x, probs=seq(0, 1, 1/n)))
print(emp.cdf(x, x))

n <- 12
x <- rnorm(n+1)
print(quantile(x, probs=seq(0, 1, 1/n)))
print(sort(x))
print(emp.cdf(x, sort(x)))
}

\keyword{distribution}
