\name{plot.M8}
\alias{plot.M8}
\title{
Plot M8 Series
}
\description{
Plot the seven M8 series plus the eighth critical series.
}
\usage{
\method{plot}{M8}(x, title="M8 Series and TIPs", ...)
}
\arguments{
\item{x}{
a list object produced by the function \code{\link{M8.TIP}}.
}
\item{title}{
a title to be placed at the top of the matrix of eight graphs.
}
\item{\dots}{
other options for formatting \code{"datetimes"} objects.
}
}
\value{
\code{NULL}
}
\details{
This produces a \eqn{4 \times 2}{4x2} grid of graphs. The first seven are graphs of the seven series, and the eighth is the critical series. When the training mode is not \code{"moving"}, the 90th and 75th percentiles for the first 6 and 7th series are plotted, respectively. These percentiles represent the thresholds for each of the seven series. When the training mode is \code{"moving"} the threshold values are not constant over time, and are not plotted.

The plot of the \dQuote{critical series} has a reference line marked at zero. A TIP is called if this series exceeds zero in two consecutive time periods. Points are marked on all plots where a TIP is in effect, the symbols having the following interpretations:
\itemize{
\item Successful TIP (STIP): \code{pch = 5}
\item Near Successful TIP (STIP-): \code{pch = 2}
\item False TIP (FTIP): \code{pch = 4}
\item Continuing TIP (CTIP): \code{pch = 3}
\item TIP caused by quake of target magnitude (c.e.): \code{pch = 0}
}
Note that the plotting symbols may be different on different plotting devices, see the argument \code{pch} in the graphics function \code{\link{par}}.
}

\author{
Li Dongfeng, 1997; modified by Maaike Vreede, 1998.
}

\seealso{
\code{\link{M8}}, \code{\link{M8.series}}, \code{\link{M8.TIP}}
}

\examples{
#   Requires the package ssNZ
require(ssNZ)

as.catalogue(subsetrect(NZ, minday=julian(1,1,1965),
                        maxday=julian(1,1,2000), minmag=4.5),
             catname="NZ45")

decluster.M8(NZ45, cutoff.mag=4.5, decluster.name="NZ.mainshocks")

temp <- M8(NZ.mainshocks, M0=7.0, minday=julian(y=1965, x=1, d=1),
           start.series=julian(y=1975, x=1, d=1), centrelong=176, 
           centrelat=-39, end.training=julian(y=2000, x=1, d=1),
           plotit=FALSE)

savpar <- par(no.readonly=TRUE)
plot(temp, title="M8 Analysis of NZ events")
par(savpar)
}

\keyword{methods}
\keyword{hplot}
