C     M8.f
C     some fortran subroutines to speed up M8 calculation
C
C--------------------------------------------------------
C     recat()
C     Separate main shocks and aftershocks, get number of
C     aftershocks for each main shock.
C     Input:
C        n --- number of records(rows) of catalogue
C        c(n,4) --- catalogue matrix,
C           each column is datetime, magnitude, 
C           longitude, latitude
C        ordmag(n) --- order of magintude(high to low)
C        sel(n) --- row name of catalogue. >0 for untreated,
C                   ==0 for mainshock, <0 for aftershock,
C                   return its master's row.name
C        numaft(n) --- number of aftershocks in following 14 days
C------------------------------------------------------------

      subroutine recat(n, c, ord, sel,  numaft, mcrit, rcrit, dcrit, m)
      integer n, m
      double precision c(n,4)
      integer ord(n)
      integer sel(n)
      integer numaft(n)

      real mcrit(m)
      real rcrit(m)
      real dcrit(m)
c      data mcrit/4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0/
c      data rcrit/40,  40,  50,  50,  50,  100, 100, 150, 200/
c      data dcrit/23,  46,  91,  183, 183, 365, 730, 913, 1906/

      integer nmain
      integer nleft, nnext, ipos
      integer i, igroup
      double precision distg
      double precision maxm
      integer master
      
      nmain = 0
      nleft = n
      nnext = 0

      do while(nleft .gt. 0)

c        find max magnitude in the left records
         do while(.true.)
            nnext = nnext+1
            if(sel(ord(nnext)) .GT. 0) then
               goto 1010
            endif
         enddo
 1010    continue
         ipos = ord(nnext)
C        This is the largest un-treated magnitude's record number
         maxm = c(ipos,2)

C        Note the main shock in sel by turning it to 0
         master = sel(ipos)
         sel(ipos) = 0
         nleft = nleft-1

C        check for its aftershocks
         if( maxm .LT. mcrit(1)) then

         else
            igroup = m
            do while(maxm .LT. mcrit(igroup))
               igroup = igroup-1
            enddo
            
            i = ipos+1
            do while(i .LE. n  .AND. 
     &               (c(i,1)-c(ipos,1)) .LE. dcrit(igroup))
               if(sel(i) .GT. 0 .AND. distg(c(ipos,3), c(ipos,4),
     &             c(i,3), c(i,4)) .LE. rcrit(igroup)) then
                  sel(i) = -master
C                 < 0  for aftershocks, store its master
C                      main shock's row.name
                  nleft = nleft-1
                  if(c(i,1)-c(ipos,1) .LE. 14) Then
                     numaft(ipos) = numaft(ipos)+1
                  end if
               endif
               i = i + 1
            enddo
         endif
      enddo
      end


C------------------------------------------------------------
C     distg() --- curve distance on earth give longitudes,latitudes
C------------------------------------------------------------
      double precision function distg(long1, lat1, long2, lat2)
      double precision long1, lat1, long2, lat2
      double precision pi
      parameter(pi=3.1415926)
      double precision long01, lat01, long02, lat02
      double precision x1, y1, z1, x2, y2, z2
      double precision rad, clat1, clat2, dist

      rad = pi/180
      long01 = long1*rad
      lat01 = lat1*rad
      long02 = long2*rad
      lat02 = lat2*rad

      clat1 = cos(lat01)
      x1 = clat1 * cos(long01)
      y1 = clat1 * sin(long01)
      z1 = sin(lat01)

      clat2 = cos(lat02)
      x2 = clat2 * cos(long02)
      y2 = clat2 * sin(long02)
      z2 = sin(lat02)

      dist = sqrt((x1-x2)**2 + (y1-y2)**2 + (z1-z2)**2)
      distg = 2*6371*asin(dist/2)
      end



