"arcdist" <-
function(point1, points2, radius = 6371){
    longitude1 <- point1[1]
    latitude1 <- point1[2]
    longitude2 <- points2[, 1]
    latitude2 <- points2[, 2]
    x1 <- cos((latitude1 * pi)/180) * cos((longitude1 * pi)/180)
    y1 <- cos((latitude1 * pi)/180) * sin((longitude1 * pi)/180)
    z1 <- sin((latitude1 * pi)/180)
    x2 <- cos((latitude2 * pi)/180) * cos((longitude2 * pi)/180)
    y2 <- cos((latitude2 * pi)/180) * sin((longitude2 * pi)/180)
    z2 <- sin((latitude2 * pi)/180)
    ddist <- sqrt((x1 - x2)^2 + (y1 - y2)^2 + (z1 - z2)^2)
    arclength <- 2 * radius * asin(ddist/2)
    return(arclength)
}
