"as.catalogue" <-
function(x, catname="", dp.second=1)
{
    if (catname == "") 
        stop("The subcatalogue name must be specified")
    if (!is.null(class(x))){
        if (class(x)=="subset"){
            events <- x
            w <- eval(parse(text = events$catname))
            x <- w[events$indices, ]
            attr(x, "subset") <- summary(events)
        }
        else if (class(x)=="list"){
            #   Calculate the dates and times as one variable
            y <- datetimes(x$year, x$month, x$day, x$hour,
                   x$minute, x$second, dp.second = dp.second,
                   missing = TRUE)
            #   Add new datetimes variable to catalogue object
            x$time <- y$time
            x$missing.time <- y$missing.time
            #   Remove unwanted fields
            x$year <- x$month <- x$day <- NULL
            x$hour <- x$minute <- x$second <- NULL 
            #   Give the object the required attributes
            class(x) <- c("catalogue", "data.frame")
        }
        else stop(paste("The object", deparse(substitute(x)),
                  "has the wrong class"))
    }
    else stop(paste('The object', deparse(substitute(x)),
              'should have mode "list"'))
    if (length(x$longitude) > 0) 
        attr(x, "row.names") <- seq(1, length(x$longitude))
    attr(x, "catname") <- catname 
    assign(catname, x, envir = globalenv())
}

