"c.catalogue" <-
function(x, y, catname,
         vars=c("time", "longitude", "latitude", "depth", "magnitude"),
         ..., recursive = FALSE)
{
    if (sum(attr(x$time, "origin")) != sum(attr(y$time, "origin")))
        stop("time origin does not match in the two catalogues")
    namesx <- names(attributes(x$magnitude))
    namesy <- names(attributes(y$magnitude))
    if (sum(is.null(namesx) + is.null(namesx))==1)
        warning("magn attributes do not match in the two catalogues")
    if ((!is.null(namesx)) & (!is.null(namesx)))
       if (any(namesx=="magn.type") & any(namesy=="magn.type"))
           if (attr(x$magnitude, "magn.type") != 
                   attr(y$magnitude, "magn.type"))
               warning("magn.type does not match in the two catalogues")
    z <- rbind(x[, vars], y[, vars])
    attr(z, "row.names") <- c(paste("x", seq(1, nrow(x)), sep=""),
                              paste("y", seq(1, nrow(y)), sep=""))
    attr(z, "catname") <- catname
    z <- z[order(z$time),]
    assign(catname, z, envir = globalenv())
    invisible()
}

