"datetimes" <-
function(year, month, day, hour, minute, second = 0, dp.second = NA, missing = FALSE)
{
#	If seconds are not recorded in catalogue,  set
#		second=0 (default) and dp.second=NA (default)
#	Otherwise second should be of the same length as year (etc) and
#	dp.second should equal the number of dp for seconds in catalogue
	if (missing == TRUE) what.one <- rep("", length(year))
	if(!is.na(dp.second)) {
		a <- is.na(second)
		if (missing == TRUE) what.one[a] <- "s"
		second[a] <- 0
	}
	a <- is.na(minute)
	if (missing == TRUE) what.one[a] <- "m"
	minute[a] <- 0
	a <- is.na(hour)
	if (missing == TRUE) what.one[a] <- "h"
	hour[a] <- 0
	a <- is.na(day)
	if (missing == TRUE) what.one[a] <- "D"
	day[a] <- 1
	a <- is.na(month)
	if (missing == TRUE) what.one[a] <- "M"
	month[a] <- 1
	a <- is.na(year)
	if (missing == TRUE) what.one[a] <- "Y"
	year[a] <- 0
	ti <- julian(month, day, year) + hour/24 + minute/1440 + second/86400
	attr(ti, "dp.second") <- dp.second
	attr(ti, "origin") <- c(month = 1, day = 1, year = 1970)
	class(ti) <- "datetimes"
	if (missing == TRUE) return(list(time = ti, missing.time = what.one))
		else return(ti)
}
