"epi.circle" <-
function(centrelong, centrelat, radius, earthradius = 6371)
{
#-----------------------------------------------------
#   Calculates points (399) on the perimeter of a circle of
#   "radius" centred at (centrelong, centrelat). 
#   The circle radius is the arc length radius on the 
#   surface of the earth. The list output
#   contains the latitude and longitude of these points.
#-----------------------------------------------------
	angle <- pi/180
	x <- seq( - radius, radius, length = 200)
	y <- sqrt(radius^2 - x^2)
	x <- c(x, rev(x)[-1])
	y <- c(y,  - rev(y)[-1])
	lat0 <- cos(sqrt(x^2 + y^2)/earthradius) * sin(centrelat * angle) + (
		cos(centrelat * angle) * sin(sqrt(x^2 + y^2)/earthradius) * y)/
		sqrt(x^2 + y^2)
	long0 <- (sin(sqrt(x^2 + y^2)/earthradius) * x)/sqrt(x^2 + y^2)/sqrt(1 - 
		lat0^2)
	latitude <- asin(lat0)/angle
	longitude <- asin(long0)/angle + centrelong
	invisible(list(centrelong = centrelong, centrelat = centrelat, radius
		 = radius, longitude = longitude, latitude = latitude))
}
