"lattice" <-
function (K, J, d, alpha, centrelat, centrelong, triangle = TRUE) 
{
    k <- rep(seq(-K, K), 2 * J + 1)
    j <- as.vector(outer(rep(1, 2 * K + 1), seq(-J, J)))
    if (triangle == TRUE) {
        x <- d * k + (1/2) * j%%2 * d
        y <- d * j * cos(pi/6)
    }
    else {
        x <- d * k
        y <- d * j
    }
    #   rotate by angle alpha
    xprime <- x * cos(alpha) - y * sin(alpha)
    yprime <- x * sin(alpha) + y * cos(alpha)
    mapping <- function(x, y, centrelat, centrelong, radius = 6371) {
        #   map x-y grid to longitude-latitude values
        angle <- pi/180
        lat0 <- cos(sqrt(x^2 + y^2)/radius) * sin(centrelat * 
            angle) + (cos(centrelat * angle) * sin(sqrt(x^2 + 
            y^2)/radius) * y)/sqrt(x^2 + y^2)
        long0 <- (sin(sqrt(x^2 + y^2)/radius) * x)/sqrt(x^2 + 
            y^2)/sqrt(1 - lat0^2)
        latitude <- asin(lat0)/angle
        longitude <- asin(long0)/angle + centrelong
        latitude[y==0] <- centrelat
        longitude[y==0] <- centrelong
        return(list(centrelong = centrelong, centrelat = centrelat, 
                    longitude = longitude, latitude = latitude))
    }
    a <- mapping(xprime, yprime, centrelat, centrelong)
    a$i <- seq(1, length(a$latitude))
    a$j <- j
    a$k <- k
    a$d <- d
    return(a)
}

