"lattice.retrieve" <-
function(i = NA, j = NA, k = NA, K, J)
{
	#  need to specify i or (j and k)
	#  always specify K and J
	if(!is.na(i)) {
		modulo <- function(x, d)
			x - d * trunc(x/d)
		nstar <- modulo(i - 1, 2 * K + 1)
		k <- K - nstar
		j <- (i - 1 - nstar)/(2 * K + 1) - J
	}
	else if(!is.na(j) & !is.na(k))
		i <- (J + j) * (2 * K + 1) + (K - k) + 1
	else stop("Must specify i or (j and k)")
	return(list(i = i, j = j, k = k, K = K, J = J))
}
