"print.subset" <-
function(x, ...)
{
	cat(x$type, "Subset", "from the", x$catname, "Catalogue\n\n")
	cat("Number of Events Selected =", length(x$indices), "\n\n")
	if(x$type == "Circular") {
		cat("Circle Centre:  latitude  =", x$centrelat, "\n")
		cat("                longitude =", x$centrelong, "\n\n")
		cat("     Anulus Radii:  inner =", x$minradius, "\n")
		cat("                    outer =", x$maxradius, "\n\n")
		cat("      Depth Range:  min   =", x$mindepth, "\n")
		cat("                    max   =", x$maxdepth, "\n\n")
	}
	if(x$type == "Polygon") {
		y <- cbind(seq(1, length(x$polylong)), x$polylong, x$polylat)
		dimnames(y) <- list(rep("           ", length(x$polylong)),
				c("", "longitude", "latitude"))
		cat("      Polygon Vertices:\n")
		print(y)
		cat("\n")
		cat("      Depth Range:  min   =", x$mindepth, "\n")
		cat("                    max   =", x$maxdepth, "\n\n")
	}
	if(x$type == "Rectangular") {
		cat("  Longitude Range:  min   =", x$minlong, "\n")
		cat("                    max   =", x$maxlong, "\n\n")
		cat("   Latitude Range:  min   =", x$minlat, "\n")
		cat("                    max   =", x$maxlat, "\n\n")
		cat("      Depth Range:  min   =", x$mindepth, "\n")
		cat("                    max   =", x$maxdepth, "\n\n")
	}
	if(x$type == "Spherical") {
		cat("Sphere Centre:  latitude  =", x$centrelat, "\n")
		cat("                longitude =", x$centrelong, "\n")
		cat("                    depth =", x$centredepth, "\n\n")
		cat("     Anulus Radii:  inner =", x$minradius, "\n")
		cat("                    outer =", x$maxradius, "\n\n")
	}
	cat("  Magnitude Range:  min   =", x$minmag, "\n")
	cat("                    max   =", x$maxmag, "\n\n")
	cat("    Time Interval:  start =", format(x$minday), "\n")
	cat("                    end   =", format(x$maxday), "\n\n")
	if (!is.null(x$extras)) {
	    cat(" Extra Conditions: ", x$extras[1], "\n")
	    if (length(x$extras) > 1)
		for (i in 2:length(x$extras))
		    cat("                   ", x$extras[i], "\n")
            cat("\n")
    }
	invisible()
}
