projection <-
function(rho, phi, theta, alpha, beta)
{
#_______________________________________________________________
#     Transforms spherical coordinates to cartesian and rotates.
#     Have spherical coordinates (rho, phi, theta). rho is the radius, 
#     theta can be thought of as the longitude and phi the latitude.
#     The resultant coordinates (x, y, z) are rotated such that the
#     point with longitude alpha and latitude beta becomes the new
#     north pole. Thus a plot of the new x*y plane is Azimuths
#     projection, centered at the new reference point.
#     The positive direction on the y axis points towards the "true"
#     northern hemisphere.
#     The x*y plane cuts the equator, and the y*z plane cuts through
#     longitudes 0 and 180. The northern hemisphere has z>0, the
#     western hemisphere (0W-180W) has x<0 and eastern hemisphere 
#     has x>0.
#
#     See Speigel (1968), page 50) Mathematical Handbook. Denote his 
#     coordinates are as rho', phi', and theta'. Below:
#                 rho' = rho
#                 phi' = 90 + theta
#                 theta' = 90 - phi
#_______________________________________________________________
	angle <- pi/180
	#  convert to cartesian coordinates.
	#  z1 axis runs through poles, x1*y1 plane cuts through equator.
	x1 <-  - rho * cos(phi * angle) * sin(theta * angle)
	y1 <- rho * cos(phi * angle) * cos(theta * angle)
	z1 <- rho * sin(phi * angle)
	#  rotate x1*y1 plane alpha degrees.
	x2 <-  - x1 * cos(alpha * angle) - y1 * sin(alpha * angle)
	y2 <- x1 * sin(alpha * angle) - y1 * cos(alpha * angle)
	z2 <- z1
	#  rotate y2*z2 plane about x2 axis through 90-beta degrees.
	x3 <- x2
	y3 <- z2 * cos(beta * angle) + y2 * sin(beta * angle)
	z3 <- z2 * sin(beta * angle) - y2 * cos(beta * angle)
	list(x = x3, y = y3, z = z3)
}



