"subset.circle" <-
function (x, centrelat = 0, centrelong = 0, minradius = 0, maxradius = Inf, 
    mindepth = 0, maxdepth = Inf, minmag = -Inf, maxmag = Inf, 
    minday = -Inf, maxday = Inf, radius = 6371, report.count = TRUE, na.rm = TRUE, ...) 
{
    .Deprecated("subsetcircle", package="ssBase",
          msg="'subset.circle' is deprecated.
          Use 'subsetcircle' instead, see help('subsetcircle').")
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(mindepth))
        indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
        indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    x1 <- cos((centrelat * pi)/180) * cos((centrelong * pi)/180)
    y1 <- cos((centrelat * pi)/180) * sin((centrelong * pi)/180)
    z1 <- sin((centrelat * pi)/180)
    x2 <- cos((x$latitude[indices] * pi)/180) * cos((x$longitude[indices] * 
        pi)/180)
    y2 <- cos((x$latitude[indices] * pi)/180) * sin((x$longitude[indices] * 
        pi)/180)
    z2 <- sin((x$latitude[indices] * pi)/180)
    ddist <- sqrt((x1 - x2)^2 + (y1 - y2)^2 + (z1 - z2)^2)
    arclength <- 2 * radius * asin(ddist/2)
    restrict <- (arclength <= maxradius & arclength >= minradius)
    restrict[is.na(restrict)] <- (!na.rm)
    indices <- indices[restrict]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, centrelong = centrelong, centrelat = centrelat, 
        minradius = minradius, maxradius = maxradius, mindepth = mindepth, 
        maxdepth = maxdepth, minmag = minmag, maxmag = maxmag, 
        minday = minday, maxday = maxday, type = "Circular", 
        catname = attr(x, "catname"), extras = extras)
    class(x) <- "subset"
    return(x)
}


"subsetcircle" <-
function (x, centrelat = 0, centrelong = 0, minradius = 0, maxradius = Inf, 
    mindepth = 0, maxdepth = Inf, minmag = -Inf, maxmag = Inf, 
    minday = -Inf, maxday = Inf, radius = 6371, report.count = TRUE, na.rm = TRUE, ...) 
{
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(mindepth))
        indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
        indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    x1 <- cos((centrelat * pi)/180) * cos((centrelong * pi)/180)
    y1 <- cos((centrelat * pi)/180) * sin((centrelong * pi)/180)
    z1 <- sin((centrelat * pi)/180)
    x2 <- cos((x$latitude[indices] * pi)/180) * cos((x$longitude[indices] * 
        pi)/180)
    y2 <- cos((x$latitude[indices] * pi)/180) * sin((x$longitude[indices] * 
        pi)/180)
    z2 <- sin((x$latitude[indices] * pi)/180)
    ddist <- sqrt((x1 - x2)^2 + (y1 - y2)^2 + (z1 - z2)^2)
    arclength <- 2 * radius * asin(ddist/2)
    restrict <- (arclength <= maxradius & arclength >= minradius)
    restrict[is.na(restrict)] <- (!na.rm)
    indices <- indices[restrict]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, centrelong = centrelong, centrelat = centrelat, 
        minradius = minradius, maxradius = maxradius, mindepth = mindepth, 
        maxdepth = maxdepth, minmag = minmag, maxmag = maxmag, 
        minday = minday, maxday = maxday, type = "Circular", 
        catname = attr(x, "catname"), extras = extras)
    class(x) <- "subset"
    return(x)
}
