"subset.polygon" <-
function (x, polylong, polylat, mindepth = 0, maxdepth = Inf, 
    minmag = -Inf, maxmag = Inf, minday = -Inf, maxday = Inf,
    report.count = TRUE, na.rm = TRUE, ...)
{
    .Deprecated("subsetpolygon", package="ssBase",
          msg="'subset.polygon' is deprecated.
          Use 'subsetpolygon' instead, see help('subsetpolygon').")
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1,
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    n <- length(polylong)
    if (n != length(polylat)) 
        stop("Error: Lengths of latitude and longitude vectors differ!")
    if (n <= 2) 
        stop("Error: too few points for a polygon!")
    indices <- indices & x$longitude >= min(polylong)
    indices <- indices & x$longitude <= max(polylong)
    indices <- indices & x$latitude >= min(polylat)
    indices <- indices & x$latitude <= max(polylat)
    if (!missing(mindepth))
        indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
        indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    a <- seq(1, length(indices))[indices]
    m <- length(a)
    if (report.count) cat("\nInitial Approximate Selection")
    if (report.count) cat("\nNumber of Selected Events =", m, "\n")
    event.long <- x$longitude[a]
    event.lat <- x$latitude[a]
    flag <- .Fortran("polyse", polylong = as.double(c(polylong, 
        polylong[1])), polylat = as.double(c(polylat, polylat[1])), 
        n = as.integer(n), eventx = as.double(event.long),
	eventy = as.double(event.lat), m = as.integer(m),
	flag = as.integer(rep(0, m)), PACKAGE="ssBase")$flag
    flag[flag == 0] <- 1
    flag[flag == -1] <- 0
    indices <- a[as.logical(flag)]
    outside <- a[!as.logical(flag)]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(outside = outside, indices = indices, polylong = polylong, 
        polylat = polylat, mindepth = mindepth, maxdepth = maxdepth, 
        minmag = minmag, maxmag = maxmag, minday = minday, maxday = maxday, 
        type = "Polygon", catname = attr(x, "catname"), extras = extras)
    class(x) <- "subset"
    return(x)
}


"subsetpolygon" <-
function (x, polylong, polylat, mindepth = 0, maxdepth = Inf, 
    minmag = -Inf, maxmag = Inf, minday = -Inf, maxday = Inf,
    report.count = TRUE, na.rm = TRUE, ...)
{
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1,
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    n <- length(polylong)
    if (n != length(polylat)) 
        stop("Error: Lengths of latitude and longitude vectors differ!")
    if (n <= 2) 
        stop("Error: too few points for a polygon!")
    indices <- indices & x$longitude >= min(polylong)
    indices <- indices & x$longitude <= max(polylong)
    indices <- indices & x$latitude >= min(polylat)
    indices <- indices & x$latitude <= max(polylat)
    if (!missing(mindepth))
        indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
        indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    a <- seq(1, length(indices))[indices]
    m <- length(a)
    if (report.count) cat("\nInitial Approximate Selection")
    if (report.count) cat("\nNumber of Selected Events =", m, "\n")
    event.long <- x$longitude[a]
    event.lat <- x$latitude[a]
    flag <- .Fortran("polyse", polylong = as.double(c(polylong, 
        polylong[1])), polylat = as.double(c(polylat, polylat[1])), 
        n = as.integer(n), eventx = as.double(event.long),
	eventy = as.double(event.lat), m = as.integer(m),
	flag = as.integer(rep(0, m)), PACKAGE="ssBase")$flag
    flag[flag == 0] <- 1
    flag[flag == -1] <- 0
    indices <- a[as.logical(flag)]
    outside <- a[!as.logical(flag)]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(outside = outside, indices = indices, polylong = polylong, 
        polylat = polylat, mindepth = mindepth, maxdepth = maxdepth, 
        minmag = minmag, maxmag = maxmag, minday = minday, maxday = maxday, 
        type = "Polygon", catname = attr(x, "catname"), extras = extras)
    class(x) <- "subset"
    return(x)
}
