"subset.rect" <-
function (x, minlong = 0, maxlong = 360, minlat = -90, maxlat = 90, 
    mindepth = 0, maxdepth = Inf, minmag = -Inf, maxmag = Inf, 
    minday = -Inf, maxday = Inf, report.count = TRUE, na.rm = TRUE, ...) 
{
    .Deprecated("subsetrect", package="ssBase",
          msg="'subset.rect' is deprecated.
          Use 'subsetrect' instead, see help('subsetrect').")
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(minlong))
	indices <- indices & x$longitude >= minlong
    if (!missing(maxlong))
	indices <- indices & x$longitude <= maxlong
    if (!missing(minlat))
	indices <- indices & x$latitude >= minlat
    if (!missing(maxlat))
	indices <- indices & x$latitude <= maxlat
    if (!missing(mindepth))
	indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
	indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
	indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
	indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
	indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
	indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, minlong = minlong, maxlong = maxlong, 
        minlat = minlat, maxlat = maxlat, mindepth = mindepth, 
        maxdepth = maxdepth, minmag = minmag, maxmag = maxmag, 
        minday = minday, maxday = maxday, catname = attr(x, "catname"), 
        type = "Rectangular", extras = extras)
    class(x) <- "subset"
    return(x)
}


"subsetrect" <-
function (x, minlong = 0, maxlong = 360, minlat = -90, maxlat = 90, 
    mindepth = 0, maxdepth = Inf, minmag = -Inf, maxmag = Inf, 
    minday = -Inf, maxday = Inf, report.count = TRUE, na.rm = TRUE, ...) 
{
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) {
	extras <- rep(" ", len...)
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0)
                indices <- indices & x[[n...[i]]] == l...[i]
            else
                warning(paste(n...[i], "is not a component of the",
                    attr(x,"catname"), "catalogue"))
	    extras[i] <- paste(n...[i], "=", l...[i])
        }
    } else
	extras <- NULL
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(minlong))
	indices <- indices & x$longitude >= minlong
    if (!missing(maxlong))
	indices <- indices & x$longitude <= maxlong
    if (!missing(minlat))
	indices <- indices & x$latitude >= minlat
    if (!missing(maxlat))
	indices <- indices & x$latitude <= maxlat
    if (!missing(mindepth))
	indices <- indices & x$depth >= mindepth
    if (!missing(maxdepth))
	indices <- indices & x$depth <= maxdepth
    if (!missing(minmag))
	indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag))
	indices <- indices & x$magnitude <= maxmag
    if (!missing(minday))
	indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday))
	indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    n <- length(indices)
    if (report.count) cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, minlong = minlong, maxlong = maxlong, 
        minlat = minlat, maxlat = maxlat, mindepth = mindepth, 
        maxdepth = maxdepth, minmag = minmag, maxmag = maxmag, 
        minday = minday, maxday = maxday, catname = attr(x, "catname"), 
        type = "Rectangular", extras = extras)
    class(x) <- "subset"
    return(x)
}
