"subset.sphere" <-
function (x, centrelat = 0, centrelong = 0, centredepth = 0, minradius = 0,
    maxradius = Inf, minmag = -Inf, maxmag = Inf, minday = -Inf,
    maxday = Inf, radius = 6371, report.count = TRUE, na.rm = TRUE,...) 
{
    .Deprecated("subsetsphere", package="ssBase",
          msg="'subset.sphere' is deprecated.
          Use 'subsetsphere' instead, see help('subsetsphere').")
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) 
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0) 
                indices <- indices & x[[n...[i]]] == l...[i]
            else warning(paste(n...[i], "is not a component of the", 
                attr(x, "catname"), "catalogue"))
        }
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(minmag)) 
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag)) 
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday)) 
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday)) 
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    kmperdeg <- 10000/90
    lat <- x$latitude[indices]
    deltalong <- (x$longitude[indices] - centrelong)*kmperdeg*cos((lat +
      centrelat)*pi/360)
    deltalat <- (lat - centrelat)*kmperdeg
    deltadep <- x$depth[indices] - centredepth
    ddist <- sqrt(deltalong^2 + deltalat^2 + deltadep^2)
    restrict <- (ddist <= maxradius & ddist >= minradius)
    restrict[is.na(restrict)] <- (!na.rm)
    indices <- indices[restrict]
    n <- length(indices)
    if (report.count) 
        cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, centrelong = centrelong, centrelat = centrelat,
        centredepth = centredepth, minradius = minradius, maxradius = maxradius,
	minmag = minmag, maxmag = maxmag, minday = minday, maxday = maxday,
	type = "Spherical", catname = attr(x, "catname"))
    class(x) <- "subset"
    return(x)
}


"subsetsphere" <-
function (x, centrelat = 0, centrelong = 0, centredepth = 0, minradius = 0,
    maxradius = Inf, minmag = -Inf, maxmag = Inf, minday = -Inf,
    maxday = Inf, radius = 6371, report.count = TRUE, na.rm = TRUE,...) 
{
    l... <- list(...)
    n... <- names(l...)
    len... <- length(l...)
    indices <- rep(TRUE, length(x$time))
    if (len... > 0) 
        for (i in 1:len...) {
            if (match(n...[i], names(x), nomatch = 0) > 0) 
                indices <- indices & x[[n...[i]]] == l...[i]
            else warning(paste(n...[i], "is not a component of the", 
                attr(x, "catname"), "catalogue"))
        }
    attr(minday, "dp.second") <- attr(maxday, "dp.second") <- 2
    attr(minday, "origin") <- attr(maxday, "origin") <- c(month = 1, 
        day = 1, year = 1970)
    class(minday) <- class(maxday) <- "datetimes"
    if (!missing(minmag)) 
        indices <- indices & x$magnitude >= minmag
    if (!missing(maxmag)) 
        indices <- indices & x$magnitude <= maxmag
    if (!missing(minday)) 
        indices <- indices & as.numeric(x$time) >= as.numeric(minday)
    if (!missing(maxday)) 
        indices <- indices & as.numeric(x$time) <= as.numeric(maxday)
    indices[is.na(indices)] <- (!na.rm)
    indices <- seq(1, length(indices))[indices]
    kmperdeg <- 10000/90
    lat <- x$latitude[indices]
    deltalong <- (x$longitude[indices] - centrelong)*kmperdeg*cos((lat +
      centrelat)*pi/360)
    deltalat <- (lat - centrelat)*kmperdeg
    deltadep <- x$depth[indices] - centredepth
    ddist <- sqrt(deltalong^2 + deltalat^2 + deltadep^2)
    restrict <- (ddist <= maxradius & ddist >= minradius)
    restrict[is.na(restrict)] <- (!na.rm)
    indices <- indices[restrict]
    n <- length(indices)
    if (report.count) 
        cat("\nNumber of Selected Events =", n, "\n")
    x <- list(indices = indices, centrelong = centrelong, centrelat = centrelat,
        centredepth = centredepth, minradius = minradius, maxradius = maxradius,
	minmag = minmag, maxmag = maxmag, minday = minday, maxday = maxday,
	type = "Spherical", catname = attr(x, "catname"))
    class(x) <- "subset"
    return(x)
}
