"summary.catalogue" <-
function(object, ...)
{
    n <- length(object$latitude)
    range1 <- function(x){
        m <- sum(is.na(x))
        n <- length(x)
        if (m==n) y <- c(NA, NA, m)
        else y <- c(range(x, na.rm=TRUE), m)
        return(y)
    }
    ranges <- rbind(range1(object$latitude),
                    range1(object$longitude), 
                    range1(object$depth),
                    range1(object$magnitude))
    dimnames(ranges) <- list(c("latitude", "longitude", "depth", 
             "magnitude"), c("minimum", "maximum", "missing"))
    time.range <- range(object$time, na.rm = TRUE)
    attributes(time.range) <- attributes(object$time)
    a <- (nchar(object$missing.time) > 0)
    if (sum(a) > 0){
        na.ti <- cbind(seq(1, n)[a], format(object$time[a]), object$missing.time[a])
        dimnames(na.ti) <- list(NULL, c("Record Number", "Time", "Problem"))
    }
    else na.ti <- "none"
    list(catname = attr(object, "catname"), n = n, ranges = ranges,
         time.range = time.range, missing.times = na.ti, names = names(object))
}
