"summary.subset" <-
function (object, plot = FALSE, ...) 
{
    nl <- 0
    if (plot == TRUE)
        lteq <- "\" * {phantom() <= \""
    else lteq <- " <= "
    if (object$type == "Spherical") {
        y <- paste("Centre Latitude = ", object$centrelat, "    ", 
            "Centre Longitude = ", object$centrelong, "    ", 
            "Centre Depth = ", object$centredepth, "    ", object$minradius, 
            lteq, "Event Radius", lteq, object$maxradius, "    ", 
            sep = "")
	    nl <- nl + 2
    }
    if (object$type == "Circular") {
        y <- paste("Centre Latitude = ", object$centrelat, "    ", 
            "Centre Longitude = ", object$centrelong, "    ", 
            object$minradius, lteq, "Event Radius", lteq, object$maxradius, 
            "    ", sep = "")
	    nl <- nl + 2
    }
    if (object$type == "Polygon") {
        y <- paste("Latitude Vertices = (", paste(object$polylat, 
            collapse = ", "), ")   Longitude Vertices = (", paste(object$polylong, 
            collapse = ", "), ")   ", sep = "")
    }
    if (object$type == "Rectangular") {
        y <- paste(object$minlat, lteq, "Latitude", lteq, object$maxlat, 
            "    ", object$minlong, lteq, "Longitude", lteq, 
            object$maxlong, "    ", sep = "")
	    nl <- nl + 4
    }
    y <- paste(object$type, " Selection Criteria:    ", object$catname, 
        " Catalogue    ", y, object$mindepth, lteq, "Depth", 
        lteq, object$maxdepth, "    ", format(object$minday), 
        lteq, "Time", lteq, format(object$maxday), "    ", object$minmag, 
        lteq, "Magnitude", lteq, object$maxmag, "    ", "Number of Events = ", 
        length(object$indices), sep = "")
    nl <- nl + 6
    if (plot == TRUE) {
        return(parse(text = paste("\"", y, "\"", paste(rep("}", nl),
        collapse = ""), sep = "")))
    } else return(y)
}

