"write.catalogue" <-
function(x, file = paste(deparse(substitute(x)), ".txt", sep = ""),
         ignore = FALSE, append = FALSE)
{
# function to convert a catalogue to the format:
#             yyyy,mmdd,hh,mm,llll,lllll,mag,dep,xxx
# 
# x is catalogue, file is output file ("" => to standard output), ignore
#   is to ignore the sign on latitude and longitude
#
	ndigits <- function(n, x, char = "0")
            formatC(x, width=n, flag=char)
	year <- years1(x$time)
	month <- months1(x$time)
	day <- days1(x$time)
	hr.min.sec <- hrs.mins.secs(x$time)
	hour <- hr.min.sec$hour
	minute <- hr.min.sec$minute
	lat <- x$latitude
	long <- x$longitude
	if(ignore) {
		latneg <- ""
		longneg <- ""
	}
	else {
		latneg <- rep("", length(lat))
		longneg <- latneg
		latneg[lat < 0] <- "-"
		longneg[long < 0] <- "-"
	}
	lat <- abs(lat)
	long <- abs(long)
	mag <- x$magnitude
	x <- paste(ndigits(4, year), ",", ndigits(2, month), ndigits(2, 
			day), ",", ndigits(2, hour), ",", ndigits(2, 
			minute), ",", latneg, ndigits(2, trunc(lat)), 
			ndigits(2, round((lat %% 1) * 60)), ",", longneg, 
			ndigits(3, trunc(long)), ndigits(2, round((long %% 
			1) * 60)), ",", format(x$magnitude, signif=1), ",",
			format(round(x$depth), digits=3), ",  0", "\n", sep = "")
	cat(x, file = file, append = append, sep="")
}
