\name{Palliser}
\alias{Palliser}
\non_function{}
\title{Palliser Earthquake Catalogue}
\usage{data(Palliser)}
\description{
The Palliser Catalogue contains events from the original Wellington Catalogue with magnitude \eqn{\ge 2.5}, depth \eqn{\le} 40 km, between 1 Jan 1990 and 31 Dec 1991, and within a 36 km radius of \eqn{41.684^\circ}{41.684deg }S and \eqn{175.503^\circ}{175.503deg }E.
}
\format{
  This data frame has class \code{"catalogue"} and contains the following columns:
  \describe{
    \item{latitude}{number of degrees north.}
    \item{longitude}{number of degrees east.}
    \item{magnitude}{event magnitude.}
    \item{depth}{event depth (km).}
    \item{missing.time}{always \code{""}.}
    \item{time}{vector of event dates and times with class \code{"datetimes"}.}
  }
}

\source{
These data originate from the original Wellington Catalogue which was administered by the Institute of Geological and Nuclear Sciences, Lower Hutt, NZ.
}

\examples{
data(Palliser)
summary(Palliser)

#    Reset the time origin to 1 January 1990
#    Useful for fitting models where this time is "zero"
Palliser$time <- Palliser$time - julian(1,1,1990)
attr(Palliser$time, "origin") <- c(month=1, day=1, year=1990)
}
\keyword{datasets}
