\name{arcdist}
\alias{arcdist}
\title{Arc Distance Between Epicentral Locations}

\description{
Calculates the arc-distance on the spherical surface between one epicentral location and a set of other locations.
}

\usage{
arcdist(point1, points2, radius = 6371)
}

\arguments{
  \item{point1}{a vector containing the longitude and latitude of the \dQuote{central} point.}
  \item{points2}{a matrix containing the other points, one in each row. The first column contains the longitudes and the second contains the latitudes.}
  \item{radius}{the radius of the sphere, default is 6371.}
}

\value{A vector of arclengths the same length as number of rows in \code{points2}.}

\author{David Harte, 2002}

\seealso{
\code{\link{epi.circle}}, \code{\link[ssEDA]{epicentres}}
}

\examples{
x <- arcdist(c(174, -42), cbind(c(174, 174, 175), c(-42, -43, -43)))
print(x)
}

\keyword{utilities}
