\name{as.catalogue}
\alias{as.catalogue}
\alias{events}
\title{Make a Catalogue Object}
\description{
Makes a catalogue from either an object with class \code{"subset"} or \code{"list"}.
}
\usage{
as.catalogue(x, catname="", dp.second=1)
}
\arguments{
  \item{x}{either an object with class \code{"subset"} (i.e. created by \code{\link{subset.circle}}, \code{\link{subset.polygon}}, or \code{\link{subset.rect}}), or an object with class \code{"list"} (see Details).}
  \item{catname}{a character string giving the required name of the catalogue.}
  \item{dp.second}{only used if \code{x} is a list with \code{NULL} class. The number of decimal places in the second component of time.}
}
\value{
\code{NULL}. The assignment takes place within the function.
}

\details{When the input object is a list, it will generally be data that have been read from a text file using the \code{scan} function. The list should contain the variables \code{year}, \code{month}, \code{day}, \code{hour}, \code{minute}, and \code{second}. These will be replaced in the resulting catalogue with one variable called \code{time}, being the number of days (and fractions) from some origin.
}

\author{David Harte, 2000}
\examples{
#   Creating a subcatalogue from a larger catalogue
data(NZ55)
y <- subsetrect(NZ55, minmag=7)
as.catalogue(y, catname="NZ7")
print(NZ7)

#   Reading Data From Disk and Creating a Catalogue
#   Say the following events are in a disk file called "events.dat"
#   -41.76,172.04,Westport,12,6.7,23,05,1968,17,24,17.4
#   -34.94,179.30,Kermadec Trench,297,6.8,08,01,1970,17,12,36.6
#   -39.13,175.18,National Park,173,7.0,05,01,1973,13,54,27.6
#   -41.61,173.65,Marlborough,84,6.7,27,05,1992,22,30,36.1
#   -45.21,166.71,Secretary Island,5,6.7,10,08,1993,00,51,51.6
#   -43.01,171.46,Arthurs Pass,11,6.7,18,06,1994,03,25,15.2
#   -37.65,179.49,East Cape,12,7.0,05,02,1995,22,51,02.3

#   Typically, we would use
#   scan function to read the data from a disk file as follows
#   y <- scan("events.dat", sep=",", what=list(latitude=0,
#             longitude=0, event="", depth=0,
#             magnitude=0, day=0, month=0,
#             year=0, hour=0, minute=0, second=0))
#  The list below will have the same format

y <- list(latitude=c(-41.76, -34.94, -39.13, -41.61, -45.21, -43.01, -37.65),
          longitude=c(172.04, 179.30, 175.18, 173.65, 166.71, 171.46, 179.49),
          event=c("Westport", "Kermadec Trench", "National Park", "Marlborough",
                  "Secretary Island", "Arthurs Pass", "East Cape"),
          depth=c(12, 297, 173, 84, 5, 11, 12),
          magnitude=c(6.7, 6.8, 7.0, 6.7, 6.7, 6.7, 7.0),
          day=c(23, 08, 05, 27, 10, 18, 05),
          month=c(05, 01, 01, 05, 08, 06, 02),
          year=c(1968, 1970, 1973, 1992, 1993, 1994, 1995),
          hour=c(17, 17, 13, 22, 00, 03, 22),
          minute=c(24, 12, 54, 30, 51, 25, 51),
          second=c(17.4, 36.6, 27.6, 36.1, 51.6, 15.2, 02.3))

as.catalogue(y, catname="my.cat", dp.second=1)
print(my.cat)
}

\keyword{classes}
