\name{c.catalogue}
\alias{c.catalogue}

\title{Combine Catalogues}
\description{
Combines two catalogues together to form a new catalogue. Provides a method for the generic function \code{\link{c}}.
}
\usage{
\method{c}{catalogue}(x, y, catname,
  vars=c("time", "longitude", "latitude", "depth", "magnitude"),
  ..., recursive = FALSE)
}

\arguments{
  \item{x}{catalogue name.}
  \item{y}{catalogue name.}
  \item{catname}{name of the new combined catalogue.}
  \item{vars}{variable names to included in the combined catalogue. These variables must exist in catalogues \code{x} and \code{y}. By default, the names are \code{c("time", "longitude", "latitude", "depth", "magnitude")}.}
  \item{...}{not used, required for compatibility with generic function \code{\link[base]{c}}.}
  \item{recursive}{not used, required for compatibility with generic function \code{\link[base]{c}}.}
}

\details{
The two catalogues are combined using \code{\link[base]{rbind.data.frame}}. The row names of the events are prefixed with \dQuote{x} for those from catalogue \code{x} and \dQuote{y} for those from catalogue \code{y}. They are also sequentially numbered. The events are also sorted by time.
}

\value{
\code{NULL}. The assignment takes place within the function.
}

\seealso{
    \code{\link{as.catalogue}}, \code{\link[base]{rbind.data.frame}}
}

\examples{
data(NZ55)
c(NZ55[1:10,], NZ55[101:120,], catname="x",
  vars=c("time", "longitude", "magnitude"))

print(x)
}

\keyword{manip}
\keyword{methods}

